/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.co.mki.celldesigner.simulation.constant.CodeInformation;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.MySpinnerNumberModel;
import jp.co.mki.celldesigner.simulation.controlpanel.ParameterData;
import jp.co.mki.celldesigner.simulation.controlpanel.ParameterScan;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.SpinnerEditor2;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;

public class TabParameterScan
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    private final int X_WIDTH = 850;
    private final int Y_WIDTH = 500;
    private JCheckBox chkScan1 = null;
    private JCheckBox chkScan2 = null;
    private ButtonGroup bgScanParameter1 = null;
    private ButtonGroup bgScanParameter2 = null;
    private JRadioButton rbInitial1 = null;
    private JRadioButton rbParameter1 = null;
    private JRadioButton rbInitial2 = null;
    private JRadioButton rbParameter2 = null;
    private JSpinner spnFrom1 = null;
    private JSpinner spnTo1 = null;
    private JSpinner spnInterval1 = null;
    private JSpinner spnFrom2 = null;
    private JSpinner spnTo2 = null;
    private JSpinner spnInterval2 = null;
    private JComboBox cmbSpecies1 = null;
    private JComboBox cmbParameter1 = null;
    private JComboBox cmbSpecies2 = null;
    private JComboBox cmbParameter2 = null;
    private GridBagLayout grbLayout = null;
    private JLabel lblSpecies1 = null;
    private JLabel lblParameter1 = null;
    private JLabel lblSpecies2 = null;
    private JLabel lblParameter2 = null;
    private SBMLPanelLists sbmlPanelLists = null;
    private JPanel pnlSimulation1 = null;
    private JPanel pnlSimulation2 = null;
    private JLabel lblName1 = null;
    private JLabel lblName2 = null;
    private JScrollPane scrMain = null;
    private JPanel pnlMain = null;
    private ParameterScan parameterScan = null;
    private ArrayList listOfSpecie = null;
    private ArrayList listOfParam = null;
    private ArrayList listOfGlobalParam = null;
    private ControlPanelMainWindow parent;

    public boolean isCheckScan1() {
        return this.chkScan1.isSelected();
    }

    public boolean isCheckScan2() {
        return this.chkScan2.isSelected();
    }

    public TabParameterScan() {
        this.initThisObjectInformation();
        this.addComponents();
        this.setEnableStatusOnComponents1();
    }

    public TabParameterScan(ControlPanelMainWindow parent, ParameterScan parameterScan, SBMLPanelLists sbmlPanelLists) {
        this.parameterScan = parameterScan;
        this.parent = parent;
        this.sbmlPanelLists = sbmlPanelLists;
        this.initThisObjectInformation();
        String combo1 = parameterScan.getTarget(0);
        String combo2 = parameterScan.getTarget(1);
        this.addComponents();
        this.setEnableStatusOnComponents1();
        this.setEnableStatusOnComponents2();
        this.updateIdList();
        if (parent.isXMLLoad) {
            if (parameterScan.getKindOfParameter(0).equals("initial value")) {
                this.rbInitial1.setSelected(true);
                this.redrawIdLabel1();
            } else {
                this.rbParameter1.setSelected(true);
                this.redrawIdLabel1();
            }
            if (parameterScan.getKindOfParameter(1) != null && parameterScan.getKindOfParameter(1).equals("initial value")) {
                this.rbInitial2.setSelected(true);
                this.redrawIdLabel2();
            } else if (this.cmbParameter2.getItemCount() == 0) {
                this.rbInitial2.setSelected(true);
                this.rbParameter2.setSelected(false);
                this.redrawIdLabel2();
                this.cmbSpecies2.setSelectedIndex(0);
                parameterScan.setTarget(this.cmbSpecies2.getItemAt(0).toString(), CodeInformation.SIMULATION_2);
            } else {
                this.rbParameter2.setSelected(true);
                this.redrawIdLabel2();
            }
            if (this.cmbParameter1.getItemCount() == 0) {
                this.rbParameter1.setEnabled(false);
                this.rbInitial1.setSelected(true);
                this.rbParameter1.setSelected(false);
            }
            if (this.cmbParameter2.getItemCount() == 0) {
                this.rbParameter2.setEnabled(false);
                this.rbInitial2.setSelected(true);
                this.rbParameter2.setSelected(false);
            }
            parameterScan.setTarget(combo1, 0);
            parameterScan.setTarget(combo2, 1);
            int i = 0;
            while (i < this.listOfSpecie.size()) {
                String sp = (String)this.listOfSpecie.get(i);
                if (parameterScan.getTarget(0).equals(sp)) {
                    this.cmbSpecies1.setSelectedIndex(i);
                } else if (parameterScan.getTarget(1).equals(sp)) {
                    this.cmbSpecies2.setSelectedIndex(i);
                }
                ++i;
            }
            i = 0;
            while (this.listOfParam != null && i < this.listOfParam.size()) {
                ParameterData data = (ParameterData)this.listOfParam.get(i);
                if (parameterScan.getTarget(0).equals(data.toString())) {
                    this.cmbParameter1.setSelectedIndex(i);
                } else if (parameterScan.getTarget(1).equals(data.toString())) {
                    this.cmbParameter2.setSelectedIndex(i);
                }
                ++i;
            }
            i = 0;
            while (this.listOfGlobalParam != null && i < this.listOfGlobalParam.size()) {
                Parameter parameter = (Parameter)this.listOfGlobalParam.get(i);
                if (parameterScan.getTarget(0).equals(parameter.getId())) {
                    this.cmbParameter1.setSelectedIndex(i);
                } else if (parameterScan.getTarget(1).equals(parameter.getId())) {
                    this.cmbParameter2.setSelectedIndex(i);
                }
                ++i;
            }
        } else {
            this.setParameterScan();
        }
    }

    private void initThisObjectInformation() {
        this.grbLayout = new GridBagLayout();
        this.setLayout(new BorderLayout());
        this.setSize(850, 500);
    }

    private void addComponents() {
        this.pnlMain = this.getPnlMain();
        this.addSimulation1();
        this.addSimulation2();
        this.scrMain = new JScrollPane(this.pnlMain);
        this.scrMain.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height));
        this.add((Component)this.scrMain, "Center");
    }

    private void addSimulation1() {
        GridBagConstraints grc = new GridBagConstraints();
        this.pnlSimulation1 = this.getPnlSimulation1();
        this.chkScan1 = this.getChkScan();
        grc.gridx = 0;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 2);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.chkScan1, grc);
        this.pnlSimulation1.add(this.chkScan1);
        if (this.parent.isXMLLoad) {
            this.chkScan1.setSelected(this.parameterScan.doScanParameter(0));
        }
        JLabel lblName = new JLabel("Name");
        grc.gridx = 1;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblName, grc);
        this.pnlSimulation1.add(lblName);
        this.cmbSpecies1 = this.getCmbName();
        this.cmbParameter1 = this.getCmbName();
        this.lblName1 = new JLabel();
        this.lblName1.setLayout(new BorderLayout());
        this.lblName1.add(this.cmbSpecies1);
        grc.gridx = 2;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(8, 5, 0, 5);
        grc.ipadx = 150;
        grc.ipady = 20;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.lblName1, grc);
        this.pnlSimulation1.add(this.lblName1);
        JLabel lblFrom = new JLabel("From");
        grc.gridx = 1;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblFrom, grc);
        this.pnlSimulation1.add(lblFrom);
        this.spnFrom1 = this.getSpnFrom(0);
        this.spnFrom1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TabParameterScan.this.stateChanged_spn1(arg0);
            }
        });
        grc.gridx = 2;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 5);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.spnFrom1, grc);
        this.pnlSimulation1.add(this.spnFrom1);
        JLabel lblTo = new JLabel("To");
        grc.gridx = 1;
        grc.gridy = 2;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblTo, grc);
        this.pnlSimulation1.add(lblTo);
        this.spnTo1 = this.getSpnTo(0);
        this.spnTo1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TabParameterScan.this.stateChanged_spn1(arg0);
            }
        });
        grc.gridx = 2;
        grc.gridy = 2;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 5);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.spnTo1, grc);
        this.pnlSimulation1.add(this.spnTo1);
        JPanel pScanParameter = new JPanel();
        this.setScanParameter1();
        pScanParameter.setLayout(new GridLayout(2, 1));
        pScanParameter.add(this.rbInitial1);
        pScanParameter.add(this.rbParameter1);
        grc.gridx = 0;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.gridheight = 2;
        grc.anchor = 23;
        grc.ipadx = 30;
        grc.ipady = 20;
        grc.insets = new Insets(0, 5, 0, 2);
        this.grbLayout.setConstraints(pScanParameter, grc);
        this.pnlSimulation1.add(pScanParameter);
        JLabel lblInterval = new JLabel("Interval");
        grc.gridx = 1;
        grc.gridy = 3;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(5, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblInterval, grc);
        this.pnlSimulation1.add(lblInterval);
        this.spnInterval1 = this.getSpnInterval(0);
        grc.gridx = 2;
        grc.gridy = 3;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(5, 5, 2, 2);
        grc.ipadx = 64;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.spnInterval1, grc);
        this.pnlSimulation1.add(this.spnInterval1);
        GridBagLayout grbLayout1 = new GridBagLayout();
        grc.gridx = 0;
        grc.gridy = 0;
        grc.weightx = 1.0;
        grc.fill = 0;
        grc.anchor = 23;
        grc.insets = new Insets(5, 5, 2, 2);
        this.grbLayout.setConstraints(this.pnlSimulation1, grc);
        this.pnlMain.add(this.pnlSimulation1);
    }

    private void addSimulation2() {
        GridBagConstraints grc = new GridBagConstraints();
        this.pnlSimulation2 = this.getPnlSimulation2();
        this.chkScan2 = this.getChkScan();
        grc.gridx = 0;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 2);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.chkScan2, grc);
        this.pnlSimulation2.add(this.chkScan2);
        if (this.parent.isXMLLoad) {
            this.chkScan2.setSelected(this.parameterScan.doScanParameter(1));
        }
        JLabel lblName = new JLabel("Name");
        grc.gridx = 1;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblName, grc);
        this.pnlSimulation2.add(lblName);
        this.cmbSpecies2 = this.getCmbName();
        this.cmbParameter2 = this.getCmbName();
        this.lblName2 = new JLabel();
        this.lblName2.setLayout(new BorderLayout());
        this.lblName2.add(this.cmbParameter2);
        grc.gridx = 2;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(8, 5, 0, 5);
        grc.ipadx = 150;
        grc.ipady = 20;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.lblName2, grc);
        this.pnlSimulation2.add(this.lblName2);
        JLabel lblFrom = new JLabel("From");
        grc.gridx = 1;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblFrom, grc);
        this.pnlSimulation2.add(lblFrom);
        this.spnFrom2 = this.getSpnFrom(1);
        this.spnFrom2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TabParameterScan.this.stateChanged_spn2(arg0);
            }
        });
        grc.gridx = 2;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 5);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.spnFrom2, grc);
        this.pnlSimulation2.add(this.spnFrom2);
        JLabel lblTo = new JLabel("To");
        grc.gridx = 1;
        grc.gridy = 2;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblTo, grc);
        this.pnlSimulation2.add(lblTo);
        this.spnTo2 = this.getSpnTo(1);
        this.spnTo2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TabParameterScan.this.stateChanged_spn2(arg0);
            }
        });
        grc.gridx = 2;
        grc.gridy = 2;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(0, 5, 2, 5);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.spnTo2, grc);
        this.pnlSimulation2.add(this.spnTo2);
        JPanel pScanParameter = new JPanel();
        this.setScanParameter2();
        pScanParameter.setLayout(new GridLayout(2, 1));
        pScanParameter.add(this.rbInitial2);
        pScanParameter.add(this.rbParameter2);
        grc.gridx = 0;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.gridheight = 2;
        grc.anchor = 23;
        grc.ipadx = 30;
        grc.ipady = 20;
        grc.insets = new Insets(0, 5, 0, 2);
        this.grbLayout.setConstraints(pScanParameter, grc);
        this.pnlSimulation2.add(pScanParameter);
        JLabel lblInterval = new JLabel("Interval");
        grc.gridx = 1;
        grc.gridy = 3;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(5, 5, 2, 0);
        grc.ipadx = 30;
        grc.ipady = 10;
        grc.anchor = 24;
        grc.fill = 0;
        this.grbLayout.setConstraints(lblInterval, grc);
        this.pnlSimulation2.add(lblInterval);
        this.spnInterval2 = this.getSpnInterval(1);
        grc.gridx = 2;
        grc.gridy = 3;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.insets = new Insets(5, 5, 2, 2);
        grc.ipadx = 64;
        grc.ipady = 10;
        grc.anchor = 23;
        grc.fill = 0;
        this.grbLayout.setConstraints(this.spnInterval2, grc);
        this.pnlSimulation2.add(this.spnInterval2);
        GridBagLayout grbLayout1 = new GridBagLayout();
        grc.gridx = 0;
        grc.gridy = 1;
        grc.weightx = 1.0;
        grc.weighty = 1.0;
        grc.fill = 0;
        grc.anchor = 23;
        grc.insets = new Insets(5, 5, 2, 2);
        this.grbLayout.setConstraints(this.pnlSimulation2, grc);
        this.pnlMain.add(this.pnlSimulation2);
    }

    private void stateChanged_spn1(ChangeEvent arg0) {
        Double to = (Double)this.spnTo1.getValue();
        Double fm = (Double)this.spnFrom1.getValue();
        int scale = StringTool.getScale(to, fm);
        if (to >= fm) {
            this.spnInterval1.setValue(new Double(StringTool.convertNumberFormat((to - fm) / 10.0, scale + 1)));
        } else {
            this.spnInterval1.setValue(new Double(StringTool.convertNumberFormat((fm - to) / 10.0, scale + 1)));
        }
        this.spnInterval1.repaint();
    }

    private void stateChanged_spn2(ChangeEvent arg0) {
        Double to = (Double)this.spnTo2.getValue();
        Double fm = (Double)this.spnFrom2.getValue();
        if (to >= fm) {
            this.spnInterval2.setValue(new Double(StringTool.convertNumberFormat((to - fm) / 10.0, 5)));
        } else {
            this.spnInterval2.setValue(new Double(StringTool.convertNumberFormat((fm - to) / 10.0, 5)));
        }
    }

    private JPanel getPnlMain() {
        JPanel _pnlMain = new JPanel();
        _pnlMain.setLayout(this.grbLayout);
        return _pnlMain;
    }

    private JCheckBox getChkScan() {
        JCheckBox _chkScan = new JCheckBox("Scan parameter", false);
        _chkScan.addActionListener(this);
        return _chkScan;
    }

    private JPanel getPnlSimulation1() {
        JPanel _pnlSimulation1 = new JPanel();
        _pnlSimulation1.setBorder(new TitledBorder("Simulation1"));
        _pnlSimulation1.setLayout(this.grbLayout);
        return _pnlSimulation1;
    }

    private JPanel getPnlSimulation2() {
        JPanel _pnlSimulation2 = new JPanel();
        _pnlSimulation2.setBorder(new TitledBorder("Simulation2"));
        _pnlSimulation2.setLayout(this.grbLayout);
        return _pnlSimulation2;
    }

    private void setScanParameter1() {
        this.bgScanParameter1 = new ButtonGroup();
        this.rbInitial1 = new JRadioButton("Initial value", true);
        this.rbParameter1 = new JRadioButton("Parameter value");
        this.rbInitial1.addActionListener(this);
        this.rbParameter1.addActionListener(this);
        this.bgScanParameter1.add(this.rbInitial1);
        this.bgScanParameter1.add(this.rbParameter1);
    }

    private void setScanParameter2() {
        this.bgScanParameter2 = new ButtonGroup();
        this.rbInitial2 = new JRadioButton("Initial value");
        this.rbParameter2 = new JRadioButton("Parameter value", true);
        this.rbInitial2.addActionListener(this);
        this.rbParameter2.addActionListener(this);
        this.bgScanParameter2.add(this.rbInitial2);
        this.bgScanParameter2.add(this.rbParameter2);
    }

    private JSpinner getSpnFrom(int index) {
        double defaultValue = 0.0;
        double minValue = Double.NEGATIVE_INFINITY;
        double maxValue = Double.MAX_VALUE;
        double stepValue = 0.5;
        MySpinnerNumberModel model = null;
        if (this.parent.isXMLLoad) {
            double value = Double.parseDouble(this.parameterScan.getFrom(index));
            model = new MySpinnerNumberModel(value, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, 0.5);
        } else {
            model = new MySpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, 0.5);
        }
        JSpinner _spnFrom = new JSpinner(model);
        _spnFrom.addChangeListener(this);
        SpinnerEditor2 editor = new SpinnerEditor2(_spnFrom, "#.##############");
        _spnFrom.setEditor(editor);
        _spnFrom.setPreferredSize(new Dimension(120, 20));
        model.setMyNumberEditorFormatter(editor.getMyNumberEditorFormatter());
        return _spnFrom;
    }

    private JSpinner getSpnTo(int index) {
        double defaultValue = 10.0;
        double minValue = Double.NEGATIVE_INFINITY;
        double maxValue = Double.MAX_VALUE;
        double stepValue = 0.5;
        MySpinnerNumberModel model = null;
        if (this.parent.isXMLLoad) {
            double value = Double.parseDouble(this.parameterScan.getTo(index));
            model = new MySpinnerNumberModel(value, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, 0.5);
        } else {
            model = new MySpinnerNumberModel(10.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, 0.5);
        }
        JSpinner _spnTo = new JSpinner(model);
        _spnTo.addChangeListener(this);
        SpinnerEditor2 editor = new SpinnerEditor2(_spnTo, "#.##############");
        _spnTo.setEditor(editor);
        _spnTo.setPreferredSize(new Dimension(120, 20));
        model.setMyNumberEditorFormatter(editor.getMyNumberEditorFormatter());
        return _spnTo;
    }

    private JSpinner getSpnInterval(int index) {
        double defaultValue = 1.0;
        double minValue = 0.0;
        double maxValue = Double.MAX_VALUE;
        double stepValue = 0.1;
        MySpinnerNumberModel model = null;
        if (this.parent.isXMLLoad) {
            double value = Double.parseDouble(this.parameterScan.getInterval(index));
            model = new MySpinnerNumberModel(value, 0.0, Double.MAX_VALUE, 0.1);
        } else {
            model = new MySpinnerNumberModel(1.0, 0.0, Double.MAX_VALUE, 0.1);
        }
        JSpinner _spnInterval = new JSpinner(model);
        _spnInterval.addChangeListener(this);
        SpinnerEditor2 editor = new SpinnerEditor2(_spnInterval, "#.###############");
        _spnInterval.setEditor(editor);
        _spnInterval.setPreferredSize(new Dimension(86, 20));
        model.setMyNumberEditorFormatter(editor.getMyNumberEditorFormatter());
        return _spnInterval;
    }

    private JComboBox getCmbName() {
        JComboBox _cmbName = new JComboBox();
        _cmbName.addItemListener(this);
        return _cmbName;
    }

    private JComboBox getCmbParameter() {
        JComboBox _cmbParameters = new JComboBox();
        return _cmbParameters;
    }

    private JButton getExeSave() {
        JButton _exeSave = new JButton("Save");
        _exeSave.addActionListener(this);
        return _exeSave;
    }

    private JButton getExeCmd() {
        JButton _exeCmd = new JButton("Execute");
        _exeCmd.addActionListener(this);
        return _exeCmd;
    }

    private JButton getExeCancel() {
        JButton _exeCancel = new JButton("Cancel");
        _exeCancel.addActionListener(this);
        return _exeCancel;
    }

    public void rgstIdComboItem(File filepath, String comboFlg) {
        SBMLDocument sbmlDocument = new SBMLDocument();
        try {
            SBMLReader reader = new SBMLReader();
            sbmlDocument = reader.readSBML(filepath.getAbsolutePath());
            StringTokenizer tokenizer = null;
            String idSequence = "";
            if (comboFlg.equals("0")) {
                ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
                int i = 0;
                while (i < listOfSpeciesData.size()) {
                    SpeciesData speciesD = (SpeciesData)listOfSpeciesData.get(i);
                    this.cmbSpecies1.addItem(speciesD.toString());
                    this.cmbSpecies2.addItem(speciesD.toString());
                    ++i;
                }
            } else {
                ListOfReactions lstReaction = sbmlDocument.getModel().getListOfReactions();
                int lstSize = (int)lstReaction.size();
                int i = 0;
                while (i < lstSize) {
                    Reaction reaction = (Reaction)lstReaction.get((long)i);
                    ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
                    idSequence = i == 0 ? String.valueOf(idSequence) + this.getElementIdSequence((ListOf)lstParameter) : String.valueOf(idSequence) + "," + this.getElementIdSequence((ListOf)lstParameter);
                    ++i;
                }
                tokenizer = new StringTokenizer(idSequence, ",", false);
                while (tokenizer.hasMoreTokens()) {
                    this.cmbParameter1.addItem(tokenizer.nextToken());
                    this.cmbParameter2.addItem(tokenizer.nextToken());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rgstIdComboItem(String comboFlg) {
        try {
            Object tokenizer = null;
            String idSequence = "";
            if (comboFlg.equals("0")) {
                this.listOfSpecie = new ArrayList();
                ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
                int i = 0;
                while (i < listOfSpeciesData.size()) {
                    SpeciesData speciesD = (SpeciesData)listOfSpeciesData.get(i);
                    this.cmbSpecies1.addItem(speciesD.toString());
                    this.cmbSpecies2.addItem(speciesD.toString());
                    this.listOfSpecie.add(speciesD.toString());
                    ++i;
                }
            } else {
                DefaultComboBoxModel<ParameterData> dcbm1 = new DefaultComboBoxModel<ParameterData>();
                this.cmbParameter1.setModel(dcbm1);
                DefaultComboBoxModel<ParameterData> dcbm2 = new DefaultComboBoxModel<ParameterData>();
                this.cmbParameter2.setModel(dcbm2);
                ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
                int lstSize = (int)lstSBase.size();
                this.listOfGlobalParam = new ArrayList();
                int i = 0;
                while (i < lstSize) {
                    Parameter parameter = (Parameter)lstSBase.get((long)i);
                    this.cmbParameter1.addItem(parameter.getId());
                    this.cmbParameter2.addItem(parameter.getId());
                    this.listOfGlobalParam.add(parameter);
                    ++i;
                }
                ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
                lstSize = (int)lstReaction.size();
                this.listOfParam = new ArrayList();
                int i2 = 0;
                while (i2 < lstSize) {
                    Reaction reaction = (Reaction)lstReaction.get((long)i2);
                    ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
                    int j = 0;
                    while ((long)j < lstParameter.size()) {
                        Parameter parameter = (Parameter)lstParameter.get((long)j);
                        dcbm1.addElement(new ParameterData(reaction, parameter));
                        dcbm2.addElement(new ParameterData(reaction, parameter));
                        this.listOfParam.add(new ParameterData(reaction, parameter));
                        ++j;
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized String getElementIdSequence(ListOf list) {
        String idseq = "";
        if (list == null) {
            return idseq;
        }
        int size = (int)list.size();
        if (size == 0) {
            return idseq;
        }
        Parameter s = (Parameter)list.get(0L);
        idseq = String.valueOf(idseq) + s.getId();
        int i = 1;
        while (i < size) {
            s = (Parameter)list.get((long)i);
            idseq = String.valueOf(idseq) + "," + s.getId();
            ++i;
        }
        return idseq;
    }

    public void setEnableStatusOnComponents1() {
        if (!this.chkScan1.isSelected()) {
            this.rbInitial1.setEnabled(false);
            this.rbParameter1.setEnabled(false);
            this.spnFrom1.setEnabled(false);
            this.spnTo1.setEnabled(false);
            this.cmbSpecies1.setEnabled(false);
            this.cmbParameter1.setEnabled(false);
            this.spnInterval1.setEnabled(false);
        } else {
            this.rbInitial1.setEnabled(true);
            if (this.cmbParameter1.getItemCount() > 0) {
                this.rbParameter1.setEnabled(true);
            }
            this.spnFrom1.setEnabled(true);
            this.spnTo1.setEnabled(true);
            this.cmbSpecies1.setEnabled(true);
            this.cmbParameter1.setEnabled(true);
            this.spnInterval1.setEnabled(true);
        }
    }

    public void setEnableStatusOnComponents2() {
        if (!this.chkScan2.isSelected()) {
            this.rbInitial2.setEnabled(false);
            this.rbParameter2.setEnabled(false);
            this.spnFrom2.setEnabled(false);
            this.spnTo2.setEnabled(false);
            this.cmbSpecies2.setEnabled(false);
            this.cmbParameter2.setEnabled(false);
            this.spnInterval2.setEnabled(false);
        } else {
            this.rbInitial2.setEnabled(true);
            if (this.cmbParameter1.getItemCount() > 0) {
                this.rbParameter2.setEnabled(true);
            }
            this.spnFrom2.setEnabled(true);
            this.spnTo2.setEnabled(true);
            this.cmbSpecies2.setEnabled(true);
            this.cmbParameter2.setEnabled(true);
            this.spnInterval2.setEnabled(true);
        }
    }

    private void redrawIdLabel1() {
        this.setVisible(false);
        if (this.rbInitial1.isSelected()) {
            this.lblName1.remove(this.cmbParameter1);
            this.lblName1.add(this.cmbSpecies1);
        } else {
            this.lblName1.remove(this.cmbSpecies1);
            this.lblName1.add(this.cmbParameter1);
        }
        this.setVisible(true);
    }

    private void redrawIdLabel2() {
        this.setVisible(false);
        if (this.rbInitial2.isSelected()) {
            this.lblName2.remove(this.cmbParameter2);
            this.lblName2.add(this.cmbSpecies2);
        } else {
            this.lblName2.remove(this.cmbSpecies2);
            this.lblName2.add(this.cmbParameter2);
        }
        this.setVisible(true);
    }

    public void setIdList(File filepath) {
        this.rgstIdComboItem(filepath, "0");
        this.rgstIdComboItem(filepath, "1");
    }

    public void updateIdList() {
        this.rgstIdComboItem("0");
        this.rgstIdComboItem("1");
    }

    private boolean isParameterGlobal() {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        return lstSBase.size() != 0L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.chkScan1) {
            this.setEnableStatusOnComponents1();
            this.parameterScan.setDoScanParameter(CodeInformation.SIMULATION_1, this.chkScan1.isSelected());
        } else if (e.getSource() == this.chkScan2) {
            this.setEnableStatusOnComponents2();
            this.parameterScan.setDoScanParameter(CodeInformation.SIMULATION_2, this.chkScan2.isSelected());
        } else if (e.getSource() == this.rbInitial1) {
            this.redrawIdLabel1();
            this.parameterScan.setKindOfParameter("initial value", CodeInformation.SIMULATION_1);
            this.parameterScan.setTarget((String)this.cmbSpecies1.getSelectedItem(), CodeInformation.SIMULATION_1);
        } else if (e.getSource() == this.rbParameter1) {
            this.redrawIdLabel1();
            this.parameterScan.setKindOfParameter("parameter value", CodeInformation.SIMULATION_1);
            this.parameterScan.setTarget(this.cmbParameter1.getSelectedItem().toString(), CodeInformation.SIMULATION_1);
        } else if (e.getSource() == this.rbInitial2) {
            this.redrawIdLabel2();
            this.parameterScan.setKindOfParameter("initial value", CodeInformation.SIMULATION_2);
            this.parameterScan.setTarget((String)this.cmbSpecies2.getSelectedItem(), CodeInformation.SIMULATION_2);
        } else if (e.getSource() == this.rbParameter2) {
            this.redrawIdLabel2();
            this.parameterScan.setKindOfParameter("parameter value", CodeInformation.SIMULATION_2);
            this.parameterScan.setTarget(this.cmbParameter2.getSelectedItem().toString(), CodeInformation.SIMULATION_2);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spnFrom1) {
            this.parameterScan.setFrom(String.valueOf(this.spnFrom1.getValue()), CodeInformation.SIMULATION_1);
        } else if (e.getSource() == this.spnTo1) {
            this.parameterScan.setTo(String.valueOf(this.spnTo1.getValue()), CodeInformation.SIMULATION_1);
        } else if (e.getSource() == this.spnInterval1) {
            this.parameterScan.setInterval(String.valueOf(this.spnInterval1.getValue()), CodeInformation.SIMULATION_1);
        } else if (e.getSource() == this.spnFrom2) {
            this.parameterScan.setFrom(String.valueOf(this.spnFrom2.getValue()), CodeInformation.SIMULATION_2);
        } else if (e.getSource() == this.spnTo2) {
            this.parameterScan.setTo(String.valueOf(this.spnTo2.getValue()), CodeInformation.SIMULATION_2);
        } else if (e.getSource() == this.spnInterval2) {
            this.parameterScan.setInterval(String.valueOf(this.spnInterval2.getValue()), CodeInformation.SIMULATION_2);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cmbSpecies1) {
            this.parameterScan.setTarget((String)this.cmbSpecies1.getSelectedItem(), CodeInformation.SIMULATION_1);
        } else if (e.getSource() == this.cmbParameter1) {
            this.parameterScan.setTarget(this.cmbParameter1.getSelectedItem().toString(), CodeInformation.SIMULATION_1);
        } else if (e.getSource() == this.cmbSpecies2) {
            this.parameterScan.setTarget((String)this.cmbSpecies2.getSelectedItem(), CodeInformation.SIMULATION_2);
        } else if (e.getSource() == this.cmbParameter2) {
            this.parameterScan.setTarget(this.cmbParameter2.getSelectedItem().toString(), CodeInformation.SIMULATION_2);
        }
    }

    private void setParameterScan() {
        this.parameterScan.setDoScanParameter(CodeInformation.SIMULATION_1, this.chkScan1.isSelected());
        this.parameterScan.setDoScanParameter(CodeInformation.SIMULATION_2, this.chkScan2.isSelected());
        this.parameterScan.setKindOfParameter("initial value", CodeInformation.SIMULATION_1);
        this.parameterScan.setKindOfParameter("parameter value", CodeInformation.SIMULATION_2);
        this.parameterScan.setTarget((String)this.cmbSpecies1.getItemAt(0), CodeInformation.SIMULATION_1);
        if (this.cmbParameter2.getItemAt(0) != null) {
            this.parameterScan.setTarget(this.cmbParameter2.getItemAt(0).toString(), CodeInformation.SIMULATION_2);
        } else {
            this.rbInitial2.setSelected(true);
            this.rbParameter2.setSelected(false);
            this.redrawIdLabel2();
            this.cmbSpecies2.setSelectedIndex(0);
            this.parameterScan.setTarget(this.cmbSpecies2.getItemAt(0).toString(), CodeInformation.SIMULATION_2);
        }
        this.parameterScan.setFrom(String.valueOf(this.spnFrom1.getValue()), CodeInformation.SIMULATION_1);
        this.parameterScan.setFrom(String.valueOf(this.spnFrom2.getValue()), CodeInformation.SIMULATION_2);
        this.parameterScan.setTo(String.valueOf(this.spnTo1.getValue()), CodeInformation.SIMULATION_1);
        this.parameterScan.setTo(String.valueOf(this.spnTo2.getValue()), CodeInformation.SIMULATION_2);
        this.parameterScan.setInterval(String.valueOf(this.spnInterval1.getValue()), CodeInformation.SIMULATION_1);
        this.parameterScan.setInterval(String.valueOf(this.spnInterval2.getValue()), CodeInformation.SIMULATION_2);
    }

    public int getSelectedIndexCombo(int index, String type) {
        if (index == 0 && type.equals("initial value")) {
            return this.cmbSpecies1.getSelectedIndex();
        }
        if (index == 0 && type.equals("parameter value")) {
            return this.cmbParameter1.getSelectedIndex();
        }
        if (index == 1 && type.equals("initial value")) {
            return this.cmbSpecies2.getSelectedIndex();
        }
        if (index == 1 && type.equals("parameter value")) {
            return this.cmbParameter2.getSelectedIndex();
        }
        return -1;
    }

    public ParameterScan getParameterScan() {
        return this.parameterScan;
    }
}

