/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.co.mki.celldesigner.simulation.controlpanel.ChangeAmount;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.TabPlotSetting;
import jp.co.mki.celldesigner.simulation.controlpanel.TabSpecies;
import jp.co.mki.celldesigner.simulation.util.FormatF;
import jp.co.mki.celldesigner.simulation.util.SimulationCheck;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.co.mki.celldesigner.simulation.viewparts.LimitedField;
import jp.co.mki.celldesigner.simulation.viewparts.NumericField;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.Species;

public class TabChangeAmount
extends JPanel
implements ActionListener {
    private final int X_WIDTH = 850;
    private final int Y_WIDTH = 500;
    private File XMLFile = null;
    private JCheckBox chkChangeAmount = null;
    private boolean bChangeAmount = false;
    private JTable mainTable = null;
    private List headerName = new ArrayList();
    private List specieId = new ArrayList();
    private List initialQuantity = new ArrayList();
    private GridBagLayout grbLayout = null;
    private JScrollPane scrPane = null;
    private JLabel lblChangeAmount = null;
    private String[][] tblDataStorage = null;
    private TableModel tblModel = null;
    private final int NUM_COL = 8;
    private TabPlotSetting plotSetting = null;
    private SBMLPanelLists sbmlPanelLists = null;
    private TabSpecies species = null;
    private JLabel lblInterval = null;
    private JTextField txtFldSpan = this.getTextFieldSpan();
    private JTextField txtFldStep = this.getTextFieldStep();
    private double spanValue;
    private double stepValue;
    private ChangeAmount changeAmount = null;
    private ArrayList speciesList = new ArrayList();
    private ControlPanelMainWindow parent;
    private JTable _mainTable;

    public JTable getMainTableObj() {
        return this._mainTable;
    }

    public ChangeAmount getChangeAmount() {
        return this.changeAmount;
    }

    public void setChangeAmount(ChangeAmount changeAmount) {
        this.changeAmount = changeAmount;
    }

    public TabChangeAmount(TabPlotSetting plotSetting, File XMLFile) {
        this.plotSetting = plotSetting;
        this.XMLFile = XMLFile;
        this.initThisObjectInformation();
        this.addComponents();
        this.setEnableStatusOnComponents();
        plotSetting.setChangeAmount(this);
    }

    public TabChangeAmount(ControlPanelMainWindow parent, ChangeAmount changeAmount, SBMLPanelLists sbmlPanelLists, TabSpecies species, TabPlotSetting plotSetting) {
        this.parent = parent;
        this.changeAmount = changeAmount;
        this.sbmlPanelLists = sbmlPanelLists;
        this.plotSetting = plotSetting;
        this.species = species;
        species.setTabChangeAmount(this);
        this.setInitValue();
        plotSetting.setChangeAmount(this);
        this.initThisObjectInformation();
        this.addComponents();
        this.setChangeAmount(parent.isXMLLoad);
    }

    private void setInitValue() {
        double initSpanValue = 240.0;
        double initStepValue = 30.0;
        this.spanValue = initSpanValue;
        this.stepValue = initStepValue;
    }

    private void initThisObjectInformation() {
        this.grbLayout = new GridBagLayout();
        this.setLayout(this.grbLayout);
        this.setSize(850, 500);
    }

    private void addComponents() {
        this.setLblChangeAmount();
    }

    public void setLblChangeAmount() {
        if (this.chkChangeAmount != null) {
            this.remove(this.chkChangeAmount);
            this.setVisible(false);
        }
        if (this.lblChangeAmount != null) {
            this.remove(this.lblChangeAmount);
            this.setVisible(false);
        }
        GridBagConstraints grc = new GridBagConstraints();
        this.chkChangeAmount = this.getChkChangeAmount();
        grc.gridx = 0;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.weighty = 0.0;
        grc.insets = new Insets(5, 5, 2, 2);
        grc.ipadx = 50;
        grc.ipady = 5;
        grc.anchor = 23;
        this.grbLayout.setConstraints(this.chkChangeAmount, grc);
        this.add(this.chkChangeAmount);
        if (this.parent.isXMLLoad) {
            this.chkChangeAmount.setSelected(this.changeAmount.doChangeAmount());
        }
        this.lblInterval = this.getLblInterval();
        this.txtFldSpan.setText(String.valueOf(this.spanValue));
        this.txtFldStep.setText(String.valueOf(this.stepValue));
        this.txtFldSpan.setHorizontalAlignment(4);
        this.txtFldStep.setHorizontalAlignment(4);
        this.lblInterval.add(new JLabel("To"));
        this.lblInterval.add(this.txtFldSpan);
        this.lblInterval.add(new JLabel("Interval"));
        this.lblInterval.add(this.txtFldStep);
        grc.gridx = 0;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.insets = new Insets(5, 5, 2, 2);
        grc.ipadx = 200;
        grc.ipady = 55;
        grc.anchor = 23;
        this.grbLayout.setConstraints(this.lblInterval, grc);
        this.add(this.lblInterval);
        if (this.parent.isXMLLoad) {
            this.spanValue = Double.parseDouble(this.changeAmount.getSpan());
            this.stepValue = Double.parseDouble(this.changeAmount.getStep());
            this.txtFldSpan.setText(this.changeAmount.getSpan());
            this.txtFldStep.setText(this.changeAmount.getStep());
        }
        this.mainTable = this.getMainTable();
        this.scrPane = new JScrollPane(this.mainTable);
        this.lblChangeAmount = this.getLblChangeAmount();
        this.lblChangeAmount.add(this.scrPane);
        grc.gridx = 0;
        grc.gridy = 2;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weighty = 1.0;
        grc.insets = new Insets(0, 5, 0, 5);
        grc.fill = 1;
        this.grbLayout.setConstraints(this.lblChangeAmount, grc);
        this.add(this.lblChangeAmount);
        this.setVisible(true);
    }

    public void setEnableStatusOnComponents() {
        if (!this.chkChangeAmount.isSelected()) {
            this.lblChangeAmount.setEnabled(false);
            this.mainTable.setEnabled(false);
            this.txtFldSpan.setEnabled(false);
            this.txtFldStep.setEnabled(false);
            this.scrPane.setEnabled(false);
        } else {
            this.lblChangeAmount.setEnabled(true);
            this.mainTable.setEnabled(true);
            this.txtFldSpan.setEnabled(true);
            this.txtFldStep.setEnabled(true);
            this.scrPane.setEnabled(true);
        }
    }

    private JCheckBox getChkChangeAmount() {
        JCheckBox _chkChangeAmount = new JCheckBox("Change amount", false);
        _chkChangeAmount.setSelected(this.bChangeAmount);
        _chkChangeAmount.addActionListener(this);
        return _chkChangeAmount;
    }

    private JLabel getLblChangeAmount() {
        JLabel _lblChangeAmount = new JLabel();
        _lblChangeAmount.setBorder(new TitledBorder("Change amount"));
        _lblChangeAmount.setLayout(new GridLayout(1, 1));
        return _lblChangeAmount;
    }

    private JTable getMainTable() {
        this._mainTable = null;
        this.setHeaderName();
        this.setFixedPart();
        if (this.changeAmount.getAmounts() == null) {
            this.tblDataStorage = new String[this.specieId.size()][this.headerName.size()];
        } else {
            String[][] beforeTblDataStorage = null;
            if (this.tblDataStorage != null) {
                int k;
                int i;
                beforeTblDataStorage = this.tblDataStorage;
                this.tblDataStorage = new String[this.specieId.size()][this.headerName.size()];
                if (this.headerName.size() > beforeTblDataStorage[0].length) {
                    i = 0;
                    while (i < this.specieId.size()) {
                        k = 0;
                        while (k < beforeTblDataStorage[i].length) {
                            this.tblDataStorage[i][k] = beforeTblDataStorage[i][k];
                            ++k;
                        }
                        ++i;
                    }
                } else if (this.headerName.size() <= beforeTblDataStorage[0].length) {
                    i = 0;
                    while (i < this.specieId.size()) {
                        k = 0;
                        while (k < this.headerName.size()) {
                            this.tblDataStorage[i][k] = beforeTblDataStorage[i][k];
                            ++k;
                        }
                        ++i;
                    }
                }
            } else {
                this.tblDataStorage = this.changeAmount.getAmounts();
            }
        }
        int i = 0;
        Iterator itSpecieId = this.specieId.iterator();
        Iterator itInitQuantity = this.initialQuantity.iterator();
        int left = 0;
        int right = 0;
        while (itInitQuantity.hasNext()) {
            String initialQuantity = (String)itInitQuantity.next();
            StringTokenizer token = new StringTokenizer(initialQuantity, ".");
            String firstToken = token.nextToken();
            if (firstToken.length() > left) {
                left = firstToken.length();
            }
            try {
                String lastToken = token.nextToken();
                if (lastToken.indexOf("E") != -1 || lastToken.length() <= right) continue;
                right = lastToken.length();
            }
            catch (Exception lastToken) {
                // empty catch block
            }
        }
        i = 0;
        itInitQuantity = this.initialQuantity.iterator();
        while (itSpecieId.hasNext()) {
            this.tblDataStorage[i][0] = (String)itSpecieId.next();
            String value = (String)itInitQuantity.next();
            if (value.indexOf("E") == -1) {
                FormatF df = new FormatF(left, right);
                if ((value = String.valueOf(df.format(Double.parseDouble(value)))).indexOf(",", 0) != -1) {
                    value = StringTool.replaceString(value, ",", "");
                }
                this.tblDataStorage[i++][1] = value;
                continue;
            }
            if (value.indexOf(",", 0) != -1) {
                value = StringTool.replaceString(value, ",", "");
            }
            this.tblDataStorage[i++][1] = value;
        }
        this.tblModel = new MyTableModel();
        this._mainTable = new JTable(this.tblModel);
        this._mainTable.setCellSelectionEnabled(true);
        this._mainTable.getTableHeader().setReorderingAllowed(false);
        int colSize = this.headerName.size();
        int j = 0;
        while (j < colSize) {
            block25: {
                TableColumn col;
                try {
                    col = this._mainTable.getColumnModel().getColumn(j);
                }
                catch (Exception myErr) {
                    break block25;
                }
                col.setCellEditor(new TextCellEditor(new JTextField()));
                col.setHeaderValue(String.valueOf(this.headerName.get(j)));
                if (j >= 2) {
                    col.setCellRenderer(new ColoredTableCellRenderer(true));
                } else {
                    col.setCellRenderer(new ColoredTableCellRenderer(false));
                }
                if (j == 0) {
                    col.setPreferredWidth(100);
                }
            }
            ++j;
        }
        this.changeAmount.setAmounts(this.tblDataStorage);
        this._mainTable.setAutoResizeMode(0);
        this._mainTable.setSize(500, 300);
        return this._mainTable;
    }

    public void setPlotSetting(TabPlotSetting plotSetting) {
        this.plotSetting = plotSetting;
    }

    public void setHeaderName() {
        double StepValue;
        double SpanValue = this.spanValue;
        double sumValue = StepValue = this.stepValue;
        this.headerName.clear();
        this.headerName.add("species/time point");
        this.headerName.add("0");
        while (sumValue <= SpanValue) {
            this.headerName.add(String.valueOf(sumValue));
            sumValue = Double.parseDouble(StringTool.convertNumberFormat(sumValue + StepValue));
        }
        this.changeAmount.setHeaderName((ArrayList)this.headerName);
    }

    public void pasteHeaderName() {
        int colSize = this.headerName.size();
        int j = 0;
        while (j < colSize) {
            TableColumn col = this.mainTable.getColumnModel().getColumn(j);
            col.setCellEditor(new TextCellEditor(new JTextField()));
            col.setHeaderValue(String.valueOf(this.headerName.get(j)));
            ++j;
        }
    }

    public void redrawMainTable() {
        this.remove(this.lblChangeAmount);
        this.setVisible(false);
        GridBagConstraints grc = new GridBagConstraints();
        this.mainTable = this.getMainTable();
        this.scrPane = new JScrollPane(this.mainTable);
        this.lblChangeAmount = this.getLblChangeAmount();
        this.lblChangeAmount.add(this.scrPane);
        grc.gridx = 0;
        grc.gridy = 2;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weighty = 1.0;
        grc.insets = new Insets(0, 5, 350, 5);
        grc.ipadx = 500;
        grc.ipady = 350;
        this.grbLayout.setConstraints(this.lblChangeAmount, grc);
        this.add(this.lblChangeAmount);
        this.setVisible(true);
    }

    public void setFixedPart() {
        try {
            this.initialQuantity.clear();
            this.specieId.clear();
            this.speciesList.clear();
            Object tokenizer = null;
            String idSequence = "";
            ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
            int i = 0;
            while (i < listOfSpeciesData.size()) {
                SpeciesData speciesD = (SpeciesData)listOfSpeciesData.get(i);
                Species species = speciesD.getSpecies();
                if (species.isSetInitialAmount()) {
                    this.initialQuantity.add(String.valueOf(species.getInitialAmount()));
                } else {
                    this.initialQuantity.add(String.valueOf(species.getInitialConcentration()));
                }
                String idseq = "";
                idseq = speciesD.toString();
                this.specieId.add(idseq);
                this.speciesList.add(idseq);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFixedPartByXML(File filepath) {
        SBMLDocument sbmlDocument = new SBMLDocument();
        try {
            SBMLReader reader = new SBMLReader();
            sbmlDocument = reader.readSBML(filepath.getAbsolutePath());
            StringTokenizer tokenizer = null;
            String idSequence = "";
            idSequence = this.getElementIdSequence((ListOf)sbmlDocument.getModel().getListOfSpecies());
            tokenizer = new StringTokenizer(idSequence, ",", false);
            while (tokenizer.hasMoreTokens()) {
                this.specieId.add(tokenizer.nextToken());
            }
            ListOfSpecies lstSBase = sbmlDocument.getModel().getListOfSpecies();
            int lstSize = (int)lstSBase.size();
            int i = 0;
            while (i < lstSize) {
                Species species = (Species)lstSBase.get((long)i);
                if (species.isSetInitialAmount()) {
                    this.initialQuantity.add(String.valueOf(species.getInitialAmount()));
                } else {
                    this.initialQuantity.add(String.valueOf(species.getInitialConcentration()));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized String getElementIdSequence(ListOf list) {
        String idseq = "";
        if (list == null) {
            return idseq;
        }
        int size = (int)list.size();
        if (size == 0) {
            return idseq;
        }
        Species s = (Species)list.get(0L);
        idseq = String.valueOf(idseq) + s.getId();
        int i = 1;
        while (i < size) {
            s = (Species)list.get((long)i);
            idseq = String.valueOf(idseq) + "," + s.getId();
            ++i;
        }
        return idseq;
    }

    public void setLabelChangeAmount(String value) {
        this.lblChangeAmount.setText(value);
        this.spanValue = Double.parseDouble(value);
        this.changeAmount.setSpan(value);
    }

    public List getHeaderName() {
        return this.headerName;
    }

    public void updateDataStorageTable(int row, String value) {
        this.tblDataStorage[row][1] = value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.chkChangeAmount) {
            this.setEnableStatusOnComponents();
            this.bChangeAmount = this.chkChangeAmount.isSelected();
            this.mainTable.repaint();
            this.setDoChangeAmount();
        } else {
            double sp;
            try {
                sp = Double.parseDouble(this.txtFldSpan.getText());
                double d = Double.parseDouble(this.txtFldStep.getText());
            }
            catch (Exception ex) {
                return;
            }
            sp = Double.parseDouble(this.txtFldSpan.getText());
            double st = Double.parseDouble(this.txtFldStep.getText());
            if (sp == 0.0) {
                JOptionPane.showMessageDialog(null, "Please set values that are larger than 0 to span.", "WARN", 0);
                this.txtFldSpan.setText(this.changeAmount.getSpan());
                return;
            }
            if (st == 0.0) {
                JOptionPane.showMessageDialog(null, "Please set values that are larger than 0 to step.", "WARN", 0);
                this.txtFldStep.setText(this.changeAmount.getStep());
                return;
            }
            if (sp < st) {
                JOptionPane.showMessageDialog(this, "Please input a value that is smaller than span to step. ", "WARN", 1);
                this.txtFldSpan.setText(this.changeAmount.getSpan());
                this.txtFldStep.setText(this.changeAmount.getStep());
                return;
            }
            this.spanValue = Double.parseDouble(this.txtFldSpan.getText());
            this.stepValue = Double.parseDouble(this.txtFldStep.getText());
            this.changeAmount.setSpan(this.txtFldSpan.getText());
            this.changeAmount.setStep(this.txtFldStep.getText());
            this.setLblChangeAmount();
            this.parent.setSpanValue(this.txtFldSpan.getText());
        }
    }

    public ArrayList getSpeciesList() {
        return this.speciesList;
    }

    public void stateChanged(ChangeEvent e) {
        this.redrawChangeAmount();
    }

    private JLabel getLblInterval() {
        JLabel _lblInterval = new JLabel();
        _lblInterval.setBorder(new TitledBorder("Time Point"));
        _lblInterval.setLayout(new GridLayout(2, 2));
        return _lblInterval;
    }

    private JTextField getTextFieldSpan() {
        NumericField _txtFldSpan = new NumericField();
        _txtFldSpan.setDocument(new LimitedField(8));
        _txtFldSpan.addActionListener(this);
        _txtFldSpan.setPreferredSize(new Dimension(65, 20));
        return _txtFldSpan;
    }

    private JTextField getTextFieldStep() {
        NumericField _txtFldStep = new NumericField();
        _txtFldStep.setDocument(new LimitedField(8));
        _txtFldStep.addActionListener(this);
        _txtFldStep.setPreferredSize(new Dimension(65, 20));
        return _txtFldStep;
    }

    private void redrawChangeAmount() {
        this.redrawMainTable();
    }

    private void setDoChangeAmount() {
        this.changeAmount.setDoChangeAmount(this.chkChangeAmount.isSelected());
    }

    public boolean isChkChangeAmount() {
        return this.chkChangeAmount.isSelected();
    }

    public String[][] getTblDataStorage() {
        return this.tblDataStorage;
    }

    public void setTblDataStorage(String[][] tblDataStorage) {
        this.tblDataStorage = tblDataStorage;
    }

    private void setChangeAmount(boolean isLoaded) {
        if (!this.parent.isXMLLoad) {
            this.changeAmount.setDoChangeAmount(this.chkChangeAmount.isSelected());
            this.changeAmount.setSpan(String.valueOf(this.spanValue));
            this.changeAmount.setStep(String.valueOf(this.stepValue));
            this.changeAmount.setSpeciesList(this.speciesList);
            this.changeAmount.setAmounts(this.tblDataStorage);
            this.changeAmount.setHeaderName((ArrayList)this.headerName);
        } else {
            this.changeAmount.setSpeciesList(this.speciesList);
        }
    }

    public class ColoredTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        boolean editStatus;

        public ColoredTableCellRenderer(boolean editStatus) {
            this.editStatus = editStatus;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object val, boolean isSelected, boolean hasFocus, int row, int column) {
            String value = (String)table.getModel().getValueAt(row, column);
            this.setText(value);
            if (!TabChangeAmount.this.chkChangeAmount.isSelected()) {
                int RED = 50;
                int GREEN = 50;
                int BLUE = 50;
                int ALPHA = 50;
                this.setForeground(Color.BLACK);
                this.setBackground(new Color(50, 50, 50, 50));
            } else if (!this.editStatus) {
                if (isSelected) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLUE);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.WHITE);
                }
            } else {
                boolean RED = false;
                boolean GREEN = false;
                int BLUE = 120;
                int ALPHA = 25;
                if (isSelected) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLUE);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(new Color(0, 0, 120, 25));
                }
            }
            if (column != 0) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            this.validate();
            return this;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return TabChangeAmount.this.tblDataStorage.length;
        }

        @Override
        public int getColumnCount() {
            return TabChangeAmount.this.tblDataStorage[0].length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return TabChangeAmount.this.tblDataStorage[row][col];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex > 1;
        }
    }

    private class TextCellEditor
    extends DefaultCellEditor {
        int row;
        int col;

        TextCellEditor(JTextField textField) {
            super(textField);
            this.setClickCountToStart(1);
            this.addCellEditorListener(new TextCellEditorListener());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.row = row;
            this.col = col;
            return super.getTableCellEditorComponent(table, value, isSelected, row, col);
        }

        private class TextCellEditorListener
        implements CellEditorListener {
            private TextCellEditorListener() {
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultCellEditor editor = (DefaultCellEditor)e.getSource();
                Object value = editor.getCellEditorValue();
                String sValue = (String)value;
                if (sValue.equals("") || SimulationCheck.isBecomeToDouble(sValue)) {
                    if (sValue.indexOf(",", 0) != -1) {
                        sValue = StringTool.replaceString(sValue, ",", "");
                    }
                    ((TabChangeAmount)((TextCellEditor)TextCellEditor.this).TabChangeAmount.this).tblDataStorage[TextCellEditor.this.row][TextCellEditor.this.col] = sValue;
                    TabChangeAmount.this.changeAmount.setAmounts(TabChangeAmount.this.tblDataStorage);
                } else {
                    JOptionPane.showMessageDialog(null, "The value which is not the integer value is input. ", "WARN", 0);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        }
    }
}

