/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.co.mki.celldesigner.simulation.controlpanel.TriangleIcon;
import jp.co.mki.celldesigner.simulation.viewparts.NumericField;

public class Spinner
extends JPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private NumericField valueTextField = new NumericField();
    private TriangleIcon topTriangle = null;
    private TriangleIcon bottomTriangle = null;
    private TriangleIcon leftTriangle = null;
    private TriangleIcon rightTriangle = null;
    private DecimalFormat decimalFormat = null;
    private Vector listenerList = null;
    public static int VERTICAL = 0;
    public static int HORIZONTAL = 1;
    private double value = 0.0;
    private double maximum = Double.MAX_VALUE;
    private double minimum = Double.NEGATIVE_INFINITY;
    private double rc = 0.1;
    private int minimumFractionDigits = -1;
    private int orientation = VERTICAL;
    JPanel buttonPanel = new JPanel();
    JButton upButton = new JButton();
    JPanel subButtonPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    GridLayout buttonGridLayout = new GridLayout();
    JButton downButton = new JButton();

    public Spinner() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Spinner(int columns) throws IllegalArgumentException {
        try {
            this.valueTextField.setColumns(columns);
            this.init();
        }
        catch (IllegalArgumentException ee) {
            throw ee;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(this.borderLayout1);
        this.valueTextField.setText("0.0");
        this.valueTextField.setHorizontalAlignment(4);
        this.valueTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Spinner.this.valueTextField_Enter(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.upButton.setMinimumSize(new Dimension(19, 12));
        this.upButton.setPreferredSize(new Dimension(19, 12));
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Spinner.this.upButton_actionPerformed(e);
            }
        });
        this.subButtonPanel.setLayout(this.buttonGridLayout);
        this.buttonPanel.setLayout(this.borderLayout2);
        this.buttonGridLayout.setColumns(1);
        this.buttonGridLayout.setRows(2);
        this.downButton.setMinimumSize(new Dimension(19, 12));
        this.downButton.setPreferredSize(new Dimension(19, 12));
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.setSelected(true);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Spinner.this.downButton_actionPerformed(e);
            }
        });
        this.add((Component)this.valueTextField, "Center");
        this.add((Component)this.buttonPanel, "West");
        this.buttonPanel.add((Component)this.subButtonPanel, "West");
        this.subButtonPanel.add((Component)this.upButton, null);
        this.subButtonPanel.add((Component)this.downButton, null);
        this.topTriangle = new TriangleIcon(TriangleIcon.TOP, TriangleIcon.FILL);
        this.topTriangle.setIconHeight(this.upButton.getHeight() - 4);
        this.topTriangle.setIconWidth(this.upButton.getWidth() - 4);
        this.topTriangle.setTop(TriangleIcon.TOP);
        this.upButton.setIcon(this.topTriangle);
        this.bottomTriangle = new TriangleIcon(TriangleIcon.BOTTOM, TriangleIcon.FILL);
        this.bottomTriangle.setIconHeight(this.downButton.getHeight() - 4);
        this.bottomTriangle.setIconWidth(this.downButton.getWidth() - 4);
        this.bottomTriangle.setTop(TriangleIcon.BOTTOM);
        this.downButton.setIcon(this.bottomTriangle);
        this.buttonPanel.setBackground(this.getBackground());
        this.subButtonPanel.setBackground(this.getBackground());
    }

    void upButton_actionPerformed(ActionEvent e) {
        this.setNextValue();
    }

    void downButton_actionPerformed(ActionEvent e) {
        this.setPreviousValue();
    }

    public double getValue() {
        double v = 0.0;
        try {
            v = Double.parseDouble(this.valueTextField.getText());
            if (!this.dToS(this.value).equals(this.dToS(v))) {
                this.value = v;
                if (!this.setValueInRange()) {
                    this.valueTextField.setText(this.dToS(this.value));
                }
                this.fireStateChanged();
            }
        }
        catch (NumberFormatException e) {
            this.valueTextField.setText(this.dToS(this.value));
            e.printStackTrace();
        }
        return this.value;
    }

    public void setValue(double v) {
        this.value = v;
        this.setValueInRange();
        this.valueTextField.setText(this.dToS(this.value));
        this.value = Double.parseDouble("3.33");
        this.fireStateChanged();
    }

    public void setNextValue() {
        this.value = this.getValue();
        this.value += this.rc;
        boolean flag = this.setValueInRange();
        this.valueTextField.setText(this.dToS(this.value));
        this.value = Double.parseDouble(this.valueTextField.getText());
        this.fireStateChanged();
    }

    public void setPreviousValue() {
        this.value = this.getValue();
        this.value -= this.rc;
        boolean flag = this.setValueInRange();
        this.valueTextField.setText(this.dToS(this.value));
        this.value = Double.parseDouble(this.valueTextField.getText());
        this.fireStateChanged();
    }

    void valueTextField_Enter(KeyEvent e) {
        double v = 0.0;
        try {
            v = Double.parseDouble(this.valueTextField.getText());
            if (this.value != v) {
                this.value = v;
                this.setValueInRange();
                this.valueTextField.setText(this.dToS(this.value));
                this.value = Double.parseDouble(this.valueTextField.getText());
                this.fireStateChanged();
            }
        }
        catch (NumberFormatException ee) {
            this.valueTextField.setText(this.dToS(this.value));
        }
    }

    private boolean setValueInRange() {
        if (this.value >= this.maximum) {
            this.value = this.maximum;
            return false;
        }
        if (this.value <= this.minimum) {
            this.value = this.minimum;
            return false;
        }
        return true;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
        if (!this.setValueInRange()) {
            this.valueTextField.setText(this.dToS(this.value));
            this.value = Double.parseDouble(this.valueTextField.getText());
            this.fireStateChanged();
        }
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
        if (!this.setValueInRange()) {
            this.valueTextField.setText(this.dToS(this.value));
            this.value = Double.parseDouble(this.valueTextField.getText());
            this.fireStateChanged();
        }
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setRC(double rc) {
        if (rc > 0.0) {
            this.rc = rc;
        }
    }

    public double getRC() {
        return this.rc;
    }

    public void setOrientation(int orientation) {
        if (orientation == VERTICAL) {
            if (this.orientation != orientation) {
                this.buttonGridLayout.setColumns(1);
                this.buttonGridLayout.setRows(2);
                this.subButtonPanel.remove(this.downButton);
                this.subButtonPanel.add(this.downButton);
                this.remove(this.buttonPanel);
                this.add((Component)this.buttonPanel, "West");
                this.upButton.setMinimumSize(new Dimension(19, 12));
                this.upButton.setPreferredSize(new Dimension(19, 12));
                this.downButton.setMinimumSize(new Dimension(19, 12));
                this.downButton.setPreferredSize(new Dimension(19, 12));
                this.validate();
                this.topTriangle.setIconHeight(this.upButton.getHeight() - 4);
                this.topTriangle.setIconWidth(this.upButton.getWidth() - 4);
                this.bottomTriangle.setIconHeight(this.downButton.getHeight() - 4);
                this.bottomTriangle.setIconWidth(this.downButton.getWidth() - 4);
                this.upButton.setIcon(this.topTriangle);
                this.downButton.setIcon(this.bottomTriangle);
            }
            this.orientation = orientation;
        } else if (orientation == HORIZONTAL) {
            if (this.orientation != orientation) {
                this.buttonGridLayout.setColumns(2);
                this.buttonGridLayout.setRows(1);
                this.subButtonPanel.remove(this.upButton);
                this.subButtonPanel.add(this.upButton);
                this.remove(this.buttonPanel);
                this.add((Component)this.buttonPanel, "West");
                this.upButton.setMinimumSize(new Dimension(10, 17));
                this.upButton.setPreferredSize(new Dimension(10, 17));
                this.downButton.setMinimumSize(new Dimension(10, 17));
                this.downButton.setPreferredSize(new Dimension(10, 17));
                this.validate();
                if (this.rightTriangle == null) {
                    this.rightTriangle = new TriangleIcon(TriangleIcon.RIGHT, TriangleIcon.FILL);
                }
                this.rightTriangle.setIconHeight(this.upButton.getHeight() - 4);
                this.rightTriangle.setIconWidth(this.upButton.getWidth() - 4);
                this.upButton.setIcon(this.rightTriangle);
                if (this.leftTriangle == null) {
                    this.leftTriangle = new TriangleIcon(TriangleIcon.LEFT, TriangleIcon.FILL);
                }
                this.leftTriangle.setIconHeight(this.downButton.getHeight() - 4);
                this.leftTriangle.setIconWidth(this.downButton.getWidth() - 4);
                this.downButton.setIcon(this.leftTriangle);
            }
            this.orientation = orientation;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setMinimumFractionDigits(int digits) {
        this.minimumFractionDigits = digits;
        if (digits < 0) {
            this.decimalFormat = null;
        } else if (digits == 0) {
            this.decimalFormat = new DecimalFormat("0");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("0.");
            int i = 0;
            while (i < this.minimumFractionDigits) {
                sb.append("0");
                ++i;
            }
            this.decimalFormat = new DecimalFormat(sb.toString());
        }
        double tempValue = this.value;
        this.valueTextField.setText(this.dToS(this.value));
        this.value = Double.parseDouble(this.valueTextField.getText());
        if (this.value != tempValue) {
            this.fireStateChanged();
        }
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    private String dToS(double d) {
        if (this.decimalFormat != null) {
            return this.decimalFormat.format(d);
        }
        return Double.toString(d);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.buttonPanel != null) {
            this.buttonPanel.setBackground(bg);
        }
        if (this.subButtonPanel != null) {
            this.subButtonPanel.setBackground(bg);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new Vector();
        }
        this.listenerList.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.listenerList) {
            cl.stateChanged(ce);
        }
    }
}

