/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.util.HashMap;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.controlpanel.VisibleChangeEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.VisibleChangeListener;

public class SpeciesVisible {
    private HashMap speciesVisibleMap = new HashMap();
    private Vector listenerVector = new Vector();

    public Boolean isVisible(String species) {
        if (species == null) {
            return null;
        }
        return (Boolean)this.speciesVisibleMap.get(species);
    }

    public void addSpeciesVisible(String species, boolean visible) {
        this.speciesVisibleMap.put(species, visible);
        this.fireStateChanged();
    }

    public void setSpeciesVisible(HashMap svMap) {
        this.speciesVisibleMap = svMap;
        this.fireStateChanged();
    }

    public void clear() {
        this.speciesVisibleMap.clear();
        this.fireStateChanged();
    }

    public void addVisibleChangeListener(VisibleChangeListener l) {
        if (!this.listenerVector.contains(l)) {
            this.listenerVector.add(l);
        }
    }

    public void removeVisibleChangeListener(VisibleChangeListener l) {
        this.listenerVector.remove(l);
    }

    protected void fireStateChanged() {
        for (VisibleChangeListener vcl : this.listenerVector) {
            vcl.stateChanged(new VisibleChangeEvent(this));
        }
    }
}

