/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.controlpanel.ColorChangeEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.ColorChangeListener;
import jp.co.mki.celldesigner.simulation.controlpanel.ListSelectionLocationEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.ListSelectionLocationListener;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesColorSet;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesVisible;
import jp.co.mki.celldesigner.simulation.controlpanel.VisibleChangeEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.VisibleChangeListener;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.Species;

public class SpeciesListPanel
extends JPanel
implements ColorChangeListener,
VisibleChangeListener {
    private SpeciesColorSet speciesColorSet = null;
    private SpeciesVisible speciesVisible = null;
    private Vector selectChangeListeners = new Vector();
    private Vector selectLocationChangeListeners = new Vector();
    private String searchedWord = null;
    private boolean selectChangeActionFlag = true;
    private int selectFocusIndex = -1;
    private JScrollPane speciesScrollPane = new JScrollPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JTextField searchTextField = new JTextField();
    private JButton searchButton = new JButton();
    private JLabel jLabel1 = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTable speciesTable = null;
    private SpeciesTableModel speciesTableModel = null;
    private GridLayout gridLayout1 = new GridLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private SBMLPanelLists sbmlPanelLists;
    private SimulationResultPanel parent;
    private JToggleButton jtoggleButton = new JToggleButton();
    private static String SELECT_ALL = "Select all";
    private static String UNSELECT_ALL = "Unselect all";

    public void setSBMLPanelLists(SBMLPanelLists sbmlPanelLists) {
        this.sbmlPanelLists = sbmlPanelLists;
    }

    public void setSimulationResultPanel(SimulationResultPanel parent) {
        this.parent = parent;
    }

    public JTable getSpeciesTable() {
        return this.speciesTable;
    }

    public void getCreateImage() {
        this.jPanel2.setVisible(false);
        this.jLabel1.setVisible(false);
    }

    public void setCreateImage() {
        this.jPanel2.setVisible(true);
        this.jLabel1.setVisible(true);
    }

    public SpeciesListPanel() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(this.borderLayout1);
        this.speciesTable = new JTable();
        this.speciesTable.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.speciesTable.setDefaultEditor(Color.class, new ColorEditor());
        this.speciesTable.getDefaultEditor(Boolean.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                String species = "";
                species = (String)SpeciesListPanel.this.speciesTableModel.getValueAt(SpeciesListPanel.this.speciesTable.getSelectedRow(), 1);
                SpeciesListPanel.this.speciesVisible.addSpeciesVisible(species, (Boolean)((DefaultCellEditor)e.getSource()).getCellEditorValue());
            }
        });
        this.speciesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SpeciesListPanel.this.speciesList_ListSelection(e);
            }
        });
        this.searchButton.setText("search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeciesListPanel.this.searchButton_actionPerformed(e);
            }
        });
        this.jtoggleButton.setText(UNSELECT_ALL);
        this.jtoggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpeciesListPanel.this.actionPerformed_jtoggleButton();
            }
        });
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("species search");
        this.jPanel1.setLayout(this.borderLayout2);
        this.searchTextField.setMinimumSize(new Dimension(20, 21));
        this.searchTextField.setColumns(6);
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SpeciesListPanel.this.searchTextField_keyPressed(e);
            }
        });
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.speciesScrollPane.setPreferredSize(new Dimension(200, 100));
        this.add((Component)this.speciesScrollPane, "Center");
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jtoggleButton, "North");
        this.jPanel1.add((Component)this.jLabel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.searchTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel2.add((Component)this.searchButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.speciesScrollPane.getViewport().add((Component)this.speciesTable, null);
    }

    public void setSpeciesList(Vector species) {
        this.searchedWord = null;
        this.speciesTable.clearSelection();
        if (species == null) {
            return;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < species.size()) {
            Object obj = species.get(i);
            String adt = "";
            adt = (String)obj;
            v.add(adt);
            ++i;
        }
        String[] adtList = new String[v.size()];
        v.toArray(adtList);
        Object[][] data = new Object[species.size()][3];
        int i2 = 0;
        while (i2 < species.size()) {
            Object obj = species.get(i2);
            String adt = "";
            adt = (String)obj;
            data[i2][1] = adt;
            if (obj instanceof Species) {
                Species sp = (Species)obj;
                adt = sp.getId();
            } else if (obj instanceof Object[]) {
                Object[] list = (Object[])obj;
                Species sp = (Species)list[0];
                SBMLResults result = (SBMLResults)list[1];
                adt = sp.getId();
                adt = String.valueOf(adt) + "\ufffd@" + result.getParameterInfo();
            }
            Boolean isBoolean = this.speciesVisible == null ? null : this.speciesVisible.isVisible(adt);
            data[i2][0] = isBoolean == null ? Boolean.TRUE : isBoolean;
            Color color = this.speciesColorSet == null ? null : this.speciesColorSet.getColor(adt);
            data[i2][2] = color == null ? Color.BLUE : color;
            ++i2;
        }
        this.speciesTableModel = new SpeciesTableModel();
        this.speciesTableModel.setValue(data);
        this.speciesTable.setModel(this.speciesTableModel);
    }

    public void setSpeciesColorSet(SpeciesColorSet sc) {
        this.speciesColorSet = sc;
    }

    public void setSpeciesVisible(SpeciesVisible sv) {
        this.speciesVisible = sv;
    }

    public String[] getSelectedSpecies() {
        int selectedRowCount = this.speciesTable.getSelectedRowCount();
        if (selectedRowCount == 0) {
            return new String[0];
        }
        Object[] obj = new Object[selectedRowCount];
        int[] selectedRowIndex = this.speciesTable.getSelectedRows();
        int i = 0;
        while (i < selectedRowIndex.length) {
            obj[i] = this.speciesTableModel.getValueAt(selectedRowIndex[i], 1);
            ++i;
        }
        String[] species = new String[obj.length];
        System.arraycopy(obj, 0, species, 0, obj.length);
        return species;
    }

    public void changeSelectionData(Vector selectedSpecies) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        Vector speciesListVector = new Vector();
        int i = 0;
        while (i < this.speciesTableModel.getRowCount()) {
            map.put(this.speciesTableModel.getValueAt(i, 1), new Integer(i));
            ++i;
        }
        Vector<Integer> indexVector = new Vector<Integer>();
        int i2 = 0;
        while (i2 < selectedSpecies.size()) {
            Integer inte = (Integer)map.get(selectedSpecies.get(i2));
            if (inte != null) {
                indexVector.add(inte);
            }
            ++i2;
        }
        int[] indexList = new int[indexVector.size()];
        this.speciesTable.clearSelection();
        int i3 = 0;
        while (i3 < indexVector.size()) {
            indexList[i3] = (Integer)indexVector.get(i3);
            this.speciesTable.addRowSelectionInterval(indexList[i3], indexList[i3]);
            ++i3;
        }
        this.selectChangeActionFlag = false;
        this.selectChangeActionFlag = true;
    }

    void actionPerformed_jtoggleButton() {
        Vector specieslist = this.parent.getSpeciesList();
        if (this.jtoggleButton.getText().equals(SELECT_ALL)) {
            this.jtoggleButton.setText(UNSELECT_ALL);
            int i = 0;
            while (i < specieslist.size()) {
                String s = (String)specieslist.get(i);
                this.speciesVisible.addSpeciesVisible(s, true);
                ++i;
            }
            i = 0;
            while (i < this.speciesTableModel.getRowCount()) {
                this.speciesTableModel.setValueAt(Boolean.TRUE, i, 0);
                ++i;
            }
        } else {
            this.jtoggleButton.setText(SELECT_ALL);
            int i = 0;
            while (i < specieslist.size()) {
                String s = (String)specieslist.get(i);
                this.speciesVisible.addSpeciesVisible(s, false);
                ++i;
            }
            i = 0;
            while (i < this.speciesTableModel.getRowCount()) {
                this.speciesTableModel.setValueAt(Boolean.FALSE, i, 0);
                ++i;
            }
        }
    }

    void searchButton_actionPerformed(ActionEvent e) {
        this.search();
    }

    private void search() {
        String adt;
        if (this.speciesTableModel.getRowCount() == 0) {
            return;
        }
        String searchStr = this.searchTextField.getText();
        if (searchStr.trim().equals("")) {
            return;
        }
        int index = -1;
        if (searchStr.equals(this.searchedWord)) {
            index = this.speciesTable.getSelectedRow();
        }
        this.searchedWord = searchStr;
        int i = index + 1;
        while (i < this.speciesTableModel.getRowCount()) {
            String speciesName = null;
            adt = (String)this.speciesTableModel.getValueAt(i, 1);
            speciesName = adt;
            if (speciesName.indexOf(searchStr) != -1) {
                this.speciesTable.setRowSelectionInterval(i, i);
                this.scrollItemToTop(i);
                return;
            }
            ++i;
        }
        if (index != -1) {
            StringBuffer warningMessage = new StringBuffer();
            warningMessage.append("The input species \"");
            warningMessage.append(this.searchTextField.getText());
            warningMessage.append("\" was not found.\nDo you search again from the beginning of a list?");
            int op = JOptionPane.showConfirmDialog(this, warningMessage.toString(), "Warning[search species]", 0);
            if (op == 1 || op == -1) {
                this.speciesTable.clearSelection();
                return;
            }
        }
        i = 0;
        while (i <= index) {
            String speciesName = null;
            adt = (String)this.speciesTableModel.getValueAt(i, 1);
            speciesName = adt;
            if (speciesName.indexOf(searchStr) != -1) {
                this.speciesTable.setRowSelectionInterval(i, i);
                this.scrollItemToTop(i);
                return;
            }
            ++i;
        }
        this.speciesTable.clearSelection();
        JOptionPane.showMessageDialog(this, "\"" + this.searchTextField.getText() + "\" did not match any species.", "Error[search species]", 2);
    }

    public void setFirstSelectionTop() {
        int[] selectIndexs = this.speciesTable.getSelectedRows();
        if (selectIndexs.length == 0) {
            return;
        }
        this.scrollItemToTop(selectIndexs[0]);
        this.fireListSelectionLocation();
    }

    public String getFirstSelectionTop() {
        if (this.selectFocusIndex == -1) {
            return null;
        }
        return (String)this.speciesTableModel.getValueAt(this.selectFocusIndex, 1);
    }

    public String getSelectionVisibleTop() {
        int index = 0;
        if (index == -1) {
            return null;
        }
        int[] selectIndexs = this.speciesTable.getSelectedRows();
        if (selectIndexs.length == 0) {
            return null;
        }
        int i = 0;
        while (i < selectIndexs.length) {
            if (selectIndexs[i] == index) {
                return (String)this.speciesTableModel.getValueAt(index, 1);
            }
            if (selectIndexs[i] > index) {
                return (String)this.speciesTableModel.getValueAt(selectIndexs[i], 1);
            }
            ++i;
        }
        return (String)this.speciesTableModel.getValueAt(selectIndexs[0], 1);
    }

    private void scrollItemToTop(int index) {
    }

    void searchTextField_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.search();
        }
    }

    public void clearSelection() {
        this.searchedWord = null;
        this.speciesTable.clearSelection();
    }

    public void setSelectionMode(int selectionMode) {
        this.speciesTable.setSelectionMode(selectionMode);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        if (!this.selectChangeListeners.contains(l)) {
            this.selectChangeListeners.add(l);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.selectChangeListeners.remove(l);
    }

    public void addListSelectionLocationListener(ListSelectionLocationListener l) {
        if (!this.selectLocationChangeListeners.contains(l)) {
            this.selectLocationChangeListeners.add(l);
        }
    }

    public void removeListSelectionLocationListener(ListSelectionLocationListener l) {
        this.selectLocationChangeListeners.remove(l);
    }

    private void fireListSelectionLocation() {
        ListSelectionLocationEvent event = new ListSelectionLocationEvent(this);
        for (ListSelectionLocationListener l : this.selectLocationChangeListeners) {
            l.stateChanged(event);
        }
    }

    void speciesList_ListSelection(ListSelectionEvent e) {
        ListSelectionEvent evt = new ListSelectionEvent(this, e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
        if (this.selectChangeActionFlag) {
            for (ListSelectionListener l : this.selectChangeListeners) {
                l.valueChanged(evt);
            }
        }
        this.selectFocusIndex = -1;
        this.fireListSelectionLocation();
    }

    @Override
    public void stateChanged(ColorChangeEvent e) {
        this.clearSelection();
        this.speciesTable.repaint();
    }

    @Override
    public void stateChanged(VisibleChangeEvent vce) {
        this.clearSelection();
        this.speciesTable.repaint();
    }

    private Color getPreferredBWColorAsString(Color rgbColor) {
        int white = 255;
        int black = 0;
        int light = (rgbColor.getRed() * 299 + rgbColor.getGreen() * 587 + rgbColor.getBlue() * 114) / 1000;
        if (Math.abs(light - white) > Math.abs(light - black)) {
            return Color.white;
        }
        return Color.black;
    }

    public int getSpeciesTableModelRowCount() {
        return this.speciesTableModel.getRowCount();
    }

    private class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        JColorChooser colorChooser;
        JDialog dialog;
        protected static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                this.colorChooser.setColor(this.currentColor);
                this.dialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.currentColor = this.colorChooser.getColor();
                String species = "";
                species = (String)SpeciesListPanel.this.speciesTableModel.getValueAt(SpeciesListPanel.this.speciesTable.getSelectedRow(), 1);
                SpeciesListPanel.this.speciesColorSet.addSpeciesColor(species, this.currentColor);
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            return this.button;
        }
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            this.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
            return this;
        }
    }

    private class SpeciesTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Visible", "Species", "Color"};
        private Object[][] data = null;

        private SpeciesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Object[] getColumnValueAt(int col) {
            Object[] obj = new Object[this.getRowCount()];
            int i = 0;
            while (i < obj.length) {
                obj[i] = this.getValueAt(i, col);
                ++i;
            }
            return obj;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 1;
        }

        public void setValue(Object[][] value) {
            this.data = value;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            int i = 0;
            while (i < numRows) {
                System.out.print("    row " + i + ":");
                int j = 0;
                while (j < numCols) {
                    System.out.print("  " + this.data[i][j]);
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println("--------------------------");
        }
    }
}

