/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.controlpanel.ColorChangeEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.ColorChangeListener;

public class SpeciesColorSet {
    private HashMap speciesColorMap = null;
    private Vector listenerVector = new Vector();

    public Color getColor(String species) {
        if (species == null) {
            return null;
        }
        return (Color)this.speciesColorMap.get(species);
    }

    public void addSpeciesColor(String species, Color color) {
        this.speciesColorMap.put(species, color);
        this.fireStateChanged();
    }

    public void setSpeciesColors(HashMap speciesColorMap) {
        this.speciesColorMap = speciesColorMap;
        this.fireStateChanged();
    }

    public void clear() {
        this.speciesColorMap.clear();
        this.fireStateChanged();
    }

    public void addColorChangeListener(ColorChangeListener l) {
        if (!this.listenerVector.contains(l)) {
            this.listenerVector.add(l);
        }
    }

    public void removeColorChangeListener(ColorChangeListener l) {
        this.listenerVector.remove(l);
    }

    protected void fireStateChanged() {
        for (ColorChangeListener ccl : this.listenerVector) {
            ccl.stateChanged(new ColorChangeEvent(this));
        }
    }

    public HashMap getSpeciesColorMap() {
        return this.speciesColorMap;
    }
}

