/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.sbml.util.Preference;

public class SliderValue {
    String value;
    static final int base = 10;
    double mantissa;
    int exponent;
    String caret;
    static final String BIG_CARET = "E";
    static final String SMALL_CARET = "e";
    int sliderScale;
    int originalSliderScale;
    int zeroCount;
    String cutValue;
    int sliderValue;
    int ESSENTIAL_FIGURE_DIGIT_MAX = 8;
    boolean isExponentialNotation;
    String minValue;
    String maxValue;
    static final String DEFAULT_MAX = "10";
    static final int MAX_TIMES = 2;
    String target;
    String strID;

    public SliderValue(String value) {
        this.init();
        this.value = value;
        this.parse();
    }

    private void init() {
        this.mantissa = 0.0;
        this.exponent = 0;
        this.caret = null;
        this.sliderScale = 0;
        this.originalSliderScale = 0;
        this.cutValue = null;
        this.zeroCount = 0;
        this.sliderValue = 0;
        this.isExponentialNotation = false;
        this.minValue = null;
        this.maxValue = null;
        this.target = null;
    }

    private void parse() {
        int indexCaret = this.value.indexOf(BIG_CARET);
        if (indexCaret >= 0) {
            this.caret = BIG_CARET;
            this.isExponentialNotation = true;
        } else {
            indexCaret = this.value.indexOf(SMALL_CARET);
            if (indexCaret >= 0) {
                this.isExponentialNotation = true;
                this.caret = SMALL_CARET;
            }
        }
        if (this.isExponentialNotation) {
            int indexDecimalPoint = this.value.indexOf(".");
            this.sliderScale = indexDecimalPoint >= 0 ? indexCaret - 1 - indexDecimalPoint : 0;
            this.mantissa = Double.valueOf(this.value.substring(0, indexCaret));
            this.exponent = Integer.valueOf(this.value.substring(indexCaret + 1));
            if (this.mantissa * Math.pow(10.0, this.sliderScale) > Math.pow(2.0, 25.0)) {
                this.decrementMantissaDigits();
                this.init();
                this.parse();
                return;
            }
            this.sliderValue = (int)(this.mantissa * Math.pow(10.0, this.sliderScale));
        } else {
            int indexDecimalPoint = this.value.indexOf(".");
            this.sliderScale = indexDecimalPoint >= 0 ? this.value.length() - 1 - indexDecimalPoint : 0;
            this.mantissa = Double.valueOf(this.value);
            this.exponent = 1;
            double calcVal = this.mantissa * Math.pow(10.0, this.sliderScale);
            if (calcVal > 2.147483647E9) {
                this.originalSliderScale = this.sliderScale;
                String val = String.valueOf(this.mantissa);
                int delCount = 0;
                int hit_index = val.indexOf(".");
                if (val.indexOf(".") != -1) {
                    boolean flg = false;
                    this.zeroCount = 0;
                    int i = 0;
                    while (i < val.length()) {
                        String v = val.substring(i, i + 1);
                        if (v.equals(".")) {
                            flg = true;
                            if (v.equals("0")) {
                                --delCount;
                            }
                        } else if (flg && v.equals("0") && this.value.matches(".*0$")) {
                            ++this.zeroCount;
                        } else {
                            if (flg && !v.equals("0")) break;
                            if (!(flg || v.equals(".") || v.equals("0") && (!v.equals("0") || val.matches("^0+.*")))) {
                                ++delCount;
                            }
                        }
                        Object var11_11 = null;
                        ++i;
                    }
                    val = String.valueOf(calcVal);
                    val = StringTool.replaceString(val, ".", "");
                }
                this.zeroCount = 0;
                this.sliderValue = Integer.parseInt(val.substring(0, 9 - this.zeroCount));
                this.sliderScale = 9 - delCount;
            } else {
                this.sliderValue = (int)calcVal;
            }
            if (this.sliderValue < 100) {
                this.sliderValue *= 10;
                ++this.sliderScale;
            }
        }
        this.setDefaultRange();
        if (Preference.isDebug) {
            this.printDebugData();
        }
    }

    private void printDebugData() {
        System.out.println("------- print debug data------->");
        System.out.println("value = " + this.value);
        System.out.println("mantissa = " + this.mantissa);
        System.out.println("exponent = " + this.exponent);
        System.out.println("caret = " + this.caret);
        System.out.println("sliderScaxle = " + this.sliderScale);
        System.out.println("sliderValue = " + this.sliderValue);
        System.out.println("minValue = " + this.minValue);
        System.out.println("maxVaule = " + this.maxValue);
        System.out.println("*originalSliderScale = " + this.originalSliderScale);
        System.out.println("*zeroCount = " + this.zeroCount);
        System.out.println("*cutValue = " + this.cutValue);
        System.out.println("<------- print debug data-------");
    }

    private void decrementMantissaDigits() {
        int indexCaret = this.value.indexOf(BIG_CARET);
        String caret = null;
        boolean isExponentialNotation = false;
        int sliderScale = 0;
        if (indexCaret >= 0) {
            caret = BIG_CARET;
            isExponentialNotation = true;
        } else {
            indexCaret = this.value.indexOf(SMALL_CARET);
            if (indexCaret >= 0) {
                isExponentialNotation = true;
                caret = SMALL_CARET;
            }
        }
        if (isExponentialNotation) {
            int indexDecimalPoint = this.value.indexOf(".");
            sliderScale = indexDecimalPoint >= 0 ? indexCaret - 1 - indexDecimalPoint : 0;
            String mantissaStr = this.value.substring(0, indexCaret);
            if ((mantissaStr = mantissaStr.substring(0, mantissaStr.length() - 1)).length() == indexDecimalPoint) {
                mantissaStr = mantissaStr.substring(0, mantissaStr.length() - 1);
            }
            this.value = sliderScale == 0 ? String.valueOf(mantissaStr) + caret + String.valueOf(this.exponent++) : String.valueOf(mantissaStr) + caret + String.valueOf(this.exponent);
        } else {
            int indexDecimalPoint = this.value.indexOf(".");
            sliderScale = indexDecimalPoint >= 0 ? this.value.length() - 1 - indexDecimalPoint : 0;
            String mantissaStr = this.value;
            if ((mantissaStr = mantissaStr.substring(0, mantissaStr.length() - 1)).length() == indexDecimalPoint) {
                mantissaStr = mantissaStr.substring(0, mantissaStr.length() - 1);
            }
            this.value = sliderScale == 0 ? mantissaStr : String.valueOf(mantissaStr) + caret + "1";
        }
    }

    private void setDefaultRange() {
        this.minValue = "0";
        this.maxValue = DEFAULT_MAX;
        if (this.isExponentialNotation) {
            this.minValue = String.valueOf(this.minValue) + ".";
            int i = 0;
            while (i < this.sliderScale) {
                this.maxValue = String.valueOf(this.maxValue) + "0";
                this.minValue = String.valueOf(this.minValue) + "0";
                ++i;
            }
            this.minValue = String.valueOf(this.minValue) + this.caret;
            this.minValue = String.valueOf(this.minValue) + String.valueOf(this.exponent);
            this.maxValue = String.valueOf(this.maxValue) + this.caret;
            this.maxValue = String.valueOf(this.maxValue) + String.valueOf(this.exponent);
            if (Double.valueOf(this.value) != 0.0) {
                this.maxValue = String.valueOf(String.valueOf(this.mantissa * 2.0)) + this.caret + String.valueOf(this.exponent);
            }
        } else if (Double.valueOf(this.value) != 0.0) {
            this.maxValue = String.valueOf(Double.valueOf(this.value) * 2.0);
        }
        if (Double.valueOf(this.value) < 0.0) {
            String swap = this.minValue;
            this.minValue = this.maxValue;
            this.maxValue = swap;
        }
    }

    public boolean isExponentialNotation() {
        return this.isExponentialNotation;
    }

    public int getSliderValue() {
        return this.sliderValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setSliderValue(int sliderValue) {
        this.sliderValue = sliderValue;
        this.mantissa = (double)sliderValue / Math.pow(10.0, this.sliderScale);
        this.value = this.isExponentialNotation ? String.valueOf(String.valueOf(this.mantissa)) + this.caret + String.valueOf(this.exponent) : String.valueOf(this.mantissa);
    }

    public void setValue(String value) {
        this.value = value;
        this.parse();
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public int getSliderMinValue() {
        if (this.isExponentialNotation) {
            return (int)(Double.valueOf(this.minValue) / Math.pow(10.0, this.exponent) * Math.pow(10.0, this.sliderScale));
        }
        return (int)(Double.valueOf(this.minValue) * Math.pow(10.0, this.sliderScale));
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public int getSliderMaxValue() {
        if (this.isExponentialNotation) {
            return (int)(Double.valueOf(this.maxValue) / Math.pow(10.0, this.exponent) * Math.pow(10.0, this.sliderScale));
        }
        return (int)(Double.valueOf(this.maxValue) * Math.pow(10.0, this.sliderScale));
    }

    public int getBase() {
        return 10;
    }

    public double getMantissa() {
        return this.mantissa;
    }

    public int getExpoinent() {
        return this.exponent;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getRedSpeId() {
        return this.strID;
    }

    public void setRedSpeId(String strId) {
        this.strID = strId;
    }
}

