/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.co.mki.celldesigner.simulation.CvodeResults;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import jp.co.mki.celldesigner.simulation.controlpanel.ColorChangeEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.ColorChangeListener;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.ListSelectionLocationEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.ListSelectionLocationListener;
import jp.co.mki.celldesigner.simulation.controlpanel.ScaleData;
import jp.co.mki.celldesigner.simulation.controlpanel.ScatterChartPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesColorSet;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesListPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesVisible;
import jp.co.mki.celldesigner.simulation.controlpanel.Spinner;
import jp.co.mki.celldesigner.simulation.controlpanel.TimeSeriesPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.VisibleChangeEvent;
import jp.co.mki.celldesigner.simulation.controlpanel.VisibleChangeListener;
import jp.co.mki.celldesigner.simulation.util.UniqueColors;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.jfree.chart.ChartPanel;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Species;

public class SimulationResultPanel
extends JPanel
implements ColorChangeListener,
VisibleChangeListener,
ListSelectionLocationListener,
ChangeListener {
    private CvodeResults cvodeResults = null;
    private SBMLResults allResults = null;
    private static final int RAW = 0;
    private static final int LOG = 1;
    private static final int[] SCALE;
    private static final String[] SCALE_STRING;
    private boolean changingSelectFlag = false;
    private SpeciesColorSet speciesColorSet = null;
    private SpeciesVisible speciesVisible = null;
    private int showingDataIndex = 0;
    private int count = 0;
    private GraphScaleControl graphScaleControl = null;
    private double maxStepValue;
    private Vector listenerList = new Vector();
    private Vector timeList = null;
    private Vector[] dataList = null;
    private Vector speciesList = null;
    private Vector lineColorList = null;
    private Vector lineVisibleList = null;
    private double maxData;
    private double minData;
    private double maxRange;
    private double minRange;
    private double maxRangeNow;
    private double minRangeNow;
    private double maxRangeOfVisible;
    private double incOrder;
    private double maxTime;
    private double minTime;
    private double maxTimeNow;
    private double minTimeNow;
    private boolean makedSwTbl;
    private boolean makedSwDrawTbl;
    private boolean settingFlag = false;
    private JPanel jPanelMain = new JPanel();
    private SpeciesListPanel jSpeciesListPanel = new SpeciesListPanel();
    private JPanel jPanelDataSelect = new JPanel();
    private Color bgColor = Color.WHITE;
    private Color ftColor = Color.BLACK;
    private JPanel jdrawPanel = new JPanel();
    public TimeSeriesPanel timeSeriesPanel = new TimeSeriesPanel();
    private JPanel southPanel = new JPanel();
    private JPanel yAxisPanel = new JPanel();
    private JPanel northPanel = new JPanel();
    private JPanel xAxisPanel = new JPanel();
    private Spinner minRangeSpinner = new Spinner(4);
    private Spinner maxRangeSpinner = new Spinner(4);
    private Spinner timeIntervalSpinner = new Spinner(6);
    private JLabel yLabel = new JLabel();
    private JLabel xLabel = new JLabel();
    private JPanel xAxisDrawPanel = new DrawPanel();
    private JPanel yAxisDrawPanel = new DrawPanel();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel6 = new JPanel();
    private JPanel jPanel9 = new JPanel();
    private JPanel jPanel7 = new JPanel();
    private JScrollBar timeScrollBar = new JScrollBar();
    private static double log10;
    private JComboBox scaleList;
    private JCheckBox checkSpecies = new JCheckBox();
    private JCheckBox checkCompartment = new JCheckBox();
    private JCheckBox checkParameter = new JCheckBox();
    private JCheckBox checkFlux = new JCheckBox();
    private int selectedValue;
    private boolean isUpdate = true;
    private Boolean[] listOfVisibleResult;
    private Boolean[] listOfOverlayedSpecies;
    private ArrayList listOfResult;
    private ControlPanelMainWindow parent;
    private SBMLPanelLists sbmlPanelLists;
    private int overlaySpeciesCount = 0;
    private Vector drawLogFragList = null;
    private JSplitPane splitMainPanel = new JSplitPane(1, true);
    private boolean isChanged = false;
    private boolean isSelected = false;
    private JLabel innerYLabel = new JLabel("Time");
    private boolean drawLogFrag = true;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        SCALE = nArray;
        SCALE_STRING = new String[]{"raw", "log"};
        log10 = Math.log(10.0);
    }

    public SimulationResultPanel(ControlPanelMainWindow parent, SBMLPanelLists sbmlPanelLists) {
        this.sbmlPanelLists = sbmlPanelLists;
        this.parent = parent;
        try {
            this.init();
            this.setLocationScreenCenter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        BorderLayout borderLayout01 = new BorderLayout();
        BorderLayout borderLayout02 = new BorderLayout();
        BorderLayout borderLayout03 = new BorderLayout();
        BorderLayout borderLayout1 = new BorderLayout();
        BorderLayout borderLayout2 = new BorderLayout();
        BorderLayout borderLayout3 = new BorderLayout();
        BorderLayout borderLayout4 = new BorderLayout();
        BorderLayout borderLayout5 = new BorderLayout();
        BorderLayout borderLayout6 = new BorderLayout();
        BorderLayout borderLayout7 = new BorderLayout();
        BorderLayout borderLayout8 = new BorderLayout();
        BorderLayout borderLayout9 = new BorderLayout();
        BorderLayout borderLayout10 = new BorderLayout();
        BorderLayout borderLayout11 = new BorderLayout();
        this.splitMainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.splitMainPanel.setResizeWeight(1.0);
        this.splitMainPanel.setOneTouchExpandable(true);
        this.jSpeciesListPanel.setSBMLPanelLists(this.sbmlPanelLists);
        this.jSpeciesListPanel.setSimulationResultPanel(this);
        this.jSpeciesListPanel.addListSelectionLocationListener(new ListSelectionLocationListener(){

            @Override
            public void stateChanged(ListSelectionLocationEvent e) {
                SimulationResultPanel.this.jSpeciesListPanel_changeListSelectionLocation(e);
            }
        });
        this.jSpeciesListPanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SimulationResultPanel.this.jSpeciesListPanel_changeListSelection(e);
            }
        });
        this.jSpeciesListPanel.addListSelectionLocationListener(this);
        this.jPanelMain.setLayout(borderLayout03);
        this.setLayout(borderLayout01);
        this.splitMainPanel.setLeftComponent(this.jPanelMain);
        this.splitMainPanel.setRightComponent(this.jSpeciesListPanel);
        this.add((Component)this.splitMainPanel, "Center");
        Border border1 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        Border border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        Border border3 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        Border border5 = BorderFactory.createEmptyBorder(3, 0, 3, 0);
        Border border6 = BorderFactory.createEmptyBorder();
        Border border8 = BorderFactory.createEmptyBorder(0, 0, 3, 3);
        Border border9 = BorderFactory.createEmptyBorder(0, 0, 0, 18);
        this.jdrawPanel.setLayout(borderLayout1);
        this.jdrawPanel.setBackground(this.bgColor);
        this.jdrawPanel.setBorder(border1);
        this.yAxisPanel.setLayout(borderLayout2);
        this.yAxisPanel.setBackground(this.bgColor);
        this.yAxisPanel.setBorder(border2);
        this.xAxisPanel.setLayout(borderLayout3);
        this.xAxisPanel.setBackground(this.bgColor);
        this.xAxisPanel.setBorder(border3);
        this.minRangeSpinner.setValue(0.0);
        this.maxRangeSpinner.setValue(0.0);
        this.timeIntervalSpinner.setBackground(Color.white);
        this.timeIntervalSpinner.setValue(0.0);
        this.minRangeSpinner.setMinimumFractionDigits(2);
        this.minRangeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SimulationResultPanel.this.minRangeSpinner_stateChanged(e);
            }
        });
        this.maxRangeSpinner.setMinimumFractionDigits(2);
        this.maxRangeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SimulationResultPanel.this.maxRangeSpinner_stateChanged(e);
            }
        });
        this.timeIntervalSpinner.setMinimumFractionDigits(2);
        this.timeIntervalSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SimulationResultPanel.this.timeIntervalSpinner_stateChanged(e);
            }
        });
        this.timeSeriesPanel.setLayout(borderLayout7);
        this.timeSeriesPanel.setPreferredSize(new Dimension(400, 400));
        this.yLabel.setForeground(this.ftColor);
        this.yLabel.setText("Concentration");
        this.jPanel9.setBackground(this.bgColor);
        this.jPanel9.add(this.yLabel);
        this.scaleList = new JComboBox<String>(SCALE_STRING);
        this.scaleList.setBackground(Color.white);
        this.scaleList.setForeground(this.ftColor);
        this.scaleList.setSelectedIndex(0);
        this.scaleList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationResultPanel.this.makedSwDrawTbl = false;
                SimulationResultPanel.this.selectedValue = ((JComboBox)e.getSource()).getSelectedIndex();
                boolean fragTemp = SimulationResultPanel.this.makeLineVisible();
                if (SimulationResultPanel.this.selectedValue == 1 && !fragTemp) {
                    JOptionPane.showMessageDialog((Component)e.getSource(), "Invalid data. Data contains values under zero.", "Invalid Data", 2);
                    ((JComboBox)e.getSource()).setSelectedIndex(0);
                    SimulationResultPanel.this.selectedValue = 0;
                    return;
                }
                SimulationResultPanel.this.resettingMaxRangeSpinner();
                SimulationResultPanel.this.drawGraph(((JComboBox)e.getSource()).getSelectedIndex());
            }
        });
        this.jPanel9.add(this.scaleList);
        this.checkSpecies.setBackground(this.bgColor);
        this.checkSpecies.setForeground(this.ftColor);
        this.checkSpecies.setText("Species");
        this.checkSpecies.setSelected(true);
        this.checkSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationResultPanel.this.checkBoxAction(e);
            }
        });
        this.jPanel9.add(this.checkSpecies);
        this.checkFlux.setBackground(this.bgColor);
        this.checkFlux.setForeground(this.ftColor);
        this.checkFlux.setText("Fluxes");
        this.checkFlux.setSelected(true);
        this.checkFlux.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationResultPanel.this.checkBoxAction(e);
            }
        });
        this.jPanel9.add(this.checkFlux);
        this.checkParameter.setBackground(this.bgColor);
        this.checkParameter.setForeground(this.ftColor);
        this.checkParameter.setText("Parameters");
        this.checkParameter.setSelected(true);
        this.checkParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationResultPanel.this.checkBoxAction(e);
            }
        });
        this.jPanel9.add(this.checkParameter);
        this.checkCompartment.setBackground(this.bgColor);
        this.checkCompartment.setForeground(this.ftColor);
        this.checkCompartment.setText("Compartments");
        this.checkCompartment.setSelected(true);
        this.checkCompartment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationResultPanel.this.checkBoxAction(e);
            }
        });
        this.jPanel9.add(this.checkCompartment);
        this.northPanel.setLayout(borderLayout6);
        this.northPanel.setBackground(this.bgColor);
        this.jPanel2.setBackground(this.bgColor);
        this.northPanel.add((Component)this.jPanel9, "West");
        this.xLabel.setHorizontalAlignment(0);
        this.xLabel.setHorizontalTextPosition(0);
        this.xLabel.setForeground(this.ftColor);
        this.xLabel.setText("Time");
        this.xLabel.setVerticalAlignment(1);
        this.xLabel.setVerticalTextPosition(1);
        this.xAxisDrawPanel.setLayout(new BorderLayout());
        this.xAxisDrawPanel.setBackground(this.bgColor);
        this.yAxisDrawPanel.setBackground(this.bgColor);
        this.timeSeriesPanel.setBackground(this.bgColor);
        this.timeIntervalSpinner.setOrientation(Spinner.HORIZONTAL);
        this.jPanel7.setLayout(borderLayout5);
        this.jPanel7.setBackground(this.bgColor);
        this.jPanel7.setBorder(border5);
        this.timeScrollBar.setOrientation(0);
        this.timeScrollBar.setVisibleAmount(0);
        this.timeScrollBar.setEnabled(false);
        this.timeScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                SimulationResultPanel.this.timeScrollBar_adjustmentValueChanged(e);
            }
        });
        this.jPanel1.setBackground(this.bgColor);
        this.jPanel6.setBackground(this.bgColor);
        this.xAxisPanel.add((Component)this.xAxisDrawPanel, "North");
        this.xAxisPanel.add((Component)this.jPanel6, "Center");
        this.xAxisPanel.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.timeIntervalSpinner, null);
        this.jPanel6.add((Component)this.xLabel, null);
        this.northPanel.add((Component)this.jPanel2, "Center");
        this.jdrawPanel.add((Component)this.northPanel, "North");
        this.jdrawPanel.add((Component)this.yAxisPanel, "West");
        this.jdrawPanel.add((Component)this.xAxisPanel, "South");
        this.jdrawPanel.add((Component)this.timeSeriesPanel, "Center");
        this.yAxisPanel.add((Component)this.minRangeSpinner, "South");
        this.yAxisPanel.add((Component)this.maxRangeSpinner, "North");
        this.yAxisPanel.add((Component)this.yAxisDrawPanel, "Center");
        this.timeSeriesPanel.setBackground(this.bgColor);
        this.jPanelMain.add((Component)this.timeScrollBar, "South");
        this.jPanelMain.add((Component)this.jdrawPanel, "Center");
        this.graphScaleControl = new GraphScaleControl(this.timeSeriesPanel, (DrawPanel)this.xAxisDrawPanel, (DrawPanel)this.yAxisDrawPanel);
        this.timeSeriesPanel.addChangeListener(this.graphScaleControl);
        this.timeSeriesPanel.addSelectChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SimulationResultPanel.this.fireStateChanged();
            }
        });
        this.timeSeriesPanel.addSelectChangeListener(this);
        this.xAxisDrawPanel.setPreferredSize(new Dimension(0, 20));
        int top = this.maxRangeSpinner.getHeight() / 2;
        int bottom = this.minRangeSpinner.getHeight() / 2;
        int right = this.timeIntervalSpinner.getWidth() / 2;
        Border border7 = BorderFactory.createEmptyBorder(top, 0, bottom, right);
    }

    public boolean isSelectedHantenCheck() {
        return this.isSelected;
    }

    public void updateSpinnerPositon(boolean isSelected) {
        this.isSelected = isSelected;
        this.yAxisPanel.remove(this.timeIntervalSpinner);
        this.jPanel1.remove(this.minRangeSpinner);
        this.jPanel1.remove(this.maxRangeSpinner);
        this.yAxisPanel.add((Component)this.minRangeSpinner, "South");
        this.yAxisPanel.add((Component)this.maxRangeSpinner, "North");
        this.jPanel1.add((Component)this.timeIntervalSpinner, "Center");
        this.minRangeSpinner.setOrientation(Spinner.VERTICAL);
        this.maxRangeSpinner.setOrientation(Spinner.VERTICAL);
        this.timeIntervalSpinner.setOrientation(Spinner.HORIZONTAL);
        if (this.isChanged) {
            this.timeSeriesPanel.setMaxRange(this.maxRangeNow);
            this.timeSeriesPanel.setMinRange(this.minRangeNow);
            this.timeSeriesPanel.setMaxTimeOfDraw(this.maxTimeNow);
            this.timeSeriesPanel.setMinTimeOfDraw(this.minTimeNow);
            this.xLabel.setText("Time");
            this.yAxisPanel.remove(this.innerYLabel);
            this.timeSeriesPanel.setData(this.timeList, this.dataList[0]);
        }
        this.validate();
        this.timeIntervalSpinner.setValue(this.timeIntervalSpinner.getValue());
    }

    public boolean setData(SBMLResults allResults, SpeciesColorSet speciesColorSet, SpeciesVisible speciesVisible) {
        this.maxData = 0.0;
        this.minData = 0.0;
        this.maxRange = 0.0;
        this.minRange = 0.0;
        this.maxRangeNow = 0.0;
        this.minRangeNow = 0.0;
        this.incOrder = 0.0;
        this.maxTime = 0.0;
        this.minTime = 0.0;
        this.maxTimeNow = 0.0;
        this.minTimeNow = 0.0;
        this.timeList = new Vector();
        this.dataList = new Vector[SCALE.length];
        int i = 0;
        while (i < this.dataList.length) {
            this.dataList[i] = new Vector();
            ++i;
        }
        this.speciesList = new Vector();
        this.lineColorList = new Vector();
        this.lineVisibleList = new Vector();
        this.maxStepValue = 0.0;
        this.drawLogFragList = new Vector();
        this.allResults = allResults;
        this.speciesColorSet = speciesColorSet;
        this.speciesVisible = speciesVisible;
        this.setBasicData();
        this.makedSwDrawTbl = false;
        this.drawGraph(0);
        return true;
    }

    public boolean setData(Boolean[] listOfVisibleResult, Boolean[] listOfOverlayedSpecies, ArrayList listOfResult, SpeciesColorSet speciesColorSet, SpeciesVisible speciesVisible) {
        this.listOfVisibleResult = listOfVisibleResult;
        this.listOfOverlayedSpecies = listOfOverlayedSpecies;
        this.listOfResult = listOfResult;
        this.maxData = 0.0;
        this.minData = 0.0;
        this.maxRange = 0.0;
        this.minRange = 0.0;
        this.maxRangeNow = 0.0;
        this.minRangeNow = 0.0;
        this.incOrder = 0.0;
        this.maxTime = 0.0;
        this.minTime = 0.0;
        this.maxTimeNow = 0.0;
        this.minTimeNow = 0.0;
        this.timeList = new Vector();
        this.dataList = new Vector[SCALE.length];
        int i = 0;
        while (i < this.dataList.length) {
            this.dataList[i] = new Vector();
            ++i;
        }
        this.speciesList = new Vector();
        this.lineColorList = new Vector();
        this.lineVisibleList = new Vector();
        this.maxStepValue = 0.0;
        this.drawLogFragList = new Vector();
        this.speciesColorSet = speciesColorSet;
        this.speciesVisible = speciesVisible;
        this.setBasicData(listOfVisibleResult, listOfOverlayedSpecies, listOfResult);
        this.makedSwDrawTbl = false;
        this.drawGraph(0);
        return true;
    }

    public CvodeResults getCvodeResults() {
        return this.cvodeResults;
    }

    public SpeciesColorSet getSpeciesColorSet() {
        return this.speciesColorSet;
    }

    public SpeciesVisible getSpeciesVisible() {
        return this.speciesVisible;
    }

    public void setSpeciesColorSet(SpeciesColorSet speciesColorSet) {
        this.speciesColorSet = speciesColorSet;
    }

    public void setSpeciesVisible(SpeciesVisible speciesVisible) {
        this.speciesVisible = speciesVisible;
    }

    public Vector getSpeciesList() {
        return this.speciesList;
    }

    public int getOverlaySpeciesCount() {
        return this.overlaySpeciesCount;
    }

    public boolean isOverlayMode() {
        return this.listOfResult != null;
    }

    public SpeciesListPanel getSpeciesListPanel() {
        return this.jSpeciesListPanel;
    }

    private Species getSpecies(String id) {
        ListOf listOfSpecies = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            Species sp = (Species)listOfSpecies.get((long)i);
            if (sp.getId().equals(id)) {
                return sp;
            }
            ++i;
        }
        return null;
    }

    private Object[] getSpecies(String id, SBMLResults result) {
        ListOf listOfSpecies = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            Species sp = (Species)listOfSpecies.get((long)i);
            if (sp.getId().equals(id)) {
                Object[] list = new Object[]{sp, result};
                return list;
            }
            ++i;
        }
        return null;
    }

    protected void setBasicData() {
        SBMLResults result;
        Species sp;
        Object[] list;
        Species sp2;
        String gdt;
        Object obj;
        if (!this.makedSwTbl) {
            this.makeDrawSourceData();
        }
        this.setSpeciesColorSet();
        this.setSpeciesVisible();
        Iterator itr = this.speciesList.iterator();
        boolean i = false;
        while (itr.hasNext()) {
            obj = itr.next();
            gdt = "";
            if (obj instanceof Species) {
                sp2 = (Species)obj;
                gdt = sp2.getId();
            } else if (obj instanceof Object[]) {
                list = (Object[])obj;
                sp = (Species)list[0];
                result = (SBMLResults)list[1];
                gdt = String.valueOf(sp.getId()) + " " + result.getParameterInfo();
            } else {
                gdt = (String)obj;
            }
            Color color = null;
            if (this.speciesColorSet != null) {
                color = this.speciesColorSet.getColor(gdt);
            }
            if (color == null) {
                color = Color.BLUE;
            }
            this.lineColorList.add(color);
        }
        itr = this.speciesList.iterator();
        i = false;
        while (itr.hasNext()) {
            obj = itr.next();
            gdt = "";
            if (obj instanceof Species) {
                sp2 = (Species)obj;
                gdt = sp2.getId();
            } else if (obj instanceof Object[]) {
                list = (Object[])obj;
                sp = (Species)list[0];
                result = (SBMLResults)list[1];
                gdt = String.valueOf(sp.getId()) + " " + result.getParameterInfo();
            } else {
                gdt = (String)obj;
            }
            Boolean isVisible = null;
            if (this.speciesVisible != null) {
                isVisible = this.speciesVisible.isVisible(gdt);
            }
            if (isVisible == null) {
                isVisible = new Boolean(true);
            }
            this.lineVisibleList.add(isVisible);
        }
        this.jSpeciesListPanel.setSpeciesColorSet(this.speciesColorSet);
        this.jSpeciesListPanel.setSpeciesVisible(this.speciesVisible);
        this.setSpeciesList(this.speciesList);
    }

    protected void setBasicData(Boolean[] listOfVisibleResult, Boolean[] listOfOverlayedSpecies, ArrayList listOfResult) {
        SBMLResults result;
        Species sp;
        Object[] list;
        Species sp2;
        String gdt;
        Object obj;
        if (!this.makedSwTbl) {
            this.makeDrawSourceData(listOfVisibleResult, listOfOverlayedSpecies, listOfResult);
        }
        this.setSpeciesColorSet();
        this.setSpeciesVisible();
        Iterator itr = this.speciesList.iterator();
        boolean i = false;
        while (itr.hasNext()) {
            obj = itr.next();
            gdt = "";
            if (obj instanceof Species) {
                sp2 = (Species)obj;
                gdt = sp2.getId();
            } else if (obj instanceof Object[]) {
                list = (Object[])obj;
                sp = (Species)list[0];
                result = (SBMLResults)list[1];
                gdt = String.valueOf(sp.getId()) + " " + result.getParameterInfo();
            } else {
                gdt = (String)obj;
            }
            Color color = null;
            if (this.speciesColorSet != null) {
                color = this.speciesColorSet.getColor(gdt);
            }
            if (color == null) {
                color = Color.BLUE;
            }
            this.lineColorList.add(color);
        }
        itr = this.speciesList.iterator();
        i = false;
        while (itr.hasNext()) {
            obj = itr.next();
            gdt = "";
            if (obj instanceof Species) {
                sp2 = (Species)obj;
                gdt = sp2.getId();
            } else if (obj instanceof Object[]) {
                list = (Object[])obj;
                sp = (Species)list[0];
                result = (SBMLResults)list[1];
                gdt = String.valueOf(sp.getId()) + " " + result.getParameterInfo();
            } else {
                gdt = (String)obj;
            }
            Boolean isVisible = null;
            if (this.speciesVisible != null) {
                isVisible = this.speciesVisible.isVisible(gdt);
            }
            if (isVisible == null) {
                isVisible = new Boolean(true);
            }
            this.lineVisibleList.add(isVisible);
        }
        this.jSpeciesListPanel.setSpeciesColorSet(this.speciesColorSet);
        this.jSpeciesListPanel.setSpeciesVisible(this.speciesVisible);
        this.setSpeciesList(this.speciesList);
    }

    private void drawGraph(int scale) {
        if (!this.makedSwDrawTbl) {
            this.makeDrawData(scale);
        }
        this.settingFlag = true;
        Vector selected = this.timeSeriesPanel.getSelectedData();
        this.timeSeriesPanel.setData(this.timeList, this.dataList[scale]);
        this.timeSeriesPanel.setLineColor(this.lineColorList);
        this.timeSeriesPanel.setLineVisible(this.lineVisibleList);
        this.timeSeriesPanel.setSelectedData(selected);
        this.timeIntervalSpinner.setMaximum(this.maxTime);
        this.timeIntervalSpinner.setMinimum(this.minTime);
        double timeRC = this.maxTime / 10.0 + this.maxTime / 100000.0;
        double Log10 = Math.log(10.0);
        int delta = -((int)(Math.log(timeRC) / Log10));
        if (delta + 1 > 2) {
            this.timeIntervalSpinner.setMinimumFractionDigits(delta + 1);
        } else {
            this.timeIntervalSpinner.setMinimumFractionDigits(2);
        }
        delta = -((int)(Math.log(this.maxRangeNow) / Log10));
        if (delta + 1 > 2) {
            this.maxRangeSpinner.setMinimumFractionDigits(delta + 1);
            this.minRangeSpinner.setMinimumFractionDigits(delta + 1);
        } else {
            this.maxRangeSpinner.setMinimumFractionDigits(2);
            this.minRangeSpinner.setMinimumFractionDigits(2);
        }
        this.timeIntervalSpinner.setRC(timeRC);
        this.timeIntervalSpinner.setValue(this.maxTimeNow);
        if (this.maxTimeNow == this.maxTime && this.minTimeNow == this.minTime) {
            this.timeScrollBar.setEnabled(false);
        } else {
            this.timeScrollBar.setEnabled(true);
        }
        this.maxRangeSpinner.setRC(this.incOrder);
        this.maxRangeSpinner.setMaximum(Double.MAX_VALUE);
        this.maxRangeSpinner.setMinimum(this.minRange);
        this.maxRangeSpinner.setValue(this.maxRangeNow);
        this.minRangeSpinner.setRC(this.incOrder);
        this.minRangeSpinner.setMaximum(Double.MAX_VALUE);
        this.minRangeSpinner.setMinimum(this.minRange);
        this.minRangeSpinner.setValue(this.minRangeNow);
        this.timeSeriesPanel.setMaxMinValue(this.maxRangeNow, this.minRangeNow, this.maxTimeNow, this.minTimeNow);
        if (this.lineColorList == null) {
            this.makeLineColor();
        }
        if (this.lineVisibleList == null) {
            this.makeLineVisible();
        }
        this.timeSeriesPanel.setLineColor(this.lineColorList);
        this.timeSeriesPanel.setLineVisible(this.lineVisibleList);
        this.settingFlag = false;
        this.timeSeriesPanel.repaint();
    }

    private void makeDrawData(int scale) {
        if (!this.makedSwTbl) {
            this.makeDrawSourceData();
        }
        this.settingFlag = true;
        this.maxData = Double.NEGATIVE_INFINITY;
        this.minData = Double.MAX_VALUE;
        Vector valToAverage = new Vector();
        Vector val2ToAverage = new Vector();
        int i = 0;
        while (i < this.speciesList.size()) {
            double[] val = (double[])this.timeList.get(i);
            double[] val2 = (double[])this.dataList[scale].get(i);
            int j = 0;
            while (j < val2.length) {
                this.maxData = Math.max(this.maxData, val2[j]);
                this.minData = Math.min(this.minData, val2[j]);
                ++j;
            }
            ++i;
        }
        if (this.maxData == Double.NEGATIVE_INFINITY) {
            this.maxData = 0.0;
        }
        this.incOrder = Math.abs(this.maxData / 100.0);
        this.maxRange = this.maxData + this.incOrder;
        this.minRange = this.minData - this.incOrder;
        if (this.minData >= 0.0) {
            this.minRange = 0.0;
        }
        this.maxRangeNow = this.maxRange;
        this.minRangeNow = this.minRange;
        this.makeTimeData();
        this.makeLineColor();
        this.makedSwDrawTbl = true;
        this.settingFlag = false;
    }

    private void makeDrawSourceData() {
        this.settingFlag = true;
        this.makedSwDrawTbl = false;
        this.drawLogFragList = new Vector();
        this.timeList = new Vector();
        this.dataList = new Vector[SCALE.length];
        int i = 0;
        while (i < this.dataList.length) {
            this.dataList[i] = new Vector();
            ++i;
        }
        this.speciesList = new Vector();
        this.maxData = Double.NEGATIVE_INFINITY;
        this.minData = Double.MAX_VALUE;
        double minStep = Double.MAX_VALUE;
        if (this.allResults != null) {
            TimeCourse f_values;
            TimeCourse p_values;
            double[] val2Log;
            double[] val2;
            double[] val;
            TimeCourse a_values;
            int neq;
            TimeCourse c_values;
            int numberOfTimePoint = this.allResults.getTimepoints();
            if (this.checkSpecies.isSelected() && (c_values = this.allResults.getSpecies()) != null && c_values.getNames() != null) {
                neq = c_values.getNames().length;
                ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
                int i2 = 0;
                while (i2 < neq) {
                    SpeciesData speciesD = (SpeciesData)listOfSpeciesData.get(i2);
                    String gtype = speciesD.toString();
                    double[] val3 = new double[numberOfTimePoint];
                    double[] val22 = new double[numberOfTimePoint];
                    double[] val2Log2 = new double[numberOfTimePoint];
                    boolean checkFlag = true;
                    int t = 0;
                    while (t < numberOfTimePoint) {
                        val3[t] = this.allResults.getTime(t);
                        val22[t] = c_values.getValue(t, i2);
                        if (val22[t] > 0.0) {
                            val2Log2[t] = Math.log(val22[t]);
                        } else {
                            checkFlag = false;
                            val2Log2[t] = 0.0;
                        }
                        ++t;
                    }
                    minStep = val3.length > 1 ? val3[1] - val3[0] : val3[0];
                    this.speciesList.add(gtype);
                    this.drawLogFragList.add(new Boolean(checkFlag));
                    this.timeList.add(val3);
                    this.dataList[0].add(val22);
                    this.dataList[1].add(val2Log2);
                    ++i2;
                }
            }
            if (this.checkCompartment.isSelected() && (a_values = this.allResults.getCompartments()) != null && a_values.getNames() != null) {
                neq = a_values.getNames().length;
                int i3 = 0;
                while (i3 < neq) {
                    String gtype = a_values.getName(i3);
                    val = new double[numberOfTimePoint];
                    val2 = new double[numberOfTimePoint];
                    val2Log = new double[numberOfTimePoint];
                    boolean checkFlag = true;
                    int t = 0;
                    while (t < numberOfTimePoint) {
                        val[t] = this.allResults.getTime(t);
                        val2[t] = a_values.getValue(t, i3);
                        if (val2[t] > 0.0) {
                            val2Log[t] = Math.log(val2[t]);
                        } else {
                            checkFlag = false;
                            val2Log[t] = 0.0;
                        }
                        ++t;
                    }
                    this.drawLogFragList.add(new Boolean(checkFlag));
                    this.speciesList.add(gtype);
                    this.timeList.add(val);
                    this.dataList[0].add(val2);
                    this.dataList[1].add(val2Log);
                    ++i3;
                }
            }
            if (this.checkParameter.isSelected() && (p_values = this.allResults.getParameters()) != null && p_values.getNames() != null) {
                neq = p_values.getNames().length;
                int i4 = 0;
                while (i4 < neq) {
                    String gtype = p_values.getName(i4);
                    val = new double[numberOfTimePoint];
                    val2 = new double[numberOfTimePoint];
                    val2Log = new double[numberOfTimePoint];
                    boolean checkFlag = true;
                    int t = 0;
                    while (t < numberOfTimePoint) {
                        val[t] = this.allResults.getTime(t);
                        val2[t] = p_values.getValue(t, i4);
                        if (val2[t] > 0.0) {
                            val2Log[t] = Math.log(val2[t]);
                        } else {
                            checkFlag = false;
                            val2Log[t] = 0.0;
                        }
                        ++t;
                    }
                    this.drawLogFragList.add(new Boolean(checkFlag));
                    this.speciesList.add(gtype);
                    this.timeList.add(val);
                    this.dataList[0].add(val2);
                    this.dataList[1].add(val2Log);
                    ++i4;
                }
            }
            if (this.checkFlux.isSelected() && (f_values = this.allResults.getFluxes()) != null && f_values.getNames() != null) {
                neq = f_values.getNames().length;
                int i5 = 0;
                while (i5 < neq) {
                    String gtype = f_values.getName(i5);
                    val = new double[numberOfTimePoint];
                    val2 = new double[numberOfTimePoint];
                    val2Log = new double[numberOfTimePoint];
                    boolean checkFlag = true;
                    int t = 0;
                    while (t < numberOfTimePoint) {
                        val[t] = this.allResults.getTime(t);
                        val2[t] = f_values.getValue(t, i5);
                        if (val2[t] > 0.0) {
                            val2Log[t] = Math.log(val2[t]);
                        } else {
                            checkFlag = false;
                            val2Log[t] = 0.0;
                        }
                        ++t;
                    }
                    this.drawLogFragList.add(new Boolean(checkFlag));
                    this.speciesList.add(gtype);
                    this.timeList.add(val);
                    this.dataList[0].add(val2);
                    this.dataList[1].add(val2Log);
                    ++i5;
                }
            }
            this.maxStepValue = minStep;
            this.makedSwTbl = true;
            this.settingFlag = false;
        }
    }

    private void makeDrawSourceData(Boolean[] listOfVisibleResult, Boolean[] listOfOverlayedSpecies, ArrayList listOfResult) {
        this.settingFlag = true;
        this.makedSwDrawTbl = false;
        this.timeList = new Vector();
        this.dataList = new Vector[SCALE.length];
        this.drawLogFragList = new Vector();
        int i = 0;
        while (i < this.dataList.length) {
            this.dataList[i] = new Vector();
            ++i;
        }
        this.speciesList = new Vector();
        this.maxData = Double.NEGATIVE_INFINITY;
        this.minData = Double.MAX_VALUE;
        double minStep = Double.MAX_VALUE;
        if (listOfResult != null) {
            double[] val2Log;
            double[] val2;
            double[] val;
            int i2;
            TimeCourse c_values;
            this.allResults = (SBMLResults)listOfResult.get(0);
            int numberOfTimePoint = this.allResults.getTimepoints();
            int speciesLength = 0;
            int compartmentsLength = 0;
            int parametersLength = 0;
            int fluxesLength = 0;
            if (this.allResults.getSpecies() != null && this.allResults.getSpecies().getNames() != null) {
                speciesLength = this.allResults.getSpecies().getNames().length;
            }
            if (this.allResults.getCompartments() != null && this.allResults.getCompartments().getNames() != null) {
                compartmentsLength = this.allResults.getCompartments().getNames().length;
            }
            if (this.allResults.getParameters() != null && this.allResults.getParameters().getNames() != null) {
                parametersLength = this.allResults.getParameters().getNames().length;
            }
            if (this.allResults.getFluxes() != null && this.allResults.getFluxes().getNames() != null) {
                fluxesLength = this.allResults.getFluxes().getNames().length;
            }
            if (this.checkSpecies.isSelected()) {
                ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
                int j = 0;
                while (j < listOfVisibleResult.length) {
                    if (listOfVisibleResult[j].booleanValue()) {
                        SBMLResults targetResult = (SBMLResults)listOfResult.get(j);
                        numberOfTimePoint = targetResult.getTimepoints();
                        TimeCourse c_values2 = targetResult.getSpecies();
                        int neq = 0;
                        if (c_values2 != null && c_values2.getNames() != null) {
                            neq = c_values2.getNames().length;
                        }
                        int i3 = 0;
                        while (i3 < neq) {
                            if (listOfOverlayedSpecies[i3].booleanValue()) {
                                SpeciesData speciesD = (SpeciesData)listOfSpeciesData.get(i3);
                                String gtype = speciesD.toString();
                                gtype = String.valueOf(gtype) + " " + targetResult.getParameterInfo();
                                double[] val3 = new double[numberOfTimePoint];
                                double[] val22 = new double[numberOfTimePoint];
                                double[] val2Log2 = new double[numberOfTimePoint];
                                boolean checkFlag = true;
                                int t = 0;
                                while (t < numberOfTimePoint) {
                                    val3[t] = targetResult.getTime(t);
                                    val22[t] = c_values2.getValue(t, i3);
                                    if (val22[t] > 0.0) {
                                        val2Log2[t] = Math.log(val22[t]);
                                    } else {
                                        checkFlag = false;
                                        val2Log2[t] = 0.0;
                                    }
                                    ++t;
                                }
                                minStep = val3.length > 1 ? val3[1] - val3[0] : val3[0];
                                this.speciesList.add(gtype);
                                this.drawLogFragList.add(new Boolean(checkFlag));
                                this.timeList.add(val3);
                                this.dataList[0].add(val22);
                                this.dataList[1].add(val2Log2);
                                ++this.overlaySpeciesCount;
                            }
                            ++i3;
                        }
                    }
                    ++j;
                }
            }
            if (this.checkCompartment.isSelected()) {
                int j = 0;
                while (j < listOfVisibleResult.length) {
                    if (listOfVisibleResult[j].booleanValue()) {
                        SBMLResults targetResult = (SBMLResults)listOfResult.get(j);
                        numberOfTimePoint = targetResult.getTimepoints();
                        c_values = targetResult.getCompartments();
                        int neq = 0;
                        if (c_values != null && c_values.getNames() != null) {
                            neq = c_values.getNames().length;
                        }
                        i2 = 0;
                        while (i2 < neq) {
                            if (listOfOverlayedSpecies[i2 + speciesLength].booleanValue()) {
                                String gtype = c_values.getName(i2);
                                gtype = String.valueOf(gtype) + " " + targetResult.getParameterInfo();
                                val = new double[numberOfTimePoint];
                                val2 = new double[numberOfTimePoint];
                                val2Log = new double[numberOfTimePoint];
                                boolean checkFlag = true;
                                int t = 0;
                                while (t < numberOfTimePoint) {
                                    val[t] = targetResult.getTime(t);
                                    val2[t] = c_values.getValue(t, i2);
                                    if (val2[t] > 0.0) {
                                        val2Log[t] = Math.log(val2[t]);
                                    } else {
                                        checkFlag = false;
                                        val2Log[t] = 0.0;
                                    }
                                    ++t;
                                }
                                minStep = val.length > 1 ? val[1] - val[0] : val[0];
                                this.drawLogFragList.add(new Boolean(checkFlag));
                                this.speciesList.add(gtype);
                                this.timeList.add(val);
                                this.dataList[0].add(val2);
                                this.dataList[1].add(val2Log);
                            }
                            ++i2;
                        }
                    }
                    ++j;
                }
            }
            if (this.checkParameter.isSelected()) {
                int j = 0;
                while (j < listOfVisibleResult.length) {
                    if (listOfVisibleResult[j].booleanValue()) {
                        SBMLResults targetResult = (SBMLResults)listOfResult.get(j);
                        numberOfTimePoint = targetResult.getTimepoints();
                        c_values = targetResult.getParameters();
                        int neq = 0;
                        if (c_values != null && c_values.getNames() != null) {
                            neq = c_values.getNames().length;
                        }
                        i2 = 0;
                        while (i2 < neq) {
                            if (listOfOverlayedSpecies[i2 + speciesLength + compartmentsLength].booleanValue()) {
                                String gtype = c_values.getName(i2);
                                gtype = String.valueOf(gtype) + " " + targetResult.getParameterInfo();
                                val = new double[numberOfTimePoint];
                                val2 = new double[numberOfTimePoint];
                                val2Log = new double[numberOfTimePoint];
                                boolean checkFlag = true;
                                int t = 0;
                                while (t < numberOfTimePoint) {
                                    val[t] = targetResult.getTime(t);
                                    val2[t] = c_values.getValue(t, i2);
                                    if (val2[t] > 0.0) {
                                        val2Log[t] = Math.log(val2[t]);
                                    } else {
                                        checkFlag = false;
                                        val2Log[t] = 0.0;
                                    }
                                    ++t;
                                }
                                minStep = val.length > 1 ? val[1] - val[0] : val[0];
                                this.speciesList.add(gtype);
                                this.drawLogFragList.add(new Boolean(checkFlag));
                                this.timeList.add(val);
                                this.dataList[0].add(val2);
                                this.dataList[1].add(val2Log);
                            }
                            ++i2;
                        }
                    }
                    ++j;
                }
            }
            if (this.checkFlux.isSelected()) {
                int j = 0;
                while (j < listOfVisibleResult.length) {
                    if (listOfVisibleResult[j].booleanValue()) {
                        SBMLResults targetResult = (SBMLResults)listOfResult.get(j);
                        numberOfTimePoint = targetResult.getTimepoints();
                        c_values = targetResult.getFluxes();
                        int neq = 0;
                        if (c_values != null && c_values.getNames() != null) {
                            neq = c_values.getNames().length;
                        }
                        i2 = 0;
                        while (i2 < neq) {
                            if (listOfOverlayedSpecies[i2 + speciesLength + compartmentsLength + parametersLength].booleanValue()) {
                                String gtype = c_values.getName(i2);
                                gtype = String.valueOf(gtype) + " " + targetResult.getParameterInfo();
                                val = new double[numberOfTimePoint];
                                val2 = new double[numberOfTimePoint];
                                val2Log = new double[numberOfTimePoint];
                                boolean checkFlag = true;
                                int t = 0;
                                while (t < numberOfTimePoint) {
                                    val[t] = targetResult.getTime(t);
                                    val2[t] = c_values.getValue(t, i2);
                                    if (val2[t] > 0.0) {
                                        val2Log[t] = Math.log(val2[t]);
                                    } else {
                                        checkFlag = false;
                                        val2Log[t] = 0.0;
                                    }
                                    ++t;
                                }
                                minStep = val.length > 1 ? val[1] - val[0] : val[0];
                                this.drawLogFragList.add(new Boolean(checkFlag));
                                this.speciesList.add(gtype);
                                this.timeList.add(val);
                                this.dataList[0].add(val2);
                                this.dataList[1].add(val2Log);
                            }
                            ++i2;
                        }
                    }
                    ++j;
                }
            }
            this.maxStepValue = minStep;
            this.makedSwTbl = true;
            this.settingFlag = false;
        }
    }

    private void makeTimeData() {
        if (this.timeList.size() > 0) {
            this.maxTime = 0.0;
            this.minTime = Double.MAX_VALUE;
            for (double[] time : this.timeList) {
                this.maxTime = Math.max(this.maxTime, time[time.length - 1]);
                this.minTime = Math.min(this.minTime, time[0]);
            }
            this.maxTimeNow = this.maxTime;
            this.minTimeNow = this.minTime;
        } else {
            this.maxTimeNow = 0.0;
            this.minTimeNow = 0.0;
        }
    }

    private void setLocationScreenCenter() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenDim.width - this.getWidth()) / 2;
        int y = (screenDim.height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    @Override
    public void stateChanged(ColorChangeEvent e) {
        this.timeSeriesPanel.clearSelected();
        this.lineColorList = null;
        this.makeLineColor();
        this.timeSeriesPanel.setLineColor(this.lineColorList);
        this.timeSeriesPanel.repaint();
    }

    @Override
    public void stateChanged(VisibleChangeEvent e) {
        this.timeSeriesPanel.clearSelected();
        this.lineVisibleList = null;
        boolean fragTemp = this.makeLineVisible();
        if (this.selectedValue == 1 && !fragTemp) {
            JOptionPane.showMessageDialog(this, "Invalid data. Data contains values under zero.", "Inavlid", 2);
        }
        this.timeSeriesPanel.setLineVisible(this.lineVisibleList);
        this.timeSeriesPanel.repaint();
        this.setMaxRangeSpinner(this.maxRangeOfVisible);
    }

    @Override
    public void stateChanged(ListSelectionLocationEvent e) {
        String adt = this.getSelectionFirstVisible();
        if (adt == null) {
            this.timeSeriesPanel.setSelectionFirstVisibleLineIndex(-1);
            this.timeSeriesPanel.repaint();
            return;
        }
        int index = this.speciesList.indexOf(adt);
        this.timeSeriesPanel.setSelectionFirstVisibleLineIndex(index);
    }

    protected void changeSelectionData(Vector selectedSpecies) {
        Vector<Integer> selectIndex = new Vector<Integer>();
        int i = 0;
        while (i < selectedSpecies.size()) {
            String s = (String)selectedSpecies.get(i);
            int index = this.speciesList.indexOf(s);
            if (index != -1) {
                selectIndex.add(new Integer(index));
            } else {
                int j = 0;
                while (j < this.speciesList.size()) {
                    Object obj = this.speciesList.get(j);
                    String target = "";
                    target = (String)obj;
                    if (target.equals(s)) {
                        selectIndex.add(new Integer(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.timeSeriesPanel.clearSelected();
        this.timeSeriesPanel.setSelectedData(selectIndex);
        this.timeSeriesPanel.repaint();
        this.fireStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireSelectedSpecies();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(l);
    }

    protected void fireStateChanged() {
        for (ChangeListener cl : this.listenerList) {
            cl.stateChanged(new ChangeEvent(this));
        }
    }

    private void makeLineColor() {
        this.lineColorList = new Vector();
        Iterator itr = this.speciesList.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Object obj = itr.next();
            String gdt = "";
            gdt = (String)obj;
            Color color = null;
            if (this.speciesColorSet != null) {
                color = this.speciesColorSet.getColor(gdt);
            }
            if (color == null) {
                color = Color.BLUE;
            }
            this.lineColorList.add(color);
            ++i;
        }
    }

    private boolean makeLineVisible() {
        boolean fragTemp = true;
        this.lineVisibleList = new Vector();
        Iterator itr = this.speciesList.iterator();
        int i = 0;
        this.maxRangeOfVisible = 0.0;
        while (itr.hasNext()) {
            Object obj = itr.next();
            String gdt = "";
            gdt = (String)obj;
            Boolean isVisible = null;
            if (this.speciesVisible != null) {
                isVisible = this.speciesVisible.isVisible(gdt);
            }
            if (isVisible == null) {
                isVisible = new Boolean(true);
            }
            if (isVisible.booleanValue() && (((Boolean)this.drawLogFragList.get(i)).booleanValue() || this.selectedValue == 0)) {
                double[] valData = (double[])this.dataList[this.scaleList.getSelectedIndex()].elementAt(i);
                int k = 0;
                while (k < valData.length) {
                    if (this.maxRangeOfVisible < valData[k]) {
                        this.maxRangeOfVisible = valData[k];
                    }
                    ++k;
                }
            } else if (isVisible.booleanValue() && this.selectedValue == 1) {
                isVisible = new Boolean(false);
                fragTemp = false;
            }
            this.lineVisibleList.add(isVisible);
            ++i;
        }
        return fragTemp;
    }

    private Vector getSelectedSpecies() {
        Vector sv = this.timeSeriesPanel.getSelectedData();
        Vector<String> gv = new Vector<String>();
        for (Integer i : sv) {
            Object obj = this.speciesList.get(i);
            String gdt = "";
            gdt = (String)obj;
            gv.add(gdt);
        }
        return gv;
    }

    public Component showViewer() {
        this.show();
        this.setSize(100, 100);
        this.timeSeriesPanel.fireStateChanged();
        return this;
    }

    public void checkBoxAction(ActionEvent e) {
        if (this.listOfResult == null) {
            this.isUpdate = false;
            this.makeDrawSourceData();
        } else {
            this.makeDrawSourceData(this.listOfVisibleResult, this.listOfOverlayedSpecies, this.listOfResult);
        }
        boolean fragTemp = this.makeLineVisible();
        if (this.selectedValue == 1 && !fragTemp) {
            JOptionPane.showMessageDialog(this, "Invalid data. Data contains values under zero.", "Invalid Data", 2);
            ((JCheckBox)e.getSource()).setSelected(false);
            return;
        }
        this.timeSeriesPanel.setLineVisible(this.lineVisibleList);
        this.makeLineColor();
        this.timeSeriesPanel.setLineColor(this.lineColorList);
        this.setBasicData();
        this.isUpdate = true;
        this.drawGraph(this.selectedValue);
        this.resettingMaxRangeSpinner();
        this.updateSpinnerPositon(this.isSelected);
    }

    public void setIsUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    void maxRangeSpinner_stateChanged(ChangeEvent e) {
        if (this.settingFlag) {
            return;
        }
        this.maxRangeNow = this.maxRangeSpinner.getValue();
        this.timeSeriesPanel.setMaxRange(this.maxRangeNow);
        this.timeSeriesPanel.repaint();
    }

    void minRangeSpinner_stateChanged(ChangeEvent e) {
        if (this.settingFlag) {
            return;
        }
        if (this.minRangeSpinner.getValue() >= this.maxRangeSpinner.getValue()) {
            this.minRangeSpinner.setValue(this.maxRangeSpinner.getValue() - this.minRangeSpinner.getRC());
            this.minRangeNow = this.maxRangeSpinner.getValue() - this.minRangeSpinner.getRC();
            return;
        }
        this.minRangeNow = this.minRangeSpinner.getValue();
        this.timeSeriesPanel.setMinRange(this.minRangeNow);
        this.timeSeriesPanel.repaint();
    }

    void timeIntervalSpinner_stateChanged(ChangeEvent e) {
        if (this.settingFlag) {
            return;
        }
        double d = 0.0;
        if (this.timeIntervalSpinner.getValue() <= this.minTime) {
            this.timeIntervalSpinner.setValue(this.minTime + this.timeIntervalSpinner.getRC());
            return;
        }
        if (this.timeIntervalSpinner.getValue() < this.maxTime) {
            this.timeScrollBar.setEnabled(true);
            d = (this.maxTime - this.timeIntervalSpinner.getValue()) / (double)(this.timeScrollBar.getMaximum() - this.timeScrollBar.getMinimum()) * (double)(this.timeScrollBar.getValue() - this.timeScrollBar.getMinimum());
        } else {
            this.timeScrollBar.setEnabled(false);
        }
        this.maxTimeNow = this.timeIntervalSpinner.getValue() + d;
        this.minTimeNow = this.minTime + d;
        this.timeSeriesPanel.setMaxTimeOfDraw(this.maxTimeNow);
        this.timeSeriesPanel.setMinTimeOfDraw(this.minTimeNow);
        this.timeSeriesPanel.repaint();
    }

    private void jSpeciesListPanel_changeListSelection(ListSelectionEvent e) {
        if (!this.changingSelectFlag) {
            this.changingSelectFlag = true;
            String[] adtList = this.jSpeciesListPanel.getSelectedSpecies();
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < adtList.length) {
                v.add(adtList[i]);
                ++i;
            }
            this.changeSelectionData(v);
            this.changingSelectFlag = false;
        }
    }

    private void jSpeciesListPanel_changeListSelectionLocation(ListSelectionLocationEvent e) {
    }

    void timeScrollBar_adjustmentValueChanged(AdjustmentEvent e) {
        if (this.settingFlag) {
            return;
        }
        double d = (this.maxTime - this.timeIntervalSpinner.getValue()) / (double)(this.timeScrollBar.getMaximum() - this.timeScrollBar.getMinimum()) * (double)(this.timeScrollBar.getValue() - this.timeScrollBar.getMinimum());
        this.maxTimeNow = this.timeIntervalSpinner.getValue() + d;
        this.minTimeNow = this.minTime + d;
        this.timeSeriesPanel.setMaxTimeOfDraw(this.maxTimeNow);
        this.timeSeriesPanel.setMinTimeOfDraw(this.minTimeNow);
        this.timeSeriesPanel.repaint();
    }

    private void fireSelectedSpecies() {
        if (!this.changingSelectFlag) {
            this.changingSelectFlag = true;
            this.jSpeciesListPanel.changeSelectionData(this.getSelectedSpecies());
            this.jSpeciesListPanel.setFirstSelectionTop();
            this.changingSelectFlag = false;
        }
    }

    protected final String getSelectionFirstVisible() {
        return this.jSpeciesListPanel.getFirstSelectionTop();
    }

    public void setSpeciesColorSet() {
        if (this.speciesList == null) {
            return;
        }
        if (this.speciesColorSet == null && this.isUpdate) {
            this.speciesColorSet = new SpeciesColorSet();
            HashMap<String, Color> colorMap = new HashMap<String, Color>();
            Color[] uniqueColors = UniqueColors.getUniqueColors(this.speciesList.size());
            Iterator itr = this.speciesList.iterator();
            int i = 0;
            while (itr.hasNext()) {
                Color color = uniqueColors[i++];
                Object obj = itr.next();
                String gdt = (String)obj;
                colorMap.put(gdt, color);
            }
            this.speciesColorSet.setSpeciesColors(colorMap);
        }
        this.jSpeciesListPanel.setSpeciesColorSet(this.speciesColorSet);
        this.speciesColorSet.addColorChangeListener(this.jSpeciesListPanel);
        this.speciesColorSet.addColorChangeListener(this);
    }

    public void setSpeciesVisible() {
        if (this.speciesList == null) {
            return;
        }
        if (this.speciesVisible == null && this.isUpdate) {
            this.speciesVisible = new SpeciesVisible();
            HashMap<String, Boolean> svMap = new HashMap<String, Boolean>();
            Iterator itr = this.speciesList.iterator();
            boolean i = false;
            while (itr.hasNext()) {
                Object obj = itr.next();
                String gdt = (String)obj;
                svMap.put(gdt, new Boolean(true));
            }
            this.speciesVisible.setSpeciesVisible(svMap);
        }
        this.jSpeciesListPanel.setSpeciesVisible(this.speciesVisible);
        this.speciesVisible.addVisibleChangeListener(this.jSpeciesListPanel);
        this.speciesVisible.addVisibleChangeListener(this);
    }

    private void setSpeciesList(Vector speciesList) {
        this.jSpeciesListPanel.setSpeciesList(speciesList);
    }

    public SBMLResults getAllResults() {
        return this.allResults;
    }

    public Vector getLineColorList() {
        return this.lineColorList;
    }

    public void setLineColorList(Vector lineColorList) {
        this.lineColorList = lineColorList;
    }

    public Vector getLineVisibleList() {
        return this.lineVisibleList;
    }

    public void setLineVisibleList(Vector lineVisibleList) {
        this.lineVisibleList = lineVisibleList;
    }

    public Vector getListenerList() {
        return this.listenerList;
    }

    public void setListenerList(Vector listenerList) {
        this.listenerList = listenerList;
    }

    public void setCheckSpeciesSelected(boolean selected) {
        this.checkSpecies.setSelected(selected);
    }

    public void setCheckCompartmentSelected(boolean selected) {
        this.checkCompartment.setSelected(selected);
    }

    public void setCheckParameterSelected(boolean selected) {
        this.checkParameter.setSelected(selected);
    }

    public void setCheckFluxSelected(boolean selected) {
        this.checkFlux.setSelected(selected);
    }

    public boolean getCheckSpeciesSelected() {
        return this.checkSpecies.isSelected();
    }

    public boolean getCheckCompartmentSelected() {
        return this.checkCompartment.isSelected();
    }

    public boolean getCheckParameterSelected() {
        return this.checkParameter.isSelected();
    }

    public boolean getCheckFluxSelected() {
        return this.checkFlux.isSelected();
    }

    public ArrayList getListOfResult() {
        return this.listOfResult;
    }

    public Boolean[] getListOfOverlayedSpecies() {
        return this.listOfOverlayedSpecies;
    }

    public Boolean[] getListOfVisibleResult() {
        return this.listOfVisibleResult;
    }

    public void setScaleList(String s) {
        this.scaleList.setSelectedItem(s);
    }

    public void setMinRangeSpinner(double d) {
        this.minRangeNow = d;
        this.minRangeSpinner.setValue(d);
    }

    public void setMaxRangeSpinner(double d) {
        this.maxRangeNow = d;
        this.maxRangeSpinner.setValue(d);
    }

    public void setSelectValue(int selectedValue, boolean repaint) {
        this.scaleList.setSelectedIndex(selectedValue);
        if (repaint) {
            this.drawGraph(selectedValue);
        }
    }

    public int getSelectValue() {
        return this.selectedValue;
    }

    public double getMinRangeNow() {
        return this.minRangeNow;
    }

    public double getMaxTimeNow() {
        return this.maxTimeNow;
    }

    public void resettingMaxRangeSpinner() {
        if (!(this.checkSpecies.isSelected() || this.checkParameter.isSelected() || this.checkCompartment.isSelected() || this.checkFlux.isSelected())) {
            return;
        }
        this.maxRangeSpinner.setValue(this.maxRangeOfVisible);
    }

    public void setTimeIntervalSpinner(double d) {
        this.maxTimeNow = d;
        this.timeIntervalSpinner.setValue(d);
    }

    public String getScaleListSelected() {
        return (String)this.scaleList.getSelectedItem();
    }

    public double getMinRangeSpinner() {
        return this.minRangeSpinner.getValue();
    }

    public double getMaxRangeSpinner() {
        return this.maxRangeSpinner.getValue();
    }

    public double getTimeIntervalSpinner() {
        return this.timeIntervalSpinner.getValue();
    }

    public double getMaxRangeNow() {
        return this.maxRangeNow;
    }

    public double getIntervalYAxisValue() {
        Vector yScaleData = this.timeSeriesPanel.getYScaleData();
        double intervalValue = 0.0;
        ScaleData first = (ScaleData)yScaleData.get(1);
        double beforeValue = Double.parseDouble(first.getString());
        int i = 2;
        while (i < yScaleData.size() - 1) {
            ScaleData sd = (ScaleData)yScaleData.get(i);
            String data = sd.getString();
            double d = Double.parseDouble(data);
            double interval = d - beforeValue;
            if (interval >= intervalValue) {
                intervalValue = interval;
            }
            beforeValue = d;
            ++i;
        }
        return intervalValue;
    }

    public double getIntervalXAxisValue() {
        Vector xScaleData = this.timeSeriesPanel.getXScaleData();
        double intervalValue = 0.0;
        ScaleData first = (ScaleData)xScaleData.get(1);
        double beforeValue = Double.parseDouble(first.getString());
        int i = 2;
        while (i < xScaleData.size() - 1) {
            ScaleData sd = (ScaleData)xScaleData.get(i);
            String data = sd.getString();
            double d = Double.parseDouble(data);
            double interval = d - beforeValue;
            if (interval >= intervalValue) {
                intervalValue = interval;
            }
            beforeValue = d;
            ++i;
        }
        return intervalValue;
    }

    public ChartPanel showScatterPlot() {
        int index1 = this.lineVisibleList.indexOf(new Boolean(true));
        int index2 = this.lineVisibleList.indexOf(new Boolean(true), index1 + 1);
        int index3 = this.lineVisibleList.indexOf(new Boolean(true), index2 + 1);
        int speciesSize = this.getAllResults().getSpecies().getNames().length;
        boolean error = false;
        if (index3 >= speciesSize) {
            index3 = -1;
        }
        if (this.getAllResults().getSpecies() != null && (index1 >= speciesSize || index2 >= speciesSize)) {
            error = true;
        }
        if (index1 == -1 || index2 == -1 || index3 != -1 || error) {
            JOptionPane.showMessageDialog(this, "Select exactly two species. ", "warning.", 1);
            return null;
        }
        ScatterChartPanel src = new ScatterChartPanel();
        ChartPanel panel = null;
        if (this.getListOfResult() == null && this.getAllResults() != null) {
            panel = new ChartPanel(src.createXYScatterChart(this.getAllResults(), index1, index2));
        } else if (this.getListOfResult() != null) {
            panel = new ChartPanel(src.createXYScatterChart(this.dataList, this.speciesList, index1, index2));
        }
        panel.setBackground(this.bgColor);
        return panel;
    }

    public ChartPanel showReverseScatterPlot() {
        int index1 = this.lineVisibleList.indexOf(new Boolean(true));
        int index2 = this.lineVisibleList.indexOf(new Boolean(true), index1 + 1);
        int index3 = this.lineVisibleList.indexOf(new Boolean(true), index2 + 1);
        if (index3 >= this.jSpeciesListPanel.getSpeciesTableModelRowCount()) {
            index3 = -1;
        }
        if (index1 == -1 || index2 == -1 || index3 != -1) {
            JOptionPane.showMessageDialog(this, "Select exactly two species. ", "warning.", 1);
            return null;
        }
        ScatterChartPanel src = new ScatterChartPanel();
        ChartPanel panel = null;
        if (this.getListOfResult() == null && this.getAllResults() != null) {
            panel = new ChartPanel(src.createXYScatterChart(this.getAllResults(), index2, index1));
        } else if (this.getListOfResult() != null) {
            panel = new ChartPanel(src.createXYScatterChart(this.dataList, this.speciesList, index2, index1));
        }
        panel.setBackground(this.bgColor);
        return panel;
    }

    private class CoordinateConverter {
        private Component source = null;
        private Component target = null;
        private Point sp = new Point();
        private Point tp = new Point();

        public CoordinateConverter(Component source, Component target) {
            this.source = source;
            this.target = target;
        }

        public Point convert(Point p) {
            double x = 0.0;
            double y = 0.0;
            Component sC = this.source;
            while (sC != null) {
                sC.getLocation(this.sp);
                x += this.sp.getX();
                y += this.sp.getY();
                sC = sC.getParent();
            }
            Component tC = this.target;
            while (tC != null) {
                tC.getLocation(this.tp);
                x -= this.tp.getX();
                y -= this.tp.getY();
                tC = tC.getParent();
            }
            p.setLocation(p.getX() + x, p.getY() + y);
            return p;
        }
    }

    private class DrawPanel
    extends JPanel {
        private Vector text = new Vector();
        private Vector point = new Vector();

        public void addDrawData(String s, int x, int y) {
            this.text.add(s);
            this.point.add(new Point(x, y));
        }

        public void addDrawData(String s, Point p) {
            this.text.add(s);
            this.point.add(p);
        }

        public void clear() {
            this.text.clear();
            this.point.clear();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int i = 0;
            while (i < this.text.size()) {
                String s = (String)this.text.get(i);
                Point p = (Point)this.point.get(i);
                FontMetrics fm = g.getFontMetrics(g.getFont());
                if (!(p.getX() < 0.0 || p.getX() + (double)fm.stringWidth(s) > (double)this.getWidth() || p.getY() < (double)fm.getHeight() || p.getY() > (double)this.getHeight())) {
                    g.setColor(Color.BLACK);
                    g.drawString(s, (int)p.getX(), (int)p.getY());
                }
                ++i;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            Graphics g = this.getGraphics();
            return dim;
        }
    }

    private class GraphScaleControl
    implements ChangeListener {
        private TimeSeriesPanel timeCoursePanel = null;
        private DrawPanel xAxisPanel = null;
        private DrawPanel yAxisPanel = null;
        private CoordinateConverter xConverter = null;
        private CoordinateConverter yConverter = null;

        public GraphScaleControl(TimeSeriesPanel tcp, DrawPanel xAxis, DrawPanel yAxis) {
            this.timeCoursePanel = tcp;
            this.xAxisPanel = xAxis;
            this.yAxisPanel = yAxis;
            this.xConverter = new CoordinateConverter(this.timeCoursePanel, this.xAxisPanel);
            this.yConverter = new CoordinateConverter(this.timeCoursePanel, this.yAxisPanel);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.xAxisPanel.clear();
            FontMetrics xfm = this.xAxisPanel.getFontMetrics(this.xAxisPanel.getFont());
            Vector xScaleData = this.timeCoursePanel.getXScaleData();
            for (ScaleData sd : xScaleData) {
                Point p = new Point(sd.getPoint());
                this.xConverter.convert(p);
                p.setLocation(p.getX(), 0.0);
                p.setLocation(p.getX() - (double)xfm.stringWidth(sd.getString()) / 2.0, p.getY() + (double)xfm.getHeight());
                this.xAxisPanel.addDrawData(sd.getString(), p);
            }
            this.xAxisPanel.repaint();
            this.yAxisPanel.clear();
            FontMetrics yfm = this.yAxisPanel.getFontMetrics(this.yAxisPanel.getFont());
            Vector yScaleData = this.timeCoursePanel.getYScaleData();
            for (ScaleData sd : yScaleData) {
                Point p = new Point(sd.getPoint());
                this.yConverter.convert(p);
                p.setLocation((double)(this.yAxisPanel.getWidth() - 2), p.getY());
                p.setLocation(p.getX() - (double)yfm.stringWidth(sd.getString()), p.getY() + (double)yfm.getAscent() / 2.0);
                this.yAxisPanel.addDrawData(sd.getString(), p);
            }
            this.yAxisPanel.repaint();
        }
    }
}

