/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import jp.co.mki.celldesigner.simulation.CvodeResults;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesColorSet;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesVisible;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SimulationResultChart {
    String title = "time series chart";
    String timeAxisLabel = "time point";
    String valueAxisLabel = "quantity";
    private static final double Log10 = Math.log(10.0);
    private static final double Log10_2 = Math.log(2.0) / Math.log(10.0);
    private static final double Log10_5 = Math.log(5.0) / Math.log(10.0);
    private boolean paramscan2;
    private ControlPanelMainWindow parent;

    public void createChart(CvodeResults cvodeResults, String saveFileName) throws IOException {
    }

    public JFreeChart createChart(ControlPanelMainWindow parent, SBMLResults cvodeResults, SimulationResultPanel originSrp, boolean paramscan2) throws IOException {
        this.paramscan2 = paramscan2;
        this.parent = parent;
        JFreeChart xyLineChart = this.createXYLineChart(cvodeResults, originSrp);
        int width = 500;
        int height = 500;
        return xyLineChart;
    }

    public JFreeChart createChart(ControlPanelMainWindow parent, ArrayList listOfSBMLResults, SimulationResultPanel originSrp, boolean paramscan2) throws IOException {
        this.paramscan2 = paramscan2;
        this.parent = parent;
        JFreeChart xyLineChart = this.createXYLineChart(listOfSBMLResults, originSrp);
        int width = 500;
        int height = 500;
        return xyLineChart;
    }

    private JFreeChart createXYLineChart(SBMLResults cvodeResults, SimulationResultPanel originSrp) {
        boolean legend = true;
        boolean tooltips = true;
        boolean urls = true;
        ArrayList listOfNames = new ArrayList();
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.title, (String)this.timeAxisLabel, (String)this.valueAxisLabel, (XYDataset)this.createXYSeriesCollection(cvodeResults, originSrp, listOfNames), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        XYPlot xyPlot = chart.getXYPlot();
        this.setXYPlotProperties(xyPlot, originSrp, listOfNames);
        Legend clegend = chart.getLegend();
        if (clegend == null) {
            clegend = new StandardLegend();
            chart.setLegend(clegend);
            clegend.setAnchor(2);
        }
        chart.setSubtitles(new ArrayList());
        if (originSrp.isSelectedHantenCheck()) {
            xyPlot.setOrientation(PlotOrientation.HORIZONTAL);
        } else {
            xyPlot.setOrientation(PlotOrientation.VERTICAL);
        }
        return chart;
    }

    private JFreeChart createXYLineChart(ArrayList listOfSBMLResults, SimulationResultPanel originSrp) {
        boolean legend = true;
        boolean tooltips = true;
        boolean urls = true;
        ArrayList listOfNames = new ArrayList();
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.title, (String)this.timeAxisLabel, (String)this.valueAxisLabel, (XYDataset)this.createXYSeriesCollection(listOfSBMLResults, originSrp, listOfNames), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        XYPlot xyPlot = chart.getXYPlot();
        this.setXYPlotProperties(xyPlot, originSrp, listOfNames);
        Legend clegend = chart.getLegend();
        if (clegend == null) {
            clegend = new StandardLegend();
            chart.setLegend(clegend);
            clegend.setAnchor(2);
        }
        chart.setSubtitles(new ArrayList());
        return chart;
    }

    private void setXYPlotProperties(XYPlot xyPlot, SimulationResultPanel originSrp, ArrayList listOfNames) {
        NumberTickUnit unit;
        TickUnits tickUnits;
        double intervalValue;
        XYItemRenderer xyRenderer = xyPlot.getRenderer();
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{10.0f, 0.0f}, 0.0f);
        SpeciesColorSet speciesColorSet = originSrp.getSpeciesColorSet();
        SpeciesVisible speciesVisible = originSrp.getSpeciesVisible();
        int i = 0;
        while (i < listOfNames.size()) {
            String name = (String)listOfNames.get(i);
            Boolean visible = speciesVisible.isVisible(name);
            if (visible == null || !visible.booleanValue()) {
                xyRenderer.setSeriesVisible(i, visible);
            } else {
                Color color = speciesColorSet.getColor(name);
                if (color == null) {
                    xyRenderer.setSeriesPaint(i, (Paint)ChartColor.BLUE);
                } else {
                    xyRenderer.setSeriesPaint(i, (Paint)color);
                }
                xyRenderer.setSeriesStroke(i, (Stroke)basicStroke);
            }
            ++i;
        }
        if (originSrp.getScaleListSelected().equals("log")) {
            LogarithmicAxis yAxis = new LogarithmicAxis("");
            yAxis.setLog10TickLabelsFlag(false);
            yAxis.setStrictValuesFlag(false);
            yAxis.setExpTickLabelsFlag(true);
            xyPlot.setRangeAxis((ValueAxis)yAxis);
        } else {
            ValueAxis rangeAxis = xyPlot.getRangeAxis();
            rangeAxis.setUpperBound(originSrp.getMaxRangeSpinner());
            rangeAxis.setLowerBound(originSrp.getMinRangeSpinner());
            double min = rangeAxis.getLowerBound();
            double max = rangeAxis.getUpperBound();
            intervalValue = originSrp.getIntervalYAxisValue();
            rangeAxis.setUpperBound(this.getUpperBound(intervalValue, max));
            tickUnits = new TickUnits();
            unit = new NumberTickUnit(intervalValue);
            tickUnits.add((TickUnit)unit);
        }
        ValueAxis domainAxis = xyPlot.getDomainAxis();
        domainAxis.setUpperBound(originSrp.getTimeIntervalSpinner());
        double min = domainAxis.getLowerBound();
        double max = domainAxis.getUpperBound();
        intervalValue = originSrp.getIntervalXAxisValue();
        domainAxis.setUpperBound(this.getUpperBound(intervalValue, max));
        tickUnits = new TickUnits();
        unit = new NumberTickUnit(intervalValue);
        tickUnits.add((TickUnit)unit);
    }

    private double getUpperBound(double intervalValue, double max) {
        double returnValue = 0.0;
        while (returnValue < max) {
            returnValue = Double.parseDouble(StringTool.convertNumberFormat(returnValue + intervalValue));
        }
        return returnValue;
    }

    private XYSeriesCollection createXYSeriesCollection(SBMLResults cvodeResults, SimulationResultPanel originSrp, ArrayList listOfNames) {
        int j;
        TimeCourse species = cvodeResults.getSpecies();
        TimeCourse compartments = cvodeResults.getCompartments();
        TimeCourse parameters = cvodeResults.getParameters();
        TimeCourse fluxes = cvodeResults.getFluxes();
        XYSeriesCollection xysc = new XYSeriesCollection();
        if (originSrp.getCheckSpeciesSelected()) {
            j = 0;
            while (j < species.getNum_val()) {
                xysc.addSeries(this.createXYSeriesByValue(cvodeResults, species, "species", listOfNames, j));
                ++j;
            }
        }
        if (originSrp.getCheckCompartmentSelected()) {
            j = 0;
            while (j < compartments.getNum_val()) {
                xysc.addSeries(this.createXYSeriesByValue(cvodeResults, compartments, "compartments", listOfNames, j));
                ++j;
            }
        }
        if (originSrp.getCheckParameterSelected()) {
            j = 0;
            while (j < parameters.getNum_val()) {
                xysc.addSeries(this.createXYSeriesByValue(cvodeResults, parameters, "parameters", listOfNames, j));
                ++j;
            }
        }
        if (originSrp.getCheckFluxSelected()) {
            j = 0;
            while (j < fluxes.getNum_val()) {
                xysc.addSeries(this.createXYSeriesByValue(cvodeResults, fluxes, "fluxes", listOfNames, j));
                ++j;
            }
        }
        return xysc;
    }

    private XYSeriesCollection createXYSeriesCollection(ArrayList listOfSBMLResults, SimulationResultPanel originSrp, ArrayList listOfNames) {
        XYSeriesCollection xysc = new XYSeriesCollection();
        Boolean[] visible = originSrp.getListOfVisibleResult();
        Boolean[] listOfOverlayedSpecies = originSrp.getListOfOverlayedSpecies();
        int i = 0;
        while (i < listOfSBMLResults.size()) {
            if (visible[i].booleanValue()) {
                int j;
                SBMLResults cvodeResults = (SBMLResults)listOfSBMLResults.get(i);
                int speciesLength = 0;
                int compartmentsLength = 0;
                int parametersLength = 0;
                int fluxesLength = 0;
                if (cvodeResults.getSpecies() != null && cvodeResults.getSpecies().getNames() != null) {
                    speciesLength = cvodeResults.getSpecies().getNames().length;
                }
                if (cvodeResults.getCompartments() != null && cvodeResults.getCompartments().getNames() != null) {
                    compartmentsLength = cvodeResults.getCompartments().getNames().length;
                }
                if (cvodeResults.getParameters() != null && cvodeResults.getParameters().getNames() != null) {
                    parametersLength = cvodeResults.getParameters().getNames().length;
                }
                if (cvodeResults.getFluxes() != null && cvodeResults.getFluxes().getNames() != null) {
                    fluxesLength = cvodeResults.getFluxes().getNames().length;
                }
                TimeCourse species = cvodeResults.getSpecies();
                TimeCourse compartments = cvodeResults.getCompartments();
                TimeCourse parameters = cvodeResults.getParameters();
                TimeCourse fluxes = cvodeResults.getFluxes();
                if (originSrp.getCheckSpeciesSelected()) {
                    j = 0;
                    while (j < species.getNum_val()) {
                        if (listOfOverlayedSpecies[j].booleanValue()) {
                            xysc.addSeries(this.createXYSeriesByValue(cvodeResults, species, "species", listOfNames, j));
                        }
                        ++j;
                    }
                }
                if (originSrp.getCheckCompartmentSelected()) {
                    j = 0;
                    while (j < compartments.getNum_val()) {
                        if (listOfOverlayedSpecies[j + speciesLength].booleanValue()) {
                            xysc.addSeries(this.createXYSeriesByValue(cvodeResults, compartments, "compartments", listOfNames, j));
                        }
                        ++j;
                    }
                }
                if (originSrp.getCheckParameterSelected()) {
                    j = 0;
                    while (j < parameters.getNum_val()) {
                        if (listOfOverlayedSpecies[j + speciesLength + compartmentsLength].booleanValue()) {
                            xysc.addSeries(this.createXYSeriesByValue(cvodeResults, parameters, "parameters", listOfNames, j));
                        }
                        ++j;
                    }
                }
                if (originSrp.getCheckFluxSelected()) {
                    j = 0;
                    while (j < fluxes.getNum_val()) {
                        if (listOfOverlayedSpecies[j + speciesLength + compartmentsLength + parametersLength].booleanValue()) {
                            xysc.addSeries(this.createXYSeriesByValue(cvodeResults, fluxes, "fluxes", listOfNames, j));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return xysc;
    }

    private XYSeries createXYSeriesByValue(SBMLResults cvodeResults, TimeCourse timeCourse2, String type, ArrayList listOfNames, int eqIndex) {
        String name = "";
        String info = "";
        ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
        if (type.equals("species")) {
            SpeciesData sp = (SpeciesData)listOfSpeciesData.get(eqIndex);
            name = sp.toString();
        } else {
            name = timeCourse2.getName(eqIndex);
        }
        if (!this.paramscan2 && cvodeResults.getParameterInfo() != null && !cvodeResults.getParameterInfo().equals("")) {
            info = " " + cvodeResults.getParameterInfo();
        }
        listOfNames.add(String.valueOf(name) + info);
        XYSeries xys = new XYSeries(String.valueOf(name) + info);
        int i = 0;
        while (i < timeCourse2.getTimepoints()) {
            double timePoint = cvodeResults.getTime(i);
            double value = timeCourse2.getValue(i, eqIndex);
            xys.add(timePoint, value);
            ++i;
        }
        return xys;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTimeAxisLabel(String timeAxisLabel) {
        this.timeAxisLabel = timeAxisLabel;
    }

    public void setValueAxisLabel(String valueAxisLabel) {
        this.valueAxisLabel = valueAxisLabel;
    }

    private double calculateDelta(double min, double max) {
        double ord;
        double delta = Math.log(max - min) / Log10;
        double dif = delta - (ord = Math.floor(delta));
        delta = dif < Log10_2 ? Math.pow(10.0, ord - 1.0) * 2.0 : (dif < Log10_5 ? Math.pow(10.0, ord - 1.0) * 5.0 : Math.pow(10.0, ord));
        return delta;
    }
}

