/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.constant.CodeInformation;
import jp.co.mki.celldesigner.simulation.controlpanel.ChangeAmount;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.ErrorTolerance;
import jp.co.mki.celldesigner.simulation.controlpanel.InteractiveSimulation;
import jp.co.mki.celldesigner.simulation.controlpanel.ParameterScan;
import jp.co.mki.celldesigner.simulation.controlpanel.SliderValue;
import jp.co.mki.celldesigner.simulation.controlpanel.Solver;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesColorSet;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesVisible;
import jp.co.mki.celldesigner.simulation.controlpanel.TimeSpan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAttribute;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlCurve;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlInteractiveSimulation;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlModel;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPlot2D;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimCondition;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSliderValue;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlTask;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlUniformTimeCourse;
import jp.co.mki.celldesigner.simulation.sedml.util.SmlUtil;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SimulationInfo {
    private ControlPanelMainWindow parent;
    Object[] listOfInfo;
    public static final int TIME_SPAN = 0;
    public static final int CHANGE_AMOUNT = 1;
    public static final int PARAMETER_SCAN = 2;
    public static final int INTERACTIVE_SIMULATION = 3;
    public static final int ERROR_TOLERANCE = 4;
    public static final int SOLVER = 5;
    public static final int[] SIMULATION_INFO_LIST;
    private ArrayList errorList;
    private SpeciesColorSet speciesColorSet;
    private SpeciesVisible speciesVisible;
    private ArrayList listOfResult;
    private ArrayList listOfResultVisible;
    private SBMLPanelLists sbmlPanelLists;
    private ArrayList listOfOriginSpecies;
    private ArrayList listOfOriginReactions;
    private int visibleResultRow;
    private HashMap hashVisibleSpecies;
    private ArrayList listOfOriginGlobalParameters;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        SIMULATION_INFO_LIST = nArray;
    }

    public SimulationInfo(ControlPanelMainWindow parent) {
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.listOfInfo = new Object[SIMULATION_INFO_LIST.length];
        this.errorList = new ArrayList();
    }

    public boolean read(File simFile) {
        TimeSpan timeSpan = (TimeSpan)this.getSimulationInfo(0);
        ChangeAmount changeAmount = (ChangeAmount)this.getSimulationInfo(1);
        ParameterScan parameterScan = (ParameterScan)this.getSimulationInfo(2);
        InteractiveSimulation interactiveSimulation = (InteractiveSimulation)this.getSimulationInfo(3);
        ErrorTolerance errorTolerance = (ErrorTolerance)this.getSimulationInfo(4);
        Solver solver = (Solver)this.getSimulationInfo(5);
        if (timeSpan == null) {
            timeSpan = new TimeSpan();
        }
        if (changeAmount == null) {
            changeAmount = new ChangeAmount();
        }
        if (parameterScan == null) {
            parameterScan = new ParameterScan();
        }
        if (interactiveSimulation == null) {
            interactiveSimulation = new InteractiveSimulation();
        }
        if (errorTolerance == null) {
            errorTolerance = new ErrorTolerance();
        }
        if (solver == null) {
            solver = new Solver();
        }
        this.listOfInfo[0] = timeSpan;
        this.listOfInfo[1] = changeAmount;
        this.listOfInfo[2] = parameterScan;
        this.listOfInfo[3] = interactiveSimulation;
        this.listOfInfo[4] = errorTolerance;
        this.listOfInfo[5] = solver;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(simFile);
            Element rootElement = doc.getDocumentElement();
            NodeList spanstepList = rootElement.getElementsByTagName("TimeSpan");
            int i = 0;
            while (i < spanstepList.getLength()) {
                if (spanstepList.item(i).getNodeName().equals("TimeSpan")) {
                    Node childNode = spanstepList.item(i);
                    this.setTimeSpan(timeSpan, childNode);
                }
                ++i;
            }
            NodeList errorToleranceList = rootElement.getElementsByTagName("ErrorTolerance");
            int i2 = 0;
            while (i2 < errorToleranceList.getLength()) {
                if (errorToleranceList.item(i2).getNodeName().equals("ErrorTolerance")) {
                    Node childNode = errorToleranceList.item(i2);
                    this.setErrorTolerance(errorTolerance, childNode);
                }
                ++i2;
            }
            NodeList solverList = rootElement.getElementsByTagName("Solver");
            int i3 = 0;
            while (i3 < solverList.getLength()) {
                if (solverList.item(i3).getNodeName().equals("Solver")) {
                    Node childNode = solverList.item(i3);
                    this.setSolver(solver, childNode);
                }
                ++i3;
            }
            NodeList parameterScanList = rootElement.getElementsByTagName("ParameterScan");
            int i4 = 0;
            while (i4 < parameterScanList.getLength()) {
                if (parameterScanList.item(i4).getNodeName().equals("ParameterScan")) {
                    Node childNode = parameterScanList.item(i4);
                    this.setParameterScan(parameterScan, childNode, i4);
                }
                ++i4;
            }
            NodeList intaractiveScanList = rootElement.getElementsByTagName("InteractiveSimulation");
            int i5 = 0;
            while (i5 < intaractiveScanList.getLength()) {
                if (intaractiveScanList.item(i5).getNodeName().equals("InteractiveSimulation")) {
                    Node childNode = intaractiveScanList.item(i5);
                    this.setInteractiveSimulation(interactiveSimulation, childNode);
                }
                ++i5;
            }
            NodeList changeAomountScanList = rootElement.getElementsByTagName("ChangeAmount");
            int i6 = 0;
            while (i6 < changeAomountScanList.getLength()) {
                if (changeAomountScanList.item(i6).getNodeName().equals("ChangeAmount")) {
                    Node childNode = changeAomountScanList.item(i6);
                    this.setChangeAmount(changeAmount, childNode);
                }
                ++i6;
            }
            NodeList resultList = rootElement.getElementsByTagName("ListOfResults");
            int i7 = 0;
            while (i7 < resultList.getLength()) {
                if (resultList.item(i7).getNodeName().equals("ListOfResults")) {
                    Node childNode = resultList.item(i7);
                    this.setListOfResults(childNode);
                }
                ++i7;
            }
            NodeList plotList = rootElement.getElementsByTagName("ListOfPlot");
            int i8 = 0;
            while (i8 < plotList.getLength()) {
                if (plotList.item(i8).getNodeName().equals("ListOfPlot")) {
                    Node childNode = plotList.item(i8);
                    this.setListOfPlot(childNode);
                }
                ++i8;
            }
            NodeList initializeList = rootElement.getElementsByTagName("ListOfInitialize");
            int i9 = 0;
            while (i9 < initializeList.getLength()) {
                if (initializeList.item(i9).getNodeName().equals("ListOfInitialize")) {
                    Node childNode = initializeList.item(i9);
                    this.setListOfInitialize(childNode);
                }
                ++i9;
            }
        }
        catch (Exception ex) {
            this.errorList.add(ex.toString());
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private void setTimeSpan(TimeSpan timeSpan, NodeList parameterList) {
        int j = 0;
        while (j < parameterList.getLength()) {
            Element parameter = (Element)parameterList.item(j);
            String attribute = parameter.getAttribute("name");
            if (attribute.equals("Span")) {
                timeSpan.setSpan(parameter.getAttribute("value"));
            } else if (attribute.equals("Step")) {
                timeSpan.setStep(parameter.getAttribute("value"));
            }
            ++j;
        }
    }

    private void setTimeSpan(TimeSpan timeSpan, Node modelNode) {
        Element parameter = (Element)modelNode;
        String span = parameter.getAttribute("Span");
        String step = parameter.getAttribute("Step");
        timeSpan.setSpan(span);
        timeSpan.setStep(step);
    }

    private void setErrorTolerance(ErrorTolerance errorTolerance, Node modelNode) {
        Element parameter = (Element)modelNode;
        String relativeTolerance = parameter.getAttribute("RelativeTolerance");
        errorTolerance.setRelativeTolerance(relativeTolerance);
    }

    private void setSolver(Solver solver, Node modelNode) {
        Element parameter = (Element)modelNode;
        String solverName = parameter.getAttribute("Name");
        solver.setSolverName(solverName);
    }

    private void setParameterScan(ParameterScan parameterScan, Node modelNode, int index) {
        Element param = (Element)modelNode;
        String attri = param.getAttribute("value");
        Node childNode = null;
        Object childNode2 = null;
        Object childNode3 = null;
        Element parameter = (Element)modelNode;
        String executable = parameter.getAttribute("executable");
        if (index == 0) {
            parameterScan.setDoScanParameter(index, Boolean.valueOf(executable));
            parameterScan.setDoScanParameter(index + 1, Boolean.valueOf(executable));
        } else {
            parameterScan.setDoScanParameter(index, Boolean.valueOf(executable));
        }
        childNode = modelNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeName() != null && childNode.getNodeName().equals("Parameters")) {
                parameter = (Element)childNode;
                String id = parameter.getAttribute("id");
                String interval = parameter.getAttribute("Interval");
                String maxvalue = parameter.getAttribute("Maxvalue");
                String minvalue = parameter.getAttribute("Minvalue");
                String reactionID = parameter.getAttribute("reaction_id");
                String scantype = parameter.getAttribute("scantype");
                if (scantype.equals("species")) {
                    parameterScan.setKindOfParameter("initial value", index);
                } else if (scantype.equals("parameter")) {
                    parameterScan.setKindOfParameter("parameter value", index);
                }
                parameterScan.setTarget(id, index);
                parameterScan.setFrom(minvalue, index);
                parameterScan.setTo(maxvalue, index);
                parameterScan.setInterval(interval, index);
                ++index;
            }
            childNode = childNode.getNextSibling();
        }
    }

    private void setInteractiveSimulation(InteractiveSimulation interactiveSimulation, Node modelNode) {
        Node childNode = null;
        Node childNode2 = null;
        ArrayList<SliderValue> speciesValueSliderList = new ArrayList<SliderValue>();
        ArrayList<SliderValue> parameterValueSliderList = new ArrayList<SliderValue>();
        childNode = modelNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeName() != null) {
                SliderValue sv;
                String minValue;
                String maxValue;
                String currentValue;
                String speciesId;
                Element parameters;
                if (childNode.getNodeName().equals("ListOfInitialValues")) {
                    childNode2 = childNode.getFirstChild();
                    while (childNode2 != null) {
                        if (childNode2.getNodeName().equals("InitialValue")) {
                            parameters = (Element)childNode2;
                            speciesId = parameters.getAttribute("SpeciesId");
                            currentValue = parameters.getAttribute("CurrentValue");
                            maxValue = parameters.getAttribute("MaxValue");
                            minValue = parameters.getAttribute("MinValue");
                            sv = new SliderValue(currentValue);
                            sv.setTarget(speciesId);
                            sv.setMinValue(minValue);
                            sv.setMaxValue(maxValue);
                            speciesValueSliderList.add(sv);
                        }
                        childNode2 = childNode2.getNextSibling();
                    }
                } else if (childNode.getNodeName().equals("ListOfParameterValues")) {
                    childNode2 = childNode.getFirstChild();
                    while (childNode2 != null) {
                        if (childNode2.getNodeName().equals("ParameterValue")) {
                            parameters = (Element)childNode2;
                            speciesId = parameters.getAttribute("id");
                            currentValue = parameters.getAttribute("CurrentValue");
                            maxValue = parameters.getAttribute("MaxValue");
                            minValue = parameters.getAttribute("MinValue");
                            sv = new SliderValue(currentValue);
                            sv.setTarget(speciesId);
                            sv.setMinValue(minValue);
                            sv.setMaxValue(maxValue);
                            parameterValueSliderList.add(sv);
                        }
                        childNode2 = childNode2.getNextSibling();
                    }
                }
            }
            childNode = childNode.getNextSibling();
        }
        interactiveSimulation.setInteractiveParameterList(speciesValueSliderList, "initial value");
        interactiveSimulation.setInteractiveParameterList(parameterValueSliderList, "parameter value");
    }

    private void setChangeAmount(ChangeAmount changeAmount, Node modelNode) {
        double StepValue;
        Element parameter = (Element)modelNode;
        String span = parameter.getAttribute("Span");
        String step = parameter.getAttribute("Step");
        String executable = parameter.getAttribute("executable");
        boolean status = Boolean.valueOf(executable);
        changeAmount.setDoChangeAmount(status);
        changeAmount.setSpan(span);
        changeAmount.setStep(step);
        Node childNode = null;
        Node childNode2 = null;
        Node childNode3 = null;
        Node childNode4 = null;
        ArrayList<String> speciesList = new ArrayList<String>();
        ArrayList valueList = new ArrayList();
        childNode = modelNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeName() != null && childNode.getNodeName().equals("ListOfSpecies")) {
                childNode2 = childNode.getFirstChild();
                while (childNode2 != null) {
                    if (childNode2.getNodeName().equals("Species")) {
                        Element parameters = (Element)childNode2;
                        String speciesID = parameters.getAttribute("SpeciesID");
                        speciesList.add(speciesID);
                        childNode3 = childNode2.getFirstChild();
                        while (childNode3 != null) {
                            if (childNode3.getNodeName().equals("ListOfAmount")) {
                                ArrayList objValue = new ArrayList();
                                childNode4 = childNode3.getFirstChild();
                                while (childNode4 != null) {
                                    ArrayList<String> objValue2 = new ArrayList<String>();
                                    if (childNode4.getNodeName().equals("Amount")) {
                                        Element parameters2 = (Element)childNode4;
                                        String amount = parameters2.getAttribute("Amount");
                                        String timePoint = parameters2.getAttribute("TimePoint");
                                        objValue2.add(timePoint);
                                        objValue2.add(amount);
                                    }
                                    if (objValue2.size() > 0) {
                                        objValue.add(objValue2);
                                    }
                                    childNode4 = childNode4.getNextSibling();
                                }
                                valueList.add(objValue);
                            }
                            childNode3 = childNode3.getNextSibling();
                        }
                    }
                    childNode2 = childNode2.getNextSibling();
                }
            }
            childNode = childNode.getNextSibling();
        }
        double SpanValue = Double.parseDouble(changeAmount.getSpan());
        double sumValue = StepValue = Double.parseDouble(changeAmount.getStep());
        ArrayList<String> headerName = new ArrayList<String>();
        headerName.add("species/time point");
        headerName.add("0");
        while (sumValue <= SpanValue) {
            headerName.add(String.valueOf(sumValue));
            sumValue += StepValue;
        }
        String[][] tblChangeAmount = new String[speciesList.size()][headerName.size()];
        Iterator itSpecieId = speciesList.iterator();
        int index = 0;
        while (itSpecieId.hasNext()) {
            tblChangeAmount[index++][0] = itSpecieId.next().toString();
        }
        int i = 0;
        while (i < valueList.size()) {
            ArrayList objValue = (ArrayList)valueList.get(i);
            int k = 0;
            while (k < headerName.size()) {
                String header = (String)headerName.get(k);
                boolean exist = false;
                int j = 0;
                while (j < objValue.size()) {
                    ArrayList objValue2 = (ArrayList)objValue.get(j);
                    String value1 = (String)objValue2.get(0);
                    String value2 = (String)objValue2.get(1);
                    if (k == 0 && j == 0) {
                        tblChangeAmount[i][k] = value2;
                    } else if (value1.equals(header)) {
                        tblChangeAmount[i][k] = value2;
                        exist = true;
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    tblChangeAmount[i][k] = "";
                }
                ++k;
            }
            ++i;
        }
        changeAmount.setSpeciesList(speciesList);
        changeAmount.setAmounts(tblChangeAmount);
    }

    private void setListOfResults(Node modelNode) {
        this.listOfResult = new ArrayList();
        this.visibleResultRow = 0;
        int index = 0;
        this.listOfResultVisible = new ArrayList();
        Node childNode = null;
        childNode = modelNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeName() != null && childNode.getNodeName().equals("Result")) {
                Element parameters = (Element)childNode;
                String attribute = parameters.getAttribute("name");
                String path = parameters.getAttribute("value");
                String visible = parameters.getAttribute("visible");
                try {
                    SBMLResults results = new SBMLResults(0, new double[0]);
                    results.setParameterInfo(attribute);
                    results.setPath(path);
                    this.listOfResult.add(results);
                    boolean vis = false;
                    if (visible.equals("true")) {
                        this.visibleResultRow = index;
                        vis = true;
                    }
                    this.listOfResultVisible.add(new Boolean(vis));
                    ++index;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.listOfResult = null;
                }
            }
            childNode = childNode.getNextSibling();
        }
    }

    private void setListOfPlot(Node modelNode) {
        Node childNode = null;
        this.speciesColorSet = new SpeciesColorSet();
        this.speciesVisible = new SpeciesVisible();
        this.hashVisibleSpecies = new HashMap();
        this.speciesColorSet.setSpeciesColors(new HashMap());
        this.speciesVisible.setSpeciesVisible(new HashMap());
        ChangeAmount changeAmount = (ChangeAmount)this.getSimulationInfo(1);
        ListOf lstSP = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        ArrayList<String> listOfSpecie = new ArrayList<String>();
        int i = 0;
        while ((long)i < lstSP.size()) {
            Species sp = (Species)lstSP.get((long)i);
            listOfSpecie.add(sp.getId());
            ++i;
        }
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        ArrayList<String> listOfReactionName = new ArrayList<String>();
        int i2 = 0;
        while ((long)i2 < lstSBase.size()) {
            Reaction reaction = (Reaction)lstSBase.get((long)i2);
            listOfReactionName.add(reaction.getName());
            ++i2;
        }
        boolean index = false;
        boolean index2 = false;
        boolean flg = false;
        childNode = modelNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeName() != null && childNode.getNodeName().equals("Plot")) {
                Element parameters = (Element)childNode;
                String visible = parameters.getAttribute("visible");
                String r = parameters.getAttribute("r");
                String g = parameters.getAttribute("g");
                String b = parameters.getAttribute("b");
                String id = parameters.getAttribute("id");
                String name = parameters.getAttribute("name");
                this.hashVisibleSpecies.put(id, Boolean.TRUE);
                this.speciesVisible.addSpeciesVisible(name, Boolean.valueOf(visible));
                this.speciesColorSet.addSpeciesColor(name, new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b)));
                flg = true;
            }
            childNode = childNode.getNextSibling();
        }
        if (!flg) {
            this.speciesColorSet = null;
            this.speciesVisible = null;
        }
    }

    private void setListOfInitialize(Node modelNode) {
        Node childNode = null;
        Node childNode2 = null;
        childNode = modelNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeName() != null) {
                String value;
                Element parameters;
                if (childNode.getNodeName().equals("ListOfSpeciesValue")) {
                    this.listOfOriginSpecies = new ArrayList();
                    childNode2 = childNode.getFirstChild();
                    while (childNode2 != null) {
                        if (childNode2.getNodeName().equals("SpeciesValue")) {
                            parameters = (Element)childNode2;
                            String id = parameters.getAttribute("id");
                            String qtype = parameters.getAttribute("quantityType");
                            value = parameters.getAttribute("value");
                            String boundaryCondition = parameters.getAttribute("boundaryCondition");
                            String constant = parameters.getAttribute("constant");
                            Species species = new Species();
                            species.setId(id);
                            if (qtype.equals("amount")) {
                                species.setInitialAmount(Double.parseDouble(value));
                            } else if (qtype.equals("concentration")) {
                                species.setInitialConcentration(Double.parseDouble(value));
                            } else {
                                species.setInitialAmount(Double.parseDouble(value));
                            }
                            species.setBoundaryCondition(Boolean.valueOf(boundaryCondition).booleanValue());
                            species.setConstant(Boolean.valueOf(constant).booleanValue());
                            this.listOfOriginSpecies.add(species);
                        }
                        childNode2 = childNode2.getNextSibling();
                    }
                } else if (childNode.getNodeName().equals("ListOfParametersValue")) {
                    this.listOfOriginReactions = new ArrayList();
                    this.listOfOriginGlobalParameters = new ArrayList();
                    childNode2 = childNode.getFirstChild();
                    while (childNode2 != null) {
                        if (childNode2.getNodeName().equals("ParametersValue")) {
                            parameters = (Element)childNode2;
                            String id = parameters.getAttribute("id");
                            value = parameters.getAttribute("value");
                            String constant = parameters.getAttribute("constant");
                            Parameter parameter = new Parameter();
                            parameter.setId(id);
                            parameter.setValue(Double.parseDouble(value));
                            parameter.setConstant(Boolean.valueOf(constant).booleanValue());
                            String scope = parameters.getAttribute("reaction_id");
                            if (scope != null) {
                                parameter.setMetaId(scope);
                                this.listOfOriginReactions.add(parameter);
                            } else {
                                this.listOfOriginGlobalParameters.add(parameter);
                            }
                        }
                        childNode2 = childNode2.getNextSibling();
                    }
                }
            }
            childNode = childNode.getNextSibling();
        }
    }

    private void setParameterScan(ParameterScan parameterScan, NodeList tasksList, Element taskElement) {
        Element initElement = (Element)taskElement.getElementsByTagName("InitialValue").item(0);
        Element paramElement = (Element)taskElement.getElementsByTagName("ParameterValue").item(0);
        parameterScan.setDoScanParameter(CodeInformation.SIMULATION_1, Boolean.valueOf(initElement.getAttribute("value")));
        parameterScan.setDoScanParameter(CodeInformation.SIMULATION_2, Boolean.valueOf(paramElement.getAttribute("value")));
        NodeList parameterList = taskElement.getElementsByTagName("Parameter");
        int i = 0;
        while (i < parameterList.getLength()) {
            Element parameter = (Element)parameterList.item(i);
            switch (i) {
                case 0: {
                    parameterScan.setTarget(parameter.getAttribute("value"), CodeInformation.SIMULATION_1);
                    break;
                }
                case 1: {
                    parameterScan.setFrom(parameter.getAttribute("value"), CodeInformation.SIMULATION_1);
                    break;
                }
                case 2: {
                    parameterScan.setTo(parameter.getAttribute("value"), CodeInformation.SIMULATION_1);
                    break;
                }
                case 3: {
                    parameterScan.setInterval(parameter.getAttribute("value"), CodeInformation.SIMULATION_1);
                    break;
                }
                case 4: {
                    parameterScan.setTarget(parameter.getAttribute("value"), CodeInformation.SIMULATION_2);
                    break;
                }
                case 5: {
                    parameterScan.setFrom(parameter.getAttribute("value"), CodeInformation.SIMULATION_2);
                    break;
                }
                case 6: {
                    parameterScan.setTo(parameter.getAttribute("value"), CodeInformation.SIMULATION_2);
                    break;
                }
                case 7: {
                    parameterScan.setInterval(parameter.getAttribute("value"), CodeInformation.SIMULATION_2);
                    break;
                }
            }
            ++i;
        }
    }

    private void setParameterScan_Initial(NodeList listOfParam) {
        ArrayList<SliderValue> speciesValueSliderList = new ArrayList<SliderValue>();
        int j = 0;
        while (j < listOfParam.getLength()) {
            NodeList parameterList = ((Element)listOfParam.item(j)).getElementsByTagName("Parameter");
            String SpeciesId = "";
            String MinValue = "";
            String MaxValue = "";
            String Interval = "";
            int k = 0;
            while (k < parameterList.getLength()) {
                switch (k) {
                    case 0: {
                        SpeciesId = ((Element)parameterList.item(k)).getAttribute("SpeciesId");
                        break;
                    }
                    case 1: {
                        MinValue = ((Element)parameterList.item(k)).getAttribute("MinValue");
                        break;
                    }
                    case 2: {
                        MaxValue = ((Element)parameterList.item(k)).getAttribute("MaxValue");
                        break;
                    }
                    case 3: {
                        Interval = ((Element)parameterList.item(k)).getAttribute("Interval");
                        break;
                    }
                }
                ++k;
            }
            SliderValue sv = new SliderValue(Interval);
            sv.setTarget(SpeciesId);
            sv.setMinValue(MinValue);
            sv.setMaxValue(MaxValue);
            speciesValueSliderList.add(j, sv);
            ++j;
        }
    }

    private void setParameterScan_Parameter(NodeList listOfParam) {
        ArrayList<SliderValue> parameterValueSliderList = new ArrayList<SliderValue>();
        int j = 0;
        while (j < listOfParam.getLength()) {
            NodeList parameterList = ((Element)listOfParam.item(j)).getElementsByTagName("Parameter");
            String Id = "";
            String MinValue = "";
            String MaxValue = "";
            String Interval = "";
            int k = 0;
            while (k < parameterList.getLength()) {
                switch (k) {
                    case 0: {
                        Id = ((Element)parameterList.item(k)).getAttribute("Id");
                        break;
                    }
                    case 1: {
                        MinValue = ((Element)parameterList.item(k)).getAttribute("MinValue");
                        break;
                    }
                    case 2: {
                        MaxValue = ((Element)parameterList.item(k)).getAttribute("MaxValue");
                        break;
                    }
                    case 3: {
                        Interval = ((Element)parameterList.item(k)).getAttribute("Interval");
                        break;
                    }
                }
                ++k;
            }
            SliderValue sv = new SliderValue(Interval);
            sv.setTarget(Id);
            sv.setMinValue(MinValue);
            sv.setMaxValue(MaxValue);
            parameterValueSliderList.add(j, sv);
            ++j;
        }
    }

    public boolean write(File simFile) {
        try {
            Element SpeciesIdCA;
            Element paramater2;
            Element paramater1;
            TimeSpan timeSpan = (TimeSpan)this.getSimulationInfo(0);
            ChangeAmount changeAmount = (ChangeAmount)this.getSimulationInfo(1);
            ParameterScan parameterScan = (ParameterScan)this.getSimulationInfo(2);
            InteractiveSimulation interactiveSimulation = (InteractiveSimulation)this.getSimulationInfo(3);
            ErrorTolerance errorTolerance = (ErrorTolerance)this.getSimulationInfo(4);
            Solver solver = (Solver)this.getSimulationInfo(5);
            DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
            docfactory.setNamespaceAware(true);
            DocumentBuilder builder = docfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("CELSIC");
            doc.appendChild(root);
            Element Model2 = doc.createElement("Model");
            Model2.setAttribute("key", this.parent.getSbframe().getName());
            Model2.setAttribute("name", this.parent.getSbframe().getName());
            root.appendChild(Model2);
            Element ListOfTasks = doc.createElement("ListOfTasks");
            root.appendChild(ListOfTasks);
            Element taskTimeSpan = doc.createElement("TimeSpan");
            taskTimeSpan.setAttribute("Span", timeSpan.getSpan());
            taskTimeSpan.setAttribute("Step", timeSpan.getStep());
            ListOfTasks.appendChild(taskTimeSpan);
            Element taskErrorTolerance = doc.createElement("ErrorTolerance");
            taskErrorTolerance.setAttribute("RelativeTolerance", errorTolerance.getRelativeTolerance());
            ListOfTasks.appendChild(taskErrorTolerance);
            Element taskSolver = doc.createElement("Solver");
            taskSolver.setAttribute("Name", solver.getSolverName());
            ListOfTasks.appendChild(taskSolver);
            Element taskParameterScan = doc.createElement("ParameterScan");
            Element taskParameterScan2 = doc.createElement("ParameterScan");
            boolean isExecutable1 = parameterScan.doScanParameter(CodeInformation.SIMULATION_1);
            boolean isExecutable2 = parameterScan.doScanParameter(CodeInformation.SIMULATION_2);
            if (isExecutable1 && !isExecutable2 || !isExecutable1 && isExecutable2) {
                taskParameterScan.setAttribute("executable", String.valueOf(isExecutable1));
                ListOfTasks.appendChild(taskParameterScan);
                paramater1 = doc.createElement("Parameters");
                taskParameterScan.appendChild(paramater1);
                if (parameterScan.getKindOfParameter(CodeInformation.SIMULATION_1).equals("initial value")) {
                    paramater1.setAttribute("scantype", "species");
                } else {
                    paramater1.setAttribute("scantype", "parameter");
                }
                paramater1.setAttribute("reaction_id", "");
                paramater1.setAttribute("id", parameterScan.getTarget(CodeInformation.SIMULATION_1));
                paramater1.setAttribute("Minvalue", parameterScan.getFrom(CodeInformation.SIMULATION_1));
                paramater1.setAttribute("Maxvalue", parameterScan.getTo(CodeInformation.SIMULATION_1));
                paramater1.setAttribute("Interval", parameterScan.getInterval(CodeInformation.SIMULATION_1));
                taskParameterScan2.setAttribute("executable", String.valueOf(isExecutable2));
                ListOfTasks.appendChild(taskParameterScan2);
                paramater2 = doc.createElement("Parameters");
                taskParameterScan2.appendChild(paramater2);
                if (parameterScan.getKindOfParameter(CodeInformation.SIMULATION_2).equals("initial value")) {
                    paramater2.setAttribute("scantype", "species");
                } else {
                    paramater2.setAttribute("scantype", "parameter");
                }
                paramater2.setAttribute("reaction_id", "");
                paramater2.setAttribute("id", parameterScan.getTarget(CodeInformation.SIMULATION_2));
                paramater2.setAttribute("Minvalue", parameterScan.getFrom(CodeInformation.SIMULATION_2));
                paramater2.setAttribute("Maxvalue", parameterScan.getTo(CodeInformation.SIMULATION_2));
                paramater2.setAttribute("Interval", parameterScan.getInterval(CodeInformation.SIMULATION_2));
            } else {
                taskParameterScan.setAttribute("executable", String.valueOf(isExecutable1));
                ListOfTasks.appendChild(taskParameterScan);
                paramater1 = doc.createElement("Parameters");
                taskParameterScan.appendChild(paramater1);
                if (parameterScan.getKindOfParameter(CodeInformation.SIMULATION_1).equals("initial value")) {
                    paramater1.setAttribute("scantype", "species");
                } else {
                    paramater1.setAttribute("scantype", "parameter");
                }
                paramater1.setAttribute("reaction_id", "");
                paramater1.setAttribute("id", parameterScan.getTarget(CodeInformation.SIMULATION_1));
                paramater1.setAttribute("Minvalue", parameterScan.getFrom(CodeInformation.SIMULATION_1));
                paramater1.setAttribute("Maxvalue", parameterScan.getTo(CodeInformation.SIMULATION_1));
                paramater1.setAttribute("Interval", parameterScan.getInterval(CodeInformation.SIMULATION_1));
                paramater2 = doc.createElement("Parameters");
                taskParameterScan.appendChild(paramater2);
                if (parameterScan.getKindOfParameter(CodeInformation.SIMULATION_2).equals("initial value")) {
                    paramater2.setAttribute("scantype", "species");
                } else {
                    paramater2.setAttribute("scantype", "parameter");
                }
                paramater2.setAttribute("reaction_id", "");
                paramater2.setAttribute("id", parameterScan.getTarget(CodeInformation.SIMULATION_2));
                paramater2.setAttribute("Minvalue", parameterScan.getFrom(CodeInformation.SIMULATION_2));
                paramater2.setAttribute("Maxvalue", parameterScan.getTo(CodeInformation.SIMULATION_2));
                paramater2.setAttribute("Interval", parameterScan.getInterval(CodeInformation.SIMULATION_2));
            }
            Element taskIteractiveSimulation = doc.createElement("InteractiveSimulation");
            ListOfTasks.appendChild(taskIteractiveSimulation);
            Element InitialValueIS = doc.createElement("ListOfInitialValues");
            taskIteractiveSimulation.appendChild(InitialValueIS);
            ArrayList listIS = interactiveSimulation.getInteractiveParameterList("initial value");
            Iterator itIS = listIS.iterator();
            while (itIS.hasNext()) {
                Element ListOfParametersIS = doc.createElement("InitialValue");
                InitialValueIS.appendChild(ListOfParametersIS);
                SliderValue sliderValue = (SliderValue)itIS.next();
                String Id = sliderValue.getTarget();
                String min = sliderValue.getMinValue();
                String max = sliderValue.getMaxValue();
                String interval = sliderValue.getValue();
                ListOfParametersIS.setAttribute("SpeciesId", Id);
                ListOfParametersIS.setAttribute("MinValue", min);
                ListOfParametersIS.setAttribute("MaxValue", max);
                ListOfParametersIS.setAttribute("CurrentValue", interval);
            }
            Element ParameterValueIS = doc.createElement("ListOfParameterValues");
            taskIteractiveSimulation.appendChild(ParameterValueIS);
            listIS = interactiveSimulation.getInteractiveParameterList("parameter value");
            itIS = listIS.iterator();
            Iterator itPM = this.listOfOriginReactions.iterator();
            while (itIS.hasNext()) {
                Element ListOfParametersIS = doc.createElement("ParameterValue");
                ParameterValueIS.appendChild(ListOfParametersIS);
                SliderValue sliderValue = (SliderValue)itIS.next();
                String Id = sliderValue.getTarget();
                String min = sliderValue.getMinValue();
                String max = sliderValue.getMaxValue();
                String interval = sliderValue.getValue();
                if (itPM.hasNext()) {
                    Parameter parameter = (Parameter)itPM.next();
                    String[] value = LibSBMLUtil.toStrings((SBase)parameter);
                    ListOfParametersIS.setAttribute("reaction_id", value[0]);
                }
                ListOfParametersIS.setAttribute("id", Id);
                ListOfParametersIS.setAttribute("MinValue", min);
                ListOfParametersIS.setAttribute("MaxValue", max);
                ListOfParametersIS.setAttribute("CurrentValue", interval);
            }
            Element taskChangeAmount = doc.createElement("ChangeAmount");
            taskChangeAmount.setAttribute("Span", changeAmount.getSpan());
            taskChangeAmount.setAttribute("Step", changeAmount.getStep());
            taskChangeAmount.setAttribute("executable", String.valueOf(changeAmount.doChangeAmount));
            ListOfTasks.appendChild(taskChangeAmount);
            Element ListOfSepeciesCA = doc.createElement("ListOfSpecies");
            taskChangeAmount.appendChild(ListOfSepeciesCA);
            String[][] tblChangeAmount = changeAmount.getAmounts();
            ArrayList speciesList = changeAmount.getSpeciesList();
            ArrayList<String> speciesIDList = new ArrayList<String>();
            ListOf listOfSP = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
            int k = 0;
            while ((long)k < listOfSP.size()) {
                Species sp = (Species)listOfSP.get((long)k);
                speciesIDList.add(sp.getId());
                ++k;
            }
            Iterator itSpeciesList = speciesList.iterator();
            ArrayList headerName = changeAmount.getHeaderName();
            int i = 0;
            while (itSpeciesList.hasNext()) {
                String speciesId = (String)itSpeciesList.next();
                Element SpeciesIdCA2 = doc.createElement("Species");
                SpeciesIdCA2.setAttribute("SpeciesID", speciesId);
                ListOfSepeciesCA.appendChild(SpeciesIdCA2);
                Element ListOfAmount = doc.createElement("ListOfAmount");
                SpeciesIdCA2.appendChild(ListOfAmount);
                int j = 1;
                while (j < tblChangeAmount[0].length) {
                    if (tblChangeAmount[i][j] != null && !tblChangeAmount[i][j].equals("")) {
                        Element AmountCA = doc.createElement("Amount");
                        ListOfAmount.appendChild(AmountCA);
                        AmountCA.setAttribute("TimePoint", (String)headerName.get(j));
                        AmountCA.setAttribute("Amount", tblChangeAmount[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
            Element ListOfResults = doc.createElement("ListOfResults");
            root.appendChild(ListOfResults);
            if (this.listOfResult != null) {
                Color color;
                Element SpeciesIdCA3;
                ArrayList listOfOverlayedResults = null;
                int lastSelectedRow = 0;
                if (this.parent.isOverlayMode()) {
                    listOfOverlayedResults = this.parent.getTabResult().getListOfOverlayedResults();
                } else if (this.listOfResult.size() > 1) {
                    lastSelectedRow = this.parent.getTabResult().getLastSelectedRow();
                }
                int k2 = 0;
                while (k2 < this.listOfResult.size()) {
                    SBMLResults results = (SBMLResults)this.listOfResult.get(k2);
                    Element result = doc.createElement("Result");
                    result.setAttribute("name", results.getParameterInfo());
                    result.setAttribute("value", results.getPath());
                    if (listOfOverlayedResults != null) {
                        ArrayList data = (ArrayList)listOfOverlayedResults.get(k2);
                        result.setAttribute("visible", ((Boolean)data.get(0)).toString());
                    } else if (k2 == lastSelectedRow) {
                        result.setAttribute("visible", "true");
                    } else {
                        result.setAttribute("visible", "false");
                    }
                    ListOfResults.appendChild(result);
                    ++k2;
                }
                Element listOfPlot = doc.createElement("ListOfPlot");
                root.appendChild(listOfPlot);
                if (!this.parent.isOverlayMode()) {
                    listOfPlot.setAttribute("type", "normal");
                    if (this.listOfResult.size() > 0 && this.speciesVisible != null && this.speciesColorSet != null) {
                        itSpeciesList = speciesList.iterator();
                        int index = 0;
                        while (itSpeciesList.hasNext()) {
                            String speciesId = (String)itSpeciesList.next();
                            if (this.speciesVisible.isVisible(speciesId) == null) continue;
                            SpeciesIdCA = doc.createElement("Plot");
                            SpeciesIdCA.setAttribute("id", speciesId);
                            SpeciesIdCA.setAttribute("name", speciesId);
                            SpeciesIdCA.setAttribute("reaction_id", "");
                            SpeciesIdCA.setAttribute("visible", Boolean.toString(this.speciesVisible.isVisible(speciesId)));
                            Color color2 = this.speciesColorSet.getColor(speciesId);
                            SpeciesIdCA.setAttribute("r", Integer.toString(color2.getRed()));
                            SpeciesIdCA.setAttribute("g", Integer.toString(color2.getGreen()));
                            SpeciesIdCA.setAttribute("b", Integer.toString(color2.getBlue()));
                            listOfPlot.appendChild(SpeciesIdCA);
                            ++index;
                        }
                        ListOf listOfReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
                        ArrayList<Reaction> listOfReactions = new ArrayList<Reaction>();
                        int g = 0;
                        while ((long)g < listOfReaction.size()) {
                            Reaction reaction = (Reaction)listOfReaction.get((long)g);
                            listOfReactions.add(reaction);
                            ++g;
                        }
                        for (Reaction reaction : listOfReactions) {
                            String reactionId = reaction.getName();
                            if (this.speciesVisible.isVisible(reactionId) == null) continue;
                            SpeciesIdCA3 = doc.createElement("Plot");
                            SpeciesIdCA3.setAttribute("id", reactionId);
                            SpeciesIdCA3.setAttribute("name", reactionId);
                            SpeciesIdCA3.setAttribute("reaction_id", reactionId);
                            SpeciesIdCA3.setAttribute("visible", Boolean.toString(this.speciesVisible.isVisible(reactionId)));
                            color = this.speciesColorSet.getColor(reactionId);
                            SpeciesIdCA3.setAttribute("r", Integer.toString(color.getRed()));
                            SpeciesIdCA3.setAttribute("g", Integer.toString(color.getGreen()));
                            SpeciesIdCA3.setAttribute("b", Integer.toString(color.getBlue()));
                            listOfPlot.appendChild(SpeciesIdCA3);
                        }
                    }
                } else {
                    listOfPlot.setAttribute("type", "overlay");
                    if (this.listOfResult.size() > 0 && this.speciesVisible != null && this.speciesColorSet != null) {
                        Iterator itOverlayedResultsList = listOfOverlayedResults.iterator();
                        int index = 0;
                        while (itOverlayedResultsList.hasNext()) {
                            ArrayList result = (ArrayList)itOverlayedResultsList.next();
                            String resultId = (String)result.get(1);
                            for (String speciesId : speciesList) {
                                String visibleSpeciesId = String.valueOf(speciesId) + " " + resultId;
                                if (this.speciesVisible.isVisible(visibleSpeciesId) == null) continue;
                                SpeciesIdCA3 = doc.createElement("Plot");
                                SpeciesIdCA3.setAttribute("id", speciesId);
                                SpeciesIdCA3.setAttribute("name", visibleSpeciesId);
                                SpeciesIdCA3.setAttribute("reaction_id", "");
                                SpeciesIdCA3.setAttribute("visible", Boolean.toString(this.speciesVisible.isVisible(visibleSpeciesId)));
                                color = this.speciesColorSet.getColor(visibleSpeciesId);
                                SpeciesIdCA3.setAttribute("r", Integer.toString(color.getRed()));
                                SpeciesIdCA3.setAttribute("g", Integer.toString(color.getGreen()));
                                SpeciesIdCA3.setAttribute("b", Integer.toString(color.getBlue()));
                                listOfPlot.appendChild(SpeciesIdCA3);
                                ++index;
                            }
                            ListOf listOfReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
                            ArrayList<Reaction> listOfReactions = new ArrayList<Reaction>();
                            int g = 0;
                            while ((long)g < listOfReaction.size()) {
                                Reaction reaction = (Reaction)listOfReaction.get((long)g);
                                listOfReactions.add(reaction);
                                ++g;
                            }
                            for (Reaction reaction : listOfReactions) {
                                String reactionId = reaction.getName();
                                String visibleReactionId = String.valueOf(reactionId) + " " + resultId;
                                if (this.speciesVisible.isVisible(visibleReactionId) == null) continue;
                                Element SpeciesIdCA4 = doc.createElement("Plot");
                                SpeciesIdCA4.setAttribute("id", reactionId);
                                SpeciesIdCA4.setAttribute("name", visibleReactionId);
                                SpeciesIdCA4.setAttribute("reaction_id", reactionId);
                                SpeciesIdCA4.setAttribute("visible", Boolean.toString(this.speciesVisible.isVisible(visibleReactionId)));
                                Color color3 = this.speciesColorSet.getColor(visibleReactionId);
                                SpeciesIdCA4.setAttribute("r", Integer.toString(color3.getRed()));
                                SpeciesIdCA4.setAttribute("g", Integer.toString(color3.getGreen()));
                                SpeciesIdCA4.setAttribute("b", Integer.toString(color3.getBlue()));
                                listOfPlot.appendChild(SpeciesIdCA4);
                            }
                        }
                    }
                }
            }
            Element ListOfInitialize = doc.createElement("ListOfInitialize");
            root.appendChild(ListOfInitialize);
            Element ListOfSpeciesValue = doc.createElement("ListOfSpeciesValue");
            ListOfInitialize.appendChild(ListOfSpeciesValue);
            int k3 = 0;
            while (k3 < this.listOfOriginSpecies.size()) {
                Species species = (Species)this.listOfOriginSpecies.get(k3);
                String qtype = "";
                if (species.isSetInitialAmount()) {
                    qtype = "amount";
                } else if (species.isSetInitialConcentration()) {
                    qtype = "concentration";
                }
                SpeciesIdCA = doc.createElement("SpeciesValue");
                SpeciesIdCA.setAttribute("id", species.getId());
                SpeciesIdCA.setAttribute("quantityType", qtype);
                SpeciesIdCA.setAttribute("value", String.valueOf(species.getInitialAmount()));
                SpeciesIdCA.setAttribute("boundaryCondition", String.valueOf(species.getBoundaryCondition()));
                SpeciesIdCA.setAttribute("constant", String.valueOf(species.getConstant()));
                ListOfSpeciesValue.appendChild(SpeciesIdCA);
                ++k3;
            }
            Element ListOfParametersValue = doc.createElement("ListOfParametersValue");
            ListOfInitialize.appendChild(ListOfParametersValue);
            for (Parameter globalParameter : this.listOfOriginGlobalParameters) {
                SpeciesIdCA = doc.createElement("ParametersValue");
                SpeciesIdCA.setAttribute("id", globalParameter.getId());
                SpeciesIdCA.setAttribute("value", String.valueOf(globalParameter.getValue()));
                SpeciesIdCA.setAttribute("constant", String.valueOf(globalParameter.getConstant()));
                ListOfParametersValue.appendChild(SpeciesIdCA);
            }
            int k4 = 0;
            while (k4 < this.listOfOriginReactions.size()) {
                Parameter parameter = (Parameter)this.listOfOriginReactions.get(k4);
                String[] scope = LibSBMLUtil.toStrings((SBase)parameter);
                Element SpeciesIdCA5 = doc.createElement("ParametersValue");
                SpeciesIdCA5.setAttribute("reaction_id", scope[0]);
                SpeciesIdCA5.setAttribute("id", parameter.getId());
                SpeciesIdCA5.setAttribute("value", String.valueOf(parameter.getValue()));
                SpeciesIdCA5.setAttribute("constant", String.valueOf(parameter.getConstant()));
                ListOfParametersValue.appendChild(SpeciesIdCA5);
                ++k4;
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource domsrc = new DOMSource(doc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(domsrc, new StreamResult(baos));
            builder = docfactory.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
            byte[] xmlbyte = baos.toByteArray();
            InputSource input = new InputSource(new ByteArrayInputStream(xmlbyte));
            input.setSystemId(simFile.toString());
            builder.parse(input);
            FileOutputStream fos = new FileOutputStream(simFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            bos.write(xmlbyte);
            bos.flush();
            fos.close();
        }
        catch (Exception ex) {
            this.errorList.add(ex.toString());
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public ArrayList getErrorList() {
        return this.errorList;
    }

    public void setSbmlPanelLists(SBMLPanelLists sbmlPanelLists) {
        this.sbmlPanelLists = sbmlPanelLists;
    }

    public Object getSimulationInfo(int kind) {
        return this.listOfInfo[kind];
    }

    public void setSimulationInfo(Object info, int kind) {
        this.listOfInfo[kind] = info;
    }

    public void setSpeciesColorSet(SpeciesColorSet speciesColorSet) {
        this.speciesColorSet = speciesColorSet;
    }

    public void setSpeciesVisible(SpeciesVisible speciesVisible) {
        this.speciesVisible = speciesVisible;
    }

    public SpeciesColorSet getSpeciesColorSet() {
        return this.speciesColorSet;
    }

    public SpeciesVisible getSpeciesVisible() {
        return this.speciesVisible;
    }

    public void setListOfResults(ArrayList listOfResult) {
        this.listOfResult = listOfResult;
    }

    public ArrayList getListOfResults() {
        return this.listOfResult;
    }

    public void setListOfOriginSpecies(ArrayList listOfOriginSpecies) {
        this.listOfOriginSpecies = listOfOriginSpecies;
    }

    public void setListOfOriginReactions(ArrayList listOfOriginReactions) {
        this.listOfOriginReactions = listOfOriginReactions;
    }

    public ArrayList getListOfOriginSpecies() {
        return this.listOfOriginSpecies;
    }

    public ArrayList getListOfOriginReactions() {
        return this.listOfOriginReactions;
    }

    public int getLastSelectedRow() {
        return this.visibleResultRow;
    }

    public HashMap getHashVisibleSpecies() {
        return this.hashVisibleSpecies;
    }

    public ArrayList getListOfResultVisible() {
        return this.listOfResultVisible;
    }

    public void setListOfOriginGlobalParameters(ArrayList listOfOriginGlobalParameters) {
        this.listOfOriginGlobalParameters = listOfOriginGlobalParameters;
    }

    public boolean updateSmlInfo(SmlSimCondition smlSimCondition, SmlTask task) {
        this.parent.setInitialValues();
        this.parent.synchronizeListOfOriginSBases();
        this.parent.setSpeciesData(this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList());
        TimeSpan timeSpan = (TimeSpan)this.getSimulationInfo(0);
        ChangeAmount changeAmount = (ChangeAmount)this.getSimulationInfo(1);
        ParameterScan parameterScan = (ParameterScan)this.getSimulationInfo(2);
        InteractiveSimulation interactiveSimulation = (InteractiveSimulation)this.getSimulationInfo(3);
        ErrorTolerance errorTolerance = (ErrorTolerance)this.getSimulationInfo(4);
        Solver solver = (Solver)this.getSimulationInfo(5);
        if (timeSpan == null) {
            timeSpan = new TimeSpan();
        }
        if (changeAmount == null) {
            changeAmount = new ChangeAmount();
        }
        if (parameterScan == null) {
            parameterScan = new ParameterScan();
        }
        if (interactiveSimulation == null) {
            interactiveSimulation = new InteractiveSimulation();
        }
        if (errorTolerance == null) {
            errorTolerance = new ErrorTolerance();
        }
        if (solver == null) {
            solver = new Solver();
        }
        this.listOfInfo[0] = timeSpan;
        this.listOfInfo[1] = changeAmount;
        this.listOfInfo[2] = parameterScan;
        this.listOfInfo[3] = interactiveSimulation;
        this.listOfInfo[4] = errorTolerance;
        this.listOfInfo[5] = solver;
        ArrayList<Object> simulationList = smlSimCondition.getListOfSimulation();
        int i = 0;
        while (i < simulationList.size()) {
            if (((SmlUniformTimeCourse)simulationList.get(i)).getId().equals(task.getSimulationReference())) {
                SmlUniformTimeCourse smlUniformTimeCourse = (SmlUniformTimeCourse)simulationList.get(i);
                this.setTimeSpan(timeSpan, smlUniformTimeCourse);
                this.setErrorTolerance(errorTolerance, smlUniformTimeCourse);
                this.setSolver(solver, smlUniformTimeCourse);
                break;
            }
            ++i;
        }
        ArrayList<Object> modelList = smlSimCondition.getListOfModels();
        int i2 = 0;
        while (i2 < modelList.size()) {
            if (((SmlModel)modelList.get(i2)).getId().equals(task.getModelReference())) {
                SmlModel smlModel = (SmlModel)modelList.get(i2);
                this.setChangeAmount(changeAmount, smlModel.getChangeAmount());
                this.setParameterScan(parameterScan, smlModel.getParameterScan());
                this.setInteractiveSimulation(interactiveSimulation, smlModel.getInteractiveSimulation());
                this.setListOfInitialize(smlModel.getListOfChanges());
                break;
            }
            ++i2;
        }
        ArrayList<Object> outputList = smlSimCondition.getListOfOutputs();
        if (outputList != null) {
            int i3 = 0;
            while (i3 < outputList.size()) {
                if (this.listOfResult == null) {
                    this.listOfResult = new ArrayList();
                }
                this.listOfResult.clear();
                if (((SmlPlot2D)outputList.get(i3)).getTaskref().equals(task.getId())) {
                    SmlPlot2D smlPlot2D = (SmlPlot2D)outputList.get(i3);
                    this.listOfResult.addAll(smlPlot2D.getResultofList());
                    this.parent.setListOfResult(this.listOfResult);
                    break;
                }
                ++i3;
            }
        }
        return true;
    }

    private void setTimeSpan(TimeSpan timeSpan, SmlUniformTimeCourse simulation) {
        timeSpan.setSpan(simulation.getOutputEndTime());
        timeSpan.setStep(String.valueOf(simulation.getNumberOfPoints()));
    }

    private void setErrorTolerance(ErrorTolerance errorTolerance, SmlUniformTimeCourse simulation) {
        errorTolerance.setRelativeTolerance("1.0E" + String.valueOf(simulation.getErrortolerance()));
    }

    private void setSolver(Solver solver, SmlUniformTimeCourse simulation) {
        solver.setSolverName(simulation.getSolver());
    }

    private void setChangeAmount(ChangeAmount changeAmount, SmlChangeAmount smlChangeAmount) {
        changeAmount.setDoChangeAmount(smlChangeAmount.doChangeAmount());
        changeAmount.setSpan(smlChangeAmount.getTo());
        changeAmount.setStep(smlChangeAmount.getInterval());
        SmlAmount smlHeaderName = smlChangeAmount.getHeaderName();
        ArrayList<String> headerName = new ArrayList<String>();
        headerName.add(smlHeaderName.getName());
        int i = 0;
        while (i < smlHeaderName.getAmount().size()) {
            headerName.add(smlHeaderName.getAmount().get(i).toString());
            ++i;
        }
        changeAmount.setHeaderName(headerName);
        ArrayList<String> speciesList = new ArrayList<String>();
        int speciesListsize = smlChangeAmount.getAmountList().size();
        int valueListsize = smlChangeAmount.getHeaderName().getAmount().size();
        String[][] tblChangeAmount = new String[speciesListsize][valueListsize + 1];
        int i2 = 0;
        while (i2 < speciesListsize) {
            SmlAmount speciesItem = (SmlAmount)smlChangeAmount.getAmountList().get(i2);
            speciesList.add(speciesItem.getName());
            tblChangeAmount[i2][0] = speciesItem.getName();
            int j = 0;
            while (j < valueListsize) {
                try {
                    tblChangeAmount[i2][j + 1] = speciesItem.getAmount().get(j).toString();
                }
                catch (Exception myErr) {
                    tblChangeAmount[i2][j + 1] = null;
                }
                ++j;
            }
            ++i2;
        }
        changeAmount.setSpeciesList(speciesList);
        changeAmount.setAmounts(tblChangeAmount);
    }

    private void setParameterScan(ParameterScan parameterScan, SmlParameterScan smlParameterScan) {
        int simulationCount = smlParameterScan.getListOfSimPS().size();
        int i = 0;
        while (i < simulationCount) {
            SmlSimParameterScan smlSimParameterScan = (SmlSimParameterScan)smlParameterScan.getListOfSimPS().get(i);
            parameterScan.setDoScanParameter(i, smlSimParameterScan.getDoScanParameter());
            parameterScan.setKindOfParameter(smlSimParameterScan.getKindOfParameter(), i);
            parameterScan.setTarget(smlSimParameterScan.getName(), i);
            parameterScan.setFrom(String.valueOf(smlSimParameterScan.getFrom()), i);
            parameterScan.setTo(String.valueOf(smlSimParameterScan.getTo()), i);
            parameterScan.setInterval(String.valueOf(smlSimParameterScan.getInterval()), i);
            ++i;
        }
    }

    private void setInteractiveSimulation(InteractiveSimulation interactiveSimulation, SmlInteractiveSimulation smlInteractiveSimulation) {
        SliderValue sv;
        SmlSliderValue sliderValue;
        ArrayList<SliderValue> speciesValueSliderList = new ArrayList<SliderValue>();
        ArrayList<SliderValue> parameterValueSliderList = new ArrayList<SliderValue>();
        ArrayList<Object> smlSpeciesValueSliderList = smlInteractiveSimulation.getListOfInitial();
        ArrayList<Object> smlParameterValueSliderList = smlInteractiveSimulation.getListOfParameter();
        interactiveSimulation.setKindOfParameter(smlInteractiveSimulation.getKindOfParameter());
        int i = 0;
        while (i < smlSpeciesValueSliderList.size()) {
            sliderValue = (SmlSliderValue)smlSpeciesValueSliderList.get(i);
            sv = new SliderValue(String.valueOf(sliderValue.getCurrent()));
            sv.setTarget(String.valueOf(sliderValue.getId()));
            sv.setMinValue(String.valueOf(sliderValue.getMin()));
            sv.setMaxValue(String.valueOf(sliderValue.getMax()));
            speciesValueSliderList.add(sv);
            ++i;
        }
        i = 0;
        while (i < smlParameterValueSliderList.size()) {
            sliderValue = (SmlSliderValue)smlParameterValueSliderList.get(i);
            sv = new SliderValue(String.valueOf(sliderValue.getCurrent()));
            sv.setTarget(String.valueOf(sliderValue.getId()));
            sv.setMinValue(String.valueOf(sliderValue.getMin()));
            sv.setMaxValue(String.valueOf(sliderValue.getMax()));
            parameterValueSliderList.add(sv);
            ++i;
        }
        interactiveSimulation.setInteractiveParameterList(speciesValueSliderList, "initial value");
        interactiveSimulation.setInteractiveParameterList(parameterValueSliderList, "parameter value");
    }

    private void setListOfInitialize(ArrayList listOfChanges) {
        ListOf lstSpecies = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        int i = 0;
        while ((long)i < lstSpecies.size()) {
            Species species = (Species)lstSpecies.get((long)i);
            Double initialquantity = null;
            String quantitytype = "amount";
            if (species.isSetInitialAmount()) {
                quantitytype = "amount";
            } else if (species.isSetInitialConcentration()) {
                quantitytype = "concentration";
            }
            int j = 0;
            while (j < listOfChanges.size()) {
                SmlChangeAttribute smlChangeAttribute = (SmlChangeAttribute)listOfChanges.get(j);
                if ("species".equals(SmlUtil.getTypeOfSmlChangeAttribute(smlChangeAttribute)) && species.getId().equals(SmlUtil.getIdOfSmlChangeAttribute(smlChangeAttribute))) {
                    if ("initialquantity".equals(SmlUtil.getItemTypeOfSmlChangeAttribute(smlChangeAttribute))) {
                        initialquantity = Double.valueOf(smlChangeAttribute.getNewValue());
                    } else if ("boundarycondition".equals(SmlUtil.getItemTypeOfSmlChangeAttribute(smlChangeAttribute))) {
                        species.setBoundaryCondition(Boolean.valueOf(smlChangeAttribute.getNewValue()).booleanValue());
                    } else if ("constant".equals(SmlUtil.getItemTypeOfSmlChangeAttribute(smlChangeAttribute))) {
                        species.setConstant(Boolean.valueOf(smlChangeAttribute.getNewValue()).booleanValue());
                    }
                }
                ++j;
            }
            if (initialquantity != null) {
                if ("amount".equals(quantitytype)) {
                    species.setInitialAmount(initialquantity.doubleValue());
                } else if ("concentration".equals(quantitytype)) {
                    species.setInitialConcentration(initialquantity.doubleValue());
                }
            }
            ++i;
        }
        ListOf lstParameters = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        int i2 = 0;
        while ((long)i2 < lstParameters.size()) {
            Parameter parameter = (Parameter)lstParameters.get((long)i2);
            int j = 0;
            while (j < listOfChanges.size()) {
                SmlChangeAttribute smlChangeAttribute = (SmlChangeAttribute)listOfChanges.get(j);
                if ("parameter".equals(SmlUtil.getTypeOfSmlChangeAttribute(smlChangeAttribute)) && parameter.getId().equals(SmlUtil.getIdOfSmlChangeAttribute(smlChangeAttribute))) {
                    if ("value".equals(SmlUtil.getItemTypeOfSmlChangeAttribute(smlChangeAttribute))) {
                        parameter.setValue(Double.valueOf(smlChangeAttribute.getNewValue()).doubleValue());
                    } else if ("constant".equals(SmlUtil.getItemTypeOfSmlChangeAttribute(smlChangeAttribute))) {
                        parameter.setConstant(Boolean.valueOf(smlChangeAttribute.getNewValue()).booleanValue());
                    }
                }
                ++j;
            }
            ++i2;
        }
        ListOf lstReactions = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        int i3 = 0;
        while ((long)i3 < lstReactions.size()) {
            Reaction reaction = (Reaction)lstReactions.get((long)i3);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            int k = 0;
            while ((long)k < lstParameter.size()) {
                Parameter parameter = (Parameter)lstParameter.get((long)k);
                int j = 0;
                while (j < listOfChanges.size()) {
                    SmlChangeAttribute smlChangeAttribute = (SmlChangeAttribute)listOfChanges.get(j);
                    if ("parameter".equals(SmlUtil.getTypeOfSmlChangeAttribute(smlChangeAttribute)) && parameter.getId().equals(SmlUtil.getIdOfSmlChangeAttribute(smlChangeAttribute))) {
                        parameter.setValue(Double.valueOf(smlChangeAttribute.getNewValue()).doubleValue());
                        break;
                    }
                    ++j;
                }
                ++k;
            }
            ++i3;
        }
    }

    private void setListOfPlot(SmlPlot2D smlPlot2D) {
        this.speciesColorSet = new SpeciesColorSet();
        this.speciesVisible = new SpeciesVisible();
        this.hashVisibleSpecies = new HashMap();
        this.speciesColorSet.setSpeciesColors(new HashMap());
        this.speciesVisible.setSpeciesVisible(new HashMap());
        ArrayList<Object> listOfCurves = smlPlot2D.getListOfCurves();
        int i = 0;
        while (i < listOfCurves.size()) {
            SmlCurve smlCurve = (SmlCurve)listOfCurves.get(i);
            this.speciesVisible.addSpeciesVisible(smlCurve.getyDataReference(), smlCurve.isVisible());
            this.speciesColorSet.addSpeciesColor(smlCurve.getyDataReference(), smlCurve.getColor());
            ++i;
        }
    }

    public ArrayList getListOfOriginGlobalParameters() {
        return this.listOfOriginGlobalParameters;
    }

    public SBMLPanelLists getSbmlPanelLists() {
        return this.sbmlPanelLists;
    }

    public ControlPanelMainWindow getParent() {
        return this.parent;
    }
}

