/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ScatterChartPanel {
    public JFreeChart createXYScatterChart(SBMLResults cvodeResults, int index1, int index2) {
        boolean legend = true;
        boolean tooltips = true;
        boolean urls = true;
        ArrayList listOfNames = new ArrayList();
        TimeCourse species = cvodeResults.getSpecies();
        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        XYSeries xySeries = new XYSeries("Series ", false, true);
        int i = 0;
        while (i < species.getTimepoints()) {
            double timePoint = cvodeResults.getTime(i);
            double value1 = species.getValue(i, index1);
            double value2 = species.getValue(i, index2);
            xySeries.add(value1, value2);
            ++i;
        }
        xySeriesCollection.addSeries(xySeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"ScatterChart", (String)species.getName(index1), (String)species.getName(index2), (XYDataset)xySeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }

    public JFreeChart createXYScatterChart(Vector[] dataList, Vector speciesList, int index1, int index2) {
        double[] val1 = (double[])dataList[0].get(index1);
        double[] val2 = (double[])dataList[0].get(index2);
        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        XYSeries xySeries = new XYSeries("Series ", false, true);
        int i = 0;
        while (i < val1.length) {
            double timePoint = i;
            double value1 = val1[i];
            double value2 = val2[i];
            xySeries.add(value1, value2);
            ++i;
        }
        xySeriesCollection.addSeries(xySeries);
        String speciesName1 = (String)speciesList.get(index1);
        String speciesName2 = (String)speciesList.get(index2);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"ScatterChart", (String)speciesName1, (String)speciesName2, (XYDataset)xySeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }
}

