/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesTable;
import jp.co.mki.celldesigner.simulation.controlpanel.TabResult;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Reaction;

public class OverlaySettingDialog
extends JDialog {
    private ControlPanelMainWindow parent;
    private TabResult tabresult;
    private JButton buttonReset;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JCheckBox checkAllChange;
    private JScrollPane resultTabelScrool;
    private SpeciesTable speciesTabel;
    private ArrayList listOfResult;
    private ArrayList listOfOriginOverlay;

    public OverlaySettingDialog(TabResult tabresult, ControlPanelMainWindow parent) {
        super(parent, "Overlay Setting", true);
        this.parent = parent;
        this.tabresult = tabresult;
        this.listOfResult = tabresult.getListOfResult();
        this.listOfOriginOverlay = new ArrayList();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(400, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.createCenterPanel();
        this.createSouthPanel();
    }

    private void createCenterPanel() {
        this.resultTabelScrool = new JScrollPane();
        this.speciesTabel = new SpeciesTable(this, this.getData());
        this.resultTabelScrool.getViewport().add((Component)this.speciesTabel, null);
        this.getContentPane().add((Component)this.resultTabelScrool, "Center");
    }

    private void createSouthPanel() {
        JPanel innerNorthPanel = new JPanel(new BorderLayout());
        this.checkAllChange = new JCheckBox(" AllCheck ");
        this.checkAllChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlaySettingDialog.this.checkAllChange_actionPerformed(e);
            }
        });
        this.checkAllChange.setSelected(false);
        this.buttonOK = new JButton(" OK ");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlaySettingDialog.this.buttonOK_actionPerformed(e);
            }
        });
        this.buttonReset = new JButton(" Reset ");
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlaySettingDialog.this.buttonReset_actionPerformed(e);
            }
        });
        this.buttonCancel = new JButton(" Cancel ");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlaySettingDialog.this.buttonCancel_actionPerformed(e);
            }
        });
        JPanel innerPanel = new JPanel();
        innerPanel.add(this.checkAllChange);
        innerPanel.add(this.buttonOK);
        innerPanel.add(this.buttonReset);
        innerPanel.add(this.buttonCancel);
        innerNorthPanel.add((Component)innerPanel, "South");
        this.getContentPane().add((Component)innerNorthPanel, "South");
    }

    public Object[][] getData() {
        int i;
        SimulationResultPanel srp;
        ArrayList rowData;
        int k;
        String[] s;
        ArrayList<ArrayList> newData = new ArrayList<ArrayList>();
        SBMLResults results = (SBMLResults)this.listOfResult.get(0);
        TimeCourse species = results.getSpecies();
        TimeCourse compartments = results.getCompartments();
        TimeCourse parameters = results.getParameters();
        TimeCourse fluxes = results.getFluxes();
        SBMLPanelLists sbmlPanelLists = this.tabresult.getSbmlPanelLists();
        ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
        String[] speciesS = new String[listOfSpeciesData.size()];
        int i2 = 0;
        while (i2 < listOfSpeciesData.size()) {
            SpeciesData sp = (SpeciesData)listOfSpeciesData.get(i2);
            speciesS[i2] = sp.getSpecies().getId();
            ++i2;
        }
        if (species != null) {
            species.setNames(speciesS);
        }
        ListOf lstReaction = sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        String[] reactions = new String[(int)lstReaction.size()];
        int i3 = 0;
        while ((long)i3 < lstReaction.size()) {
            Reaction reaction = (Reaction)lstReaction.get((long)i3);
            reactions[i3] = reaction.getId();
            ++i3;
        }
        if (fluxes != null) {
            fluxes.setNames(reactions);
        }
        int speciesLength = 0;
        int compartmentsLength = 0;
        int parametersLength = 0;
        int fluxesLength = 0;
        if (species != null && species.getNames() != null) {
            s = species.getNames();
            k = 0;
            while (k < species.getNames().length) {
                rowData = new ArrayList();
                rowData.add(Boolean.FALSE);
                SpeciesData speciesD = (SpeciesData)listOfSpeciesData.get(k);
                String name = speciesD.toString();
                rowData.add(name);
                this.listOfOriginOverlay.add(rowData);
                ++k;
            }
            speciesLength = species.getNames().length;
        }
        if (compartments != null && compartments.getNames() != null) {
            s = compartments.getNames();
            k = 0;
            while (k < compartments.getNames().length) {
                rowData = new ArrayList();
                rowData.add(Boolean.FALSE);
                rowData.add(s[k]);
                this.listOfOriginOverlay.add(rowData);
                ++k;
            }
            compartmentsLength = compartments.getNames().length;
        }
        if (parameters != null && parameters.getNames() != null) {
            s = parameters.getNames();
            k = 0;
            while (k < parameters.getNames().length) {
                rowData = new ArrayList();
                rowData.add(Boolean.FALSE);
                rowData.add(s[k]);
                this.listOfOriginOverlay.add(rowData);
                ++k;
            }
            parametersLength = parameters.getNames().length;
        }
        if (fluxes != null && fluxes.getNames() != null) {
            s = fluxes.getNames();
            k = 0;
            while (k < fluxes.getNames().length) {
                rowData = new ArrayList();
                rowData.add(Boolean.FALSE);
                rowData.add(s[k]);
                this.listOfOriginOverlay.add(rowData);
                ++k;
            }
            fluxesLength = fluxes.getNames().length;
        }
        if ((srp = this.parent.getSrp()) == null) {
            i = 0;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (i < speciesLength) {
                    newData.add(rowData);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckSpeciesSelected() && i < speciesLength) {
                    newData.add(rowData);
                }
                ++i;
            }
            i = speciesLength;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckCompartmentSelected() && i < speciesLength + compartmentsLength) {
                    newData.add(rowData);
                }
                ++i;
            }
            i = speciesLength + compartmentsLength;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckParameterSelected() && i < speciesLength + compartmentsLength + parametersLength) {
                    newData.add(rowData);
                }
                ++i;
            }
            i = speciesLength + compartmentsLength + parametersLength;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckFluxSelected() && i < speciesLength + compartmentsLength + parametersLength + fluxesLength) {
                    newData.add(rowData);
                }
                ++i;
            }
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i4 = 0;
        while (i4 < newData.size()) {
            ArrayList data = (ArrayList)newData.get(i4);
            arrayData[i4] = data.toArray();
            ++i4;
        }
        return arrayData;
    }

    public Object[][] getUpdateData() {
        ArrayList rowData;
        int i;
        SimulationResultPanel srp;
        ArrayList<ArrayList> newData = new ArrayList<ArrayList>();
        SBMLResults results = (SBMLResults)this.listOfResult.get(0);
        TimeCourse species = results.getSpecies();
        TimeCourse compartments = results.getCompartments();
        TimeCourse parameters = results.getParameters();
        TimeCourse fluxes = results.getFluxes();
        int speciesLength = 0;
        int compartmentsLength = 0;
        int parametersLength = 0;
        int fluxesLength = 0;
        if (species != null && species.getNames() != null) {
            speciesLength = species.getNames().length;
        }
        if (compartments != null && compartments.getNames() != null) {
            compartmentsLength = compartments.getNames().length;
        }
        if (parameters != null && parameters.getNames() != null) {
            parametersLength = parameters.getNames().length;
        }
        if (fluxes != null && fluxes.getNames() != null) {
            fluxesLength = fluxes.getNames().length;
        }
        if ((srp = this.parent.getSrp()) == null) {
            i = 0;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (i < speciesLength) {
                    newData.add(rowData);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckSpeciesSelected() && i < speciesLength) {
                    newData.add(rowData);
                }
                ++i;
            }
            i = speciesLength;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckCompartmentSelected() && i < speciesLength + compartmentsLength) {
                    newData.add(rowData);
                }
                ++i;
            }
            i = speciesLength + compartmentsLength;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckParameterSelected() && i < speciesLength + compartmentsLength + parametersLength) {
                    newData.add(rowData);
                }
                ++i;
            }
            i = speciesLength + compartmentsLength + parametersLength;
            while (i < this.listOfOriginOverlay.size()) {
                rowData = (ArrayList)this.listOfOriginOverlay.get(i);
                if (srp.getCheckFluxSelected() && i < speciesLength + compartmentsLength + parametersLength + fluxesLength) {
                    newData.add(rowData);
                }
                ++i;
            }
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            ArrayList data = (ArrayList)newData.get(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        return arrayData;
    }

    public void reload() {
        this.remove(this.resultTabelScrool);
        this.resultTabelScrool = new JScrollPane();
        this.speciesTabel = new SpeciesTable(this, this.getUpdateData());
        this.resultTabelScrool.getViewport().add((Component)this.speciesTabel, null);
        this.getContentPane().add((Component)this.resultTabelScrool, "Center");
    }

    public ArrayList getListOfOverlayedSpecies() {
        int rowCount = this.speciesTabel.getModel().getRowCount();
        ArrayList rowList = new ArrayList(rowCount);
        int i = 0;
        while (i < rowCount) {
            int colCount = this.speciesTabel.getModel().getColumnCount();
            ArrayList<Object> row = new ArrayList<Object>(colCount);
            int j = 0;
            while (j < colCount) {
                Object value = this.speciesTabel.getModel().getValueAt(i, j);
                row.add(value);
                ++j;
            }
            rowList.add(row);
            ++i;
        }
        return rowList;
    }

    private void checkAllChange_actionPerformed(ActionEvent e) {
        int rowCount = this.speciesTabel.getModel().getRowCount();
        int i = 0;
        while (i < rowCount) {
            int colCount = this.speciesTabel.getModel().getColumnCount();
            this.speciesTabel.getModel().setValueAt(new Boolean(this.checkAllChange.isSelected()), i, 0);
            ++i;
        }
    }

    private void buttonOK_actionPerformed(ActionEvent e) {
        ArrayList data;
        int i;
        ArrayList listOfOverlayedSpecies = this.getListOfOverlayedSpecies();
        SimulationResultPanel srp = this.parent.getSrp();
        Boolean[] target = new Boolean[this.listOfOriginOverlay.size()];
        SBMLResults results = (SBMLResults)this.listOfResult.get(0);
        TimeCourse species = results.getSpecies();
        TimeCourse compartments = results.getCompartments();
        TimeCourse parameters = results.getParameters();
        TimeCourse fluxes = results.getFluxes();
        int speciesLength = 0;
        int compartmentsLength = 0;
        int parametersLength = 0;
        int fluxesLength = 0;
        int speciesLength2 = 0;
        int compartmentsLength2 = 0;
        int parametersLength2 = 0;
        int fluxesLength2 = 0;
        if (species != null && species.getNames() != null) {
            if (srp == null || srp.getCheckSpeciesSelected()) {
                speciesLength = species.getNames().length;
            }
            speciesLength2 = species.getNames().length;
        }
        if (compartments != null && compartments.getNames() != null) {
            if (srp != null && srp.getCheckCompartmentSelected()) {
                compartmentsLength = compartments.getNames().length;
            }
            compartmentsLength2 = compartments.getNames().length;
        }
        if (parameters != null && parameters.getNames() != null) {
            if (srp != null && srp.getCheckParameterSelected()) {
                parametersLength = parameters.getNames().length;
            }
            parametersLength2 = parameters.getNames().length;
        }
        if (fluxes != null && fluxes.getNames() != null) {
            if (srp != null && srp.getCheckFluxSelected()) {
                fluxesLength = fluxes.getNames().length;
            }
            fluxesLength2 = fluxes.getNames().length;
        }
        if (srp == null || srp.getCheckSpeciesSelected()) {
            i = 0;
            while (i < speciesLength) {
                data = (ArrayList)listOfOverlayedSpecies.get(i);
                this.listOfOriginOverlay.set(i, data);
                target[i] = (Boolean)data.get(0);
                ++i;
            }
        } else {
            i = 0;
            while (i < speciesLength2) {
                data = (ArrayList)this.listOfOriginOverlay.get(i);
                data.set(0, Boolean.FALSE);
                target[i] = Boolean.FALSE;
                ++i;
            }
        }
        if (srp != null && srp.getCheckCompartmentSelected()) {
            i = 0;
            while (i < compartmentsLength) {
                data = (ArrayList)listOfOverlayedSpecies.get(i + speciesLength);
                this.listOfOriginOverlay.set(i + speciesLength2, data);
                target[i + speciesLength2] = (Boolean)data.get(0);
                ++i;
            }
        } else {
            i = 0;
            while (i < compartmentsLength2) {
                data = (ArrayList)this.listOfOriginOverlay.get(i + speciesLength2);
                data.set(0, Boolean.FALSE);
                target[i + speciesLength2] = Boolean.FALSE;
                ++i;
            }
        }
        if (srp != null && srp.getCheckParameterSelected()) {
            i = 0;
            while (i < parametersLength) {
                data = (ArrayList)listOfOverlayedSpecies.get(i + speciesLength + compartmentsLength);
                this.listOfOriginOverlay.set(i + speciesLength2 + compartmentsLength2, data);
                target[i + speciesLength2 + compartmentsLength2] = (Boolean)data.get(0);
                ++i;
            }
        } else {
            i = 0;
            while (i < parametersLength2) {
                data = (ArrayList)this.listOfOriginOverlay.get(i + speciesLength2 + compartmentsLength2);
                data.set(0, Boolean.FALSE);
                target[i + speciesLength2 + compartmentsLength2] = Boolean.FALSE;
                ++i;
            }
        }
        if (srp != null && srp.getCheckFluxSelected()) {
            i = 0;
            while (i < fluxesLength) {
                data = (ArrayList)listOfOverlayedSpecies.get(i + speciesLength + compartmentsLength + parametersLength);
                this.listOfOriginOverlay.set(i + speciesLength2 + compartmentsLength2 + parametersLength2, data);
                target[i + speciesLength2 + compartmentsLength2 + parametersLength2] = (Boolean)data.get(0);
                ++i;
            }
        } else {
            i = 0;
            while (i < fluxesLength2) {
                data = (ArrayList)this.listOfOriginOverlay.get(i + speciesLength2 + compartmentsLength2 + parametersLength2);
                data.set(0, Boolean.FALSE);
                target[i + speciesLength2 + compartmentsLength2 + parametersLength2] = Boolean.FALSE;
                ++i;
            }
        }
        boolean isVisible = false;
        int i2 = 0;
        while (i2 < target.length) {
            if (target[i2].booleanValue()) {
                isVisible = true;
            }
            ++i2;
        }
        this.tabresult.setShowButton(isVisible);
        this.tabresult.setListOfOverlayedSpecies(target);
        this.setVisible(false);
    }

    private void buttonReset_actionPerformed(ActionEvent e) {
        Boolean[] listOfOverlayedSpecies = this.tabresult.getListOfOverlayedSpecies();
        if (listOfOverlayedSpecies == null) {
            return;
        }
        int rowCount = this.speciesTabel.getModel().getRowCount();
        int i = 0;
        while (i < rowCount) {
            int colCount = this.speciesTabel.getModel().getColumnCount();
            this.speciesTabel.getModel().setValueAt(listOfOverlayedSpecies[i], i, 0);
            ++i;
        }
    }

    private void buttonCancel_actionPerformed(ActionEvent e) {
        this.buttonReset_actionPerformed(e);
        this.setVisible(false);
    }

    public ArrayList getListOfOriginOverlay() {
        return this.listOfOriginOverlay;
    }

    public void setListOfOverlayedSpecies(Boolean[] listOfOverlayedSpecies) {
        int i = 0;
        while (i < this.listOfOriginOverlay.size()) {
            ArrayList data = (ArrayList)this.listOfOriginOverlay.get(i);
            data.set(0, listOfOverlayedSpecies[i]);
            ++i;
        }
    }
}

