/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import javax.swing.SpinnerNumberModel;
import jp.co.mki.celldesigner.simulation.controlpanel.MyNumberEditorFormatter;
import jp.co.mki.celldesigner.simulation.util.StringTool;

class MySpinnerNumberModel
extends SpinnerNumberModel {
    private MyNumberEditorFormatter editor;

    public MySpinnerNumberModel(double value, double minimum, double maximum, double stepSize) {
        super(value, minimum, maximum, stepSize);
    }

    public void setMyNumberEditorFormatter(MyNumberEditorFormatter editor) {
        this.editor = editor;
    }

    @Override
    public Object getNextValue() {
        Number num;
        Object value = this.getValue();
        Double stepSize = (Double)this.getStepSize();
        if (value instanceof Double) {
            Double dValue = (Double)value;
            int scale = StringTool.getScale(dValue, stepSize);
            num = new Double(StringTool.convertNumberFormat(dValue + stepSize, scale));
        } else if (value instanceof Float) {
            Float fValue = (Float)value;
            num = new Double(fValue.floatValue() + stepSize.floatValue());
        } else if (value instanceof Long) {
            Long lValue = (Long)value;
            num = new Long(lValue + stepSize.longValue());
        } else if (value instanceof Integer) {
            Integer iValue = (Integer)value;
            num = new Integer(iValue + stepSize.intValue());
        } else if (value instanceof Short) {
            Short sValue = (Short)value;
            num = new Short((short)(sValue + stepSize.shortValue()));
        } else {
            Byte bValue = (Byte)value;
            num = new Byte((byte)(bValue + stepSize.byteValue()));
        }
        Double maximum = (Double)this.getMaximum();
        return maximum.compareTo((Double)num) >= 0 ? num : null;
    }

    @Override
    public Object getPreviousValue() {
        Number num;
        Object value = this.getValue();
        Double stepSize = (Double)this.getStepSize();
        if (value instanceof Double) {
            Double dValue = (Double)value;
            int scale = StringTool.getScale(dValue, stepSize);
            num = new Double(StringTool.convertNumberFormat(dValue - stepSize, scale));
        } else if (value instanceof Float) {
            Float fValue = (Float)value;
            num = new Double(fValue.floatValue() - stepSize.floatValue());
        } else if (value instanceof Long) {
            Long lValue = (Long)value;
            num = new Long(lValue - stepSize.longValue());
        } else if (value instanceof Integer) {
            Integer iValue = (Integer)value;
            num = new Integer(iValue - stepSize.intValue());
        } else if (value instanceof Short) {
            Short sValue = (Short)value;
            num = new Short((short)(sValue - stepSize.shortValue()));
        } else {
            Byte bValue = (Byte)value;
            num = new Byte((byte)(bValue - stepSize.byteValue()));
        }
        Double minimum = (Double)this.getMinimum();
        return minimum.compareTo((Double)num) <= 0 ? num : null;
    }
}

