/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.InternationalFormatter;

class MyNumberEditorFormatter
extends InternationalFormatter {
    private final SpinnerNumberModel model;

    MyNumberEditorFormatter(SpinnerNumberModel model, NumberFormat format) {
        super(format);
        this.model = model;
        this.setValueClass(model.getValue().getClass());
    }

    public Comparable getMaximum() {
        return this.model.getMaximum();
    }

    public Comparable getMinimum() {
        return this.model.getMinimum();
    }

    public void setMaximum(Comparable max) {
        this.model.setMaximum(max);
    }

    public void setMinimum(Comparable min) {
        this.model.setMinimum(min);
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        try {
            Double d = null;
            try {
                d = new Double(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (text.indexOf("E") != -1 || d != null && String.valueOf(d).indexOf("E") != -1) {
                super.setFormat(new DecimalFormat("#.###############E0"));
            } else {
                super.setFormat(new DecimalFormat("#.###############"));
            }
            return super.stringToValue(text);
        }
        catch (ParseException e) {
            Double d;
            Object object = this.getFormat().parseObject(text);
            if (object instanceof Double) {
                d = (Double)object;
            } else if (object instanceof Number) {
                d = new Double(((Number)object).doubleValue());
            } else {
                throw e;
            }
            if (this.getMaximum().compareTo(d) < 0) {
                return this.getMaximum();
            }
            if (this.getMinimum().compareTo(d) > 0) {
                return this.getMinimum();
            }
            throw e;
        }
    }
}

