/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.PlotConfigDialog;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultChart;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultPanel;
import jp.co.mki.celldesigner.simulation.util.ImageStore;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class ImageConfigDialog
extends JDialog {
    private ControlPanelMainWindow parent;
    private boolean print;
    private ChartPanel panel;
    protected static BasicStroke basicStroke;

    public JFreeChart getJFreeChart() {
        return this.panel.getChart();
    }

    public ImageConfigDialog(ControlPanelMainWindow parent, boolean print) {
        this.parent = parent;
        this.print = print;
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setTitle("Image Config Dialog");
        this.setSize(800, 600);
        this.setLocation(0, 0);
        this.createChartPanel();
        this.createButton();
        basicStroke = (BasicStroke)this.getJFreeChart().getXYPlot().getDomainGridlineStroke();
        this.panel.setPopupMenu(null);
        this.panel.setMouseZoomable(false);
        this.setVisible(true);
    }

    private void createChartPanel() {
        SimulationResultChart src = new SimulationResultChart();
        src.setTitle(this.parent.getSbframe().getFilename());
        src.setTimeAxisLabel("Time");
        src.setValueAxisLabel("amount");
        SimulationResultPanel srp = this.parent.getSrp();
        try {
            if (this.parent.isShowScatter() && this.parent.isShowReverse()) {
                this.panel = srp.showReverseScatterPlot();
            } else if (this.parent.isShowScatter()) {
                this.panel = srp.showScatterPlot();
            } else if (srp.getListOfResult() == null && srp.getAllResults() != null) {
                this.panel = new ChartPanel(src.createChart(this.parent, srp.getAllResults(), srp, this.parent.is2paramScan()));
            } else if (srp.getListOfResult() != null) {
                this.panel = new ChartPanel(src.createChart(this.parent, srp.getListOfResult(), srp, this.parent.is2paramScan()));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.getContentPane().add((Component)this.panel, "Center");
    }

    private void createButton() {
        JPanel innerPanel = new JPanel();
        JButton buttonConfig = new JButton("Config");
        buttonConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConfigDialog.this.buttonConfig_actionPerformed(e);
            }
        });
        JButton buttonSave = new JButton("Save Image");
        buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConfigDialog.this.buttonSave_actionPerformed(e);
            }
        });
        JButton buttonPrint = new JButton("Print");
        buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConfigDialog.this.buttonPrint_actionPerformed(e);
            }
        });
        JButton buttonClose = new JButton("Close");
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConfigDialog.this.buttonClose_actionPerformed(e);
            }
        });
        innerPanel.add(buttonConfig);
        innerPanel.add(buttonSave);
        innerPanel.add(buttonPrint);
        innerPanel.add(buttonClose);
        this.getContentPane().add((Component)innerPanel, "South");
    }

    private void buttonConfig_actionPerformed(ActionEvent e) {
        PlotConfigDialog edit = new PlotConfigDialog(this.getJFreeChart());
    }

    private void buttonSave_actionPerformed(ActionEvent e) {
        ImageStore im = new ImageStore();
        im.storeImage((Component)this.panel);
    }

    private void buttonPrint_actionPerformed(ActionEvent e) {
        this.panel.createChartPrintJob();
    }

    private void buttonClose_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.buttonClose_actionPerformed(null);
        }
    }
}

