/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.mki.celldesigner.simulation.controlpanel.ExtendChartPropertyEditPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.ExtendFontChooserPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.LineNameTable;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.FontDisplayField;
import org.jfree.ui.PaintSample;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;

class ExtendLegendPropertyEditPanel
extends JPanel
implements ActionListener {
    private ExtendChartPropertyEditPanel parent;
    private boolean showLegend;
    private JCheckBox showLegendCheckBox;
    private StrokeSample outlineStroke;
    private JButton selectOutlineStrokeButton;
    private PaintSample outlinePaint;
    private JButton selectOutlinePaintButton;
    private PaintSample backgroundPaint;
    private JButton selectBackgroundPaintButton;
    private Font seriesFont;
    private JButton selectSeriesFontButton;
    private PaintSample seriesPaint;
    private JButton selectSeriesPaintButton;
    private StrokeSample[] availableStrokeSamples;
    private FontDisplayField fontDisplayField;
    private LineNameTable lineNameTable;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public ExtendLegendPropertyEditPanel(Legend legend, JFreeChart chart, ExtendChartPropertyEditPanel parent) {
        this.parent = parent;
        StandardLegend l = legend != null ? (StandardLegend)legend : new StandardLegend();
        this.showLegend = legend != null;
        this.outlineStroke = new StrokeSample(l.getOutlineStroke());
        this.outlinePaint = new PaintSample(l.getOutlinePaint());
        this.backgroundPaint = new PaintSample(l.getBackgroundPaint());
        this.seriesFont = l.getItemFont();
        this.seriesPaint = new PaintSample(l.getItemPaint());
        this.availableStrokeSamples = new StrokeSample[4];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        this.availableStrokeSamples[3] = new StrokeSample((Stroke)new BasicStroke(4.0f));
        this.setLayout(new BorderLayout());
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), localizationResources.getString("General")));
        JPanel interior = new JPanel((LayoutManager)new LCBLayout(6));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        interior.add(new JLabel(localizationResources.getString("Show_Legend")));
        this.showLegendCheckBox = new JCheckBox();
        this.showLegendCheckBox.setSelected(this.showLegend);
        this.showLegendCheckBox.setActionCommand("ShowLegend");
        this.showLegendCheckBox.addActionListener(this);
        interior.add(new JPanel());
        interior.add(this.showLegendCheckBox);
        interior.add(new JLabel(localizationResources.getString("Outline")));
        interior.add((Component)this.outlineStroke);
        this.selectOutlineStrokeButton = new JButton(localizationResources.getString("Select..."));
        this.selectOutlineStrokeButton.setActionCommand("OutlineStroke");
        this.selectOutlineStrokeButton.addActionListener(this);
        interior.add(this.selectOutlineStrokeButton);
        interior.add(new JLabel(localizationResources.getString("Outline_Paint")));
        this.selectOutlinePaintButton = new JButton(localizationResources.getString("Select..."));
        this.selectOutlinePaintButton.setActionCommand("OutlinePaint");
        this.selectOutlinePaintButton.addActionListener(this);
        interior.add((Component)this.outlinePaint);
        interior.add(this.selectOutlinePaintButton);
        interior.add(new JLabel(localizationResources.getString("Background")));
        this.selectBackgroundPaintButton = new JButton(localizationResources.getString("Select..."));
        this.selectBackgroundPaintButton.setActionCommand("BackgroundPaint");
        this.selectBackgroundPaintButton.addActionListener(this);
        interior.add((Component)this.backgroundPaint);
        interior.add(this.selectBackgroundPaintButton);
        interior.add(new JLabel(localizationResources.getString("Series_label_font")));
        this.selectSeriesFontButton = new JButton(localizationResources.getString("Select..."));
        this.selectSeriesFontButton.setActionCommand("SeriesFont");
        this.selectSeriesFontButton.addActionListener(this);
        this.fontDisplayField = new FontDisplayField(this.seriesFont);
        interior.add((Component)this.fontDisplayField);
        interior.add(this.selectSeriesFontButton);
        interior.add(new JLabel(localizationResources.getString("Series_label_paint")));
        this.selectSeriesPaintButton = new JButton(localizationResources.getString("Select..."));
        this.selectSeriesPaintButton.setActionCommand("SeriesPaint");
        this.selectSeriesPaintButton.addActionListener(this);
        interior.add((Component)this.seriesPaint);
        interior.add(this.selectSeriesPaintButton);
        this.enableOrDisableControls();
        general.add(interior);
        this.add((Component)general, "North");
        this.createNameChangeTable(chart);
    }

    private void createNameChangeTable(JFreeChart chart) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(190, 160));
        Vector newData = new Vector();
        XYPlot xyPlot = chart.getXYPlot();
        XYSeriesCollection collection = (XYSeriesCollection)xyPlot.getDataset();
        int i = 0;
        while (i < collection.getSeriesCount()) {
            Vector<String> rowData = new Vector<String>();
            rowData.addElement(collection.getSeriesName(i));
            newData.addElement(rowData);
            ++i;
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            Vector data = (Vector)newData.elementAt(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        this.lineNameTable = new LineNameTable(arrayData);
        scrollPane.getViewport().add(this.lineNameTable);
        this.add((Component)scrollPane, "Center");
    }

    public ArrayList getNameTableList() {
        int rowCount = this.lineNameTable.getModel().getRowCount();
        ArrayList rowList = new ArrayList(rowCount);
        int i = 0;
        while (i < rowCount) {
            int colCount = this.lineNameTable.getModel().getColumnCount();
            ArrayList<Object> row = new ArrayList<Object>(colCount);
            int j = 0;
            while (j < colCount) {
                Object value = this.lineNameTable.getModel().getValueAt(i, j);
                row.add(value);
                ++j;
            }
            rowList.add(row);
            ++i;
        }
        return rowList;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint.getPaint();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint.getPaint();
    }

    public Font getSeriesFont() {
        return this.seriesFont;
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint.getPaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("OutlineStroke")) {
            this.attemptModifyOutlineStroke();
        } else if (command.equals("OutlinePaint")) {
            this.attemptModifyOutlinePaint();
        } else if (command.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        } else if (command.equals("SeriesFont")) {
            this.attemptModifySeriesFont();
        } else if (command.equals("SeriesPaint")) {
            this.attemptModifySeriesPaint();
        } else if (command.equals("ShowLegend")) {
            this.attemptModifyShowLegend();
        }
        this.parent.toFrontParentDialog();
    }

    private void attemptModifyOutlineStroke() {
        StrokeChooserPanel panel = new StrokeChooserPanel(this.outlineStroke, this.availableStrokeSamples);
        int result = JOptionPane.showConfirmDialog(this, panel, localizationResources.getString("Pen_Stroke_Selection"), 2, -1);
        if (result == 0) {
            this.outlineStroke.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptModifyOutlinePaint() {
        Color c = JColorChooser.showDialog(this, localizationResources.getString("Outline_Color"), Color.blue);
        if (c != null) {
            this.outlinePaint.setPaint((Paint)c);
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color c = JColorChooser.showDialog(this, localizationResources.getString("Background_Color"), Color.blue);
        if (c != null) {
            this.backgroundPaint.setPaint((Paint)c);
        }
    }

    public void attemptModifySeriesFont() {
        ExtendFontChooserPanel panel = new ExtendFontChooserPanel(this.seriesFont);
        int result = JOptionPane.showConfirmDialog(this, (Object)panel, localizationResources.getString("Font_Selection"), 2, -1);
        if (result == 0) {
            this.seriesFont = panel.getSelectedFont();
            this.fontDisplayField.setText(String.valueOf(this.seriesFont.getFontName()) + ", " + this.seriesFont.getSize());
        }
    }

    private void attemptModifySeriesPaint() {
        Color c = JColorChooser.showDialog(this, localizationResources.getString("Series_Label_Color"), Color.blue);
        if (c != null) {
            this.seriesPaint.setPaint((Paint)c);
        }
    }

    private void attemptModifyShowLegend() {
        this.showLegend = this.showLegendCheckBox.isSelected();
        this.enableOrDisableControls();
    }

    private void enableOrDisableControls() {
        boolean enabled = this.showLegend;
        this.selectOutlineStrokeButton.setEnabled(enabled);
        this.selectOutlinePaintButton.setEnabled(enabled);
        this.selectBackgroundPaintButton.setEnabled(enabled);
        this.selectSeriesFontButton.setEnabled(enabled);
        this.selectSeriesPaintButton.setEnabled(enabled);
    }

    public void setLegendProperties(JFreeChart chart) {
        if (this.showLegend) {
            Legend legend = chart.getLegend();
            if (legend == null) {
                legend = new StandardLegend();
                chart.setLegend(legend);
            }
            if (legend instanceof StandardLegend) {
                StandardLegend standard = (StandardLegend)legend;
                standard.setOutlineStroke(this.getOutlineStroke());
                standard.setOutlinePaint(this.getOutlinePaint());
                standard.setBackgroundPaint(this.getBackgroundPaint());
                standard.setItemFont(this.getSeriesFont());
                standard.setItemPaint(this.getSeriesPaint());
            }
            ArrayList list = this.getNameTableList();
            XYPlot xyPlot = chart.getXYPlot();
            XYSeriesCollection collection = (XYSeriesCollection)xyPlot.getDataset();
            int i = 0;
            while (i < list.size()) {
                ArrayList data = (ArrayList)list.get(i);
                collection.getSeries(i).setName((String)data.get(0));
                ++i;
            }
            legend.setAnchor(2);
        } else {
            chart.setLegend(null);
        }
    }
}

