/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.co.mki.celldesigner.simulation.controlpanel.ExtendLegendPropertyEditPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.ImageConfigDialog;
import jp.co.mki.celldesigner.simulation.controlpanel.PlotConfigDialog;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.PlotPropertyEditPanel;
import org.jfree.chart.ui.TitlePropertyEditPanel;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;

class ExtendChartPropertyEditPanel
extends JPanel
implements ActionListener {
    private PlotConfigDialog parent;
    private TitlePropertyEditPanel titlePropertiesPanel;
    private ExtendLegendPropertyEditPanel legendPropertiesPanel;
    private PlotPropertyEditPanel plotPropertiesPanel;
    private JCheckBox antialias;
    private PaintSample background;
    private ButtonGroup group1;
    private ButtonGroup group2;
    private ButtonGroup group3;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public void toFrontParentDialog() {
        this.parent.toFront();
    }

    public ExtendChartPropertyEditPanel(PlotConfigDialog parent, JFreeChart chart) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        JPanel other = new JPanel(new BorderLayout());
        other.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), localizationResources.getString("General")));
        JPanel interior = new JPanel((LayoutManager)new LCBLayout(9));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.antialias = new JCheckBox(localizationResources.getString("Draw_anti-aliased"));
        this.antialias.setSelected(chart.getAntiAlias());
        interior.add(this.antialias);
        interior.add(new JLabel(""));
        interior.add(new JLabel(""));
        interior.add(new JLabel(localizationResources.getString("Background_paint")));
        this.background = new PaintSample(chart.getBackgroundPaint());
        interior.add((Component)this.background);
        JButton button = new JButton(localizationResources.getString("Select..."));
        button.setActionCommand("BackgroundPaint");
        button.addActionListener(this);
        interior.add(button);
        interior.add(new JLabel(localizationResources.getString("Series_Paint")));
        JTextField info = new JTextField(localizationResources.getString("No_editor_implemented"));
        info.setEnabled(false);
        interior.add(info);
        button = new JButton(localizationResources.getString("Edit..."));
        button.setEnabled(false);
        interior.add(button);
        interior.add(new JLabel(localizationResources.getString("Series_Stroke")));
        info = new JTextField(localizationResources.getString("No_editor_implemented"));
        info.setEnabled(false);
        interior.add(info);
        button = new JButton(localizationResources.getString("Edit..."));
        button.setEnabled(false);
        interior.add(button);
        interior.add(new JLabel(localizationResources.getString("Series_Outline_Paint")));
        info = new JTextField(localizationResources.getString("No_editor_implemented"));
        info.setEnabled(false);
        interior.add(info);
        button = new JButton(localizationResources.getString("Edit..."));
        button.setEnabled(false);
        interior.add(button);
        interior.add(new JLabel(localizationResources.getString("Series_Outline_Stroke")));
        info = new JTextField(localizationResources.getString("No_editor_implemented"));
        info.setEnabled(false);
        interior.add(info);
        button = new JButton(localizationResources.getString("Edit..."));
        button.setEnabled(false);
        interior.add(button);
        interior.add(new JLabel("Grid Visible"));
        JRadioButton radio1 = new JRadioButton("on");
        radio1.setEnabled(true);
        radio1.setSelected(chart.getXYPlot().isDomainGridlinesVisible());
        interior.add(radio1);
        JRadioButton radio2 = new JRadioButton("off");
        radio2.setEnabled(true);
        radio2.setSelected(!radio1.isSelected());
        this.group1 = new ButtonGroup();
        this.group1.add(radio1);
        this.group1.add(radio2);
        interior.add(radio2);
        interior.add(new JLabel("Line"));
        JRadioButton radio3 = new JRadioButton("dotted");
        radio3.setEnabled(true);
        radio3.setSelected(chart.getXYPlot().getDomainGridlineStroke() == ImageConfigDialog.basicStroke);
        interior.add(radio3);
        JRadioButton radio4 = new JRadioButton("solid");
        radio4.setEnabled(true);
        radio4.setSelected(!radio3.isSelected());
        this.group2 = new ButtonGroup();
        this.group2.add(radio3);
        this.group2.add(radio4);
        interior.add(radio4);
        interior.add(new JLabel("TickMark"));
        JRadioButton radio5 = new JRadioButton("Outside");
        radio5.setEnabled(true);
        radio5.setSelected(chart.getXYPlot().getDomainAxis().getTickMarkOutsideLength() == 2.0f);
        interior.add(radio5);
        JRadioButton radio6 = new JRadioButton("Inside");
        radio6.setEnabled(true);
        radio6.setSelected(!radio5.isSelected());
        this.group3 = new ButtonGroup();
        this.group3.add(radio5);
        this.group3.add(radio6);
        interior.add(radio6);
        general.add((Component)interior, "North");
        other.add((Component)general, "North");
        JPanel parts = new JPanel(new BorderLayout());
        TextTitle title = chart.getTitle();
        Legend legend = chart.getLegend();
        Plot plot = chart.getPlot();
        JTabbedPane tabs = new JTabbedPane();
        this.titlePropertiesPanel = new TitlePropertyEditPanel((Title)title);
        this.titlePropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        tabs.addTab(localizationResources.getString("Title"), (Component)this.titlePropertiesPanel);
        this.legendPropertiesPanel = new ExtendLegendPropertyEditPanel(legend, chart, this);
        this.legendPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        tabs.addTab(localizationResources.getString("Legend"), this.legendPropertiesPanel);
        this.plotPropertiesPanel = new PlotPropertyEditPanel(plot);
        this.plotPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        tabs.addTab(localizationResources.getString("Plot"), (Component)this.plotPropertiesPanel);
        tabs.add(localizationResources.getString("Other"), other);
        parts.add((Component)tabs, "North");
        this.add(parts);
    }

    public TitlePropertyEditPanel getTitlePropertyEditPanel() {
        return this.titlePropertiesPanel;
    }

    public ExtendLegendPropertyEditPanel getLegendPropertyEditPanel() {
        return this.legendPropertiesPanel;
    }

    public PlotPropertyEditPanel getPlotPropertyEditPanel() {
        return this.plotPropertiesPanel;
    }

    public boolean getAntiAlias() {
        return this.antialias.isSelected();
    }

    public Paint getBackgroundPaint() {
        return this.background.getPaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color c = JColorChooser.showDialog(this, localizationResources.getString("Background_Color"), Color.blue);
        if (c != null) {
            this.background.setPaint((Paint)c);
        }
        this.parent.toFront();
    }

    public void updateChartProperties(JFreeChart chart) {
        JRadioButton button;
        this.titlePropertiesPanel.setTitleProperties(chart);
        this.legendPropertiesPanel.setLegendProperties(chart);
        this.plotPropertiesPanel.updatePlotProperties(chart.getPlot());
        chart.setAntiAlias(this.getAntiAlias());
        chart.setBackgroundPaint(this.getBackgroundPaint());
        Enumeration<AbstractButton> e = this.group1.getElements();
        while (e.hasMoreElements()) {
            button = (JRadioButton)e.nextElement();
            if (button.getText().equals("on") && button.isSelected()) {
                chart.getXYPlot().setDomainGridlinesVisible(true);
                chart.getXYPlot().setRangeGridlinesVisible(true);
                continue;
            }
            if (!button.getText().equals("off") || !button.isSelected()) continue;
            chart.getXYPlot().setDomainGridlinesVisible(false);
            chart.getXYPlot().setRangeGridlinesVisible(false);
        }
        e = this.group2.getElements();
        while (e.hasMoreElements()) {
            button = (JRadioButton)e.nextElement();
            if (button.getText().equals("dotted") && button.isSelected()) {
                chart.getXYPlot().setDomainGridlineStroke((Stroke)ImageConfigDialog.basicStroke);
                chart.getXYPlot().setRangeGridlineStroke((Stroke)ImageConfigDialog.basicStroke);
                continue;
            }
            if (!button.getText().equals("solid") || !button.isSelected()) continue;
            chart.getXYPlot().setDomainGridlineStroke((Stroke)new BasicStroke());
            chart.getXYPlot().setRangeGridlineStroke((Stroke)new BasicStroke());
        }
        e = this.group3.getElements();
        while (e.hasMoreElements()) {
            button = (JRadioButton)e.nextElement();
            if (button.getText().equals("Outside") && button.isSelected()) {
                chart.getXYPlot().getDomainAxis().setTickMarkInsideLength(0.0f);
                chart.getXYPlot().getRangeAxis().setTickMarkInsideLength(0.0f);
                chart.getXYPlot().getDomainAxis().setTickMarkOutsideLength(2.0f);
                chart.getXYPlot().getRangeAxis().setTickMarkOutsideLength(2.0f);
                continue;
            }
            if (!button.getText().equals("Inside") || !button.isSelected()) continue;
            chart.getXYPlot().getDomainAxis().setTickMarkInsideLength(2.0f);
            chart.getXYPlot().getRangeAxis().setTickMarkInsideLength(2.0f);
            chart.getXYPlot().getDomainAxis().setTickMarkOutsideLength(0.0f);
            chart.getXYPlot().getRangeAxis().setTickMarkOutsideLength(0.0f);
        }
    }
}

