/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import jp.co.mki.celldesigner.simulation.controlpanel.ChangeAmount;
import jp.co.mki.celldesigner.simulation.controlpanel.CornerHeader;
import jp.co.mki.celldesigner.simulation.controlpanel.ErrorTolerance;
import jp.co.mki.celldesigner.simulation.controlpanel.ExecuteODESolver;
import jp.co.mki.celldesigner.simulation.controlpanel.ImageConfigDialog;
import jp.co.mki.celldesigner.simulation.controlpanel.InteractiveSimulation;
import jp.co.mki.celldesigner.simulation.controlpanel.MyTask;
import jp.co.mki.celldesigner.simulation.controlpanel.OverlaySettingDialog;
import jp.co.mki.celldesigner.simulation.controlpanel.ParameterScan;
import jp.co.mki.celldesigner.simulation.controlpanel.SBaseEditorListener;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationInfo;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SliderValue;
import jp.co.mki.celldesigner.simulation.controlpanel.Solver;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesColorSet;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesVisible;
import jp.co.mki.celldesigner.simulation.controlpanel.TabChangeAmount;
import jp.co.mki.celldesigner.simulation.controlpanel.TabParameterScan;
import jp.co.mki.celldesigner.simulation.controlpanel.TabParameterScanInteractive;
import jp.co.mki.celldesigner.simulation.controlpanel.TabParameters;
import jp.co.mki.celldesigner.simulation.controlpanel.TabPlotSetting;
import jp.co.mki.celldesigner.simulation.controlpanel.TabResult;
import jp.co.mki.celldesigner.simulation.controlpanel.TabSpecies;
import jp.co.mki.celldesigner.simulation.controlpanel.TableRowHeader;
import jp.co.mki.celldesigner.simulation.controlpanel.TaskNameInputDialog;
import jp.co.mki.celldesigner.simulation.controlpanel.TaskTree;
import jp.co.mki.celldesigner.simulation.controlpanel.TimeSpan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlModel;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPaint;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPlot2D;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimCondition;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlTask;
import jp.co.mki.celldesigner.simulation.sedml.util.SmlUtil;
import jp.co.mki.celldesigner.simulation.util.MyProgressBar;
import jp.co.mki.celldesigner.simulation.util.SimulationProperties;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.multiwindow.MultiWindowFrame;
import jp.fric.io.util.FilePather;
import jp.sbi.celldesigner.Application;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MainWindowAccess;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBEventRecorder;
import jp.sbi.celldesigner.SBMLFiler;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.copasi.ExecuteCopasi;
import jp.sbi.celldesigner.simulation.ExecuteSolver;
import jp.sbi.celldesigner.simulationcore.ExecuteSimulationCore;
import jp.sbi.celldesigner.soslib.SOSlib;
import jp.sbi.celldesigner.soslib.SOSlibException;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.celldesigner.util.PoliteFileDialog;
import jp.sbi.celldesigner.util.RecentFiles;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.ListPanel;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.jfree.chart.ChartPanel;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;
import org.sbml.libsbml.Species;

public class ControlPanelMainWindow
extends JDialog
implements ActionListener,
SBaseEditorListener,
ChangeListener,
Runnable {
    private TabSpecies tabSpecies = null;
    private final int X_WIDTH_MAIN = 920;
    private final int X_WIDTH = 1120;
    private JPanel backGroundPanel = null;
    private JSplitPane splitBackGroundPanel = null;
    private JPanel treePanel = null;
    private JButton saveCondition = null;
    private TaskTree taskList = null;
    private SmlSimCondition smlSimCondition;
    private SmlSimCondition cloneSmlSimCondition;
    private ArrayList listOfTasks = null;
    private SmlTask editingTask = null;
    private TaskNameInputDialog taskNameInputDialog = null;
    private String modelPath = "";
    private String modelName = "";
    boolean sedFileIsExist = false;
    boolean sbmlFileIsExist = false;
    private final int Y_WIDTH = 520;
    private TabParameters tabParameters = null;
    private TabChangeAmount tabChangeAmount = null;
    private TabParameterScan tabParameterScan = null;
    private TabParameterScanInteractive tabTabScanInteractive = null;
    private TabPlotSetting tabPlotSetting = null;
    private TabResult tabResult = null;
    private JPanel mainPanel = null;
    private JTabbedPane tabPane = null;
    private File XMLFile = null;
    private JButton exeInitialize = null;
    private JCheckBox exeCheck;
    private JCheckBox exeReverseCheck;
    private JButton exeSave = null;
    private JButton exeCmd = null;
    private JButton exeClose = null;
    private SBMLDocument sbmlDocument = new SBMLDocument();
    private SBMLPanelLists sbmlPanelLists;
    private SBMLFiler filer;
    private SBModelFrame sbframe;
    private FilePather pather;
    private SpecInfo spec;
    private MainWindowAccess access;
    private double SpanValue;
    private double StepValue;
    private JLabel lblTimespan = null;
    private JSpinner spnSpan = null;
    private JSpinner spnStep = null;
    JSpinner errorToleranceSpinner = null;
    private JRadioButton rbSoslib = null;
    private JRadioButton rbCopasi = null;
    private JRadioButton rbSimulationCore = null;
    private JLabel picLabel = null;
    private JPanel pnlConfig = null;
    private JSplitPane splitConfig = null;
    private JSplitPane splitMainWindow = null;
    private JPanel pnlMainWindow = null;
    private SimulationInfo simulationInfo = null;
    private TimeSpan timeSpan = null;
    private ChangeAmount changeAmount = null;
    private ParameterScan paramaterScan = null;
    private InteractiveSimulation interactiveSimulation = null;
    private ErrorTolerance errorTolerance = null;
    private Solver solver = null;
    private String thisModelPath = null;
    private String thisSBMLPath = null;
    public boolean isXMLLoad = false;
    public SpeciesColorSet speciesColorSet;
    public SpeciesVisible speciesVisible;
    private ArrayList listOfResult;
    private static final int TAB_SPECIES = 0;
    private static final int TAB_PARAMETERS = 1;
    private static final int TAB_CHANGEAMOUNT = 2;
    private static final int TAB_PARAMETERSCAN = 3;
    private static final int TAB_INTERACTIVE = 4;
    private static final int TAB_RESULTS = 5;
    private SimulationResultPanel srp;
    private Thread runner;
    private boolean blinkMode;
    private ArrayList listOfOriginSpecies;
    private ArrayList listOfOriginReactions;
    private ArrayList listOfOriginGlobalParameters;
    protected ArrayList listOfSpeciesData;
    private boolean isBeforeExecParamScan;
    private double beforeEndTime;
    private double beforeMaxRange;
    private MyProgressBar progressBar;
    private String EXECUTING = "executing...";
    private boolean isChanged = false;
    private Vector panelMenuButtonVector = new Vector();
    private HashMap panelMenuButtonHashM = new HashMap();
    private HashMap panelMenuButtonHashRM = new HashMap();
    private HashMap panelMenuButtonHashML = new HashMap();
    private HashMap panelMenuButtonHashRML = new HashMap();

    public ControlPanelMainWindow(String title, File XMLFile) {
        this.XMLFile = XMLFile;
        this.readXML(XMLFile);
        this.initThisObjectInformation();
        this.addComponents();
    }

    public SBModelFrame getSbframe() {
        return this.sbframe;
    }

    public void setSelectedModelTab() {
        ((MainWindow)this.access).setSelectedModelTab(this.sbframe);
    }

    public void setSpeciesData(ListOf sbaseList) {
        this.listOfSpeciesData = new ArrayList((int)sbaseList.size());
        HashMap hash = this.access.getCurrentModel().getSBModel().getHashRepairSpecies();
        int i = 0;
        while ((long)i < sbaseList.size()) {
            Species sp = (Species)sbaseList.get((long)i);
            if (sp.getCompartment() != null && !sp.getCompartment().equals("") && hash.get(sp.getId()) == null) {
                SpeciesData data = new SpeciesData(sp, sbaseList);
                this.listOfSpeciesData.add(data);
            }
            ++i;
        }
    }

    public ControlPanelMainWindow(SBMLPanelLists sbmlPanelLists, SBMLFiler filer, SBModelFrame sbframe, FilePather pather, SpecInfo spec, MainWindowAccess access) {
        super((JFrame)((Object)access));
        SBModelFrame frame;
        this.setTitle("ControlPanel " + sbframe.getFilename());
        this.sbmlPanelLists = sbmlPanelLists;
        this.access = access;
        this.filer = filer;
        this.sbframe = sbframe;
        this.pather = pather;
        this.spec = spec;
        this.isExistSimulationDir();
        this.setInitialValues();
        this.setSpeciesData(sbmlPanelLists.getSBaseListPanel(3).getSBaseList());
        this.isXMLLoad = false;
        this.listOfResult = null;
        File file = null;
        if (access.getCurrentModel() != null && !(frame = access.getCurrentModel()).frameTitle().endsWith("*")) {
            file = frame.getPath();
        }
        if (file != null) {
            String path = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4);
            String xmlPath = String.valueOf(path) + "_sed.xml";
            String simPath = String.valueOf(path) + ".sim";
            File sim = new File(simPath);
            File xml = new File(xmlPath);
            if (xml.exists() || sim.exists()) {
                this.thisModelPath = path;
                this.simulationInfo = new SimulationInfo(this);
                this.simulationInfo.setSbmlPanelLists(sbmlPanelLists);
                if (xml.exists()) {
                    try {
                        this.smlSimCondition = SmlUtil.getValueFromXmlFile(xml);
                        this.cloneSmlSimCondition = this.smlSimCondition.clone();
                        this.sedFileIsExist = true;
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, e.getMessage());
                        return;
                    }
                    this.listOfTasks = this.smlSimCondition.getListOfTasks();
                    if (this.listOfTasks != null && this.listOfTasks.size() > 0) {
                        this.editingTask = (SmlTask)this.listOfTasks.get(0);
                    }
                    this.simulationInfo.updateSmlInfo(this.smlSimCondition, this.editingTask);
                } else if (sim.exists()) {
                    this.simulationInfo.read(sim);
                }
                this.backupSimData();
                this.isXMLLoad = true;
            }
        }
        if (this.listOfTasks == null || this.listOfTasks.size() == 0) {
            this.createDefaultTask();
        }
        this.initThisObjectInformation();
        this.createStorageClasses();
        this.setSimulationInfo();
        try {
            this.addComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initSpanAndErrTolerancePanel();
        if (this.isXMLLoad && this.listOfResult != null) {
            if (this.listOfResult.size() == 1) {
                if (this.sedFileIsExist) {
                    this.setTabResult();
                    this.SetDrawArea();
                } else {
                    this.calcAndDrawLoadResultImage((SBMLResults)this.listOfResult.get(0), true, false, false, false);
                }
            } else if (this.listOfResult.size() > 1) {
                if (this.sedFileIsExist) {
                    this.setTabResult();
                    this.SetDrawArea();
                } else {
                    try {
                        if (this.paramaterScan.doScanParameter[0] && this.paramaterScan.doScanParameter[1]) {
                            this.calcAndDrawLoadResultImage((SBMLResults)this.listOfResult.get(this.simulationInfo.getLastSelectedRow()), true, false, false, false);
                            this.tabResult.reload(this.listOfResult);
                            this.tabResult.setShowButton(true);
                            this.tabResult.setWritingButton(true);
                        } else if (this.paramaterScan.doScanParameter[0] || this.paramaterScan.doScanParameter[1]) {
                            int i = 0;
                            while (i < this.listOfResult.size()) {
                                SBMLResults results = (SBMLResults)this.listOfResult.get(i);
                                if (results.getPath() != null && !results.getPath().equals("")) {
                                    results.getOutputFileFromSedXml(results.getPath());
                                    String[] species = new String[this.listOfSpeciesData.size()];
                                    int j = 0;
                                    while (j < this.listOfSpeciesData.size()) {
                                        SpeciesData sp = (SpeciesData)this.listOfSpeciesData.get(j);
                                        species[j] = sp.getSpecies().getId();
                                        ++j;
                                    }
                                    TimeCourse s_values = results.getSpecies();
                                    if (s_values != null) {
                                        s_values.setNames(species);
                                    }
                                    ListOf lstReaction = sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
                                    String[] reactions = new String[(int)lstReaction.size()];
                                    int j2 = 0;
                                    while ((long)j2 < lstReaction.size()) {
                                        Reaction reaction = (Reaction)lstReaction.get((long)j2);
                                        reactions[j2] = reaction.getId();
                                        ++j2;
                                    }
                                    TimeCourse f_values = results.getFluxes();
                                    if (f_values != null) {
                                        f_values.setNames(reactions);
                                    }
                                    results.setCompartments(new TimeCourse(0, 0));
                                    results.setParameters(new TimeCourse(0, 0));
                                }
                                ++i;
                            }
                            ArrayList listOfResultVisible = this.simulationInfo.getListOfResultVisible();
                            Boolean[] target = new Boolean[this.listOfResult.size()];
                            int i2 = 0;
                            while (i2 < this.listOfResult.size()) {
                                target[i2] = (Boolean)listOfResultVisible.get(i2);
                                ++i2;
                            }
                            HashMap listOfVisibleSpecies = this.simulationInfo.getHashVisibleSpecies();
                            OverlaySettingDialog settingsDialog = new OverlaySettingDialog(this.tabResult, this);
                            ArrayList listOfVOverlayedSpecies = settingsDialog.getListOfOriginOverlay();
                            Boolean[] listOfOverlayedSpecies = new Boolean[listOfVOverlayedSpecies.size()];
                            int i3 = 0;
                            while (i3 < listOfVOverlayedSpecies.size()) {
                                ArrayList data = (ArrayList)listOfVOverlayedSpecies.get(i3);
                                String name = (String)data.get(1);
                                listOfOverlayedSpecies[i3] = listOfVisibleSpecies.get(name) != null ? Boolean.TRUE : Boolean.FALSE;
                                ++i3;
                            }
                            this.tabResult.setOverlayMode(true);
                            this.tabResult.setShowButton(true);
                            this.tabResult.setListOfOverlayedSpecies(listOfOverlayedSpecies);
                            settingsDialog.setListOfOverlayedSpecies(listOfOverlayedSpecies);
                            this.tabResult.setOverlaySettingDialog(settingsDialog);
                            this.tabResult.reload(this.listOfResult);
                            this.tabResult.setListOfResultsVisible(target);
                            this.calcAndDrawLoadResultImage(target, listOfOverlayedSpecies, true, false, false, false, false);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.getTabParameters().resetParameters();
    }

    private void createJWSCompornent() {
        this.setResizable(false);
        this.mainPanel = (JPanel)this.getContentPane();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(300, 210));
        this.lblTimespan = this.getLblTimespan();
        this.spnSpan = this.getSpnSpan();
        this.spnStep = this.getSpnStep();
        this.lblTimespan.add(new JLabel("End Time"));
        this.lblTimespan.add(this.spnSpan);
        this.lblTimespan.add(new JLabel("Num. of Points"));
        this.lblTimespan.add(this.spnStep);
        JPanel pnlErrorTolerance = new JPanel(new GridLayout(1, 2));
        pnlErrorTolerance.setBorder(new TitledBorder("Error tolerance"));
        pnlErrorTolerance.add(new JLabel("Exp."));
        this.setErrorToleranceSpinner();
        pnlErrorTolerance.add(this.errorToleranceSpinner);
        this.exeCmd = this.getExeCmd();
        this.mainPanel.add((Component)this.lblTimespan, "Center");
        JPanel innerSouthPanel = new JPanel(new BorderLayout());
        innerSouthPanel.setPreferredSize(new Dimension(200, 100));
        innerSouthPanel.add((Component)pnlErrorTolerance, "Center");
        JPanel innerSouthPanel2 = new JPanel();
        innerSouthPanel2.add(this.exeCmd);
        this.exeClose = this.getExeClose();
        innerSouthPanel2.add(this.exeClose);
        innerSouthPanel.add((Component)innerSouthPanel2, "South");
        this.mainPanel.add((Component)innerSouthPanel, "South");
    }

    protected static ImageIcon createToolbarIcon(String relativePath, String imageName) {
        String imgLocation = String.valueOf(relativePath) + File.separator + imageName + ".png";
        URL imageURL = MainWindow.class.getResource(imgLocation);
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    public void setPanelToolbarIcon() {
        MainWindow mainWin = MainWindow.getLastInstance();
        if (Preference.iconSize == 24) {
            mainWin.setToolbarIconImage(this.panelMenuButtonVector, this.panelMenuButtonHashML, this.panelMenuButtonHashRML);
        } else {
            mainWin.setToolbarIconImage(this.panelMenuButtonVector, this.panelMenuButtonHashM, this.panelMenuButtonHashRM);
        }
    }

    private void createFileMenuToolBar() {
        Insets toolBarButtonInsets = new Insets(0, 0, 0, 0);
        String[] fileMenuToolBarEntry = new String[]{"save", "save_as", "save_image", "print", "execute", "savecondition"};
        JToolBar fileMenuToolBar = new JToolBar();
        fileMenuToolBar.setRollover(true);
        this.getContentPane().add((Component)fileMenuToolBar, "North");
        int id = 2;
        MediaTracker tracker = new MediaTracker(this);
        Image[] images1 = new Image[fileMenuToolBarEntry.length];
        Image[] images2 = new Image[fileMenuToolBarEntry.length];
        Image[] images1L = new Image[fileMenuToolBarEntry.length];
        Image[] images2L = new Image[fileMenuToolBarEntry.length];
        int i = 0;
        while (i < images1.length) {
            String imgName = new String(String.valueOf(fileMenuToolBarEntry[i]) + "_n");
            images1[i] = ControlPanelMainWindow.createImage("ui_icons", imgName);
            images1L[i] = ControlPanelMainWindow.createImage("icons_24/ui_icons", imgName);
            this.panelMenuButtonHashM.put(imgName, images1[i]);
            this.panelMenuButtonHashML.put(imgName, images1L[i]);
            tracker.addImage(images1[i], 2);
            tracker.addImage(images1L[i], 2);
            String imgRName = new String(fileMenuToolBarEntry[i]);
            images2[i] = ControlPanelMainWindow.createImage("ui_icons", imgRName);
            images2L[i] = ControlPanelMainWindow.createImage("icons_24/ui_icons", imgRName);
            this.panelMenuButtonHashRM.put(imgRName, images2[i]);
            this.panelMenuButtonHashRML.put(imgRName, images2L[i]);
            tracker.addImage(images2[i], 2);
            tracker.addImage(images2L[i], 2);
            ++i;
        }
        try {
            tracker.waitForID(2);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        JButton buttonSave = new JButton();
        buttonSave.setName(fileMenuToolBarEntry[0]);
        buttonSave.setMargin(toolBarButtonInsets);
        buttonSave.setToolTipText("Save");
        buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveActionPerformed(e);
            }
        });
        fileMenuToolBar.add(buttonSave);
        this.panelMenuButtonVector.add(buttonSave);
        JButton buttonSaveAs = new JButton();
        buttonSaveAs.setName(fileMenuToolBarEntry[1]);
        buttonSaveAs.setMargin(toolBarButtonInsets);
        buttonSaveAs.setToolTipText("Save As");
        buttonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveAsActionPerformed(e);
            }
        });
        fileMenuToolBar.add(buttonSaveAs);
        this.panelMenuButtonVector.add(buttonSaveAs);
        JButton buttonPrint = new JButton();
        buttonPrint.setName(fileMenuToolBarEntry[3]);
        buttonPrint.setMargin(toolBarButtonInsets);
        buttonPrint.setToolTipText("Print");
        buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuPrintActionPerformed(e);
            }
        });
        fileMenuToolBar.add(buttonPrint);
        this.panelMenuButtonVector.add(buttonPrint);
        JButton buttonSaveCondition = new JButton();
        buttonSaveCondition.setName(fileMenuToolBarEntry[5]);
        buttonSaveCondition.setMargin(toolBarButtonInsets);
        buttonSaveCondition.setToolTipText("SaveCondition");
        buttonSaveCondition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveConditionActionPerformed(e);
            }
        });
        fileMenuToolBar.add(buttonSaveCondition);
        this.panelMenuButtonVector.add(buttonSaveCondition);
    }

    protected static Image createImage(String relativePath, String imageName) {
        String imgLocation = String.valueOf(relativePath) + "/" + imageName + ".png";
        URL imageURL = MainWindow.class.getResource(imgLocation);
        if (imageURL == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().getImage(imageURL);
    }

    private void isExistSimulationDir() {
        File simulationfile;
        String current = SimulationProperties.getInstance().getInitParameter("input_path");
        File newfile = new File(current);
        File[] fileList = newfile.listFiles();
        if (fileList == null) {
            simulationfile = new File(current);
            simulationfile.mkdirs();
        }
        if ((fileList = (newfile = new File(current = SimulationProperties.getInstance().getInitParameter("result_path"))).listFiles()) == null) {
            simulationfile = new File(current);
            simulationfile.mkdirs();
        }
    }

    public void setInitialValues() {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        this.listOfOriginSpecies = new ArrayList();
        int i = 0;
        while ((long)i < lstSBase.size()) {
            Species species = (Species)lstSBase.get((long)i);
            Species origin = species.cloneObject();
            this.listOfOriginSpecies.add(origin);
            ++i;
        }
        this.listOfOriginReactions = new ArrayList();
        ListOf lstGlobalParam = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        lstSBase = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        this.listOfOriginGlobalParameters = new ArrayList();
        if (lstGlobalParam.size() > 0L) {
            int j = 0;
            while ((long)j < lstGlobalParam.size()) {
                Parameter parameter = (Parameter)lstGlobalParam.get((long)j);
                Parameter originP = new Parameter();
                originP.setId(parameter.getId());
                originP.setMetaId(parameter.getMetaId());
                originP.setName(parameter.getName());
                originP.setValue(parameter.getValue());
                originP.setConstant(parameter.getConstant());
                originP.setAnnotation(parameter.getAnnotation());
                this.listOfOriginGlobalParameters.add(originP);
                ++j;
            }
        }
        int i2 = 0;
        while ((long)i2 < lstSBase.size()) {
            Reaction reaction = (Reaction)lstSBase.get((long)i2);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            Reaction originR = new Reaction();
            originR.setId(reaction.getId());
            KineticLaw originK = new KineticLaw();
            originR.setKineticLaw(originK);
            int j = 0;
            while ((long)j < lstParameter.size()) {
                Parameter parameter = (Parameter)lstParameter.get((long)j);
                Parameter originP = new Parameter();
                originP.setId(parameter.getId());
                originP.setMetaId(parameter.getMetaId());
                originP.setName(parameter.getName());
                originP.setValue(parameter.getValue());
                originP.setConstant(parameter.getConstant());
                originP.setAnnotation(parameter.getAnnotation());
                this.listOfOriginReactions.add(originP);
                ++j;
            }
            ++i2;
        }
    }

    private void margeListOfOriginReactions(ArrayList listOfParameters) {
        int i = 0;
        while (i < this.listOfOriginReactions.size()) {
            Parameter originParameter = (Parameter)this.listOfOriginReactions.get(i);
            Parameter parameter = (Parameter)listOfParameters.get(i);
            originParameter.setValue(parameter.getValue());
            originParameter.setConstant(parameter.getConstant());
            ++i;
        }
    }

    private void initThisObjectInformation() {
        this.backGroundPanel = (JPanel)this.getContentPane();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.setJMenuBar(this.createMenuBar());
        this.createFileMenuToolBar();
        this.setPanelToolbarIcon();
        this.backGroundPanel.setPreferredSize(new Dimension(1120, 520));
        this.mainPanel.setPreferredSize(new Dimension(920, 520));
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.getAccessibleContext().setAccessibleDescription("The menu that is related to i/o operation");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Open Condition");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.openFile();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.getAccessibleContext().setAccessibleDescription("This update xml file which is be equivalent to control panel.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save As...");
        menuItem.getAccessibleContext().setAccessibleDescription("Save a new xml file which is be equivalent to control panel.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveAsActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save Condition");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveConditionActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save Condition As...");
        menuItem.getAccessibleContext().setAccessibleDescription("Save a new SED-ML file for simulation experimental condition.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveConditionAsActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save Image / Print");
        menuItem.getAccessibleContext().setAccessibleDescription("Save image file of simulation result");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuSaveImageActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Rename Experiment");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.taskRenameActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close", 81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.getAccessibleContext().setAccessibleDescription("This close control panel");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuCloseActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic(78);
        menu.getAccessibleContext().setAccessibleDescription("The menu that is related to copy and paste action");
        menuBar.add(menu);
        menuItem = new JMenuItem("Copy", 67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.getAccessibleContext().setAccessibleDescription("This copy area of dragged to clipboard");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuCopyActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Paste", 86);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.getAccessibleContext().setAccessibleDescription("This copy clipboard to point of clicked");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuPasteActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Data");
        menu.setMnemonic(78);
        menu.getAccessibleContext().setAccessibleDescription("The menu that does i/o operation to external file related to change amount");
        menuBar.add(menu);
        menuItem = new JMenuItem("Import");
        menuItem.getAccessibleContext().setAccessibleDescription("This copy from external file to cell of change amount");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuImportActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Export");
        menuItem.getAccessibleContext().setAccessibleDescription("This copy to external file from cell of change amount");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuExportActionPerformed(e);
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Simulation");
        menu.setMnemonic(78);
        menu.getAccessibleContext().setAccessibleDescription("The menu that run simulation");
        menuBar.add(menu);
        menuItem = new JMenuItem("Run");
        menuItem.getAccessibleContext().setAccessibleDescription("This run simple simulation");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanelMainWindow.this.menuRunActionPerformed(e);
            }
        });
        menu.add(menuItem);
        return menuBar;
    }

    private JSplitPane getSplitConfig() {
        JSplitPane _splitConfig = new JSplitPane(0, true);
        _splitConfig.setBorder(BorderFactory.createEmptyBorder());
        _splitConfig.setDividerSize(5);
        _splitConfig.setDividerLocation(100);
        _splitConfig.setResizeWeight(0.0);
        _splitConfig.setOneTouchExpandable(true);
        return _splitConfig;
    }

    private JSplitPane getSplitMainWindow() {
        JSplitPane _splitMainWindow = new JSplitPane(1, true);
        _splitMainWindow.setBorder(BorderFactory.createEmptyBorder());
        _splitMainWindow.setDividerLocation(this.getPreferredSize().width / 3 + 50);
        _splitMainWindow.setResizeWeight(1.0);
        _splitMainWindow.setOneTouchExpandable(true);
        return _splitMainWindow;
    }

    private void addComponents() {
        this.splitConfig = this.getSplitConfig();
        this.lblTimespan = this.getLblTimespan();
        this.spnSpan = this.getSpnSpan();
        this.spnStep = this.getSpnStep();
        this.lblTimespan.add(new JLabel("End Time"));
        this.lblTimespan.add(this.spnSpan);
        JLabel lblNumpoints = new JLabel("Num. of Points");
        lblNumpoints.setToolTipText("Num. of Points");
        this.lblTimespan.add(lblNumpoints);
        this.lblTimespan.add(this.spnStep);
        JPanel pnlErrorTolerance = new JPanel();
        pnlErrorTolerance.setLayout(new GridLayout(3, 2));
        pnlErrorTolerance.setBorder(new TitledBorder("Error tolerance"));
        this.setErrorToleranceSpinner();
        pnlErrorTolerance.add(new JPanel());
        pnlErrorTolerance.add(new JPanel());
        pnlErrorTolerance.add(new JLabel("  Exp."));
        pnlErrorTolerance.add(this.errorToleranceSpinner);
        JPanel pnlSelectSolver = new JPanel();
        pnlSelectSolver.setLayout(new BoxLayout(pnlSelectSolver, 1));
        pnlSelectSolver.setBorder(new TitledBorder("Solver"));
        this.setSolverRadioButton();
        pnlSelectSolver.add(this.rbSoslib);
        pnlSelectSolver.add(this.rbCopasi);
        pnlSelectSolver.add(this.rbSimulationCore);
        JPanel pnlTimeSpn = new JPanel();
        pnlTimeSpn.setLayout(new GridLayout(1, 2));
        pnlTimeSpn.add(this.lblTimespan);
        pnlTimeSpn.add(pnlErrorTolerance);
        pnlTimeSpn.add(pnlSelectSolver);
        this.splitConfig.setLeftComponent(pnlTimeSpn);
        this.pnlConfig = this.getPnlConfig();
        this.createConfigTabbedPane();
        this.rgstConfigTabbedPane();
        this.pnlConfig.add((Component)this.tabPane, "Center");
        this.splitConfig.setRightComponent(this.pnlConfig);
        this.splitMainWindow = this.getSplitMainWindow();
        this.splitMainWindow.setLeftComponent(this.splitConfig);
        JTabbedPane tabpane = new JTabbedPane();
        tabpane.addTab("Graph", new JPanel());
        tabpane.addTab("Table", new JScrollPane());
        this.splitMainWindow.setRightComponent(tabpane);
        this.pnlMainWindow = new JPanel();
        this.pnlMainWindow.setLayout(new BorderLayout());
        this.pnlMainWindow.add(this.splitMainWindow);
        this.createTaskTreePanel();
        this.exeInitialize = this.getExeInitialize();
        this.exeSave = this.getExeSave();
        this.exeCmd = this.getExeCmd();
        this.exeClose = this.getExeClose();
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel innerEastPanel = new JPanel();
        this.progressBar = new MyProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(120, 20));
        this.progressBar.setBorderPainted(false);
        innerEastPanel.add(this.progressBar);
        southPanel.add((Component)innerEastPanel, "East");
        JPanel pnlExeBtn = new JPanel();
        pnlExeBtn.add(this.exeInitialize);
        pnlExeBtn.add(this.exeSave);
        pnlExeBtn.add(this.exeCmd);
        pnlExeBtn.add(this.exeClose);
        this.exeCheck = new JCheckBox("show scatter plot");
        this.exeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ControlPanelMainWindow.this.showScatterAction();
            }
        });
        pnlExeBtn.add(this.exeCheck);
        this.exeReverseCheck = new JCheckBox("reverse");
        this.exeReverseCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ControlPanelMainWindow.this.showReverseScatterAction();
            }
        });
        this.exeReverseCheck.setVisible(false);
        pnlExeBtn.add(this.exeReverseCheck);
        southPanel.add((Component)pnlExeBtn, "Center");
        this.mainPanel.add((Component)this.pnlMainWindow, "Center");
        this.mainPanel.add((Component)southPanel, "South");
        this.splitBackGroundPanel = this.getSplitBackGroundPanel();
        this.splitBackGroundPanel.setLeftComponent(this.treePanel);
        this.splitBackGroundPanel.setRightComponent(this.mainPanel);
        this.backGroundPanel.add(this.splitBackGroundPanel);
    }

    private void showScatterAction() {
        this.doShowScatterAction();
    }

    public void doShowScatterAction() {
        if (this.srp != null) {
            if (this.exeCheck.isSelected()) {
                ChartPanel scatterPanel = this.srp.showScatterPlot();
                if (scatterPanel == null) {
                    this.exeCheck.setSelected(false);
                    this.exeReverseCheck.setSelected(false);
                    this.exeReverseCheck.setVisible(false);
                } else {
                    this.exeReverseCheck.setVisible(true);
                    ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, (Component)this.srp.showScatterPlot());
                }
            } else {
                this.exeReverseCheck.setSelected(false);
                this.exeReverseCheck.setVisible(false);
                ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, this.srp.showViewer());
            }
        }
    }

    private void showReverseScatterAction() {
        this.doShowReverseScatterAction();
    }

    public void doShowReverseScatterAction() {
        if (this.exeReverseCheck.isSelected()) {
            ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, (Component)this.srp.showReverseScatterPlot());
        } else {
            ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, (Component)this.srp.showScatterPlot());
        }
    }

    private void createConfigTabbedPane() {
        this.tabPane = new JTabbedPane(1, 0);
        this.tabPane.setTabLayoutPolicy(1);
        this.tabPane.addChangeListener(this);
        this.tabSpecies = new TabSpecies(this.sbmlPanelLists, this);
        this.tabSpecies.addSBaseEditorListener(this);
        this.tabParameters = new TabParameters(this.sbmlPanelLists, this);
        this.tabParameters.addSBaseEditorListener(this);
        this.tabParameterScan = new TabParameterScan(this, this.paramaterScan, this.sbmlPanelLists);
        this.tabTabScanInteractive = new TabParameterScanInteractive(this.interactiveSimulation, this.sbmlPanelLists, this, this.tabSpecies, this.tabParameters, true);
        this.tabPlotSetting = new TabPlotSetting();
        if (this.listOfOriginSpecies.size() > 0) {
            this.tabChangeAmount = new TabChangeAmount(this, this.changeAmount, this.sbmlPanelLists, this.tabSpecies, this.tabPlotSetting);
        }
        this.tabResult = new TabResult(this, this.sbmlPanelLists, this.listOfResult);
        this.tabResult.setOverlayMode(false);
    }

    public boolean isShowScatter() {
        return this.exeCheck.isSelected();
    }

    public boolean isShowReverse() {
        return this.exeReverseCheck.isSelected();
    }

    private void rgstConfigTabbedPane() {
        if (this.listOfOriginSpecies.size() > 0) {
            this.tabPane.addTab("Species", this.tabSpecies);
        } else {
            this.tabPane.addTab("Species", null);
            this.tabPane.setEnabledAt(0, false);
        }
        this.tabPane.addTab("Parameters", this.tabParameters);
        if (this.listOfOriginSpecies.size() > 0) {
            this.tabPane.addTab("Change amount", this.tabChangeAmount);
        } else {
            this.tabPane.addTab("Change amount", null);
            this.tabPane.setEnabledAt(2, false);
        }
        this.tabPane.addTab("Parameter Scan", this.tabParameterScan);
        this.tabPane.addTab("Interactive Simulation", this.tabTabScanInteractive);
        this.tabPane.addTab("Results", this.tabResult);
        if (this.listOfOriginSpecies.size() > 0) {
            this.tabPane.setEnabledAt(1, true);
        }
    }

    private JButton getExeInitialize() {
        JButton _exeInitialize = new JButton("Initialize");
        _exeInitialize.addActionListener(this);
        return _exeInitialize;
    }

    private JButton getExeSave() {
        JButton _exeSave = new JButton("Save As");
        _exeSave.addActionListener(this);
        return _exeSave;
    }

    private JButton getExeCmd() {
        JButton _exeCmd = new JButton("Execute");
        _exeCmd.addActionListener(this);
        return _exeCmd;
    }

    private JButton getExeClose() {
        JButton _exeClose = new JButton("Close");
        _exeClose.addActionListener(this);
        return _exeClose;
    }

    private void setSolverRadioButton() {
        ButtonGroup bgSolver = new ButtonGroup();
        this.rbSoslib = new JRadioButton("SOSlib", true);
        this.rbSoslib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ControlPanelMainWindow.this.solver.setSolverName("SOSlib");
                if (ControlPanelMainWindow.this.tabChangeAmount != null) {
                    ControlPanelMainWindow.this.tabPane.setEnabledAt(2, true);
                }
            }
        });
        this.rbCopasi = new JRadioButton("COPASI");
        this.rbCopasi.setEnabled(Application.hasCopasiJava);
        this.rbCopasi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ControlPanelMainWindow.this.solver.setSolverName("COPASI");
                if (ControlPanelMainWindow.this.tabChangeAmount != null) {
                    ControlPanelMainWindow.this.tabPane.setEnabledAt(2, false);
                }
            }
        });
        this.rbSimulationCore = new JRadioButton("SimulationCore");
        this.rbSimulationCore.setEnabled(true);
        this.rbSimulationCore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ControlPanelMainWindow.this.solver.setSolverName("SimulationCore");
                if (ControlPanelMainWindow.this.tabChangeAmount != null) {
                    ControlPanelMainWindow.this.tabPane.setEnabledAt(2, false);
                }
            }
        });
        bgSolver.add(this.rbSoslib);
        bgSolver.add(this.rbCopasi);
        bgSolver.add(this.rbSimulationCore);
        if (this.solver != null && this.solver.getSolverName() != null) {
            if (this.solver.getSolverName().equals("COPASI")) {
                this.rbCopasi.setSelected(true);
            } else if (this.solver.getSolverName().equals("SimulationCore")) {
                this.rbSimulationCore.setSelected(true);
            }
        } else {
            this.rbSoslib.setSelected(true);
        }
    }

    private void setErrorToleranceSpinner() {
        int defaultValue = -6;
        int minValue = -14;
        boolean maxValue = false;
        boolean stepValue = true;
        SpinnerNumberModel model = null;
        if (this.errorTolerance != null && this.errorTolerance.getRelativeTolerance() != null) {
            double rt = Double.parseDouble(this.errorTolerance.getRelativeTolerance());
            int loadedValue = (int)Math.log10(rt);
            model = new SpinnerNumberModel(loadedValue, -14, 0, 1);
        } else {
            model = new SpinnerNumberModel(-6, -14, 0, 1);
        }
        this.errorToleranceSpinner = new JSpinner(model);
        this.errorToleranceSpinner.addChangeListener(this);
    }

    private JSpinner getSpnSpan() {
        double defaultValue = 100.0;
        double minValue = 0.0;
        double maxValue = Double.MAX_VALUE;
        double stepValue = 0.5;
        SpinnerNumberModel model = null;
        if (this.timeSpan != null && this.timeSpan.getSpan() != null) {
            double loaddefaultValue = Double.parseDouble(this.timeSpan.getSpan());
            model = new SpinnerNumberModel(loaddefaultValue, 0.0, Double.MAX_VALUE, 0.5);
        } else {
            model = new SpinnerNumberModel(100.0, 0.0, Double.MAX_VALUE, 0.5);
        }
        JSpinner _spnSpan = new JSpinner(model);
        _spnSpan.addChangeListener(this);
        return _spnSpan;
    }

    private JSpinner getSpnSpan(double defaultValues) {
        double defaultValue = defaultValues;
        double minValue = 0.0;
        double maxValue = Double.MAX_VALUE;
        double stepValue = 0.5;
        SpinnerNumberModel model = new SpinnerNumberModel(defaultValue, 0.0, Double.MAX_VALUE, 0.5);
        JSpinner _spnSpan = new JSpinner(model);
        _spnSpan.addChangeListener(this);
        return _spnSpan;
    }

    private JSpinner getSpnStep() {
        double defaultValue = 100.0;
        double minValue = 0.0;
        double maxValue = Double.MAX_VALUE;
        double stepValue = 1.0;
        SpinnerNumberModel model = null;
        if (this.timeSpan != null && this.timeSpan.getStep() != null) {
            double loaddefaultValue = Double.parseDouble(this.timeSpan.getStep());
            model = new SpinnerNumberModel(loaddefaultValue, 0.0, Double.MAX_VALUE, 1.0);
        } else {
            model = new SpinnerNumberModel(100.0, 0.0, Double.MAX_VALUE, 1.0);
        }
        JSpinner _spnStep = new JSpinner(model);
        _spnStep.addChangeListener(this);
        return _spnStep;
    }

    private JLabel getLblTimespan() {
        JLabel _lblTimespan = new JLabel();
        _lblTimespan.setBorder(new TitledBorder("Time span"));
        _lblTimespan.setLayout(new GridLayout(2, 2));
        return _lblTimespan;
    }

    private JPanel getPnlConfig() {
        JPanel _pnlConfig = new JPanel();
        _pnlConfig.setLayout(new BorderLayout());
        return _pnlConfig;
    }

    public double getSpanValue() {
        return this.SpanValue;
    }

    public double getStepValue() {
        return this.StepValue;
    }

    public void setSpanValue(double SpanValue) {
        this.SpanValue = SpanValue;
    }

    public void setSpanValue(String SpanValue) {
        this.lblTimespan.remove(1);
        this.spnSpan = this.getSpnSpan(Double.parseDouble(SpanValue));
        this.lblTimespan.add((Component)this.spnSpan, 1);
        this.timeSpan.setSpan(String.valueOf(this.spnSpan.getValue()));
    }

    public void setStepValue(double StepValue) {
        this.StepValue = StepValue;
    }

    public void showMoreThanZeroWarnDialog(String msg) {
        JOptionPane.showMessageDialog(null, "Please set [" + msg + "] as larger than 0.", "WARN", 0);
    }

    public void validateSpinnerValue() {
        double sp = Double.parseDouble(String.valueOf(this.spnSpan.getValue()));
        double st = Double.parseDouble(String.valueOf(this.spnStep.getValue()));
        if (sp == 0.0) {
            this.showMoreThanZeroWarnDialog("End Time");
            return;
        }
        if (st == 0.0) {
            this.showMoreThanZeroWarnDialog("Num. of Points");
            return;
        }
    }

    public void validateParameterScanIntervalValue() {
        ParameterScan scan = this.tabParameterScan.getParameterScan();
        double in1 = Double.parseDouble(scan.getInterval(0));
        double in2 = Double.parseDouble(scan.getInterval(1));
        if (scan.doScanParameter(0) && in1 == 0.0 || scan.doScanParameter(1) && in2 == 0.0) {
            this.showMoreThanZeroWarnDialog("interval value");
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.exeCmd) {
                this.validateSpinnerValue();
                if (this.tabPane.getSelectedIndex() == 2) {
                    if (this.tabChangeAmount != null && this.tabChangeAmount.isChkChangeAmount()) {
                        this.validateParameterScanIntervalValue();
                        if (this.changeAmount.isExistIllegalValue()) {
                            return;
                        }
                    }
                    this.stopBlink();
                    if (this.tabChangeAmount != null) {
                        if (this.tabChangeAmount.isChkChangeAmount() && this.tabParameterScan.isCheckScan1() && this.tabParameterScan.isCheckScan2()) {
                            this.calcChangeAmount2ParameterScanBatch();
                            this.isBeforeExecParamScan = true;
                        } else if (this.tabChangeAmount.isChkChangeAmount() && (this.tabParameterScan.isCheckScan1() || this.tabParameterScan.isCheckScan2())) {
                            this.calcChangeAmount1ParameterScanBatch();
                            this.isBeforeExecParamScan = true;
                        } else if (this.tabChangeAmount.isChkChangeAmount()) {
                            this.calcChangeAmount();
                            this.isBeforeExecParamScan = false;
                        } else {
                            this.calcAndDrawResultImage();
                            this.isBeforeExecParamScan = false;
                        }
                    } else {
                        this.calcAndDrawResultImage();
                        this.isBeforeExecParamScan = false;
                    }
                } else if (this.tabPane.getSelectedIndex() == 3) {
                    this.validateParameterScanIntervalValue();
                    this.stopBlink();
                    if (this.tabChangeAmount != null) {
                        if (this.tabChangeAmount.isChkChangeAmount() && this.tabParameterScan.isCheckScan1() && this.tabParameterScan.isCheckScan2()) {
                            if (this.changeAmount.isExistIllegalValue()) {
                                return;
                            }
                            this.calcChangeAmount2ParameterScanBatch();
                        } else if (this.tabChangeAmount.isChkChangeAmount() && (this.tabParameterScan.isCheckScan1() || this.tabParameterScan.isCheckScan2())) {
                            if (this.changeAmount.isExistIllegalValue()) {
                                return;
                            }
                            this.calcChangeAmount1ParameterScanBatch();
                            this.isBeforeExecParamScan = true;
                        } else if (this.tabParameterScan.isCheckScan1() && this.tabParameterScan.isCheckScan2()) {
                            this.calc2ParameterScanBatch();
                            this.isBeforeExecParamScan = true;
                        } else if (this.tabParameterScan.isCheckScan1() || this.tabParameterScan.isCheckScan2()) {
                            this.calc1ParameterScanBatch();
                            this.isBeforeExecParamScan = true;
                        } else {
                            this.calcAndDrawResultImage();
                            this.isBeforeExecParamScan = false;
                        }
                    } else {
                        this.calcAndDrawResultImage();
                        this.isBeforeExecParamScan = false;
                    }
                } else {
                    this.stopBlink();
                    this.calcAndDrawResultImage();
                    this.isBeforeExecParamScan = false;
                }
            } else if (e.getSource() == this.exeClose) {
                this.confirmExit(this);
            } else if (e.getSource() == this.exeSave) {
                this.processSave("saveAs");
            } else if (e.getSource() == this.exeInitialize) {
                this.processInitialize();
            } else if (e.getSource() == this.saveCondition) {
                this.processSaveCondition();
            }
        }
        catch (SOSlibException ep) {
            JOptionPane.showMessageDialog(null, "Simulation Failed: \n" + ep.getMessage(), "Error", 0);
            return;
        }
        if (this.isShowReverse()) {
            this.showReverseScatterAction();
        } else if (this.isShowScatter()) {
            this.showScatterAction();
        }
        this.repaint();
    }

    private void processSave(String mode) {
        String path = !this.sbmlFileIsExist || mode.equals("saveAs") ? PoliteFileDialog.getSelectedFilePath("Select file", ".xml", 1) : String.valueOf(this.thisSBMLPath) + ".xml";
        if (path == null) {
            return;
        }
        path = SmlUtil.SubString(path, ".xml");
        path = SmlUtil.SubString(path, "_sed");
        File outputFile = new File(String.valueOf(path) + "_sed.xml");
        this.simulationInfo.setListOfOriginSpecies(this.listOfOriginSpecies);
        this.simulationInfo.setListOfOriginReactions(this.listOfOriginReactions);
        this.simulationInfo.setSpeciesColorSet(this.speciesColorSet);
        this.simulationInfo.setSpeciesVisible(this.speciesVisible);
        this.simulationInfo.setListOfResults(this.listOfResult);
        this.simulationInfo.setSbmlPanelLists(this.sbmlPanelLists);
        this.simulationInfo.setListOfOriginGlobalParameters(this.listOfOriginGlobalParameters);
        this.resetModelPathName();
        ArrayList listResults = null;
        listResults = this.tabResult.getListOfResult() != null && !this.tabResult.getListOfResult().isEmpty() ? this.tabResult.getListOfResult() : this.listOfResult;
        SmlUtil.updateSmlSimCondition(this.smlSimCondition, this.editingTask, this.simulationInfo, this.modelName, this.modelPath, listResults, path);
        try {
            ArrayList<Object> plot2DList = this.smlSimCondition.getListOfOutputs();
            if (plot2DList != null) {
                int index = 0;
                while (index < plot2DList.size()) {
                    SmlPlot2D plot2D = (SmlPlot2D)plot2DList.get(index);
                    ArrayList list = (ArrayList)plot2D.getResultofList();
                    if (list != null && list.size() > 0) {
                        this.fileOutPutMethod(path, plot2D.getTaskref(), list);
                    }
                    ++index;
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Can not save data to file.");
            return;
        }
        this.cloneSmlSimCondition = this.smlSimCondition.clone();
        MainWindow multiwindow = (MainWindow)this.access.getMyFrame();
        SBModelFrame multiwindowFrame = multiwindow.getCurrentModel();
        File file = multiwindow.getCurrentModel().getPath();
        String outPutPath = outputFile.getAbsolutePath();
        String modelFormat = "";
        if (outPutPath.length() > 4) {
            File xmlFile = new File(String.valueOf(path) + ".xml");
            try {
                HashMap hash = this.access.getCurrentModel().getSBModel().getHashRepairSpecies();
                if (hash.keySet().isEmpty()) {
                    this.filer.write(xmlFile, multiwindowFrame);
                } else {
                    this.filer.export(this.sbframe, xmlFile, this.spec);
                    modelFormat = " as pure SBML";
                }
            }
            catch (Exception exception) {
                this.access.openErrorDialog(exception);
                return;
            }
            RecentFiles recentFiles = new RecentFiles();
            recentFiles.add(xmlFile.getAbsolutePath());
            ((MultiWindowFrame)multiwindowFrame).saveDone();
        }
        String saveMessage = "";
        saveMessage = this.listOfResult != null ? "Saved model(.xml)" + modelFormat + " and results (_result/) files." : "Saved model(.xml)" + modelFormat;
        this.thisSBMLPath = path;
        this.sbmlFileIsExist = true;
        JOptionPane.showMessageDialog(null, saveMessage, "Information", 1);
    }

    private void processInitialize() {
        ArrayList listOfInitial = this.interactiveSimulation.getInteractiveParameterList("initial value");
        this.setSelectedModelTab();
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        int i = 0;
        while ((long)i < lstSBase.size()) {
            Species species = (Species)lstSBase.get((long)i);
            int k = 0;
            while (k < this.listOfOriginSpecies.size()) {
                Species origin = (Species)this.listOfOriginSpecies.get(k);
                if (origin.getId().equals(species.getId())) {
                    if (origin.isSetInitialAmount()) {
                        species.setInitialAmount(origin.getInitialAmount());
                    } else {
                        species.setInitialConcentration(origin.getInitialConcentration());
                    }
                    species.setBoundaryCondition(origin.getBoundaryCondition());
                    species.setConstant(origin.getConstant());
                    int j = 0;
                    while (j < listOfInitial.size()) {
                        SliderValue sv = (SliderValue)listOfInitial.get(j);
                        if (sv.getTarget().equals(species.getId())) {
                            if (origin.isSetInitialAmount()) {
                                sv.setValue(String.valueOf(origin.getInitialAmount()));
                            } else {
                                sv.setValue(String.valueOf(origin.getInitialConcentration()));
                            }
                        }
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
        ArrayList listOfParam = this.interactiveSimulation.getInteractiveParameterList("parameter value");
        ListOf lstGlobalParam = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        lstSBase = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        int index = 0;
        if (lstGlobalParam.size() > 0L) {
            int j = 0;
            while ((long)j < lstGlobalParam.size()) {
                Parameter parameter = (Parameter)lstGlobalParam.get((long)j);
                Parameter originparameter = (Parameter)this.listOfOriginGlobalParameters.get(index);
                parameter.setValue(originparameter.getValue());
                parameter.setConstant(originparameter.getConstant());
                SliderValue sv = (SliderValue)listOfParam.get(index++);
                sv.setValue(String.valueOf(originparameter.getValue()));
                ++j;
            }
        }
        index = 0;
        int i2 = 0;
        while ((long)i2 < lstSBase.size()) {
            Reaction reaction = (Reaction)lstSBase.get((long)i2);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            int j = 0;
            while ((long)j < lstParameter.size()) {
                Parameter parameter = (Parameter)lstParameter.get((long)j);
                Parameter originparameter = (Parameter)this.listOfOriginReactions.get(index);
                parameter.setValue(originparameter.getValue());
                parameter.setConstant(originparameter.getConstant());
                SliderValue sv = (SliderValue)listOfParam.get(index++);
                sv.setValue(String.valueOf(originparameter.getValue()));
                ++j;
            }
            ++i2;
        }
        this.isChanged = false;
        i2 = 0;
        while (i2 < 7) {
            this.SBaseChanged(i2);
            ++i2;
        }
        this.processTableReload(true);
        this.spnSpan.setValue(Double.parseDouble(this.getTimeSpan().getSpan()));
        this.spnStep.setValue(Double.parseDouble(this.getTimeSpan().getStep()));
        double rt = Double.parseDouble(this.errorTolerance.getRelativeTolerance());
        int loadedValue = (int)Math.log10(rt);
        this.errorToleranceSpinner.setValue(loadedValue);
        if ("SOSlib".equals(this.solver.getSolverName())) {
            this.rbSoslib.setSelected(true);
        } else if ("COPASI".equals(this.solver.getSolverName())) {
            this.rbCopasi.setSelected(true);
            if (this.tabChangeAmount != null) {
                this.tabPane.setEnabledAt(2, false);
            }
        } else if ("SimulationCore".equals(this.solver.getSolverName())) {
            this.rbSimulationCore.setSelected(true);
            if (this.tabChangeAmount != null) {
                this.tabPane.setEnabledAt(2, false);
            }
        }
    }

    public void processTableReload(boolean initialize) {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        this.setSpeciesData(lstSBase);
        int index = this.tabPane.getSelectedIndex();
        this.tabPane.remove(this.tabSpecies);
        this.tabPane.remove(this.tabParameters);
        this.tabPane.remove(this.tabChangeAmount);
        this.tabPane.remove(this.tabParameterScan);
        this.tabPane.remove(this.tabTabScanInteractive);
        this.tabPane.remove(this.tabResult);
        TableColumnModel tm = this.tabSpecies.getColmunModel();
        this.tabSpecies = new TabSpecies(this.sbmlPanelLists, this);
        this.tabSpecies.setColmunModel(tm);
        this.tabSpecies.addSBaseEditorListener(this);
        this.tabPane.add(this.tabSpecies, "Species", 0);
        this.tabChangeAmount = new TabChangeAmount(this, this.changeAmount, this.sbmlPanelLists, this.tabSpecies, this.tabPlotSetting);
        this.tabSpecies.setTabChangeAmount(this.tabChangeAmount);
        tm = this.tabParameters.getColmunModel();
        this.tabParameters = new TabParameters(this.sbmlPanelLists, this);
        this.tabParameters.setColmunModel(tm);
        this.tabParameters.addSBaseEditorListener(this);
        this.tabPane.add(this.tabParameters, "Parameters", 1);
        this.tabPane.add(this.tabChangeAmount, "Change amount", 2);
        this.tabParameterScan = new TabParameterScan(this, this.paramaterScan, this.sbmlPanelLists);
        this.tabPane.add(this.tabParameterScan, "Parameter Scan", 3);
        boolean isrbInitialSelected = this.tabTabScanInteractive.isrbInitialSelected();
        String[][] tblDataStorageSpecies = null;
        String[][] tblDataStorageReactions = null;
        tblDataStorageSpecies = this.interactiveSimulation.getTblDataStorage(this.interactiveSimulation.getInteractiveParameterList("initial value"));
        tblDataStorageReactions = this.interactiveSimulation.getTblDataStorage(this.interactiveSimulation.getInteractiveParameterList("parameter value"));
        this.tabTabScanInteractive = new TabParameterScanInteractive(this.interactiveSimulation, this.sbmlPanelLists, this, this.tabSpecies, this.tabParameters, initialize);
        this.tabPane.add(this.tabTabScanInteractive, "Interactive Simulation", 4);
        this.tabPane.add(this.tabResult, "Results", 5);
        this.tabPane.repaint();
        if (initialize) {
            this.tabTabScanInteractive.setDefineRangeValue(tblDataStorageReactions, false);
            this.tabPane.setSelectedIndex(0);
        } else {
            if (isrbInitialSelected) {
                tblDataStorageReactions = this.interactiveSimulation.getTblDataStorage(tblDataStorageReactions, this.interactiveSimulation.getTblDataStorage(this.interactiveSimulation.getInteractiveParameterList("parameter value")));
                this.tabTabScanInteractive.setDefineRangeValue(tblDataStorageReactions, false);
                tblDataStorageSpecies = this.interactiveSimulation.getTblDataStorage(tblDataStorageSpecies, this.interactiveSimulation.getTblDataStorage(this.interactiveSimulation.getInteractiveParameterList("initial value")));
                this.tabTabScanInteractive.setDefineRangeValue(tblDataStorageSpecies, true);
            } else {
                tblDataStorageSpecies = this.interactiveSimulation.getTblDataStorage(tblDataStorageSpecies, this.interactiveSimulation.getTblDataStorage(this.interactiveSimulation.getInteractiveParameterList("initial value")));
                this.tabTabScanInteractive.setDefineRangeValue(tblDataStorageSpecies, true);
                tblDataStorageReactions = this.interactiveSimulation.getTblDataStorage(tblDataStorageReactions, this.interactiveSimulation.getTblDataStorage(this.interactiveSimulation.getInteractiveParameterList("parameter value")));
                this.tabTabScanInteractive.setDefineRangeValue(tblDataStorageReactions, false);
            }
            this.tabTabScanInteractive.setrbInitialSelected(isrbInitialSelected);
            this.tabPane.setSelectedIndex(index);
        }
    }

    private void importAction() {
        String path = PoliteFileDialog.getSelectedFilePath("Select file", ".csv", 0);
        if (path == null) {
            return;
        }
        try {
            FileReader reader = new FileReader(path);
            BufferedReader in = new BufferedReader(reader);
            String line = in.readLine();
            StringTokenizer token = new StringTokenizer(line, ",");
            token.nextToken();
            String span = token.nextToken();
            double dspan = Double.parseDouble(span);
            double span2 = Double.parseDouble(this.changeAmount.getSpan());
            if (dspan != span2) {
                JOptionPane.showMessageDialog(null, "Couldn't adjust [End Time] values between this simulation setting and the imported file", "WARN", 0);
                return;
            }
            line = in.readLine();
            token = new StringTokenizer(line, ",");
            token.nextToken();
            String step = token.nextToken();
            double dstep = Double.parseDouble(step);
            double step2 = Double.parseDouble(this.changeAmount.getStep());
            if (dstep != step2) {
                JOptionPane.showMessageDialog(null, "Couldn't adjust [Num. of Points] values between this simulation setting and the imported file", "WARN", 0);
                return;
            }
            line = in.readLine();
            String[][] data = this.changeAmount.getAmounts();
            String[][] replaceData = new String[data.length][data[0].length];
            int lineCount = 0;
            while ((line = in.readLine()) != null) {
                String s;
                int l = 0;
                int i = 0;
                boolean endflg = true;
                ArrayList<String> rowData = new ArrayList<String>();
                boolean includeComma = false;
                StringBuffer buf = new StringBuffer();
                while (endflg) {
                    i = line.indexOf(",", l);
                    if (i != -1) {
                        s = line.substring(l, i);
                        if (s.indexOf("\"") != -1 && !includeComma) {
                            includeComma = true;
                            buf.append(s);
                            l = i + 1;
                            continue;
                        }
                        if (s.indexOf("\"") == s.length() - 1 && includeComma) {
                            buf.append("," + s);
                            includeComma = false;
                            s = buf.toString();
                            i = s.length();
                            s = s.substring(1, s.length() - 1);
                            buf = new StringBuffer();
                        } else if (includeComma) {
                            buf.append("," + s);
                            l = i + 1;
                            continue;
                        }
                        rowData.add(s);
                        l = i + 1;
                        continue;
                    }
                    rowData.add(line.substring(l, line.length()));
                    endflg = false;
                }
                i = 0;
                while (i < rowData.size()) {
                    double ss;
                    String initialValue;
                    double ini;
                    s = (String)rowData.get(i);
                    if (s.equals("null")) {
                        s = "";
                    }
                    if (i == 0) {
                        String speciesName = data[lineCount][i];
                        if (!speciesName.equals(s)) {
                            JOptionPane.showMessageDialog(null, "Couldn't adjust [SpeciesNames] between this model and the imported file", "WARN", 0);
                            return;
                        }
                    } else if (i == 1 && (ini = Double.parseDouble(initialValue = data[lineCount][i])) != (ss = Double.parseDouble(s))) {
                        JOptionPane.showMessageDialog(null, "Couldn't adjust [InitialValue] between this model and the imported file", "WARN", 0);
                        return;
                    }
                    replaceData[lineCount][i] = s;
                    ++i;
                }
                ++lineCount;
            }
            int i = 0;
            while (i < replaceData.length) {
                int k = 0;
                while (k < replaceData[0].length) {
                    this.changeAmount.amounts[i][k] = replaceData[i][k];
                    ++k;
                }
                ++i;
            }
            in.close();
            reader.close();
            this.tabChangeAmount.setLblChangeAmount();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Illegal file format.", "WARN", 0);
        }
    }

    private void exportAction() {
        String path = PoliteFileDialog.getSelectedFilePath("Select file", ".csv", 1);
        if (path == null) {
            return;
        }
        try {
            String comma = ",";
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("Span" + comma + this.changeAmount.getSpan());
            bw.newLine();
            bw.write("Step" + comma + this.changeAmount.getStep());
            bw.newLine();
            int i = 0;
            while (i < this.changeAmount.getHeaderName().size()) {
                String header = (String)this.changeAmount.getHeaderName().get(i);
                bw.write(header);
                if (i + 1 < this.changeAmount.getHeaderName().size()) {
                    bw.write(comma);
                }
                ++i;
            }
            bw.newLine();
            String[][] data = this.changeAmount.getAmounts();
            int i2 = 0;
            while (i2 < data.length) {
                int k = 0;
                while (k < data[0].length) {
                    String param = data[i2][k];
                    if (param == null) {
                        param = "";
                    } else if (param.indexOf(comma) != -1) {
                        param = "\"" + param + "\"";
                    }
                    bw.write(param);
                    if (k + 1 < data[0].length) {
                        bw.write(comma);
                    }
                    ++k;
                }
                bw.newLine();
                ++i2;
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void calcAndDrawResultImage() {
        boolean selectedSpecies = true;
        boolean selectedCompartments = false;
        boolean selectedParameters = false;
        boolean selectedFluxes = false;
        double maxRange = -1.0;
        double minV = -1.0;
        double maxV = -1.0;
        double timV = -1.0;
        String scal = "";
        if (this.listOfOriginSpecies.size() == 0) {
            selectedSpecies = false;
            selectedParameters = true;
        }
        SBMLResults results = null;
        try {
            results = this.solveODE2(this.rbCopasi.isSelected(), this.rbSimulationCore.isSelected());
        }
        catch (SOSlibException e) {
            JOptionPane.showMessageDialog(null, "Simulation Failed: \n" + e.getMessage(), "Error", 0);
            return;
        }
        if (this.srp != null) {
            selectedSpecies = this.srp.getCheckSpeciesSelected();
            selectedCompartments = this.srp.getCheckCompartmentSelected();
            selectedParameters = this.srp.getCheckParameterSelected();
            selectedFluxes = this.srp.getCheckFluxSelected();
            if (selectedSpecies || selectedSpecies || selectedParameters || selectedFluxes) {
                minV = this.srp.getMinRangeSpinner();
                maxV = this.srp.getMaxRangeSpinner();
                timV = this.srp.getTimeIntervalSpinner();
                scal = this.srp.getScaleListSelected();
            }
            if (this.isBeforeExecParamScan && this.srp.getListOfResult() != null) {
                selectedSpecies = true;
                selectedCompartments = false;
                selectedParameters = false;
                selectedFluxes = false;
            }
        }
        this.srp = new SimulationResultPanel(this, this.sbmlPanelLists);
        this.srp.setCheckSpeciesSelected(true);
        this.srp.setCheckCompartmentSelected(true);
        this.srp.setCheckParameterSelected(true);
        this.srp.setCheckFluxSelected(true);
        if (this.tabResult.isOverlayMode() || this.isBeforeExecParamScan && this.srp.getListOfResult() != null) {
            this.speciesColorSet = null;
            this.speciesVisible = null;
        }
        this.srp.setData(results, this.speciesColorSet, this.speciesVisible);
        int divLocation = this.splitMainWindow.getDividerLocation();
        ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, this.srp.showViewer());
        this.splitMainWindow.setDividerLocation(divLocation);
        this.createAllResultTab();
        this.speciesColorSet = this.srp.getSpeciesColorSet();
        this.speciesVisible = this.srp.getSpeciesVisible();
        this.listOfResult = new ArrayList();
        this.listOfResult.add(this.srp.getAllResults());
        this.tabResult.setWritingButton(false);
        this.tabResult.setOverlayMode(false);
        this.tabResult.reload(this.listOfResult);
        this.srp.setCheckSpeciesSelected(selectedSpecies);
        this.srp.setCheckCompartmentSelected(selectedCompartments);
        this.srp.setCheckParameterSelected(selectedParameters);
        this.srp.setCheckFluxSelected(selectedFluxes);
        this.srp.checkBoxAction(null);
        maxRange = this.srp.getMaxRangeNow();
        if (minV >= 0.0) {
            this.srp.setScaleList(scal);
            this.srp.setMinRangeSpinner(minV);
            this.srp.setMaxRangeSpinner(maxV);
            this.srp.setTimeIntervalSpinner(timV);
            if (this.beforeMaxRange != maxRange) {
                this.srp.setMaxRangeSpinner(maxRange);
            }
            if (this.beforeEndTime != (Double)this.spnSpan.getValue()) {
                this.srp.setTimeIntervalSpinner((Double)this.spnSpan.getValue());
            }
        }
        this.beforeEndTime = (Double)this.spnSpan.getValue();
        this.beforeMaxRange = maxRange;
        this.srp.updateSpinnerPositon(this.exeCheck.isSelected());
    }

    public void calcAndDrawLoadResultImage(SBMLResults results, boolean selectedSpecies, boolean selectedCompartments, boolean selectedParameters, boolean selectedFluxes) {
        this.stopBlink();
        double maxRange = -1.0;
        double minV = -1.0;
        double maxV = -1.0;
        double timV = -1.0;
        String scal = "";
        if (this.srp != null && (selectedSpecies || selectedSpecies || selectedParameters || selectedFluxes)) {
            minV = this.srp.getMinRangeSpinner();
            maxV = this.srp.getMaxRangeSpinner();
            timV = this.srp.getTimeIntervalSpinner();
            scal = this.srp.getScaleListSelected();
        }
        this.srp = new SimulationResultPanel(this, this.sbmlPanelLists);
        boolean updateTable = false;
        Thread t2 = new Thread(new MyTask(this));
        if (results == null) {
            try {
                results = this.solveODE2(this.rbCopasi.isSelected(), this.rbSimulationCore.isSelected());
            }
            catch (SOSlibException e) {
                JOptionPane.showMessageDialog(null, "Simulation Failed: \n" + e.getMessage(), "Error", 0);
                return;
            }
            updateTable = true;
        }
        this.srp.setCheckSpeciesSelected(true);
        this.srp.setCheckCompartmentSelected(true);
        this.srp.setCheckParameterSelected(true);
        this.srp.setCheckFluxSelected(true);
        try {
            if (results.getPath() != null && !results.getPath().equals("")) {
                results.getOutputFileFromSedXml(results.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int lstSize = this.listOfSpeciesData.size();
        String[] species = new String[lstSize];
        int i = 0;
        while (i < this.listOfSpeciesData.size()) {
            SpeciesData sp = (SpeciesData)this.listOfSpeciesData.get(i);
            species[i] = sp.getSpecies().getId();
            ++i;
        }
        TimeCourse s_values = results.getSpecies();
        if (s_values != null) {
            s_values.setNames(species);
        }
        ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        lstSize = (int)lstReaction.size();
        String[] reactions = new String[lstSize];
        int i2 = 0;
        while (i2 < lstSize) {
            Reaction reaction = (Reaction)lstReaction.get((long)i2);
            reactions[i2] = reaction.getId();
            ++i2;
        }
        TimeCourse f_values = results.getFluxes();
        if (f_values != null) {
            f_values.setNames(reactions);
        }
        if (this.tabResult.isOverlayMode() || this.isBeforeExecParamScan) {
            this.speciesColorSet = null;
            this.speciesVisible = null;
            this.isBeforeExecParamScan = false;
        }
        this.srp.setData(results, this.speciesColorSet, this.speciesVisible);
        int divLocation = this.splitMainWindow.getDividerLocation();
        ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, this.srp.showViewer());
        this.splitMainWindow.setDividerLocation(divLocation);
        this.createAllResultTab();
        this.speciesColorSet = this.srp.getSpeciesColorSet();
        this.speciesVisible = this.srp.getSpeciesVisible();
        if (updateTable) {
            this.listOfResult = new ArrayList();
            this.listOfResult.add(this.srp.getAllResults());
            this.tabResult.setOverlayMode(false);
            this.tabResult.reload(this.listOfResult);
        }
        this.srp.setCheckSpeciesSelected(selectedSpecies);
        this.srp.setCheckCompartmentSelected(selectedCompartments);
        this.srp.setCheckParameterSelected(selectedParameters);
        this.srp.setCheckFluxSelected(selectedFluxes);
        this.srp.checkBoxAction(null);
        maxRange = this.srp.getMaxRangeNow();
        if (minV >= 0.0) {
            this.srp.setScaleList(scal);
            this.srp.setMinRangeSpinner(minV);
            this.srp.setMaxRangeSpinner(maxV);
            this.srp.setTimeIntervalSpinner(timV);
            if (this.beforeMaxRange != maxRange) {
                this.srp.setMaxRangeSpinner(maxRange);
            }
            if (this.beforeEndTime != (Double)this.spnSpan.getValue()) {
                this.srp.setTimeIntervalSpinner((Double)this.spnSpan.getValue());
            }
        }
        this.beforeEndTime = (Double)this.spnSpan.getValue();
        this.beforeMaxRange = maxRange;
        this.srp.updateSpinnerPositon(this.exeCheck.isSelected());
    }

    private void createAllResultTab() {
        JTabbedPane tab = new JTabbedPane();
        SBMLResults result = this.srp.getAllResults();
        TimeCourse species = result.getSpecies();
        JTable tableSpecies = new JTable();
        tableSpecies.setColumnSelectionAllowed(true);
        if (species != null && species.getNum_val() > 0) {
            DefaultTableModel modelSpecies = new DefaultTableModel(species.getValuesToObject(), species.getNamesToObject());
            tableSpecies.setModel(modelSpecies);
            tableSpecies.setAutoResizeMode(0);
        }
        JScrollPane scrollSpecies = new JScrollPane();
        scrollSpecies.setRowHeaderView(new TableRowHeader(tableSpecies, this.getResultTableRowHeader(result.getTime())));
        scrollSpecies.setCorner("UPPER_LEFT_CORNER", new CornerHeader(tableSpecies, this.getCornerHeader()));
        scrollSpecies.getViewport().add(tableSpecies);
        JPanel speciesPanel = new JPanel(new BorderLayout());
        speciesPanel.add((Component)scrollSpecies, "Center");
        tab.addTab("species", speciesPanel);
        TimeCourse fluxes = result.getFluxes();
        JTable tableFluxes = new JTable();
        tableFluxes.setColumnSelectionAllowed(true);
        if (fluxes != null && fluxes.getNum_val() > 0) {
            DefaultTableModel modelFluxes = new DefaultTableModel(fluxes.getValuesToObject(), fluxes.getNamesToObject());
            tableFluxes.setModel(modelFluxes);
            tableFluxes.setAutoResizeMode(0);
        }
        JScrollPane scrollFluxes = new JScrollPane();
        scrollFluxes.setRowHeaderView(new TableRowHeader(tableFluxes, this.getResultTableRowHeader(result.getTime())));
        scrollFluxes.setCorner("UPPER_LEFT_CORNER", new CornerHeader(tableFluxes, this.getCornerHeader()));
        scrollFluxes.getViewport().add(tableFluxes);
        JPanel fluxesPanel = new JPanel(new BorderLayout());
        fluxesPanel.add((Component)scrollFluxes, "Center");
        tab.addTab("fluxes", fluxesPanel);
        TimeCourse parameters = result.getParameters();
        JTable tableParameters = new JTable();
        tableParameters.setColumnSelectionAllowed(true);
        if (parameters != null && parameters.getNum_val() > 0) {
            DefaultTableModel modelParameters = new DefaultTableModel(parameters.getValuesToObject(), parameters.getNamesToObject());
            tableParameters.setModel(modelParameters);
            tableParameters.setAutoResizeMode(0);
        }
        JScrollPane scrollParameters = new JScrollPane();
        scrollParameters.setRowHeaderView(new TableRowHeader(tableParameters, this.getResultTableRowHeader(result.getTime())));
        scrollParameters.setCorner("UPPER_LEFT_CORNER", new CornerHeader(tableParameters, this.getCornerHeader()));
        scrollParameters.getViewport().add(tableParameters);
        JPanel parametersPanel = new JPanel(new BorderLayout());
        parametersPanel.add((Component)scrollParameters, "Center");
        tab.addTab("parameters", parametersPanel);
        TimeCourse compartments = result.getCompartments();
        JTable tableCompartments = new JTable();
        tableCompartments.setColumnSelectionAllowed(true);
        if (compartments != null && compartments.getNum_val() > 0) {
            DefaultTableModel modelCompartments = new DefaultTableModel(compartments.getValuesToObject(), compartments.getNamesToObject());
            tableCompartments.setModel(modelCompartments);
            tableCompartments.setAutoResizeMode(0);
        }
        JScrollPane scrollCompartments = new JScrollPane();
        scrollCompartments.setRowHeaderView(new TableRowHeader(tableCompartments, this.getResultTableRowHeader(result.getTime())));
        scrollCompartments.setCorner("UPPER_LEFT_CORNER", new CornerHeader(tableCompartments, this.getCornerHeader()));
        scrollCompartments.getViewport().add(tableCompartments);
        JPanel compartmentsPanel = new JPanel(new BorderLayout());
        compartmentsPanel.add((Component)scrollCompartments, "Center");
        tab.addTab("compartments", compartmentsPanel);
        ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(1, tab);
    }

    public String getCornerHeader() {
        return " time / names ";
    }

    private Vector getResultTableRowHeader(double[] time) {
        Vector<String> listOfHeader = new Vector<String>();
        int i = 0;
        while (i < time.length) {
            listOfHeader.add(Double.toString(time[i]));
            ++i;
        }
        return listOfHeader;
    }

    public void calcAndDrawLoadResultImage(Boolean[] listOfVisibleResults, Boolean[] listOfOverlayedSpecies, boolean selectedSpecies, boolean selectedCompartments, boolean selectedParameters, boolean selectedFluxes, boolean isSpeciesColorReset) {
        double maxRange = -1.0;
        double minV = -1.0;
        double maxV = -1.0;
        double timV = -1.0;
        String scal = "";
        if (this.srp != null && (selectedSpecies || selectedSpecies || selectedParameters || selectedFluxes)) {
            minV = this.srp.getMinRangeSpinner();
            maxV = this.srp.getMaxRangeSpinner();
            timV = this.srp.getTimeIntervalSpinner();
            scal = this.srp.getScaleListSelected();
        }
        this.srp = new SimulationResultPanel(this, this.sbmlPanelLists);
        this.srp.setCheckSpeciesSelected(true);
        this.srp.setCheckCompartmentSelected(true);
        this.srp.setCheckParameterSelected(true);
        this.srp.setCheckFluxSelected(true);
        if (isSpeciesColorReset) {
            this.speciesColorSet = null;
            this.speciesVisible = null;
        }
        this.srp.setData(listOfVisibleResults, listOfOverlayedSpecies, this.listOfResult, this.speciesColorSet, this.speciesVisible);
        this.srp.setCheckSpeciesSelected(selectedSpecies);
        this.srp.setCheckCompartmentSelected(selectedCompartments);
        this.srp.setCheckParameterSelected(selectedParameters);
        this.srp.setCheckFluxSelected(selectedFluxes);
        this.srp.checkBoxAction(null);
        int divLocation = this.splitMainWindow.getDividerLocation();
        ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, this.srp.showViewer());
        this.splitMainWindow.setDividerLocation(divLocation);
        this.createAllResultTab();
        this.speciesColorSet = this.srp.getSpeciesColorSet();
        this.speciesVisible = this.srp.getSpeciesVisible();
        maxRange = this.srp.getMaxRangeNow();
        if (minV >= 0.0) {
            this.srp.setScaleList(scal);
            this.srp.setMinRangeSpinner(minV);
            this.srp.setMaxRangeSpinner(maxV);
            this.srp.setTimeIntervalSpinner(timV);
            if (this.beforeMaxRange != maxRange) {
                this.srp.setMaxRangeSpinner(maxRange);
            }
            if (this.beforeEndTime != (Double)this.spnSpan.getValue()) {
                this.srp.setTimeIntervalSpinner((Double)this.spnSpan.getValue());
            }
        }
        this.beforeEndTime = (Double)this.spnSpan.getValue();
        this.beforeMaxRange = maxRange;
        this.srp.updateSpinnerPositon(this.exeCheck.isSelected());
    }

    public void calcChangeAmount1ParameterScanBatch() throws SOSlibException {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        ChangeAmount amount = this.tabChangeAmount.getChangeAmount();
        ArrayList listOfHeader = amount.getHeaderName();
        ArrayList listOfSpecies = amount.getSpeciesList();
        String[][] tblDataStorage = amount.getAmounts();
        String span = amount.getSpan();
        String step = String.valueOf(this.spnStep.getValue());
        int scale = StringTool.getScale(Double.parseDouble(span), Double.parseDouble(step));
        double range = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(span) / Double.parseDouble(step), scale));
        String startSpan = "0";
        String endSpan = "";
        this.listOfResult = new ArrayList();
        String target = "";
        double from = 0.0;
        double to = 0.0;
        double interval = 0.0;
        ParameterScan scan = this.tabParameterScan.getParameterScan();
        if (this.tabParameterScan.isCheckScan1()) {
            from = Double.parseDouble(scan.getFrom(0));
            to = Double.parseDouble(scan.getTo(0));
            interval = Double.parseDouble(scan.getInterval(0));
            target = scan.getTarget(0);
        } else if (this.tabParameterScan.isCheckScan2()) {
            from = Double.parseDouble(scan.getFrom(1));
            to = Double.parseDouble(scan.getTo(1));
            interval = Double.parseDouble(scan.getInterval(1));
            target = scan.getTarget(1);
        } else {
            return;
        }
        boolean incremented = true;
        if (from > to) {
            incremented = false;
        }
        int scale1 = StringTool.getScale(from, interval);
        this.listOfResult = new ArrayList();
        String[] specieNames = new String[listOfSpecies.size()];
        ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        String[] reactions = new String[(int)lstReaction.size()];
        Thread t2 = new Thread(new MyTask(this));
        this.progressBar.setDrawString(this.EXECUTING);
        this.progressBar.setActive(true);
        t2.start();
        do {
            ArrayList<SBMLResults> stackOfResult = new ArrayList<SBMLResults>();
            span = amount.getSpan();
            step = String.valueOf(this.spnStep.getValue());
            startSpan = "0";
            endSpan = "";
            int k = 0;
            while (k < listOfSpecies.size()) {
                Species specie = (Species)lstSBase.get((long)k);
                if (specie.getName().equals(target)) {
                    if (specie.isSetInitialAmount()) {
                        specie.setInitialAmount(from);
                    } else {
                        specie.setInitialConcentration(from);
                    }
                }
                specieNames[k] = specie.getName();
                ++k;
            }
            StringTokenizer token = new StringTokenizer(target, ":");
            String rid = "";
            String id = "";
            if (token.countTokens() == 2) {
                rid = token.nextToken();
                id = token.nextToken();
            }
            int i = 0;
            while ((long)i < lstReaction.size()) {
                Reaction reaction = (Reaction)lstReaction.get((long)i);
                if (reaction.getId().equals(rid)) {
                    KineticLaw law = reaction.getKineticLaw();
                    ListOfParameters lstParameter = law.getListOfParameters();
                    int j = 0;
                    while ((long)j < lstParameter.size()) {
                        Parameter parameter = (Parameter)lstParameter.get((long)j);
                        if (parameter.getId().equals(id)) {
                            parameter.setValue(from);
                            break;
                        }
                        ++j;
                    }
                }
                reactions[i] = reaction.getId();
                ++i;
            }
            i = 2;
            while (i < listOfHeader.size()) {
                String header = (String)listOfHeader.get(i);
                boolean flg = false;
                int k2 = 0;
                while (k2 < listOfSpecies.size()) {
                    String data = tblDataStorage[k2][i];
                    if (data != null && !data.equals("")) {
                        flg = true;
                        endSpan = header;
                        break;
                    }
                    ++k2;
                }
                if (flg) {
                    double dspan = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(endSpan) - Double.parseDouble(startSpan), scale));
                    SBMLResults beforeResults = null;
                    try {
                        beforeResults = this.solveODE2(Double.toString(dspan), StringTool.convertNumberFormat(Double.toString(dspan / range), scale), startSpan, endSpan);
                    }
                    catch (SOSlibException e) {
                        t2.stop();
                        this.progressBar.setDrawString("");
                        this.progressBar.setActive(false);
                        this.progressBar.setDrawStart(0);
                        this.paintImmediately();
                        this.repaint();
                        throw e;
                    }
                    beforeResults.setParameterInfo(String.valueOf(startSpan) + "to" + endSpan);
                    stackOfResult.add(beforeResults);
                    startSpan = endSpan;
                    int k3 = 0;
                    while (k3 < listOfSpecies.size()) {
                        TimeCourse species;
                        Species specie = (Species)lstSBase.get((long)k3);
                        String initialQuantity = tblDataStorage[k3][i];
                        if (initialQuantity != null && !initialQuantity.equals("")) {
                            if (specie.isSetInitialAmount()) {
                                specie.setInitialAmount(Double.parseDouble(initialQuantity));
                            } else {
                                specie.setInitialConcentration(Double.parseDouble(initialQuantity));
                            }
                            species = beforeResults.getSpecies();
                            species.setValues(species.getTimepoints() - 1, k3, Double.parseDouble(initialQuantity));
                        } else {
                            species = beforeResults.getSpecies();
                            double resultValue = species.getValue(beforeResults.getTimepoints() - 1, k3);
                            if (specie.isSetInitialAmount()) {
                                specie.setInitialAmount(resultValue);
                            } else {
                                specie.setInitialConcentration(resultValue);
                            }
                        }
                        ++k3;
                    }
                }
                ++i;
            }
            if (!span.equals(startSpan)) {
                endSpan = span;
                double dspan = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(span) - Double.parseDouble(startSpan), scale));
                SBMLResults beforeResults = this.solveODE2(Double.toString(dspan), StringTool.convertNumberFormat(Double.toString(dspan / range), scale), startSpan, endSpan);
                beforeResults.setParameterInfo(String.valueOf(startSpan) + "to" + endSpan);
                stackOfResult.add(beforeResults);
            }
            int resultCount = 0;
            int i2 = 0;
            while (i2 < stackOfResult.size()) {
                SBMLResults results = (SBMLResults)stackOfResult.get(i2);
                resultCount += results.getTimepoints();
                if (i2 != 0) {
                    --resultCount;
                }
                ++i2;
            }
            ListOf listOfReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
            SBMLResults newResults = new SBMLResults(resultCount, new double[resultCount]);
            TimeCourse newSpecies = new TimeCourse(resultCount, listOfSpecies.size());
            double[][] speciesvalues = new double[resultCount][listOfSpecies.size() + 1];
            newSpecies.setValues(speciesvalues);
            newResults.setSpecies(newSpecies);
            TimeCourse newFluxes = new TimeCourse(resultCount, (int)listOfReaction.size());
            double[][] fluxesvalues = new double[resultCount][(int)listOfReaction.size() + 1];
            newFluxes.setValues(fluxesvalues);
            newResults.setFluxes(newFluxes);
            int index = 0;
            double[] timePoint = new double[resultCount];
            timePoint[0] = 0.0;
            int i3 = 0;
            while (i3 < stackOfResult.size()) {
                SBMLResults results = (SBMLResults)stackOfResult.get(i3);
                TimeCourse species = results.getSpecies();
                double[][] speciedata = species.getValues();
                TimeCourse fluxes = results.getFluxes();
                double[][] fluxData = fluxes.getValues();
                int k4 = 0;
                if (i3 != 0) {
                    ++k4;
                }
                while (k4 < results.getTimepoints()) {
                    speciesvalues[index][0] = range * (double)index;
                    fluxesvalues[index][0] = range * (double)index;
                    timePoint[index] = range * (double)index;
                    int j = 0;
                    while (j < listOfSpecies.size()) {
                        speciesvalues[index][j] = speciedata[k4][j];
                        ++j;
                    }
                    j = 0;
                    while ((long)j < listOfReaction.size()) {
                        fluxesvalues[index][j] = fluxData[k4][j];
                        ++j;
                    }
                    ++index;
                    ++k4;
                }
                ++i3;
            }
            newResults.setTimepoints(newResults.getTimepoints());
            newResults.setTime(timePoint);
            newResults.setParameterInfo(String.valueOf(target) + " = " + from);
            newResults.setParameterInfo(newResults.getParameterInfo().replace(':', '_'));
            newSpecies.setNames(specieNames);
            newFluxes.setNames(reactions);
            this.listOfResult.add(newResults);
        } while (!(incremented ? (from = Double.parseDouble(StringTool.convertNumberFormat(from + interval, scale1))) > to : (from = Double.parseDouble(StringTool.convertNumberFormat(from - interval, scale1))) < to));
        int i = 0;
        while (i < listOfSpecies.size()) {
            Species specie = (Species)lstSBase.get((long)i);
            String initialQuantity = tblDataStorage[i][1];
            if (specie.isSetInitialAmount()) {
                specie.setInitialAmount(Double.parseDouble(initialQuantity));
            } else {
                specie.setInitialConcentration(Double.parseDouble(initialQuantity));
            }
            ++i;
        }
        t2.stop();
        this.progressBar.setDrawString("");
        this.progressBar.setActive(false);
        this.progressBar.setDrawStart(0);
        this.paintImmediately();
        this.repaint();
        this.tabResult.setWritingButton(false);
        this.tabResult.setOverlayMode(true);
        this.tabResult.reload(this.listOfResult);
        JOptionPane.showMessageDialog(null, "The simulation was completed.", "Information", 1);
        this.startBlink();
    }

    public void calcChangeAmount2ParameterScanBatch() throws SOSlibException {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        ChangeAmount amount = this.tabChangeAmount.getChangeAmount();
        ArrayList listOfHeader = amount.getHeaderName();
        ArrayList listOfSpecies = amount.getSpeciesList();
        String[][] tblDataStorage = amount.getAmounts();
        String span = amount.getSpan();
        String step = String.valueOf(this.spnStep.getValue());
        int scale = StringTool.getScale(Double.parseDouble(span), Double.parseDouble(step));
        double range = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(span) / Double.parseDouble(step), scale));
        String startSpan = "0";
        String endSpan = "";
        this.listOfResult = new ArrayList();
        ParameterScan scan = this.tabParameterScan.getParameterScan();
        String target1 = "";
        double from1 = 0.0;
        double to1 = 0.0;
        double interval1 = 0.0;
        String target2 = "";
        double from2 = 0.0;
        double to2 = 0.0;
        double interval2 = 0.0;
        from1 = Double.parseDouble(scan.getFrom(0));
        to1 = Double.parseDouble(scan.getTo(0));
        interval1 = Double.parseDouble(scan.getInterval(0));
        target1 = scan.getTarget(0);
        boolean incremented1 = true;
        if (from1 > to1) {
            incremented1 = false;
        }
        int scale1 = StringTool.getScale(from1, interval1);
        from2 = Double.parseDouble(scan.getFrom(1));
        to2 = Double.parseDouble(scan.getTo(1));
        interval2 = Double.parseDouble(scan.getInterval(1));
        target2 = scan.getTarget(1);
        boolean incremented2 = true;
        if (from2 > to2) {
            incremented2 = false;
        }
        int scale2 = StringTool.getScale(from2, interval2);
        this.listOfResult = new ArrayList();
        String[] specieNames = new String[listOfSpecies.size()];
        ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        String[] reactions = new String[(int)lstReaction.size()];
        Thread t2 = new Thread(new MyTask(this));
        this.progressBar.setDrawString(this.EXECUTING);
        this.progressBar.setActive(true);
        t2.start();
        do {
            from2 = Double.parseDouble(scan.getFrom(1));
            to2 = Double.parseDouble(scan.getTo(1));
            interval2 = Double.parseDouble(scan.getInterval(1));
            target2 = scan.getTarget(1);
            do {
                ArrayList<SBMLResults> stackOfResult = new ArrayList<SBMLResults>();
                span = amount.getSpan();
                step = String.valueOf(this.spnStep.getValue());
                startSpan = "0";
                endSpan = "";
                int k = 0;
                while (k < listOfSpecies.size()) {
                    Species specie = (Species)lstSBase.get((long)k);
                    if (specie.getName().equals(target1)) {
                        if (specie.isSetInitialAmount()) {
                            specie.setInitialAmount(from1);
                        } else {
                            specie.setInitialConcentration(from1);
                        }
                    } else if (specie.getName().equals(target2)) {
                        if (specie.isSetInitialAmount()) {
                            specie.setInitialAmount(from2);
                        } else {
                            specie.setInitialConcentration(from2);
                        }
                    }
                    specieNames[k] = specie.getName();
                    ++k;
                }
                StringTokenizer token = new StringTokenizer(target1, ":");
                String rid1 = "";
                String id1 = "";
                if (token.countTokens() == 2) {
                    rid1 = token.nextToken();
                    id1 = token.nextToken();
                }
                StringTokenizer token2 = new StringTokenizer(target2, ":");
                String rid2 = "";
                String id2 = "";
                if (token2.countTokens() == 2) {
                    rid2 = token2.nextToken();
                    id2 = token2.nextToken();
                }
                int i = 0;
                while ((long)i < lstReaction.size()) {
                    Parameter parameter;
                    int j;
                    ListOfParameters lstParameter;
                    KineticLaw law;
                    Reaction reaction = (Reaction)lstReaction.get((long)i);
                    if (reaction.getId().equals(rid1)) {
                        law = reaction.getKineticLaw();
                        lstParameter = law.getListOfParameters();
                        j = 0;
                        while ((long)j < lstParameter.size()) {
                            parameter = (Parameter)lstParameter.get((long)j);
                            if (parameter.getId().equals(id1)) {
                                parameter.setValue(from1);
                                break;
                            }
                            ++j;
                        }
                    } else if (reaction.getId().equals(rid2)) {
                        law = reaction.getKineticLaw();
                        lstParameter = law.getListOfParameters();
                        j = 0;
                        while ((long)j < lstParameter.size()) {
                            parameter = (Parameter)lstParameter.get((long)j);
                            if (parameter.getId().equals(id2)) {
                                parameter.setValue(from2);
                                break;
                            }
                            ++j;
                        }
                    }
                    reactions[i] = reaction.getId();
                    ++i;
                }
                i = 2;
                while (i < listOfHeader.size()) {
                    String header = (String)listOfHeader.get(i);
                    boolean flg = false;
                    int k2 = 0;
                    while (k2 < listOfSpecies.size()) {
                        String data = tblDataStorage[k2][i];
                        if (data != null && !data.equals("")) {
                            flg = true;
                            endSpan = header;
                            break;
                        }
                        ++k2;
                    }
                    if (flg) {
                        double dspan = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(endSpan) - Double.parseDouble(startSpan), scale));
                        SBMLResults beforeResults = null;
                        try {
                            beforeResults = this.solveODE2(Double.toString(dspan), StringTool.convertNumberFormat(Double.toString(dspan / range), scale), startSpan, endSpan);
                        }
                        catch (SOSlibException e) {
                            this.progressBar.setDrawString("");
                            this.progressBar.setActive(false);
                            this.progressBar.setDrawStart(0);
                            this.paintImmediately();
                            this.repaint();
                            throw e;
                        }
                        beforeResults.setParameterInfo(String.valueOf(startSpan) + "to" + endSpan);
                        stackOfResult.add(beforeResults);
                        startSpan = endSpan;
                        int k3 = 0;
                        while (k3 < listOfSpecies.size()) {
                            TimeCourse species;
                            Species specie = (Species)lstSBase.get((long)k3);
                            String initialQuantity = tblDataStorage[k3][i];
                            if (initialQuantity != null && !initialQuantity.equals("")) {
                                if (specie.isSetInitialAmount()) {
                                    specie.setInitialAmount(Double.parseDouble(initialQuantity));
                                } else {
                                    specie.setInitialConcentration(Double.parseDouble(initialQuantity));
                                }
                                species = beforeResults.getSpecies();
                                species.setValues(species.getTimepoints() - 1, k3, Double.parseDouble(initialQuantity));
                            } else {
                                species = beforeResults.getSpecies();
                                double resultValue = species.getValue(beforeResults.getTimepoints() - 1, k3);
                                if (specie.isSetInitialAmount()) {
                                    specie.setInitialAmount(resultValue);
                                } else {
                                    specie.setInitialConcentration(resultValue);
                                }
                            }
                            ++k3;
                        }
                    }
                    ++i;
                }
                if (!span.equals(startSpan)) {
                    endSpan = span;
                    double dspan = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(span) - Double.parseDouble(startSpan), scale));
                    SBMLResults beforeResults = this.solveODE2(Double.toString(dspan), StringTool.convertNumberFormat(Double.toString(dspan / range), scale), startSpan, endSpan);
                    beforeResults.setParameterInfo(String.valueOf(startSpan) + "to" + endSpan);
                    stackOfResult.add(beforeResults);
                }
                int resultCount = 0;
                int i2 = 0;
                while (i2 < stackOfResult.size()) {
                    SBMLResults results = (SBMLResults)stackOfResult.get(i2);
                    resultCount += results.getTimepoints();
                    if (i2 != 0) {
                        --resultCount;
                    }
                    ++i2;
                }
                ListOf listOfReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
                SBMLResults newResults = new SBMLResults(resultCount, new double[resultCount]);
                TimeCourse newSpecies = new TimeCourse(resultCount, listOfSpecies.size());
                double[][] speciesvalues = new double[resultCount][listOfSpecies.size() + 1];
                newSpecies.setValues(speciesvalues);
                newResults.setSpecies(newSpecies);
                TimeCourse newFluxes = new TimeCourse(resultCount, (int)listOfReaction.size());
                double[][] fluxesvalues = new double[resultCount][(int)listOfReaction.size() + 1];
                newFluxes.setValues(fluxesvalues);
                newResults.setFluxes(newFluxes);
                int index = 0;
                double[] timePoint = new double[resultCount];
                timePoint[0] = 0.0;
                int i3 = 0;
                while (i3 < stackOfResult.size()) {
                    SBMLResults results = (SBMLResults)stackOfResult.get(i3);
                    TimeCourse species = results.getSpecies();
                    double[][] speciedata = species.getValues();
                    TimeCourse fluxes = results.getFluxes();
                    double[][] fluxData = fluxes.getValues();
                    int k4 = 0;
                    if (i3 != 0) {
                        ++k4;
                    }
                    while (k4 < results.getTimepoints()) {
                        speciesvalues[index][0] = range * (double)index;
                        fluxesvalues[index][0] = range * (double)index;
                        timePoint[index] = range * (double)index;
                        int j = 0;
                        while (j < listOfSpecies.size()) {
                            speciesvalues[index][j] = speciedata[k4][j];
                            ++j;
                        }
                        j = 0;
                        while ((long)j < listOfReaction.size()) {
                            fluxesvalues[index][j] = fluxData[k4][j];
                            ++j;
                        }
                        ++index;
                        ++k4;
                    }
                    ++i3;
                }
                newResults.setTimepoints(newResults.getTimepoints());
                newResults.setTime(timePoint);
                newResults.setParameterInfo(String.valueOf(target1) + " = " + from1 + " , " + target2 + " = " + from2);
                newResults.setParameterInfo(newResults.getParameterInfo().replace(':', '_'));
                newSpecies.setNames(specieNames);
                newFluxes.setNames(reactions);
                this.listOfResult.add(newResults);
            } while (!(incremented2 ? (from2 = Double.parseDouble(StringTool.convertNumberFormat(from2 + interval2, scale2))) > to2 : (from2 = Double.parseDouble(StringTool.convertNumberFormat(from2 - interval2, scale2))) < to2));
        } while (!(incremented1 ? (from1 = Double.parseDouble(StringTool.convertNumberFormat(from1 + interval1, scale1))) > to1 : (from1 = Double.parseDouble(StringTool.convertNumberFormat(from1 - interval1, scale1))) < to1));
        int i = 0;
        while (i < listOfSpecies.size()) {
            Species specie = (Species)lstSBase.get((long)i);
            String initialQuantity = tblDataStorage[i][1];
            if (specie.isSetInitialAmount()) {
                specie.setInitialAmount(Double.parseDouble(initialQuantity));
            } else {
                specie.setInitialConcentration(Double.parseDouble(initialQuantity));
            }
            ++i;
        }
        t2.stop();
        this.progressBar.setDrawString("");
        this.progressBar.setActive(false);
        this.progressBar.setDrawStart(0);
        this.paintImmediately();
        this.repaint();
        this.tabResult.setShowButton(true);
        this.tabResult.setWritingButton(true);
        this.tabResult.setOverlayMode(false);
        this.tabResult.reload(this.listOfResult);
        JOptionPane.showMessageDialog(null, "The simulation was completed.", "Information", 1);
        this.startBlink();
    }

    public void calc1ParameterScanBatch() throws SOSlibException {
        Object[] listOfResults = this.solveODE3(this.rbCopasi.isSelected(), this.rbSimulationCore.isSelected());
        ParameterScan scan = this.tabParameterScan.getParameterScan();
        String target = "";
        double from = 0.0;
        double to = 0.0;
        double interval = 0.0;
        if (scan.doScanParameter(0)) {
            target = scan.getTarget(0);
            from = Double.parseDouble(scan.getFrom(0));
            to = Double.parseDouble(scan.getTo(0));
            interval = Double.parseDouble(scan.getInterval(0));
        } else if (scan.doScanParameter(1)) {
            target = scan.getTarget(1);
            from = Double.parseDouble(scan.getFrom(1));
            to = Double.parseDouble(scan.getTo(1));
            interval = Double.parseDouble(scan.getInterval(1));
        }
        boolean incremented = true;
        if (from > to) {
            incremented = false;
        }
        this.listOfResult = new ArrayList();
        double start = from;
        int scale = StringTool.getScale(start, interval);
        int i = 0;
        while (i < listOfResults.length) {
            SBMLResults result = (SBMLResults)listOfResults[i];
            result.setParameterInfo(String.valueOf(target) + " = " + start);
            result.setParameterInfo(result.getParameterInfo().replace(':', '_'));
            start = incremented ? Double.parseDouble(StringTool.convertNumberFormat(start + interval, scale)) : Double.parseDouble(StringTool.convertNumberFormat(start - interval, scale));
            this.listOfResult.add(result);
            ++i;
        }
        this.tabResult.setWritingButton(false);
        this.tabResult.setOverlayMode(true);
        this.tabResult.reload(this.listOfResult);
        JOptionPane.showMessageDialog(null, "Simulation was completed.\nPlease go to [Results] tab to see the results.", "Information", 1);
        this.startBlink();
    }

    public void calc2ParameterScanBatch() throws SOSlibException {
        Object[] listOfResults = this.solveODE4(this.rbCopasi.isSelected(), this.rbSimulationCore.isSelected());
        ParameterScan scan = this.tabParameterScan.getParameterScan();
        String target1 = "";
        double from1 = 0.0;
        double to1 = 0.0;
        double interval1 = 0.0;
        String target2 = "";
        double from2 = 0.0;
        double to2 = 0.0;
        double interval2 = 0.0;
        from1 = Double.parseDouble(scan.getFrom(0));
        to1 = Double.parseDouble(scan.getTo(0));
        interval1 = Double.parseDouble(scan.getInterval(0));
        target1 = scan.getTarget(0);
        boolean incremented1 = true;
        if (from1 > to1) {
            incremented1 = false;
        }
        int scale1 = StringTool.getScale(from1, interval1);
        from2 = Double.parseDouble(scan.getFrom(1));
        to2 = Double.parseDouble(scan.getTo(1));
        interval2 = Double.parseDouble(scan.getInterval(1));
        target2 = scan.getTarget(1);
        boolean incremented2 = true;
        if (from2 > to2) {
            incremented2 = false;
        }
        int scale2 = StringTool.getScale(from2, interval2);
        this.listOfResult = new ArrayList();
        double start = from1;
        int i = 0;
        while (i < listOfResults.length) {
            Object[] array = (Object[])listOfResults[i];
            double start2 = from2;
            int k = 0;
            while (k < array.length) {
                SBMLResults result = (SBMLResults)array[k];
                result.setParameterInfo(String.valueOf(target1) + " = " + start + " , " + target2 + " = " + start2);
                result.setParameterInfo(result.getParameterInfo().replace(':', '_'));
                start2 = incremented2 ? Double.parseDouble(StringTool.convertNumberFormat(start2 + interval2, scale2)) : Double.parseDouble(StringTool.convertNumberFormat(start2 - interval2, scale2));
                this.listOfResult.add(result);
                ++k;
            }
            start = incremented1 ? Double.parseDouble(StringTool.convertNumberFormat(start + interval1, scale1)) : Double.parseDouble(StringTool.convertNumberFormat(start - interval1, scale1));
            ++i;
        }
        this.tabResult.setWritingButton(true);
        this.tabResult.setShowButton(true);
        this.tabResult.setOverlayMode(false);
        this.tabResult.reload(this.listOfResult);
        JOptionPane.showMessageDialog(null, "Simulation was completed.\nPlease go to [Results] tab to see the results.", "Information", 1);
        this.startBlink();
    }

    public void calcChangeAmount() throws SOSlibException {
        ArrayList lstSBase = this.listOfSpeciesData;
        ChangeAmount amount = this.tabChangeAmount.getChangeAmount();
        ArrayList listOfHeader = amount.getHeaderName();
        ArrayList listOfSpecies = amount.getSpeciesList();
        String[][] tblDataStorage = amount.getAmounts();
        String span = amount.getSpan();
        String step = String.valueOf(this.spnStep.getValue());
        int scale = StringTool.getScale(Double.parseDouble(span), Double.parseDouble(step));
        double range = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(span) / Double.parseDouble(step), scale));
        String startSpan = "0";
        String endSpan = "";
        this.listOfResult = new ArrayList();
        Thread t2 = new Thread(new MyTask(this));
        this.progressBar.setDrawString(this.EXECUTING);
        this.progressBar.setActive(true);
        t2.start();
        int i = 2;
        while (i < listOfHeader.size()) {
            String header = (String)listOfHeader.get(i);
            boolean flg = false;
            int k = 0;
            while (k < listOfSpecies.size()) {
                String data = tblDataStorage[k][i];
                if (data != null && !data.equals("")) {
                    flg = true;
                    endSpan = header;
                    break;
                }
                ++k;
            }
            if (flg) {
                double dspan = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(endSpan) - Double.parseDouble(startSpan), scale));
                SBMLResults beforeResults = null;
                try {
                    beforeResults = this.solveODE2(Double.toString(dspan), StringTool.convertNumberFormat(Double.toString(dspan / range), scale), startSpan, endSpan);
                }
                catch (SOSlibException e) {
                    t2.stop();
                    this.progressBar.setDrawString("");
                    this.progressBar.setActive(false);
                    this.progressBar.setDrawStart(0);
                    this.paintImmediately();
                    this.repaint();
                    throw e;
                }
                beforeResults.setParameterInfo(String.valueOf(startSpan) + "to" + endSpan);
                this.listOfResult.add(beforeResults);
                startSpan = endSpan;
                int k2 = 0;
                while (k2 < listOfSpecies.size()) {
                    TimeCourse species;
                    SpeciesData specied = (SpeciesData)lstSBase.get(k2);
                    Species specie = specied.getSpecies();
                    String initialQuantity = tblDataStorage[k2][i];
                    if (initialQuantity != null && !initialQuantity.equals("")) {
                        if (specie.isSetInitialAmount()) {
                            specie.setInitialAmount(Double.parseDouble(initialQuantity));
                        } else {
                            specie.setInitialConcentration(Double.parseDouble(initialQuantity));
                        }
                        species = beforeResults.getSpecies();
                        species.setValues(species.getTimepoints() - 1, k2, Double.parseDouble(initialQuantity));
                    } else {
                        species = beforeResults.getSpecies();
                        double resultValue = species.getValue(beforeResults.getTimepoints() - 1, k2);
                        if (specie.isSetInitialAmount()) {
                            specie.setInitialAmount(resultValue);
                        } else {
                            specie.setInitialConcentration(resultValue);
                        }
                    }
                    ++k2;
                }
            }
            ++i;
        }
        if (!span.equals(startSpan)) {
            endSpan = span;
            double dspan = Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(span) - Double.parseDouble(startSpan), scale));
            try {
                SBMLResults beforeResults = this.solveODE2(Double.toString(dspan), StringTool.convertNumberFormat(Double.toString(dspan / range), scale), startSpan, endSpan);
                beforeResults.setParameterInfo(String.valueOf(startSpan) + "to" + endSpan);
                this.listOfResult.add(beforeResults);
            }
            catch (SOSlibException e) {
                t2.stop();
                this.progressBar.setDrawString("");
                this.progressBar.setActive(false);
                this.progressBar.setDrawStart(0);
                this.paintImmediately();
                this.repaint();
                throw e;
            }
        }
        int resultCount = 0;
        int i2 = 0;
        while (i2 < this.listOfResult.size()) {
            SBMLResults results = (SBMLResults)this.listOfResult.get(i2);
            resultCount += results.getTimepoints();
            if (i2 != 0) {
                --resultCount;
            }
            ++i2;
        }
        ListOf listOfReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        SBMLResults newResults = new SBMLResults(resultCount, new double[resultCount]);
        TimeCourse newSpecies = new TimeCourse(resultCount, listOfSpecies.size());
        double[][] speciesvalues = new double[resultCount][listOfSpecies.size() + 1];
        newSpecies.setValues(speciesvalues);
        newResults.setSpecies(newSpecies);
        TimeCourse newFluxes = new TimeCourse(resultCount, (int)listOfReaction.size());
        double[][] fluxesvalues = new double[resultCount][(int)listOfReaction.size() + 1];
        newFluxes.setValues(fluxesvalues);
        newResults.setFluxes(newFluxes);
        int index = 0;
        double[] timePoint = new double[resultCount];
        timePoint[0] = 0.0;
        int i3 = 0;
        while (i3 < this.listOfResult.size()) {
            SBMLResults results = (SBMLResults)this.listOfResult.get(i3);
            TimeCourse species = results.getSpecies();
            double[][] speciedata = species.getValues();
            TimeCourse fluxes = results.getFluxes();
            double[][] fluxData = fluxes.getValues();
            int k = 0;
            if (i3 != 0) {
                ++k;
            }
            while (k < results.getTimepoints()) {
                speciesvalues[index][0] = range * (double)index;
                fluxesvalues[index][0] = range * (double)index;
                timePoint[index] = range * (double)index;
                int j = 0;
                while (j < listOfSpecies.size()) {
                    speciesvalues[index][j] = speciedata[k][j];
                    ++j;
                }
                j = 0;
                while ((long)j < listOfReaction.size()) {
                    fluxesvalues[index][j] = fluxData[k][j];
                    ++j;
                }
                ++index;
                ++k;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < listOfSpecies.size()) {
            SpeciesData specied = (SpeciesData)lstSBase.get(i3);
            Species specie = specied.getSpecies();
            String initialQuantity = tblDataStorage[i3][1];
            if (specie.isSetInitialAmount()) {
                specie.setInitialAmount(Double.parseDouble(initialQuantity));
            } else {
                specie.setInitialConcentration(Double.parseDouble(initialQuantity));
            }
            ++i3;
        }
        this.listOfResult = new ArrayList();
        this.listOfResult.add(newResults);
        newResults.setTimepoints(newResults.getTimepoints());
        newResults.setTime(timePoint);
        t2.stop();
        this.progressBar.setDrawString("");
        this.progressBar.setActive(false);
        this.progressBar.setDrawStart(0);
        this.paintImmediately();
        this.repaint();
        if (this.srp != null) {
            this.calcAndDrawLoadResultImage(newResults, this.srp.getCheckSpeciesSelected(), this.srp.getCheckCompartmentSelected(), this.srp.getCheckParameterSelected(), this.srp.getCheckFluxSelected());
        } else {
            this.calcAndDrawLoadResultImage(newResults, true, false, false, false);
        }
        this.tabResult.setWritingButton(false);
        this.tabResult.setOverlayMode(false);
        this.tabResult.reload(this.listOfResult);
        if (this.beforeEndTime != (Double)this.spnSpan.getValue()) {
            this.srp.setTimeIntervalSpinner((Double)this.spnSpan.getValue());
        }
        this.beforeEndTime = (Double)this.spnSpan.getValue();
    }

    public JLabel getPicLabel() {
        return this.picLabel;
    }

    @Override
    public void SBaseChanged(int numberOfList) {
        ListPanel listPanel = (ListPanel)this.sbmlPanelLists.getSBaseListPanel(numberOfList);
        listPanel.updateDialog();
        if (this.sbframe != null) {
            this.sbframe.setChangedInControlPanel();
        }
    }

    private void confirmExit(JDialog frame) {
        int answer = JOptionPane.showConfirmDialog(frame, "Are you sure you want to close the ControlPanel?", "Confirm Exit", 0);
        if (answer == 0) {
            this.tabResult.setCloseOverlaySetting();
            frame.dispose();
            ((MainWindow)this.access).removeListOfCP(this);
        }
    }

    private Object[] solveODE4(boolean isCopasiSelected, boolean isSimulationCoreSelected) throws SOSlibException {
        String[] args = this.initForSolveODE();
        ParameterScan scan = this.tabParameterScan.getParameterScan();
        this.setParameterScanArgs(args, scan, 0);
        this.setParameterScanArgs(args, scan, 1);
        ExecuteSolver execute = isCopasiSelected ? new ExecuteCopasi(args, 2) : (isSimulationCoreSelected ? new ExecuteSimulationCore(args, 2) : new ExecuteODESolver(args, ExecuteODESolver.PARAMETER_SCAN2));
        Thread t1 = new Thread(execute);
        t1.start();
        this.progressBar.setDrawString(this.EXECUTING);
        this.progressBar.setActive(true);
        while (!execute.isEnd()) {
            try {
                this.paintImmediately();
                Thread.sleep(500L);
                if (!execute.isEnd()) continue;
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.progressBar.setDrawString("");
        this.progressBar.setActive(false);
        this.progressBar.setDrawStart(0);
        this.paintImmediately();
        this.repaint();
        if (execute.isError()) {
            throw new SOSlibException(execute.getErrorMessage());
        }
        return execute.getListOfResults();
    }

    private String getInputFileName() {
        String inputFileName = String.valueOf(SimulationProperties.getInstance().getInitParameter("input_path")) + System.getProperty("file.separator") + SimulationProperties.getInstance().getInitParameter("input_file_name");
        return inputFileName;
    }

    private Object[] solveODE3(boolean isCopasiSelected, boolean isSimulationCoreSelected) throws SOSlibException {
        String[] args = this.initForSolveODE();
        ParameterScan scan = this.tabParameterScan.getParameterScan();
        if (scan.doScanParameter(0)) {
            this.setParameterScanArgs(args, scan, 0);
        } else if (scan.doScanParameter(1)) {
            this.setParameterScanArgs(args, scan, 1, 5);
        }
        ExecuteSolver execute = isCopasiSelected ? new ExecuteCopasi(args, 1) : (isSimulationCoreSelected ? new ExecuteSimulationCore(args, 1) : new ExecuteODESolver(args, ExecuteODESolver.PARAMETER_SCAN1));
        Thread t1 = new Thread(execute);
        t1.start();
        this.progressBar.setDrawString(this.EXECUTING);
        this.progressBar.setActive(true);
        while (!execute.isEnd()) {
            try {
                this.paintImmediately();
                Thread.sleep(500L);
                if (!execute.isEnd()) continue;
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.progressBar.setDrawString("");
        this.progressBar.setActive(false);
        this.progressBar.setDrawStart(0);
        this.paintImmediately();
        this.repaint();
        if (execute.isError()) {
            throw new SOSlibException(execute.getErrorMessage());
        }
        return execute.getListOfResults();
    }

    private void setParameterScanArgs(String[] args, ParameterScan scan, int param) {
        int indexOfArgs = 5 + param * 5;
        this.setParameterScanArgs(args, scan, param, indexOfArgs);
    }

    private void setParameterScanArgs(String[] args, ParameterScan scan, int param, int i) {
        if (scan.getKindOfParameter(param).equals("initial value")) {
            args[i] = "";
            int index = this.tabParameterScan.getSelectedIndexCombo(param, "initial value");
            SpeciesData sp = (SpeciesData)this.listOfSpeciesData.get(index);
            args[i + 1] = sp.getSpecies().getId();
        } else if (scan.getKindOfParameter(param).equals("parameter value")) {
            StringTokenizer token = new StringTokenizer(scan.getTarget(param), ":");
            if (token.countTokens() == 1) {
                args[i] = "";
                args[i + 1] = token.nextToken();
            } else {
                args[i] = token.nextToken();
                args[i + 1] = token.nextToken();
            }
        }
        args[i + 2] = scan.getFrom(param);
        args[i + 3] = scan.getTo(param);
        double pspan = 0.0;
        int scale = StringTool.getScale(Double.parseDouble(scan.getTo(param)), Double.parseDouble(scan.getFrom(param)));
        pspan = Double.parseDouble(scan.getFrom(param)) < Double.parseDouble(scan.getTo(param)) ? Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(scan.getTo(param)) - Double.parseDouble(scan.getFrom(param)), scale)) : Double.parseDouble(StringTool.convertNumberFormat(Double.parseDouble(scan.getFrom(param)) - Double.parseDouble(scan.getTo(param)), scale));
        double pstep = Double.parseDouble(StringTool.convertNumberFormat(pspan / Double.parseDouble(scan.getInterval(param))));
        args[i + 4] = String.valueOf(pstep);
    }

    private SBMLResults solveODE2(boolean isCopasiSelected, boolean isSimulationCoreSelected) throws SOSlibException {
        ExecuteSolver execute;
        String[] args = this.initForSolveODE();
        String fileName = args[1];
        double timeEnd = Double.valueOf(args[2]);
        double numPoints = Double.valueOf(args[3]);
        String solver = "";
        long start = System.currentTimeMillis();
        if (isCopasiSelected) {
            execute = new ExecuteCopasi(args, 0);
            solver = "COPASI";
        } else if (isSimulationCoreSelected) {
            execute = new ExecuteSimulationCore(args, 0);
            solver = "SimulationCore";
        } else {
            execute = new ExecuteODESolver(args, ExecuteODESolver.NORMAL_SOLVER);
            solver = "SOSlib";
        }
        Thread t1 = new Thread(execute);
        t1.start();
        this.progressBar.setDrawString(this.EXECUTING);
        this.progressBar.setActive(true);
        while (!execute.isEnd()) {
            try {
                this.paintImmediately();
                Thread.sleep(500L);
                if (!execute.isEnd()) continue;
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        long simTime = end - start;
        SBEventRecorder.addLog("Simulation time: " + simTime + "msec");
        SBEventRecorder.addLog("         solver: " + solver);
        SBEventRecorder.addLog("          model: " + fileName);
        SBEventRecorder.addLog("        timeEnd: " + timeEnd + ", numPoints: " + numPoints);
        if (jp.sbi.sbml.util.Preference.isDebug) {
            System.out.println("Simulation time: " + simTime + "msec");
            System.out.println("         solver: " + solver);
            System.out.println("          model: " + fileName);
            System.out.println("        timeEnd: " + timeEnd + ", numPoints: " + numPoints);
        }
        this.progressBar.setDrawString("");
        this.progressBar.setActive(false);
        this.progressBar.setDrawStart(0);
        this.paintImmediately();
        this.repaint();
        if (execute.isError()) {
            throw new SOSlibException(execute.getErrorMessage());
        }
        return execute.getResults();
    }

    private String[] initForSolveODE() {
        String inputFileName = this.getInputFileName();
        this.writeXML(new File(inputFileName));
        String[] args = new String[15];
        args[0] = "dummy";
        args[1] = inputFileName;
        args[2] = String.valueOf(this.spnSpan.getValue());
        args[3] = String.valueOf(this.spnStep.getValue());
        args[4] = String.valueOf(Math.pow(10.0, ((Number)this.errorToleranceSpinner.getValue()).intValue()));
        return args;
    }

    private SBMLResults solveODE2(String span, String step, String startSpan, String endSpan) throws SOSlibException {
        String inputFileName = String.valueOf(SimulationProperties.getInstance().getInitParameter("input_path")) + System.getProperty("file.separator") + startSpan + "to" + endSpan + ".xml";
        this.writeXML(new File(inputFileName));
        String[] args = new String[]{"dummy", inputFileName, String.valueOf(span), String.valueOf(step), String.valueOf(Math.pow(10.0, ((Number)this.errorToleranceSpinner.getValue()).intValue()))};
        return SOSlib.solveOde2(args);
    }

    private void writeXML(File resultFileName) {
        try {
            this.setSelectedModelTab();
            this.sbmlDocument = this.access.getCurrentModel().getSBModel().getSBMLDocument();
            this.sbmlDocument.setLevelAndVersion((long)this.spec.getLevel(), (long)this.spec.getVersion());
            this.access.getCurrentModel().getSBModel().prepareSave();
            if (this.spec.getLevel() == 1) {
                this.access.getCurrentModel().getSBModel().prepareSaveForLevel1();
            }
            this.sbmlDocument = LibSBMLUtil.getNotEnableAnnotationDocument(this.sbmlDocument, this.spec);
            this.access.getCurrentModel().getSBModel().setSBOTerm(this.sbmlDocument.getModel());
            CelldUtil.resetMetaidAndAnnotationOfMiriam(this.access.getCurrentModel().getSBModel());
            if (!SBMLFiler.isAllowedFileName(resultFileName.getAbsolutePath())) {
                try {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFileName.getAbsolutePath()), "UTF-8");
                    SBMLWriter writer = new SBMLWriter();
                    out.write(writer.writeToString(this.sbmlDocument));
                    out.close();
                    out = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                SBMLWriter writer = new SBMLWriter();
                writer.writeSBML(this.sbmlDocument, resultFileName.getAbsolutePath());
                writer.delete();
                writer = null;
            }
        }
        catch (SIdFormatException sie) {
            sie.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readXML(File filepath) {
        try {
            SBMLReader reader = new SBMLReader();
            this.sbmlDocument = reader.readSBML(filepath.getAbsolutePath());
            LibSBMLUtil.setParameterAnnotation((ListOf)this.sbmlDocument.getModel().getListOfReactions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String tabId = String.valueOf(this.tabPane.getSelectedIndex());
        if (this.tabChangeAmount != null) {
            this.setChangeAmountMenu(tabId.equals("2"));
        }
        if (tabId.equals("5")) {
            this.stopBlink();
        }
        if (this.tabChangeAmount != null) {
            this.tabChangeAmount.setLabelChangeAmount(String.valueOf(this.spnSpan.getValue()));
        }
        if (e.getSource() == this.errorToleranceSpinner) {
            double rTolerance = Math.pow(10.0, ((Number)this.errorToleranceSpinner.getValue()).intValue());
            this.errorTolerance.setRelativeTolerance(String.valueOf(rTolerance));
        }
        if (this.tabChangeAmount != null && tabId.equals("2")) {
            this.rbCopasi.setEnabled(false);
            this.tabChangeAmount.setLblChangeAmount();
            this.tabChangeAmount.setEnableStatusOnComponents();
            this.changeAmount.setSpeciesList(this.tabChangeAmount.getSpeciesList());
            this.changeAmount.setDoChangeAmount(this.tabChangeAmount.isChkChangeAmount());
            this.changeAmount.setAmounts(this.tabChangeAmount.getTblDataStorage());
        } else {
            if (Application.hasCopasiJava) {
                this.rbCopasi.setEnabled(true);
            }
            if (tabId.equals("4")) {
                this.tabTabScanInteractive.setSpLblSlider(true);
            } else if (e.getSource() == this.spnSpan) {
                this.timeSpan.setSpan(String.valueOf(this.spnSpan.getValue()));
            } else if (e.getSource() == this.spnStep) {
                this.timeSpan.setStep(String.valueOf(this.spnStep.getValue()));
            }
        }
    }

    private void menuSaveActionPerformed(ActionEvent e) {
        this.processSave("save");
    }

    private void menuSaveAsActionPerformed(ActionEvent e) {
        this.processSave("saveAs");
    }

    private void menuSaveConditionAsActionPerformed(ActionEvent e) {
        this.processSaveConditionAs();
    }

    private void menuSaveImageActionPerformed(ActionEvent e) {
        if (this.srp == null) {
            JOptionPane.showMessageDialog(this, "There is no save image. ", "warning.", 1);
            return;
        }
        new ImageConfigDialog(this, false);
    }

    public SBMLPanelLists getSBMLPanelLists() {
        return this.sbmlPanelLists;
    }

    private void menuCloseActionPerformed(ActionEvent e) {
        this.confirmExit(this);
    }

    private void menuPrintActionPerformed(ActionEvent e) {
        if (this.srp == null) {
            JOptionPane.showMessageDialog(this, "There is no print image. ", "warning.", 1);
            return;
        }
        new ImageConfigDialog(this, true);
    }

    private void menuCopyActionPerformed(ActionEvent e) {
        JTable table = this.tabChangeAmount.getMainTableObj();
        int[] cols = table.getSelectedColumns();
        int[] rows = table.getSelectedRows();
        String strCopy = "";
        int n = 0;
        while (n < rows.length) {
            int z = 0;
            while (z < cols.length) {
                String s = (String)table.getValueAt(rows[n], cols[z]);
                if (!(s != null && s.equals("") || s != null)) {
                    s = "";
                }
                strCopy = String.valueOf(strCopy) + s + "\t";
                ++z;
            }
            strCopy = String.valueOf(strCopy) + "\n";
            ++n;
        }
        ControlPanelMainWindow.copyStringToClipboard(strCopy);
    }

    private void menuPasteActionPerformed(ActionEvent e) {
        int nMaxCol;
        int nMaxRow;
        int row;
        int col;
        ChangeAmount changeAmount = this.tabChangeAmount.getChangeAmount();
        JTable table = this.tabChangeAmount.getMainTableObj();
        int r = table.getSelectedRow();
        int c = table.getSelectedColumn();
        if (c < 2) {
            return;
        }
        String buf = ControlPanelMainWindow.getStringFromClipboard("");
        int[] selectColmns = table.getSelectedColumns();
        int[] selectRows = table.getSelectedRows();
        if (selectColmns.length < 2 && selectRows.length < 2) {
            col = c;
            row = r;
            nMaxRow = table.getRowCount() - row;
            nMaxCol = table.getColumnCount() - col;
        } else {
            col = selectColmns[0];
            row = selectRows[0];
            nMaxRow = selectRows.length;
            nMaxCol = selectColmns.length;
        }
        StringTokenizer copyRow = new StringTokenizer(buf, "\n");
        int nCopyRow = copyRow.countTokens();
        StringBuffer replaceBuf = new StringBuffer("");
        String data = "";
        int j = 0;
        while (j < nCopyRow) {
            String lowData = copyRow.nextToken();
            boolean endflg = true;
            int i = 0;
            int l = 0;
            String nullString = null;
            while (endflg) {
                i = lowData.indexOf("\t", l);
                if (i != -1) {
                    data = lowData.substring(l, i);
                    if (data.equals("")) {
                        replaceBuf.append(nullString);
                    } else {
                        replaceBuf.append(data);
                    }
                    replaceBuf.append("\t");
                    l = i + 1;
                    continue;
                }
                if (lowData.substring(l, lowData.length()).equals("")) {
                    replaceBuf.append(nullString);
                } else {
                    replaceBuf.append(lowData.substring(l, lowData.length()));
                }
                endflg = false;
                replaceBuf.append("\n");
            }
            ++j;
        }
        buf = replaceBuf.toString();
        copyRow = new StringTokenizer(buf, "\n");
        StringTokenizer copyCol = new StringTokenizer(copyRow.nextToken(), "\t");
        int nCopyCol = copyCol.countTokens();
        int nLoopCount = nCopyCol == selectColmns.length ? selectRows.length : 1;
        int nLoopRowCount = 0;
        int n = 0;
        while (n < nLoopCount) {
            StringTokenizer copyList = new StringTokenizer(buf, "\n");
            int nRow = row;
            int nCount = 0;
            if (n < selectRows.length) {
                while (copyList.hasMoreTokens()) {
                    int nColmun = col;
                    if (nMaxRow <= nCount) break;
                    StringTokenizer copyData = new StringTokenizer(copyList.nextToken(), "\t");
                    int ncolCount = 0;
                    while (copyData.hasMoreElements()) {
                        if (nMaxCol <= ncolCount) break;
                        String strItem = copyData.nextToken();
                        if (strItem != null && strItem.equals("null")) {
                            strItem = "";
                        }
                        if (nMaxRow <= nLoopRowCount) continue;
                        changeAmount.amounts[nRow][nColmun] = strItem;
                        ++nColmun;
                        ++ncolCount;
                    }
                    ++nCount;
                    ++nLoopRowCount;
                    ++nRow;
                }
                row += nCopyRow;
            }
            n += nCopyRow;
        }
        this.tabChangeAmount.setLblChangeAmount();
    }

    private void menuImportActionPerformed(ActionEvent e) {
        this.importAction();
    }

    private void menuExportActionPerformed(ActionEvent e) {
        this.exportAction();
    }

    private void menuRunActionPerformed(ActionEvent e) {
        this.calcAndDrawResultImage();
    }

    private void createStorageClasses() {
        if (this.simulationInfo == null) {
            this.simulationInfo = new SimulationInfo(this);
            this.timeSpan = new TimeSpan();
            this.changeAmount = new ChangeAmount();
            this.paramaterScan = new ParameterScan();
            this.interactiveSimulation = new InteractiveSimulation();
            this.errorTolerance = new ErrorTolerance();
            this.solver = new Solver();
        } else {
            this.timeSpan = (TimeSpan)this.simulationInfo.getSimulationInfo(0);
            this.changeAmount = (ChangeAmount)this.simulationInfo.getSimulationInfo(1);
            this.paramaterScan = (ParameterScan)this.simulationInfo.getSimulationInfo(2);
            this.interactiveSimulation = (InteractiveSimulation)this.simulationInfo.getSimulationInfo(3);
            this.errorTolerance = (ErrorTolerance)this.simulationInfo.getSimulationInfo(4);
            this.solver = (Solver)this.simulationInfo.getSimulationInfo(5);
        }
    }

    private void setSimulationInfo() {
        this.simulationInfo.setSimulationInfo(this.timeSpan, 0);
        this.simulationInfo.setSimulationInfo(this.changeAmount, 1);
        this.simulationInfo.setSimulationInfo(this.paramaterScan, 2);
        this.simulationInfo.setSimulationInfo(this.interactiveSimulation, 3);
        this.simulationInfo.setSimulationInfo(this.errorTolerance, 4);
        this.simulationInfo.setSimulationInfo(this.solver, 5);
    }

    public static void copyStringToClipboard(String str) {
        StringSelection ss = new StringSelection(str);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    public static String getStringFromClipboard(Object requestor) {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = c.getContents(requestor);
        if (t == null) {
            return null;
        }
        try {
            return (String)t.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException e) {
            return null;
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
    }

    public SimulationResultPanel getSrp() {
        return this.srp;
    }

    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public String getSpan() {
        return String.valueOf(this.spnSpan.getValue());
    }

    public String getStep() {
        return String.valueOf(this.spnStep.getValue());
    }

    public void setSpeciesColorSet(SpeciesColorSet speciesColorSet) {
        this.speciesColorSet = speciesColorSet;
    }

    public void setSpeciesVisible(SpeciesVisible speciesVisible) {
        this.speciesVisible = speciesVisible;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        int answer;
        if (e.getID() == 201 && (answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to close the ControlPanel?", "Confirm Exit", 0)) == 0) {
            this.tabResult.setCloseOverlaySetting();
            this.dispose();
            ((MainWindow)this.access).removeListOfCP(this);
        }
    }

    public boolean isOverlayMode() {
        return this.tabResult.isOverlayMode();
    }

    public void setChangeAmountMenu(boolean enable) {
        JMenuBar menuBar = this.getJMenuBar();
        menuBar.getMenu(1).setEnabled(enable);
        menuBar.getMenu(2).setEnabled(enable);
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                boolean bl = this.blinkMode = !this.blinkMode;
                if (this.tabPane.getForegroundAt(this.tabPane.getTabCount() - 1).equals(Color.YELLOW)) {
                    this.tabPane.setForegroundAt(this.tabPane.getTabCount() - 1, Color.BLACK);
                } else {
                    this.tabPane.setForegroundAt(this.tabPane.getTabCount() - 1, Color.YELLOW);
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.blinkMode = true;
        this.repaint();
    }

    private void startBlink() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    private void stopBlink() {
        if (this.runner != null) {
            this.runner.interrupt();
            this.runner = null;
            this.tabPane.setForegroundAt(this.tabPane.getTabCount() - 1, Color.BLACK);
        }
    }

    public TabResult getTabResult() {
        return this.tabResult;
    }

    public boolean is2paramScan() {
        return this.paramaterScan.doScanParameter[0] && this.paramaterScan.doScanParameter[1];
    }

    public void paintImmediately() {
        this.progressBar.paintImmediately(this.progressBar.getVisibleRect());
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public TabParameters getTabParameters() {
        return this.tabParameters;
    }

    public SimulationInfo getSimulationInfo() {
        return this.simulationInfo;
    }

    public ArrayList getListOfResult() {
        return this.listOfResult;
    }

    public void setListOfResult(ArrayList list) {
        this.listOfResult = list;
    }

    public JCheckBox getExeCheck() {
        return this.exeCheck;
    }

    public JCheckBox getExeReverseCheck() {
        return this.exeReverseCheck;
    }

    private void backupSimData() {
        this.listOfResult = this.simulationInfo.getListOfResults();
        this.speciesColorSet = this.simulationInfo.getSpeciesColorSet();
        this.speciesVisible = this.simulationInfo.getSpeciesVisible();
        if (this.simulationInfo.getListOfOriginSpecies() != null) {
            this.listOfOriginSpecies = this.simulationInfo.getListOfOriginSpecies();
        }
        if (this.simulationInfo.getListOfOriginReactions() != null) {
            this.margeListOfOriginReactions(this.simulationInfo.getListOfOriginReactions());
        }
        this.paramaterScan = (ParameterScan)this.simulationInfo.listOfInfo[2];
    }

    private JSplitPane getSplitBackGroundPanel() {
        JSplitPane splitBackGroundPanel = new JSplitPane(1, true);
        splitBackGroundPanel.setBorder(BorderFactory.createEmptyBorder());
        splitBackGroundPanel.setDividerSize(5);
        splitBackGroundPanel.setDividerLocation(0);
        splitBackGroundPanel.setResizeWeight(0.0);
        splitBackGroundPanel.setOneTouchExpandable(true);
        return splitBackGroundPanel;
    }

    private void resetModelPathName() {
        SBModelFrame frame = this.access.getCurrentModel();
        this.modelPath = frame.getPath().getPath();
        this.modelName = frame.getSBModel().getModelName();
    }

    private void openFile(File file) throws Exception {
        this.simulationInfo = new SimulationInfo(this);
        this.simulationInfo.setSbmlPanelLists(this.sbmlPanelLists);
        this.smlSimCondition = SmlUtil.getValueFromXmlFile(file);
        this.cloneSmlSimCondition = this.smlSimCondition.clone();
    }

    private void createDefaultTask() {
        this.smlSimCondition = new SmlSimCondition();
        this.listOfTasks = new ArrayList();
        SmlTask defaultTask = new SmlTask();
        defaultTask.setId("t1");
        defaultTask.setName("expt1");
        defaultTask.setModelReference("m1");
        defaultTask.setSimulationReference("s1");
        this.listOfTasks.add(defaultTask);
        this.editingTask = defaultTask;
        this.smlSimCondition.setListOfTasks(this.listOfTasks);
    }

    private void createTaskTreePanel() {
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new BorderLayout());
        this.taskList = new TaskTree();
        this.taskList.createRootNode(this.listOfTasks);
        this.taskList.setSelectionRow(1);
        this.taskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ControlPanelMainWindow.this.selectTaskTreeAction(event);
            }
        });
        this.taskList.setBackgroundColor(this.treePanel.getBackground());
        JPanel pnlTree = new JPanel();
        pnlTree.add(this.taskList);
        this.treePanel.add((Component)pnlTree, "West");
        this.saveCondition = this.getSaveCondition();
        JPanel pnlSCBtn = new JPanel();
        pnlSCBtn.add(this.saveCondition);
        this.treePanel.add((Component)pnlSCBtn, "South");
    }

    private void initSpanAndErrTolerancePanel() {
        this.timeSpan.setSpan(String.valueOf(this.spnSpan.getValue()));
        this.timeSpan.setStep(String.valueOf(this.spnStep.getValue()));
        double rTolerance = Math.pow(10.0, ((Number)this.errorToleranceSpinner.getValue()).intValue());
        this.errorTolerance.setRelativeTolerance(String.valueOf(rTolerance));
        if (this.rbSoslib.isSelected()) {
            this.solver.setSolverName("SOSlib");
            if (this.listOfOriginSpecies.size() > 0) {
                this.tabPane.setEnabledAt(2, true);
            }
        } else {
            this.solver.setSolverName("COPASI");
            if (this.listOfOriginSpecies.size() > 0) {
                this.tabPane.setEnabledAt(2, false);
            }
        }
    }

    private void openFile() {
        FilePather fp = new FilePather();
        String[] suffices = new String[]{"xml"};
        String description = "XML files";
        File file = fp.getUserSelection((Component)this, 1, suffices, description, null);
        if (file != null) {
            try {
                this.openFile(file);
                SmlModel smlModel = (SmlModel)this.smlSimCondition.getListOfModels().get(0);
                String modelSource = smlModel.getSource();
                MainWindow multiwindow = (MainWindow)this.access.getMyFrame();
                SBModelFrame multiwindowFrame = multiwindow.getCurrentModel();
                File modelFile = multiwindow.getCurrentModel().getPath();
                System.out.println("source: " + modelSource);
                System.out.println(modelFile.getAbsolutePath());
                String message = "This Sed xml is for the model file " + modelFile.getAbsolutePath() + ". \n" + "Are you sure you want to open the file?";
                int answer = JOptionPane.showConfirmDialog(this, message, "Confirm Open Condition File", 0);
                if (answer == 1) {
                    return;
                }
                this.isXMLLoad = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                return;
            }
            this.listOfTasks = this.smlSimCondition.getListOfTasks();
            if (this.listOfTasks != null && this.listOfTasks.size() > 0) {
                this.editingTask = (SmlTask)this.listOfTasks.get(0);
            } else {
                this.createDefaultTask();
            }
            this.simulationInfo.updateSmlInfo(this.smlSimCondition, this.editingTask);
            this.createStorageClasses();
            this.setSimulationInfo();
            this.backupSimData();
            this.setTabResult();
            this.SetDrawAreaInit();
            this.SetDrawArea();
            this.createTaskTreePanel();
            this.splitBackGroundPanel.setLeftComponent(this.treePanel);
            this.processTableReload(true);
            this.setSimulationInfoFromFile();
            this.setChangedFlgWhileTaskChanged();
            this.getTabParameters().resetParameters();
            this.thisModelPath = file.getPath();
            this.sedFileIsExist = true;
            String openMessage = "Open simulation condition successful.";
            JOptionPane.showMessageDialog(null, openMessage, "Information", 1);
        }
    }

    private void SetDrawArea() {
        if (this.listOfResult == null) {
            return;
        }
        if (this.listOfResult.size() == 1) {
            this.DrawResultImageFromTaskResultList((SBMLResults)this.listOfResult.get(0), this.smlSimCondition);
        } else if (this.listOfResult.size() > 1) {
            SBMLResults result = null;
            int i = 0;
            while (i < this.listOfResult.size()) {
                result = (SBMLResults)this.listOfResult.get(i);
                if (result.isVisible()) {
                    this.DrawResultImageFromTaskResultList(result, this.smlSimCondition);
                    this.tabResult.setRowSelect(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void SetDrawAreaInit() {
        JTabbedPane tabpane = new JTabbedPane();
        tabpane.addTab("", new JPanel());
        tabpane.addTab("", new JScrollPane());
        ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, new JPanel());
        ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(1, tabpane);
    }

    private void setTabResult() {
        if (this.listOfResult == null) {
            this.listOfResult = new ArrayList();
        }
        this.tabResult.reload(this.listOfResult);
        this.tabResult.setShowButton(false);
        this.tabResult.setWritingButton(false);
        this.tabResult.setOverlayMode(false);
        if (this.listOfResult.size() > 1) {
            this.tabResult.setShowButton(true);
            if (this.paramaterScan.doScanParameter[0] && this.paramaterScan.doScanParameter[1]) {
                this.tabResult.setWritingButton(true);
            } else if (this.paramaterScan.doScanParameter[0] || this.paramaterScan.doScanParameter[1]) {
                this.tabResult.setOverlayMode(true);
            }
        }
    }

    public void setChangedFlgWhileTaskChanged() {
        if (this.smlSimCondition == null || this.editingTask == null) {
            return;
        }
        ArrayList<Object> modelList = this.smlSimCondition.getListOfModels();
        int i = 0;
        while (i < modelList.size()) {
            if (((SmlModel)modelList.get(i)).getId().equals(this.editingTask.getModelReference())) {
                SmlModel smlModel = (SmlModel)modelList.get(i);
                if (smlModel.getListOfChanges().size() > 0) {
                    this.setChanged(true);
                } else {
                    this.setChanged(false);
                }
                this.getSbframe().setChangedInControlPanel();
                break;
            }
            ++i;
        }
    }

    private void processSaveConditionAs() {
        this.sedFileIsExist = false;
        this.processSaveCondition();
    }

    private void processSaveCondition() {
        int answer;
        this.simulationInfo.setSpeciesColorSet(this.speciesColorSet);
        this.simulationInfo.setSpeciesVisible(this.speciesVisible);
        this.simulationInfo.setListOfResults(this.listOfResult);
        this.simulationInfo.setSbmlPanelLists(this.sbmlPanelLists);
        this.simulationInfo.setListOfOriginSpecies(this.listOfOriginSpecies);
        this.simulationInfo.setListOfOriginReactions(this.listOfOriginReactions);
        this.simulationInfo.setListOfOriginGlobalParameters(this.listOfOriginGlobalParameters);
        String path = !this.sedFileIsExist ? PoliteFileDialog.getSelectedFilePath("Select file", "_sed.xml", 1) : this.thisModelPath;
        if (path == null) {
            return;
        }
        path = SmlUtil.SubString(path, ".xml");
        path = SmlUtil.SubString(path, "_sed");
        File outputFile = new File(String.valueOf(path) + "_sed.xml");
        if (this.cloneSmlSimCondition == null) {
            this.cloneSmlSimCondition = this.smlSimCondition.clone();
        }
        this.listOfTasks = this.smlSimCondition.getListOfTasks();
        String newModelId = SmlUtil.getNewModelId(this.smlSimCondition);
        String newSimulationId = SmlUtil.getNewSimulationId(this.smlSimCondition);
        SmlTask smlNewTask = new SmlTask();
        smlNewTask.setId(this.editingTask.getId());
        smlNewTask.setName(this.editingTask.getName());
        smlNewTask.setModelReference(newModelId);
        smlNewTask.setSimulationReference(newSimulationId);
        String newTaskName = null;
        if (outputFile.exists() && this.sedFileIsExist && (answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite the task?", "Confirm Overwrite", 0)) == 1) {
            this.taskNameInputDialog = new TaskNameInputDialog(this.smlSimCondition.getListOfTasks());
            this.taskNameInputDialog.setText(SmlUtil.getNewTaskName(this.smlSimCondition));
            this.taskNameInputDialog.setVisible(true);
            if (this.taskNameInputDialog.isCanceled()) {
                return;
            }
            newTaskName = this.taskNameInputDialog.getText().trim();
            smlNewTask.setId(SmlUtil.getNewTaskId(this.smlSimCondition));
            smlNewTask.setName(newTaskName);
        }
        ArrayList list = null;
        list = this.tabResult.getListOfResult() != null && !this.tabResult.getListOfResult().isEmpty() ? this.tabResult.getListOfResult() : this.listOfResult;
        this.resetModelPathName();
        SmlUtil.updateSmlSimCondition(this.cloneSmlSimCondition, smlNewTask, this.simulationInfo, this.modelName, this.modelPath, list, path);
        this.smlSimCondition = this.cloneSmlSimCondition.clone();
        int indexOfTask = this.taskList.removeNode(smlNewTask);
        this.taskList.addNode(smlNewTask, indexOfTask);
        this.taskList.setSelectionRow(indexOfTask + 1);
        this.editingTask = smlNewTask;
        try {
            if (list != null && list.size() > 0) {
                this.fileOutPutMethod(path, smlNewTask.getId(), list);
            }
            SmlUtil.savetoXmlFile(outputFile, this.smlSimCondition);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Can not save data to file.");
            return;
        }
        String saveMessage = "";
        saveMessage = this.listOfResult != null ? "Saved simulation condition (_sed.xml) and results (_result/) files." : "Saved simulation condition (_sed.xml) ";
        this.isXMLLoad = true;
        this.sedFileIsExist = true;
        this.thisModelPath = path;
        JOptionPane.showMessageDialog(null, saveMessage, "Information", 1);
    }

    private void fileOutPutMethod(String outputPath, String taskId, ArrayList list) throws Exception {
        try {
            boolean bCreateTemp = false;
            File folder = new File(String.valueOf(outputPath) + "_Result");
            if (!folder.exists()) {
                folder.mkdir();
            }
            String pathFolder = String.valueOf(outputPath) + "_Result" + File.separator + taskId + "_result";
            String tempFolder = null;
            File file = new File(pathFolder);
            if (!file.exists()) {
                file.mkdir();
            } else {
                tempFolder = this.getTempFolder(outputPath, taskId, true);
                bCreateTemp = true;
            }
            int index = 0;
            while (index < list.size()) {
                SBMLResults resoutinfo = (SBMLResults)list.get(index);
                if (resoutinfo.getPath() != null && !resoutinfo.getPath().equals("")) {
                    resoutinfo.getOutputFileFromSedXml(resoutinfo.getPath());
                }
                if (bCreateTemp) {
                    resoutinfo.outputFile(String.valueOf(tempFolder) + File.separator + "result" + resoutinfo.getParameterInfo() + ".txt");
                } else {
                    resoutinfo.outputFile(String.valueOf(pathFolder) + File.separator + "result" + resoutinfo.getParameterInfo() + ".txt");
                }
                ++index;
            }
            if (bCreateTemp) {
                File filedelTarget = new File(pathFolder);
                SmlUtil.deleteDir(filedelTarget);
                File fileRenameTarget = new File(tempFolder);
                fileRenameTarget.renameTo(filedelTarget);
            }
        }
        catch (Exception e) {
            throw new Exception();
        }
    }

    public String getTempFolder(String outputPath, String taskId, boolean bCreateTemp) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String tempStr = sdf.format(cal.getTime());
        String tempFolder = String.valueOf(outputPath) + "_Result" + File.separator + taskId + "_result" + "." + tempStr;
        File folder = new File(tempFolder);
        if (folder.exists()) {
            return this.getTempFolder(outputPath, taskId, bCreateTemp);
        }
        if (bCreateTemp) {
            folder.mkdir();
        }
        return tempFolder;
    }

    private void selectTaskTreeAction(MouseEvent event) {
        DefaultMutableTreeNode selectedNode;
        SmlTask selectedTask;
        if (this.taskList.getSelectionCount() != 1) {
            return;
        }
        if (this.taskList.getRootNode().getChildCount() == 1) {
            return;
        }
        this.resetModelPathName();
        int selRow = this.taskList.getRowForLocation(event.getX(), event.getY());
        int cnt = this.taskList.getRootNode().getChildCount();
        if (selRow <= 0 || selRow > cnt) {
            selRow = 1;
        }
        this.taskList.setSelectionRow(selRow);
        if (selRow > 0 && !(selectedTask = (SmlTask)((TaskTree.MyTreeLeafObject)(selectedNode = (DefaultMutableTreeNode)this.taskList.getRootNode().getChildAt(selRow - 1)).getUserObject()).getObj()).getName().equals(this.editingTask.getName())) {
            try {
                this.errorToleranceSpinner.commitEdit();
                this.spnSpan.commitEdit();
                this.spnStep.commitEdit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList listResults = null;
            listResults = this.tabResult.getListOfResult() != null && !this.tabResult.getListOfResult().isEmpty() ? this.tabResult.getListOfResult() : this.listOfResult;
            SmlUtil.updateSmlSimCondition(this.smlSimCondition, this.editingTask, this.simulationInfo, this.modelName, this.modelPath, listResults, null);
            this.editingTask = selectedTask;
            this.processInitialize();
            this.simulationInfo.updateSmlInfo(this.smlSimCondition, this.editingTask);
            this.SetDrawAreaInit();
            this.listOfResult = new ArrayList();
            if (this.simulationInfo.getListOfResults() != null) {
                this.listOfResult.addAll(this.simulationInfo.getListOfResults());
            }
            this.setTabResult();
            this.srp = null;
            if (this.simulationInfo.getListOfResults() != null && this.simulationInfo.getListOfResults().size() > 0) {
                this.SetDrawArea();
            }
            if (this.srp == null) {
                this.exeCheck.setSelected(false);
                this.exeReverseCheck.setSelected(false);
                this.exeReverseCheck.setVisible(false);
            }
            this.createStorageClasses();
            this.setSimulationInfo();
            this.processTableReload(true);
            this.spnSpan.setValue(Double.parseDouble(this.getTimeSpan().getSpan()));
            this.spnStep.setValue(Double.parseDouble(this.getTimeSpan().getStep()));
            double rt = Double.parseDouble(this.errorTolerance.getRelativeTolerance());
            int loadedValue = (int)Math.log10(rt);
            this.errorToleranceSpinner.setValue(loadedValue);
            if ("SOSlib".equals(this.solver.getSolverName())) {
                this.rbSoslib.setSelected(true);
            } else if ("COPASI".equals(this.solver.getSolverName())) {
                this.rbCopasi.setSelected(true);
                if (this.tabChangeAmount != null) {
                    this.tabPane.setEnabledAt(2, false);
                }
            } else if ("SimulationCore".equals(this.solver.getSolverName())) {
                this.rbSimulationCore.setSelected(true);
                if (this.tabChangeAmount != null) {
                    this.tabPane.setEnabledAt(2, false);
                }
            } else {
                this.rbSoslib.setSelected(true);
            }
            this.setChangedFlgWhileTaskChanged();
            this.getTabParameters().resetParameters();
        }
    }

    private JButton getSaveCondition() {
        JButton saveCondition = new JButton("Save Condition");
        saveCondition.addActionListener(this);
        return saveCondition;
    }

    public void synchronizeListOfOriginSBases() {
        this.simulationInfo.setListOfOriginSpecies(this.listOfOriginSpecies);
        this.simulationInfo.setListOfOriginReactions(this.listOfOriginReactions);
        this.simulationInfo.setListOfOriginGlobalParameters(this.listOfOriginGlobalParameters);
    }

    public void DrawResultImageFromTaskResultList(SBMLResults results, SmlSimCondition smlSimCondition) {
        this.stopBlink();
        boolean selectedSpecies = false;
        boolean selectedCompartments = false;
        boolean selectedParameters = false;
        boolean selectedFluxes = false;
        HashMap<String, Boolean> speciesVisibleMap = new HashMap<String, Boolean>();
        HashMap<String, Color> speciesColorSetMap = new HashMap<String, Color>();
        int selectedValue = 0;
        boolean exeCheckFlg = false;
        boolean exeReverseCheckFlg = false;
        double Ymax = 0.0;
        double o = 0.0;
        double Xperscreen = 0.0;
        this.exeCheck.setSelected(exeCheckFlg);
        this.exeReverseCheck.setSelected(exeReverseCheckFlg);
        if (smlSimCondition != null && smlSimCondition.getListOfOutputs() != null) {
            int size = smlSimCondition.getListOfOutputs().size();
            String targetTaskName = this.editingTask.getName();
            int i = 0;
            while (i < size) {
                SmlPlot2D plot2dTarget = (SmlPlot2D)smlSimCondition.getListOfOutputs().get(i);
                if (plot2dTarget.getTaskref().equals(this.editingTask.getId())) {
                    SmlPaint paint;
                    Ymax = plot2dTarget.getGraphInfo().getYmax();
                    o = plot2dTarget.getGraphInfo().getO();
                    Xperscreen = plot2dTarget.getGraphInfo().getXperscreen();
                    if (!plot2dTarget.getGraphInfo().getConcentration().equals("raw")) {
                        selectedValue = 1;
                    }
                    selectedSpecies = plot2dTarget.getGraphInfo().isSpecies();
                    selectedCompartments = plot2dTarget.getGraphInfo().isCompartments();
                    selectedParameters = plot2dTarget.getGraphInfo().isParameters();
                    selectedFluxes = plot2dTarget.getGraphInfo().isFluxes();
                    exeCheckFlg = plot2dTarget.getGraphInfo().isShow();
                    if (exeCheckFlg) {
                        exeReverseCheckFlg = plot2dTarget.getGraphInfo().isReverse();
                    }
                    int j = 0;
                    while (j < plot2dTarget.getGraphInfo().getSpeciesPaintSize()) {
                        paint = plot2dTarget.getGraphInfo().getSpeciesPaint().get(j);
                        speciesVisibleMap.put(paint.getId(), paint.getVisible());
                        speciesColorSetMap.put(paint.getName(), paint.getColor());
                        ++j;
                    }
                    j = 0;
                    while (j < plot2dTarget.getGraphInfo().getParameteresSize()) {
                        paint = plot2dTarget.getGraphInfo().getParameteresPaint().get(j);
                        speciesVisibleMap.put(paint.getId(), paint.getVisible());
                        speciesColorSetMap.put(paint.getId(), paint.getColor());
                        ++j;
                    }
                    j = 0;
                    while (j < plot2dTarget.getGraphInfo().getFluxesPaintSize()) {
                        paint = plot2dTarget.getGraphInfo().getFluxesPaint().get(j);
                        speciesVisibleMap.put(paint.getId(), paint.getVisible());
                        speciesColorSetMap.put(paint.getId(), paint.getColor());
                        ++j;
                    }
                    j = 0;
                    while (j < plot2dTarget.getGraphInfo().getCompartmentsSize()) {
                        paint = plot2dTarget.getGraphInfo().getCompartmentsPaint().get(j);
                        speciesVisibleMap.put(paint.getId(), paint.getVisible());
                        speciesColorSetMap.put(paint.getId(), paint.getColor());
                        ++j;
                    }
                    break;
                }
                ++i;
            }
        }
        this.srp = new SimulationResultPanel(this, this.sbmlPanelLists);
        this.srp.setCheckSpeciesSelected(true);
        this.srp.setCheckCompartmentSelected(true);
        this.srp.setCheckParameterSelected(true);
        this.srp.setCheckFluxSelected(true);
        if (this.tabResult.isOverlayMode() || this.isBeforeExecParamScan) {
            this.speciesColorSet = null;
            this.speciesVisible = null;
            this.isBeforeExecParamScan = false;
        }
        try {
            if (results.getPath() != null && !results.getPath().equals("")) {
                results.getOutputFileFromSedXml(results.getPath());
            }
        }
        catch (Exception ex) {
            return;
        }
        this.srp.setData(results, this.speciesColorSet, this.speciesVisible);
        if (!speciesVisibleMap.isEmpty()) {
            this.srp.getSpeciesVisible().setSpeciesVisible(speciesVisibleMap);
        }
        if (!speciesColorSetMap.isEmpty()) {
            this.srp.getSpeciesColorSet().setSpeciesColors(speciesColorSetMap);
        }
        int divLocation = this.splitMainWindow.getDividerLocation();
        ((JTabbedPane)this.splitMainWindow.getRightComponent()).setComponentAt(0, this.srp.showViewer());
        this.splitMainWindow.setDividerLocation(divLocation);
        this.createAllResultTab();
        this.speciesColorSet = this.srp.getSpeciesColorSet();
        this.speciesVisible = this.srp.getSpeciesVisible();
        this.srp.setCheckSpeciesSelected(selectedSpecies);
        this.srp.setCheckCompartmentSelected(selectedCompartments);
        this.srp.setCheckParameterSelected(selectedParameters);
        this.srp.setCheckFluxSelected(selectedFluxes);
        this.srp.checkBoxAction(null);
        this.beforeEndTime = (Double)this.spnSpan.getValue();
        this.beforeMaxRange = this.srp.getMaxRangeNow();
        this.exeCheck.setSelected(exeCheckFlg);
        this.exeReverseCheck.setSelected(exeReverseCheckFlg);
        this.srp.updateSpinnerPositon(this.exeCheck.isSelected());
        this.srp.timeSeriesPanel.repaint();
        this.ExecuteScatterAndReverseCheckBoxEvent(selectedValue);
        if (!this.exeCheck.isSelected()) {
            this.srp.setMaxRangeSpinner(Ymax);
            this.srp.setMinRangeSpinner(o);
            this.srp.setTimeIntervalSpinner(Xperscreen);
        }
    }

    private void ExecuteScatterAndReverseCheckBoxEvent(int selectedValue) {
        if (this.exeCheck.isSelected()) {
            this.srp.getLineVisibleList().clear();
            if (this.srp.getCheckSpeciesSelected()) {
                int i = 0;
                while (i < this.srp.getSpeciesList().size()) {
                    String selectedId = (String)this.srp.getSpeciesList().get(i);
                    this.srp.getLineVisibleList().add(this.srp.getSpeciesVisible().isVisible(selectedId));
                    ++i;
                }
            }
            this.showScatterAction();
            if (this.exeReverseCheck.isSelected()) {
                this.showReverseScatterAction();
            }
        } else {
            this.srp.setSelectValue(selectedValue, true);
        }
    }

    private void menuSaveConditionActionPerformed(ActionEvent e) {
        this.processSaveCondition();
    }

    private void taskRenameActionPerformed(ActionEvent e) {
        String taskName = this.editingTask.getName();
        this.taskNameInputDialog = new TaskNameInputDialog(this.smlSimCondition.getListOfTasks());
        this.taskNameInputDialog.setText(taskName);
        this.taskNameInputDialog.setVisible(true);
        if (this.taskNameInputDialog.isCanceled()) {
            return;
        }
        this.editingTask.setName(this.taskNameInputDialog.getText());
        this.treePanel.repaint();
    }

    public void setSimulationInfoFromFile() {
        if (this.simulationInfo != null) {
            this.spnSpan.setValue(Double.parseDouble(this.timeSpan.getSpan()));
            this.spnStep.setValue(Double.parseDouble(this.timeSpan.getStep()));
            this.errorToleranceSpinner.setValue((int)Math.log10(Double.parseDouble(this.errorTolerance.getRelativeTolerance())));
            if ("SOSlib".equals(this.solver.getSolverName())) {
                this.rbSoslib.setSelected(true);
            } else if ("COPASI".equals(this.solver.getSolverName())) {
                this.rbCopasi.setSelected(true);
                if (this.tabChangeAmount != null) {
                    this.tabPane.setEnabledAt(2, false);
                }
            } else if ("SimulationCore".equals(this.solver.getSolverName())) {
                this.rbSimulationCore.setSelected(true);
                if (this.tabChangeAmount != null) {
                    this.tabPane.setEnabledAt(2, false);
                }
            } else {
                this.rbSoslib.setSelected(true);
            }
        }
    }
}

