/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation;

public class TimeCourse {
    int timepoints;
    int num_val;
    String[] names;
    double[][] values;

    private TimeCourse() {
    }

    public TimeCourse(int timepoints, int num_val) {
        this();
        this.init(timepoints, num_val);
    }

    public TimeCourse clone() {
        TimeCourse newInstance = new TimeCourse();
        newInstance.timepoints = this.timepoints;
        newInstance.num_val = this.num_val;
        if (this.names != null) {
            newInstance.names = (String[])this.names.clone();
        }
        if (this.values != null) {
            newInstance.values = (double[][])this.values.clone();
        }
        return newInstance;
    }

    private void init(int timepoints, int num_val) {
        this.timepoints = timepoints;
        this.num_val = num_val;
        this.values = new double[timepoints][];
        int i = 0;
        while (i < timepoints) {
            this.values[i] = new double[num_val];
            ++i;
        }
    }

    public void setTimepoints(int timepoints) {
        this.timepoints = timepoints;
    }

    public void setNum_val(int num_val) {
        this.num_val = num_val;
    }

    public void setName(int index, String name) {
        this.names[index] = name;
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public void setValue(int index, double[] value) {
        this.values[index] = value;
    }

    public void setValueInv(int index, double[] value) {
        int i = 0;
        while (i < value.length) {
            this.values[i][index] = value[i];
            ++i;
        }
    }

    public int getTimepoints() {
        return this.timepoints;
    }

    public int getNum_val() {
        return this.num_val;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getName(int speciesIndex) {
        return this.names[speciesIndex];
    }

    public double[][] getValues() {
        return this.values;
    }

    public double getValue(int timeIndex, int index) {
        return this.values[timeIndex][index];
    }

    public void setValues(double[][] values) {
        this.values = values;
    }

    public void setValues(int timeIndex, int index, double value) {
        this.values[timeIndex][index] = value;
    }

    public Object[][] getValuesToObject() {
        int x = this.values.length;
        int y = this.values[0].length;
        Object[][] obj = new Object[x][y];
        int i = 0;
        while (i < this.values.length) {
            int k = 0;
            while (k < this.values[0].length) {
                obj[i][k] = new Double(this.values[i][k]);
                ++k;
            }
            ++i;
        }
        return obj;
    }

    public Object[] getNamesToObject() {
        Object[] obj = new Object[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            obj[i] = this.names[i];
            ++i;
        }
        return obj;
    }
}

