/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation;

import java.io.IOException;
import jp.co.mki.celldesigner.simulation.CvodeResults;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultChart;
import jp.co.mki.celldesigner.simulation.util.SimulationProperties;

public class Simulator {
    static {
        System.loadLibrary("SODE");
    }

    public static void main(String[] args) {
        CvodeResults results = Simulator.s_odeSolver(args);
        try {
            SimulationResultChart src = new SimulationResultChart();
            src.setTitle("test chart");
            src.setTimeAxisLabel("time axis");
            src.setValueAxisLabel("amount");
            src.createChart(results, String.valueOf(SimulationProperties.getInstance().getInitParameter("result_path")) + "/xyl.jpg");
            results.outputFile(String.valueOf(SimulationProperties.getInstance().getInitParameter("result_path")) + "/result.txt");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static Object[] solveOde4(String[] args) {
        return Simulator.s_odeSolver4(args);
    }

    public static native Object[] s_odeSolver4(String[] var0);

    public static Object[] solveOde3(String[] args) {
        return Simulator.s_odeSolver3(args);
    }

    public static native Object[] s_odeSolver3(String[] var0);

    public static SBMLResults solveOde2(String[] args) {
        return Simulator.s_odeSolver2(args);
    }

    public static native SBMLResults s_odeSolver2(String[] var0);

    public static CvodeResults solveOde(String[] args) {
        return Simulator.s_odeSolver(args);
    }

    public static native CvodeResults s_odeSolver(String[] var0);
}

