/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import jp.sbi.celldesigner.copasi.Copasi;
import jp.sbi.celldesigner.util.CelldUtil;
import org.COPASI.CCopasiTask;
import org.COPASI.CModel;
import org.COPASI.CTimeSeries;
import org.COPASI.CTrajectoryTask;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Species;
import org.simulator.math.odes.MultiTable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SBMLResults {
    private int timepoints;
    private double[] time;
    private TimeCourse species;
    private TimeCourse compartments;
    private TimeCourse parameters;
    private TimeCourse fluxes;
    private String path;
    private String parameterInfo = "";
    private static final String SPECIES = "#species";
    private static final String COMPARTMENTS = "#compartments";
    private static final String PARAMETERS = "#parameters";
    private static final String FLUXES = "#fluxes";
    private static final String TIME = "time";
    private boolean visible = false;

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    private SBMLResults() {
    }

    public SBMLResults(int timepoints, double[] time) {
        this();
        this.init(timepoints, time);
    }

    public SBMLResults clone() {
        SBMLResults newInstance = new SBMLResults();
        newInstance.timepoints = this.timepoints;
        if (this.time != null) {
            newInstance.time = (double[])this.time.clone();
        }
        if (this.species != null) {
            newInstance.species = this.species.clone();
        }
        if (this.compartments != null) {
            newInstance.compartments = this.compartments.clone();
        }
        if (this.parameters != null) {
            newInstance.parameters = this.parameters.clone();
        }
        if (this.fluxes != null) {
            newInstance.fluxes = this.fluxes.clone();
        }
        newInstance.path = this.path;
        newInstance.parameterInfo = this.parameterInfo;
        newInstance.visible = this.visible;
        return newInstance;
    }

    public SBMLResults readAnnotationFromDOMTree(Element sourcedoc) throws Exception {
        SBMLResults result = new SBMLResults();
        if (sourcedoc.getNodeType() == 1) {
            NamedNodeMap map = sourcedoc.getAttributes();
            String id = map.getNamedItem("id").getNodeValue();
            String source = map.getNamedItem("source").getNodeValue();
            String visible = map.getNamedItem("visible").getNodeValue();
            if (source != null) {
                result.setPath(source);
            }
            if (id != null) {
                result.setParameterInfo(id);
            }
            if (visible != null) {
                boolean bo = true;
                if (CelldUtil.issameIgnoreCaseIgnoreSpace(visible, "false")) {
                    bo = false;
                }
                result.setVisible(bo);
            }
        }
        return result;
    }

    public void getOutputFileFromSedXml(String fileName) throws IOException {
        int k;
        double[] valuesAtT;
        ArrayList lineData;
        String timeStr;
        ArrayList firstData;
        String line;
        FileReader reader = new FileReader(fileName);
        BufferedReader in = new BufferedReader(reader);
        String mode = "";
        ArrayList speciesData = new ArrayList();
        ArrayList compartmentsData = new ArrayList();
        ArrayList parametersData = new ArrayList();
        ArrayList fluxesData = new ArrayList();
        ArrayList<String> timeData = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> speciesNames = new ArrayList<String>();
        ArrayList<String> fluxesNames = new ArrayList<String>();
        ArrayList<String> compartmentsNames = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            String str;
            ArrayList<String> lineData2;
            StringTokenizer token = new StringTokenizer(line, " ");
            if (line.equals(SPECIES)) {
                mode = SPECIES;
                continue;
            }
            if (line.equals(COMPARTMENTS)) {
                mode = COMPARTMENTS;
                continue;
            }
            if (line.equals(PARAMETERS)) {
                mode = PARAMETERS;
                continue;
            }
            if (line.equals(FLUXES)) {
                mode = FLUXES;
                continue;
            }
            if (line.contains(TIME) && mode == PARAMETERS) {
                names = new ArrayList();
                token.nextToken();
                while (token.hasMoreElements()) {
                    String str2 = token.nextToken();
                    names.add(str2);
                }
                continue;
            }
            if (line.contains(TIME)) {
                if (mode == SPECIES) {
                    speciesNames = new ArrayList();
                    token.nextToken();
                    while (token.hasMoreElements()) {
                        String str3 = token.nextToken();
                        speciesNames.add(str3);
                    }
                    continue;
                }
                if (mode == FLUXES) {
                    fluxesNames = new ArrayList();
                    token.nextToken();
                    while (token.hasMoreElements()) {
                        String str4 = token.nextToken();
                        fluxesNames.add(str4);
                    }
                    continue;
                }
                if (mode != COMPARTMENTS) continue;
                compartmentsNames = new ArrayList();
                token.nextToken();
                while (token.hasMoreElements()) {
                    String str5 = token.nextToken();
                    compartmentsNames.add(str5);
                }
                continue;
            }
            if (mode.equals(SPECIES)) {
                int index = 0;
                lineData2 = new ArrayList<String>();
                while (token.hasMoreElements()) {
                    str = token.nextToken();
                    if (index == 0) {
                        timeData.add(str);
                    } else {
                        lineData2.add(str);
                    }
                    ++index;
                }
                speciesData.add(lineData2);
                continue;
            }
            if (mode.equals(COMPARTMENTS)) {
                int index = 0;
                lineData2 = new ArrayList();
                while (token.hasMoreElements()) {
                    str = token.nextToken();
                    if (index != 0) {
                        lineData2.add(str);
                    }
                    ++index;
                }
                compartmentsData.add(lineData2);
                continue;
            }
            if (mode.equals(PARAMETERS)) {
                int index = 0;
                lineData2 = new ArrayList();
                while (token.hasMoreElements()) {
                    str = token.nextToken();
                    if (index != 0) {
                        lineData2.add(str);
                    }
                    ++index;
                }
                parametersData.add(lineData2);
                continue;
            }
            if (!mode.equals(FLUXES) || line.equals(mode)) continue;
            int index = 0;
            lineData2 = new ArrayList();
            while (token.hasMoreElements()) {
                str = token.nextToken();
                if (index != 0) {
                    lineData2.add(str);
                }
                ++index;
            }
            fluxesData.add(lineData2);
        }
        if (speciesData.size() > 0) {
            this.time = new double[timeData.size()];
            firstData = (ArrayList)speciesData.get(0);
            this.species = new TimeCourse(this.time.length, firstData.size());
            this.timepoints = timeData.size();
            this.species.setNum_val(firstData.size());
            if (speciesNames.size() > 0) {
                this.species.setNames(speciesNames.toArray(new String[speciesNames.size()]));
            }
            int i = 0;
            while (i < timeData.size()) {
                timeStr = (String)timeData.get(i);
                this.time[i] = Double.parseDouble(timeStr);
                lineData = (ArrayList)speciesData.get(i);
                valuesAtT = new double[firstData.size()];
                k = 0;
                while (k < lineData.size()) {
                    valuesAtT[k] = Double.parseDouble((String)lineData.get(k));
                    ++k;
                }
                this.species.setValue(i, valuesAtT);
                ++i;
            }
        }
        if (compartmentsData.size() > 0) {
            this.time = new double[timeData.size()];
            firstData = (ArrayList)compartmentsData.get(0);
            this.compartments = new TimeCourse(this.time.length, firstData.size());
            this.timepoints = timeData.size();
            this.compartments.setNum_val(firstData.size());
            if (compartmentsNames.size() > 0) {
                this.compartments.setNames(names.toArray(new String[compartmentsNames.size()]));
            }
            int i = 0;
            while (i < timeData.size()) {
                timeStr = (String)timeData.get(i);
                this.time[i] = Double.parseDouble(timeStr);
                lineData = (ArrayList)compartmentsData.get(i);
                valuesAtT = new double[firstData.size()];
                k = 0;
                while (k < lineData.size()) {
                    valuesAtT[k] = Double.parseDouble((String)lineData.get(k));
                    ++k;
                }
                this.compartments.setValue(i, valuesAtT);
                ++i;
            }
        }
        if (parametersData.size() > 0) {
            this.time = new double[timeData.size()];
            firstData = (ArrayList)parametersData.get(0);
            this.parameters = new TimeCourse(this.time.length, firstData.size());
            if (names.size() > 0) {
                this.parameters.setNames(names.toArray(new String[names.size()]));
            }
            this.timepoints = timeData.size();
            this.parameters.setNum_val(firstData.size());
            int i = 0;
            while (i < timeData.size()) {
                timeStr = (String)timeData.get(i);
                this.time[i] = Double.parseDouble(timeStr);
                lineData = (ArrayList)parametersData.get(i);
                valuesAtT = new double[firstData.size()];
                k = 0;
                while (k < lineData.size()) {
                    valuesAtT[k] = Double.parseDouble((String)lineData.get(k));
                    ++k;
                }
                this.parameters.setValue(i, valuesAtT);
                ++i;
            }
        }
        if (fluxesData.size() > 0) {
            this.time = new double[timeData.size()];
            firstData = (ArrayList)fluxesData.get(0);
            this.fluxes = new TimeCourse(this.time.length, firstData.size());
            this.timepoints = timeData.size();
            this.fluxes.setNum_val(firstData.size());
            if (fluxesNames.size() > 0) {
                this.fluxes.setNames(fluxesNames.toArray(new String[fluxesNames.size()]));
            }
            int i = 0;
            while (i < timeData.size()) {
                timeStr = (String)timeData.get(i);
                this.time[i] = Double.parseDouble(timeStr);
                lineData = (ArrayList)fluxesData.get(i);
                valuesAtT = new double[firstData.size()];
                k = 0;
                while (k < lineData.size()) {
                    valuesAtT[k] = Double.parseDouble((String)lineData.get(k));
                    ++k;
                }
                this.fluxes.setValue(i, valuesAtT);
                ++i;
            }
        }
        in.close();
        reader.close();
    }

    private void init(int timepoints, double[] time) {
        this.timepoints = timepoints;
        this.time = time;
    }

    public SBMLResults(CCopasiTask task) {
        this();
        this.initForCopasi(task);
        this.setSimulationResults(task);
    }

    public SBMLResults(MultiTable solution, ListOf<Species> los) {
        this();
        this.timepoints = solution.getTimePoints().length;
        this.setTime(solution);
        this.setSimulationResults(solution, los);
    }

    private void setSimulationResults(MultiTable solution, ListOf<Species> los) {
        this.timepoints = solution.getTimePoints().length;
        int numSpecies = los.size();
        this.species = new TimeCourse(this.timepoints, numSpecies);
        this.species.setNames(new String[numSpecies]);
        this.setSpeciesNames(solution, los);
        int i = 0;
        while (i < this.timepoints) {
            double[] valSpecies = new double[numSpecies];
            int k = 0;
            int j = 1;
            while (j < solution.getColumnCount()) {
                if (los.get(solution.getColumnName(j)) != null) {
                    valSpecies[k] = solution.getValueAt(i, j);
                    ++k;
                }
                ++j;
            }
            this.species.setValue(i, valSpecies);
            ++i;
        }
    }

    private void setSpeciesNames(MultiTable solution, ListOf<Species> los) {
        int i = 0;
        int j = 1;
        while (j < solution.getColumnCount()) {
            if (los.get(solution.getColumnName(j)) != null) {
                this.species.setName(i, solution.getColumnName(j));
                ++i;
            }
            ++j;
        }
    }

    private void setSimulationResults(CCopasiTask task) {
        CTimeSeries timeSeries = ((CTrajectoryTask)task).getTimeSeries();
        CModel cModel = ((CTrajectoryTask)task).getProblem().getModel();
        int numSpecies = (int)cModel.getNumMetabs();
        int numCompartments = (int)cModel.getNumCompartments();
        int numNonconstCompartments = Copasi.getNumNonconstCompartments(cModel);
        int numParameters = (int)cModel.getNumModelValues();
        int numNonconstParameters = Copasi.getNumNonconstParameters(cModel);
        int i = 0;
        while (i < this.timepoints) {
            int j;
            int noffset;
            int offset = 1;
            if (numSpecies > 0) {
                double[] valSpecies = new double[numSpecies];
                int j2 = offset;
                while (j2 < offset + numSpecies) {
                    valSpecies[j2 - 1] = timeSeries.getConcentrationData((long)i, (long)j2);
                    ++j2;
                }
                this.species.setValue(i, valSpecies);
            }
            offset += numSpecies;
            if (numNonconstCompartments > 0) {
                double[] valCompartment = new double[numNonconstCompartments];
                noffset = 0;
                j = offset;
                while (j < offset + numCompartments) {
                    if (!cModel.getCompartment((long)(j - offset)).isFixed()) {
                        valCompartment[noffset++] = timeSeries.getConcentrationData((long)i, (long)j);
                    }
                    ++j;
                }
                this.compartments.setValue(i, valCompartment);
            }
            offset += numCompartments;
            if (numNonconstParameters > 0) {
                double[] valParameters = new double[numNonconstParameters];
                noffset = 0;
                j = offset;
                while (j < offset + numParameters) {
                    if (!cModel.getModelValue((long)(j - offset)).isFixed()) {
                        valParameters[noffset++] = timeSeries.getConcentrationData((long)i, (long)j);
                    }
                    ++j;
                }
                this.parameters.setValue(i, valParameters);
            }
            ++i;
        }
    }

    private void initForCopasi(CCopasiTask task) {
        CTimeSeries timeSeries = ((CTrajectoryTask)task).getTimeSeries();
        CModel cModel = ((CTrajectoryTask)task).getProblem().getModel();
        this.timepoints = (int)timeSeries.getRecordedSteps();
        int numSpecies = (int)cModel.getNumMetabs();
        int numFluxes = (int)cModel.getNumReactions();
        int numCompartments = (int)cModel.getNumCompartments();
        int numNonconstCompartments = Copasi.getNumNonconstCompartments(cModel);
        int numParameters = (int)cModel.getNumModelValues();
        int numNonconstParameters = Copasi.getNumNonconstParameters(cModel);
        this.setTime(timeSeries);
        if (numSpecies > 0) {
            this.species = new TimeCourse(this.timepoints, numSpecies);
            this.species.setNames(new String[0]);
            this.setSpeciesNames(task);
        }
        if (numNonconstParameters > 0) {
            this.parameters = new TimeCourse(this.timepoints, numNonconstParameters);
            this.parameters.setNames(new String[0]);
            this.setParameterNames(task);
        }
        if (numNonconstCompartments > 0) {
            this.compartments = new TimeCourse(this.timepoints, numNonconstCompartments);
            this.compartments.setNames(new String[0]);
            this.setCompartmentNames(task);
        }
    }

    private void setTime(CTimeSeries timeSeries) {
        this.time = new double[this.timepoints];
        int i = 0;
        while (i < this.timepoints) {
            this.time[i] = timeSeries.getConcentrationData((long)i, 0L);
            ++i;
        }
    }

    private void setTime(MultiTable solution) {
        this.time = new double[this.timepoints];
        int i = 0;
        while (i < this.timepoints) {
            this.time[i] = new BigDecimal(solution.getTimePoint(i)).setScale(8, 4).doubleValue();
            ++i;
        }
    }

    private void setSpeciesNames(CCopasiTask task) {
        int numSpecies = (int)((CTrajectoryTask)task).getProblem().getModel().getNumMetabs();
        Vector<String> columnNames = new Vector<String>();
        int i = 0;
        while (i < numSpecies) {
            columnNames.addElement(task.getProblem().getModel().getMetabolite((long)i).getSBMLId());
            ++i;
        }
        this.species.setNames(columnNames.toArray(new String[0]));
    }

    private void setFluxNames(CCopasiTask task) {
        int numFluxes = (int)task.getProblem().getModel().getNumReactions();
        Vector<String> fluxNames = new Vector<String>();
        int i = 0;
        while (i < numFluxes) {
            fluxNames.addElement(task.getProblem().getModel().getReaction((long)i).getSBMLId());
            ++i;
        }
        this.fluxes.setNames(fluxNames.toArray(new String[0]));
    }

    private void setParameterNames(CCopasiTask task) {
        CModel cModel = task.getProblem().getModel();
        int numParameters = (int)cModel.getNumModelValues();
        Vector<String> parameterNames = new Vector<String>();
        int i = 0;
        while (i < numParameters) {
            if (!cModel.getModelValue((long)i).isFixed()) {
                parameterNames.addElement(task.getProblem().getModel().getModelValue((long)i).getSBMLId());
            }
            ++i;
        }
        this.parameters.setNames(parameterNames.toArray(new String[0]));
    }

    private void setCompartmentNames(CCopasiTask task) {
        CModel cModel = task.getProblem().getModel();
        int numCompartments = (int)task.getProblem().getModel().getNumCompartments();
        Vector<String> compartmentNames = new Vector<String>();
        int i = 0;
        while (i < numCompartments) {
            if (!cModel.getCompartment((long)i).isFixed()) {
                compartmentNames.addElement(task.getProblem().getModel().getCompartment((long)i).getSBMLId());
            }
            ++i;
        }
        this.compartments.setNames(compartmentNames.toArray(new String[0]));
    }

    public void setTimepoints(int nout) {
        this.timepoints = nout;
    }

    public void setTime(double[] time) {
        this.time = time;
    }

    public void setSpecies(TimeCourse species) {
        this.species = species;
    }

    public void setCompartments(TimeCourse compartments) {
        this.compartments = compartments;
    }

    public void setParameters(TimeCourse parameters) {
        this.parameters = parameters;
    }

    public void setFluxes(TimeCourse fluxes) {
        this.fluxes = fluxes;
    }

    public int getTimepoints() {
        return this.timepoints;
    }

    public double[] getTime() {
        return this.time;
    }

    public double getTime(int timeIndex) {
        return this.time[timeIndex];
    }

    public TimeCourse getSpecies() {
        return this.species;
    }

    public TimeCourse getCompartments() {
        return this.compartments;
    }

    public TimeCourse getParameters() {
        return this.parameters;
    }

    public TimeCourse getFluxes() {
        return this.fluxes;
    }

    public void outputFile(String fileName) throws IOException {
        int j;
        int i;
        PrintWriter pw = new PrintWriter(new FileWriter(fileName));
        pw.print("#species\n");
        if (this.species != null && this.species.getNum_val() > 0) {
            pw.print(TIME);
            i = 0;
            while (i < this.species.names.length) {
                pw.print(" " + this.species.names[i]);
                ++i;
            }
            pw.print("\n");
            i = 0;
            while (i < this.time.length) {
                pw.print(String.valueOf(this.getTime(i)) + " ");
                j = 0;
                while (j < this.species.getValues()[0].length) {
                    pw.print(String.valueOf(this.species.getValue(i, j)) + " ");
                    ++j;
                }
                pw.println();
                ++i;
            }
        }
        pw.print("#compartments\n");
        if (this.compartments != null && this.compartments.getNum_val() > 0) {
            pw.print(TIME);
            i = 0;
            while (i < this.compartments.names.length) {
                pw.print(" " + this.compartments.names[i]);
                ++i;
            }
            pw.print("\n");
            i = 0;
            while (i < this.time.length) {
                pw.print(String.valueOf(this.getTime(i)) + " ");
                j = 0;
                while (j < this.compartments.getNames().length) {
                    pw.print(String.valueOf(this.compartments.getValue(i, j)) + " ");
                    ++j;
                }
                pw.println();
                ++i;
            }
        }
        pw.print("#parameters\n");
        if (this.parameters != null && this.parameters.getNum_val() > 0) {
            pw.print(TIME);
            i = 0;
            while (i < this.parameters.names.length) {
                pw.print(" " + this.parameters.names[i]);
                ++i;
            }
            pw.print("\n");
            i = 0;
            while (i < this.time.length) {
                pw.print(String.valueOf(this.getTime(i)) + " ");
                j = 0;
                while (j < this.parameters.getNames().length) {
                    pw.print(String.valueOf(this.parameters.getValue(i, j)) + " ");
                    ++j;
                }
                pw.println();
                ++i;
            }
        }
        pw.print("#fluxes\n");
        if (this.fluxes != null && this.fluxes.getNum_val() > 0) {
            pw.print(TIME);
            i = 0;
            while (i < this.fluxes.names.length) {
                pw.print(" " + this.fluxes.names[i]);
                ++i;
            }
            pw.print("\n");
            i = 0;
            while (i < this.time.length) {
                pw.print(String.valueOf(this.getTime(i)) + " ");
                j = 0;
                while (j < this.fluxes.getNames().length) {
                    pw.print(String.valueOf(this.fluxes.getValue(i, j)) + " ");
                    ++j;
                }
                pw.println();
                ++i;
            }
        }
        pw.close();
    }

    public void printConcentrationTimeCourse() {
        int i = 0;
        while (i < this.time.length) {
            System.out.print(String.valueOf(this.getTime(i)) + " ");
            int j = 0;
            while (j < this.species.getNum_val()) {
                System.out.print(String.valueOf(this.species.getValue(i, j)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.compartments.getNum_val()) {
                System.out.print(String.valueOf(this.compartments.getValue(i, j)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.parameters.getNum_val()) {
                System.out.print(String.valueOf(this.parameters.getValue(i, j)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.fluxes.getNum_val()) {
                System.out.print(String.valueOf(this.fluxes.getValue(i, j)) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void printSpeciesConcentration() {
        if (this.species != null && this.species.getNum_val() > 0) {
            System.out.print(TIME);
            int i = 0;
            while (i < this.species.getNames().length) {
                System.out.print("\t" + this.species.getNames()[i]);
                ++i;
            }
            System.out.println();
            i = 0;
            while (i < this.time.length) {
                System.out.print(String.valueOf(this.getTime(i)) + "\t");
                int j = 0;
                while (j < this.species.getValues()[0].length) {
                    System.out.print(String.valueOf(this.species.getValue(i, j)) + "\t");
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getParameterInfo() {
        return this.parameterInfo;
    }

    public void setParameterInfo(String parameterInfo) {
        this.parameterInfo = parameterInfo;
    }

    public String toString() {
        String r = "Path: " + this.getPath() + "\nTimePoints: " + this.getTimepoints() + "\nParameter Info: " + this.getParameterInfo() + "\nSpecies #: " + this.getSpecies().getNum_val() + "\nFluxes #: " + this.getFluxes().getNum_val() + "\nCompartments #: " + this.getCompartments().getNum_val() + "\nParameters #: " + this.getParameters().getNum_val();
        return r;
    }
}

