/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CvodeResults {
    int ntime;
    int neq;
    int nass;
    int nconst;
    double[] time;
    String[] species;
    String[] ass_parameter;
    String[] parameter;
    double[][] value;
    double[][] avalue;
    double[][] pvalue;
    private String path;
    private String parameterInfo;

    private CvodeResults() {
    }

    public CvodeResults(int ntime, int neq, int nass, int nconst) {
        this();
        this.init(ntime, neq, nass, nconst);
    }

    private void init(int ntime, int neq, int nass, int nconst) {
        this.ntime = ntime;
        this.neq = neq;
        this.nass = nass;
        this.nconst = nconst;
        this.value = new double[neq][];
        this.avalue = new double[nass][];
        this.pvalue = new double[nconst][];
    }

    public void setTime(double[] time) {
        this.time = time;
    }

    public void setSpecies(String[] species) {
        this.species = species;
    }

    public void setAss_parameter(String[] ass_parameter) {
        this.ass_parameter = ass_parameter;
    }

    public void setParameter(String[] parameter) {
        this.parameter = parameter;
    }

    public void setValue(int eqIndex, double[] value) {
        this.value[eqIndex] = value;
    }

    public void setAvalue(int assIndex, double[] avalue) {
        this.avalue[assIndex] = avalue;
    }

    public void setPvalue(int constIndex, double[] pvalue) {
        this.pvalue[constIndex] = pvalue;
    }

    public double getTime(int timeIndex) {
        return this.time[timeIndex];
    }

    public String getSpecies(int speciesIndex) {
        return this.species[speciesIndex];
    }

    public String getAss_parameter(int ass_parameterIndex) {
        return this.ass_parameter[ass_parameterIndex];
    }

    public String getParameter(int parameterIndex) {
        return this.parameter[parameterIndex];
    }

    public int getNumberOfTimePoint() {
        return this.ntime;
    }

    public int getNeq() {
        return this.neq;
    }

    public int getNass() {
        return this.nass;
    }

    public int getNconst() {
        return this.nconst;
    }

    public double getValue(int eqIndex, int timeIndex) {
        return this.value[eqIndex][timeIndex];
    }

    public double getAvalue(int assIndex, int timeIndex) {
        return this.avalue[assIndex][timeIndex];
    }

    public double getPvalue(int constIndex, int timeIndex) {
        return this.pvalue[constIndex][timeIndex];
    }

    public void outputFile(String fileName) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(fileName));
        int i = 0;
        while (i < this.ntime) {
            pw.print(String.valueOf(this.getTime(i)) + " ");
            int j = 0;
            while (j < this.neq) {
                pw.print(String.valueOf(this.getValue(j, i)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.nass) {
                pw.print(String.valueOf(this.getAvalue(j, i)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.nconst) {
                pw.print(String.valueOf(this.getPvalue(j, i)) + " ");
                ++j;
            }
            pw.println();
            ++i;
        }
        pw.close();
    }

    public void getOutputFile(String fileName) throws IOException {
        String line;
        FileReader reader = new FileReader(fileName);
        BufferedReader in = new BufferedReader(reader);
        ArrayList data = new ArrayList();
        ArrayList<String> timeData = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            StringTokenizer token = new StringTokenizer(line, " ");
            int index = 0;
            ArrayList<String> lineData = new ArrayList<String>();
            while (token.hasMoreElements()) {
                String str = token.nextToken();
                if (index == 0) {
                    timeData.add(str);
                } else {
                    lineData.add(str);
                }
                ++index;
            }
            data.add(lineData);
        }
        this.time = new double[timeData.size()];
        this.ntime = timeData.size();
        ArrayList firstData = (ArrayList)data.get(0);
        this.value = new double[firstData.size()][timeData.size()];
        this.neq = firstData.size();
        int i = 0;
        while (i < timeData.size()) {
            String timeStr = (String)timeData.get(i);
            this.time[i] = Double.parseDouble(timeStr);
            ArrayList lineData = (ArrayList)data.get(i);
            int k = 0;
            while (k < lineData.size()) {
                this.value[k][i] = Double.parseDouble((String)lineData.get(k));
                ++k;
            }
            ++i;
        }
        in.close();
        reader.close();
    }

    public void printConcentrationTimeCourse() {
        int i = 0;
        while (i < this.ntime) {
            System.out.print(String.valueOf(this.getTime(i)) + " ");
            int j = 0;
            while (j < this.neq) {
                System.out.print(String.valueOf(this.getValue(j, i)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.nass) {
                System.out.print(String.valueOf(this.getAvalue(j, i)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.nconst) {
                System.out.print(String.valueOf(this.getPvalue(j, i)) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getParameterInfo() {
        return this.parameterInfo;
    }

    public void setParameterInfo(String parameterInfo) {
        this.parameterInfo = parameterInfo;
    }
}

