/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jp.co.mki.celldesigner.simulation.TimeCourse;

public class AllResults {
    int nout;
    double[] time;
    TimeCourse species;
    TimeCourse compartments;
    TimeCourse parameters;
    TimeCourse fluxes;
    TimeCourse jacobians;
    TimeCourse odes;
    private String path;
    private String parameterInfo;

    private AllResults() {
    }

    public AllResults(int nout, double[] time) {
        this();
        this.init(nout, time);
    }

    private void init(int nout, double[] time) {
        this.nout = nout;
        this.time = time;
    }

    public void setNout(int nout) {
        this.nout = nout;
    }

    public void setTime(double[] time) {
        this.time = time;
    }

    public void setSpecies(TimeCourse species) {
        this.species = species;
    }

    public void setCompartments(TimeCourse compartments) {
        this.compartments = compartments;
    }

    public void setParameters(TimeCourse parameters) {
        this.parameters = parameters;
    }

    public void setFluxes(TimeCourse fluxes) {
        this.fluxes = fluxes;
    }

    public void setJacobians(TimeCourse jacobians) {
        this.jacobians = jacobians;
    }

    public void setOdes(TimeCourse odes) {
        this.odes = odes;
    }

    public int getNout() {
        return this.nout;
    }

    public double[] getTime() {
        return this.time;
    }

    public double getTime(int timeIndex) {
        return this.time[timeIndex];
    }

    public TimeCourse getSpecies() {
        return this.species;
    }

    public TimeCourse getCompartments() {
        return this.compartments;
    }

    public TimeCourse getParameters() {
        return this.parameters;
    }

    public TimeCourse getFluxes() {
        return this.fluxes;
    }

    public TimeCourse getJacobians() {
        return this.jacobians;
    }

    public TimeCourse getOdes() {
        return this.odes;
    }

    public void outputFile(String fileName) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(fileName));
        int i = 0;
        while (i < this.time.length) {
            pw.print(String.valueOf(this.getTime(i)) + " ");
            int j = 0;
            while (j < this.species.getNum_val()) {
                pw.print(String.valueOf(this.species.getValue(i, j)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.compartments.getNum_val()) {
                pw.print(String.valueOf(this.compartments.getValue(i, j)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.parameters.getNum_val()) {
                pw.print(String.valueOf(this.parameters.getValue(i, j)) + " ");
                ++j;
            }
            pw.println();
            ++i;
        }
        pw.close();
    }

    public void getOutputFile(String fileName) throws IOException {
        String line;
        FileReader reader = new FileReader(fileName);
        BufferedReader in = new BufferedReader(reader);
        ArrayList data = new ArrayList();
        ArrayList<String> timeData = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            StringTokenizer token = new StringTokenizer(line, " ");
            int index = 0;
            ArrayList<String> lineData = new ArrayList<String>();
            while (token.hasMoreElements()) {
                String str = token.nextToken();
                if (index == 0) {
                    timeData.add(str);
                } else {
                    lineData.add(str);
                }
                ++index;
            }
            data.add(lineData);
        }
        this.time = new double[timeData.size()];
        ArrayList firstData = (ArrayList)data.get(0);
        this.species = new TimeCourse(this.time.length, firstData.size());
        this.nout = firstData.size();
        int i = 0;
        while (i < timeData.size()) {
            String timeStr = (String)timeData.get(i);
            this.time[i] = Double.parseDouble(timeStr);
            ArrayList lineData = (ArrayList)data.get(i);
            double[] valuesAtT = new double[firstData.size()];
            int k = 0;
            while (k < lineData.size()) {
                valuesAtT[k] = Double.parseDouble((String)lineData.get(k));
                ++k;
            }
            this.species.setValue(i, valuesAtT);
            ++i;
        }
        in.close();
        reader.close();
    }

    public void printConcentrationTimeCourse() {
        int i = 0;
        while (i < this.time.length) {
            System.out.print(String.valueOf(this.getTime(i)) + " ");
            int j = 0;
            while (j < this.species.getNum_val()) {
                System.out.print(String.valueOf(this.species.getValue(i, j)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.compartments.getNum_val()) {
                System.out.print(String.valueOf(this.compartments.getValue(i, j)) + " ");
                ++j;
            }
            j = 0;
            while (j < this.parameters.getNum_val()) {
                System.out.print(String.valueOf(this.parameters.getValue(i, j)) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getParameterInfo() {
        return this.parameterInfo;
    }

    public void setParameterInfo(String parameterInfo) {
        this.parameterInfo = parameterInfo;
    }
}

