/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.samples;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class EventDemo1 {
    static int shapeCount = 0;
    static Stroke lineStroke = new BasicStroke(2.0f);

    public EventDemo1() {
        JFrame frame = new JFrame("GEF Application Demo");
        frame.setBounds(10, 10, 1000, 900);
        frame.setDefaultCloseOperation(3);
        JPanel contentPane = (JPanel)frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        JButton button1 = new JButton("edit");
        JButton button2 = new JButton("move");
        toolBar.add(button1);
        toolBar.add(button2);
        contentPane.add((Component)toolBar, "North");
        MyLayeredPane docVC = new MyLayeredPane();
        contentPane.add((Component)docVC, "Center");
        this.setupContent(docVC);
        frame.show();
    }

    private void setupContent(JLayeredPane content) {
        content.setLayout(null);
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(12345L);
            System.out.println("content=" + content);
            int xmax = 1000;
            int ymax = 850;
            int i = 0;
            while (i < 1000) {
                MyShapeVC panel;
                int x = random.nextInt(xmax + 1);
                int y = random.nextInt(ymax + 1);
                switch (i % 3) {
                    case 0: {
                        panel = new MyRoundRectShapeVC(x, y);
                        break;
                    }
                    case 1: {
                        panel = new MyLineShapeVC(x, y);
                        break;
                    }
                    default: {
                        panel = new MyShapeVC(x, y);
                    }
                }
                content.add(panel);
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new EventDemo1();
    }

    class MyLayeredPane
    extends JLayeredPane
    implements MouseListener,
    MouseMotionListener {
        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            System.out.println("mouseMoved in layeredPane (" + x + ", " + y + ")");
        }
    }

    class MyLineShapeVC
    extends MyShapeVC {
        public MyLineShapeVC(int x, int y) {
            super(x, y);
        }

        @Override
        protected void paintHilited(Graphics2D g2) {
            Color foreColor = g2.getColor();
            g2.setStroke(lineStroke);
            g2.setColor(Color.CYAN);
            g2.drawLine(0, 0, this.width, this.height);
            g2.setColor(foreColor);
        }

        @Override
        protected void paintNotHilited(Graphics2D g2) {
            Color foreColor = g2.getColor();
            g2.setStroke(lineStroke);
            g2.setColor(foreColor);
            g2.drawLine(0, 0, this.width, this.height);
        }
    }

    class MyRoundRectShapeVC
    extends MyShapeVC {
        public MyRoundRectShapeVC(int x, int y) {
            super(x, y);
        }

        @Override
        protected void paintHilited(Graphics2D g2) {
            Color backColor = g2.getBackground();
            Color foreColor = g2.getColor();
            g2.setColor(backColor);
            g2.fillRoundRect(0, 0, this.width, this.height, 8, 8);
            g2.setColor(Color.CYAN);
            g2.drawRoundRect(0, 0, this.width, this.height, 8, 8);
            g2.setColor(foreColor);
        }

        @Override
        protected void paintNotHilited(Graphics2D g2) {
            Color backColor = g2.getBackground();
            Color foreColor = g2.getColor();
            g2.setColor(backColor);
            g2.fillRoundRect(0, 0, this.width, this.height, 8, 8);
            g2.setColor(foreColor);
            g2.drawRoundRect(0, 0, this.width, this.height, 8, 8);
        }
    }

    class MyShapeVC
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        protected int pressedX;
        protected int pressedY;
        protected int id;
        protected boolean mousePressed = false;
        protected boolean hilited = false;

        public MyShapeVC(int x, int y) {
            this.x = x;
            this.y = y;
            this.width = 30;
            this.height = 15;
            this.id = shapeCount++;
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBounds(this.x, this.y, this.width + 1, this.height + 1);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public int getId() {
            return this.id;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.hilited) {
                this.paintHilited(g2);
            } else {
                this.paintNotHilited(g2);
            }
        }

        protected void paintHilited(Graphics2D g2) {
            g2.clearRect(0, 0, this.width, this.height);
            g2.setColor(Color.CYAN);
            g2.drawRect(0, 0, this.width, this.height);
            g2.setColor(Color.BLACK);
        }

        protected void paintNotHilited(Graphics2D g2) {
            g2.clearRect(0, 0, this.width, this.height);
            g2.drawRect(0, 0, this.width, this.height);
        }

        protected void myRepaint() {
            this.setLocation(this.x - 1, this.y);
            this.setLocation(this.x, this.y);
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            new MyThread(EventDemo1.this, this){

                @Override
                public void run() {
                    System.out.println("mouseEntered with " + ((MyShapeVC)this.c).getId());
                }
            }.run();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            new MyThread(EventDemo1.this, this){

                @Override
                public void run() {
                    System.out.println("mouseEntered with " + ((MyShapeVC)this.c).getId());
                }
            }.run();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.hilited = true;
            int x = e.getX();
            int y = e.getY();
            this.pressedX = x;
            this.pressedY = y;
            this.myRepaint();
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            this.mousePressed = false;
            this.hilited = false;
            this.myRepaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int newMouseX = e.getX();
            int newMouseY = e.getY();
            int dx = newMouseX - this.pressedX;
            int dy = newMouseY - this.pressedY;
            int newx = this.x + dx;
            int newy = this.y + dy;
            this.x = newx;
            this.y = newy;
            this.setLocation(newx, newy);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    abstract class MyThread
    implements Runnable {
        protected JComponent c;

        public MyThread(JComponent c) {
            this.c = c;
        }

        @Override
        public abstract void run();
    }
}

