/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;

public class XYAnchorImpl
extends AnchorImpl {
    protected SimpleAnchorImpl xAnchor;
    protected SimpleAnchorImpl yAnchor;
    protected TreeSet shapes;

    public XYAnchorImpl(SimpleAnchorImpl xAnchor, SimpleAnchorImpl yAnchor) {
        this.xAnchor = xAnchor;
        this.yAnchor = yAnchor;
        this.x = xAnchor.getX();
        this.y = yAnchor.getY();
        this.shapes = new TreeSet();
        this.shapes.addAll(xAnchor.getShapes());
        this.shapes.addAll(yAnchor.getShapes());
    }

    @Override
    public void initialize(ShapeModelImpl shape) {
    }

    @Override
    protected void decideXY() {
        this.xAnchor.decideXY();
        this.yAnchor.decideXY();
        this.x = this.xAnchor.x;
        this.y = this.yAnchor.y;
    }

    @Override
    protected void moveOffset(int dx, int dy) {
        this.xAnchor.moveOffset(dx, 0);
        this.yAnchor.moveOffset(0, dy);
        this.decideXY();
    }

    @Override
    protected void moveOffsetByOwnerResize(int dx, int dy) {
        this.moveOffset(dx, dy);
    }

    @Override
    protected void moveOffsetByResize(ShapeModelImpl target, int oldWidth, int oldHeight, int width, int height) {
        if (this.xAnchor.getShapes().contains(target)) {
            this.xAnchor.moveOffsetByResize(target, oldWidth, oldHeight, width, height);
        } else if (this.yAnchor.getShapes().contains(target)) {
            this.yAnchor.moveOffsetByResize(target, oldWidth, oldHeight, width, height);
        } else {
            System.out.println(" unknown target!!!!!!!!!!!!!!!!");
            System.out.println("  target=" + target);
            System.out.println("  xAnchor's shapes=" + this.xAnchor.getShapes());
            System.out.println("  yAnchor's shapes=" + this.yAnchor.getShapes());
            new Exception().printStackTrace();
        }
    }

    @Override
    public Set getShapes() {
        return Collections.unmodifiableSet(this.shapes);
    }

    @Override
    public void updateOffset(AnchoredShapeModelImpl ashape) {
        this.xAnchor.updateOffset(ashape);
        this.yAnchor.updateOffset(ashape);
        this.decideXY();
    }

    @Override
    public ShapeModelImpl getFirstShapeOfShapes() {
        throw new IllegalStateException();
    }

    @Override
    public double getOffsetX() {
        return this.xAnchor.getOffsetX();
    }

    @Override
    public double getOffsetY() {
        return this.yAnchor.getOffsetY();
    }
}

