/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;

public class SimpleAnchorImpl
extends AnchorImpl {
    protected ShapeModelImpl shape;
    protected TreeSet shapes = new TreeSet();
    public static final int AT_CENTER = 0;
    public static final int AT_NORTH = 1;
    public static final int AT_SOUTH = 2;
    public static final int AT_EAST = 3;
    public static final int AT_WEST = 4;
    public static final int AT_NORTHWEST = 5;
    public static final int AT_NORTHEAST = 6;
    public static final int AT_SOUTHWEST = 7;
    public static final int AT_SOUTHEAST = 8;
    public static final int WITH_CENTER = 10;
    public static final int WITH_HANDLE = 11;
    protected int atType;
    protected int withType;
    protected double offsetX;
    protected double offsetY;
    protected int lastWidthOfShape;
    protected int lastHeightOfShape;

    protected SimpleAnchorImpl() {
    }

    public SimpleAnchorImpl(int atType) {
        this(atType, 10, 0.0, 0.0);
    }

    public SimpleAnchorImpl(int atType, int withType) {
        this(atType, withType, 0.0, 0.0);
    }

    public SimpleAnchorImpl(int atType, int withType, double dx, double dy) {
        this();
        if (atType < 0 || atType > 8) {
            throw new IllegalArgumentException("invalid atType:" + atType);
        }
        if (withType < 10 || withType > 11) {
            throw new IllegalArgumentException("invalid withType:" + withType);
        }
        this.atType = atType;
        this.withType = withType;
        this.offsetX = dx;
        this.offsetY = dy;
    }

    @Override
    public void initialize(ShapeModelImpl shape) {
        this.shape = shape;
        this.shapes.add(shape);
        this.lastWidthOfShape = shape.width;
        this.lastHeightOfShape = shape.height;
        this.decideXY();
    }

    @Override
    protected void decideXY() {
        switch (this.atType) {
            case 3: 
            case 6: 
            case 8: {
                this.x = (double)(this.shape.x + this.shape.width) + this.offsetX;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                this.x = (double)this.shape.x + this.offsetX;
                break;
            }
            default: {
                this.x = (double)(this.shape.x + this.shape.getCenterOffsetX()) + this.offsetX;
            }
        }
        switch (this.atType) {
            case 1: 
            case 5: 
            case 6: {
                this.y = (double)this.shape.y + this.offsetY;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                this.y = (double)(this.shape.y + this.shape.height) + this.offsetY;
                break;
            }
            default: {
                this.y = (double)(this.shape.y + this.shape.getCenterOffsetY()) + this.offsetY;
            }
        }
    }

    @Override
    public void updateOffset(AnchoredShapeModelImpl ashape) {
        double newx = ashape.getAnchoredPointX(this);
        double newy = ashape.getAnchoredPointY(this);
        this.decideXY();
        double dx = newx - this.x;
        double dy = newy - this.y;
        this.offsetX += dx;
        this.offsetY += dy;
        this.decideXY();
    }

    @Override
    public void moveOffset(int dx, int dy) {
        this.offsetX += (double)dx;
        this.offsetY += (double)dy;
        this.decideXY();
    }

    @Override
    protected void moveOffsetByResize(ShapeModelImpl target, int oldWidth, int oldHeight, int width, int height) {
        switch (this.atType) {
            case 0: 
            case 1: 
            case 2: {
                if (oldWidth == width || oldWidth == 0) break;
                this.offsetX *= (double)width / (double)oldWidth;
            }
        }
        switch (this.atType) {
            case 0: 
            case 3: 
            case 4: {
                if (oldHeight == height || oldHeight == 0) break;
                this.offsetY *= (double)height / (double)oldHeight;
            }
        }
        this.decideXY();
    }

    @Override
    protected void moveOffsetByOwnerResize(int dx, int dy) {
        if (this.withType == 10) {
            this.moveOffset(dx, dy);
        }
    }

    public String toString() {
        return "offset=" + this.offsetX + "," + this.offsetY;
    }

    @Override
    public Set getShapes() {
        return Collections.unmodifiableSet(this.shapes);
    }

    @Override
    public ShapeModelImpl getFirstShapeOfShapes() {
        if (this.shapes != null && !this.shapes.isEmpty()) {
            return (ShapeModelImpl)this.shapes.iterator().next();
        }
        return null;
    }

    @Override
    public double getOffsetX() {
        return this.offsetX;
    }

    @Override
    public double getOffsetY() {
        return this.offsetY;
    }

    public String getAtTypeString() {
        switch (this.atType) {
            case 0: {
                return "center";
            }
            case 1: {
                return "north";
            }
            case 2: {
                return "south";
            }
            case 3: {
                return "east";
            }
            case 4: {
                return "west";
            }
            case 5: {
                return "northWest";
            }
            case 6: {
                return "northEast";
            }
            case 7: {
                return "southWest";
            }
            case 8: {
                return "southEast";
            }
        }
        return "?";
    }
}

