/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.Observable;
import java.util.Vector;
import javax.swing.JLayeredPane;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.MoverImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeHandleModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeHandleVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeWithHandleModelImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleMoverImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;

public class ShapeWithHandleVCImpl
extends AnchoredShapeVCImpl {
    protected Vector handleMovers;
    protected ShapeHandleVCImpl[] handleVCs;

    @Override
    public void initializevc(ModelImpl model) {
        super.initializevc(model);
        this.handleVCs = null;
        this.handleMovers = new Vector(){

            @Override
            public Object get(int index) {
                try {
                    return super.get(index);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return null;
                }
            }

            @Override
            public Object set(int index, Object obj) {
                int lack = index - this.size() + 1;
                if (lack > 0) {
                    int i = 0;
                    while (i < lack) {
                        this.addElement(null);
                        ++i;
                    }
                }
                return super.set(index, obj);
            }
        };
    }

    @Override
    protected Class getExpectedModelClass() {
        return ShapeWithHandleModelImpl.class;
    }

    protected boolean hasHandleVCs() {
        return this.handleVCs != null;
    }

    public void setHandleMovers(MoverImpl[] movers) {
        if (movers != null) {
            this.handleMovers = new Vector();
            int n = movers.length;
            int i = 0;
            while (i < n) {
                this.handleMovers.addElement(movers[i]);
                ++i;
            }
        }
    }

    protected void resizeByHandle(int type, int dx, int dy) {
        int minHeight;
        int minWidth = this.getMinWidth();
        if (type == 0 || type == 3) {
            dx = -dx;
        }
        int width = ((ShapeModelImpl)this.model).getWidth();
        int nextWidth = width + dx;
        if (!this.isReversible() && nextWidth < minWidth) {
            nextWidth = minWidth;
            dx = minWidth - width;
        } else {
            int actualNextWidth;
            int n = actualNextWidth = nextWidth > 0 ? nextWidth : 1 - nextWidth;
            if (actualNextWidth < minWidth) {
                dx = minWidth - width;
            }
        }
        if (type == 0 || type == 3) {
            dx = -dx;
        }
        if ((minHeight = this.getMinHeight()) > 0) {
            if (type == 0 || type == 2) {
                dy = -dy;
            }
            int height = ((ShapeModelImpl)this.model).getHeight();
            int nextHeight = height + dy;
            if (!this.isReversible() && nextHeight < minHeight) {
                nextHeight = minHeight;
                dy = minHeight - height;
            } else {
                int actualNextHeight;
                int n = actualNextHeight = nextHeight > 0 ? nextHeight : 1 - nextHeight;
                if (actualNextHeight < minHeight) {
                    dy = minHeight - height;
                }
            }
            if (type == 0 || type == 2) {
                dy = -dy;
            }
        }
        ((ShapeWithHandleModelImpl)this.model).resizeByHandle(type, dx, dy);
    }

    protected void createHandleVC(ShapeHandleModelImpl[] handles, int i) {
        this.handleVCs[i] = null;
        if (handles[i] != null) {
            this.handleMovers.ensureCapacity(i + 1);
            MoverImpl mover = (MoverImpl)this.handleMovers.get(i);
            if (mover == null) {
                mover = new SimpleMoverImpl();
                this.handleMovers.set(i, mover);
            }
            if (mover.isActive()) {
                this.handleVCs[i] = new ShapeHandleVCImpl();
                this.handleVCs[i].initializevc(handles[i]);
                this.add(this.handleVCs[i]);
                this.canvasVC.putToShapeVCsByModel(handles[i], this.handleVCs[i]);
                this.handleVCs[i].setHandleMover(mover);
            }
        }
    }

    @Override
    public void update(Observable model, Object aspect) {
        super.update(model, aspect);
        switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
            case 21: {
                ShapeHandleModelImpl[] handles = ((ShapeWithHandleModelImpl)this.getModel()).getHandles();
                if (handles == null) {
                    System.out.println("handles is null");
                }
                this.handleVCs = new ShapeHandleVCImpl[handles.length];
                this.createHandleVC(handles, 0);
                this.createHandleVC(handles, handles.length - 1);
                int i = 1;
                while (i < handles.length - 1) {
                    this.createHandleVC(handles, i);
                    ++i;
                }
                break;
            }
            case 12: {
                break;
            }
            case 22: {
                int i = 0;
                while (i < this.handleVCs.length) {
                    if (this.handleVCs[i] != null) {
                        this.handleVCs[i].remove();
                    }
                    ++i;
                }
                this.handleVCs = null;
            }
        }
    }

    @Override
    protected void addGuiComponentPrimitive(SwingVCImpl child) {
        this.canvasVC.component.add(child.component, JLayeredPane.DRAG_LAYER, 0);
    }
}

