/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeHandleModelImpl;

public class ShapeWithHandleModelImpl
extends AnchoredShapeModelImpl {
    protected ShapeHandleModelImpl[] handles;
    private static final int HANDLE_NUM = 4;

    @Override
    public void initialize(CanvasModelImpl canvas, int x, int y, int w, int h, boolean forDrag) {
        super.initialize(canvas, x, y, w, h, forDrag);
        this.handles = null;
    }

    @Override
    protected void updateHandles() {
        if (this.handles == null) {
            this.handles = new ShapeHandleModelImpl[4];
            int w = this.width - 1;
            int h = this.height - 1;
            this.setMyHandle1(0, this.x, this.y);
            this.setMyHandle1(2, this.x + w, this.y);
            this.setMyHandle1(1, this.x + w, this.y + h);
            this.setMyHandle1(3, this.x, this.y + h);
            this.setChanged();
            this.notifyObservers(21);
            this.clearChanged();
            this.canvas.setHandledShape(this);
        }
    }

    protected void setMyHandle1(int type, int x1, int y1) {
        this.handles[type] = new ShapeHandleModelImpl(this.canvas, this, x1, y1, type);
        this.handles[type].moveCenterOffsetWithoutNotify();
    }

    protected void removeHandles() {
        if (this.handles != null) {
            int i = 0;
            while (i < this.handles.length) {
                if (this.handles[i] != null) {
                    this.handles[i].remove();
                }
                ++i;
            }
            this.handles = null;
            this.setChanged();
            this.notifyObservers(22);
            this.clearChanged();
        }
    }

    protected boolean hasHandles() {
        return this.handles != null;
    }

    protected ShapeHandleModelImpl[] getHandles() {
        return this.handles;
    }

    @Override
    public void move(int dx, int dy) {
        if (this.hasHandles()) {
            int i = 0;
            while (i < this.handles.length) {
                if (this.handles[i] != null) {
                    this.handles[i].movePrimitive(dx, dy);
                }
                ++i;
            }
        }
        super.move(dx, dy);
    }

    public void resizeByHandle(int type, int dx, int dy) {
        this.handles[type].movePrimitive(dx, dy);
        int lastCx = this.getCenterX();
        int lastCy = this.getCenterY();
        int lastWidth = this.getWidth();
        int lastHeight = this.getHeight();
        switch (type) {
            case 0: {
                this.moveHandlePrimitive(3, dx, 0);
                this.moveHandlePrimitive(2, 0, dy);
                this.x += dx;
                this.y += dy;
                this.width -= dx;
                this.height -= dy;
                break;
            }
            case 2: {
                this.moveHandlePrimitive(1, dx, 0);
                this.moveHandlePrimitive(0, 0, dy);
                this.y += dy;
                this.width += dx;
                this.height -= dy;
                break;
            }
            case 1: {
                this.moveHandlePrimitive(3, 0, dy);
                this.moveHandlePrimitive(2, dx, 0);
                this.width += dx;
                this.height += dy;
                break;
            }
            case 3: {
                this.moveHandlePrimitive(1, 0, dy);
                this.moveHandlePrimitive(0, dx, 0);
                this.x += dx;
                this.width -= dx;
                this.height += dy;
            }
        }
        this.moveAnchor(lastCx, lastCy);
        int currentWidth = this.getWidth();
        int currentHeight = this.getHeight();
        this.setChanged();
        this.notifyObservers(31, lastWidth, lastHeight, currentWidth, currentHeight);
        this.clearChanged();
    }

    protected void moveHandlePrimitive(int index, int dx, int dy) {
        if (index < this.handles.length && this.handles[index] != null) {
            this.handles[index].movePrimitive(dx, dy);
        }
    }

    @Override
    protected boolean hasName() {
        return true;
    }

    @Override
    protected void removeChildren() {
        this.removeHandles();
        super.removeChildren();
    }
}

