/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Observable;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AspectConstants;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CompositeShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.DxDy;
import jp.co.fujiric.star.gui.gef.swing.MoverImpl;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.PointOnPolyline;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleMoverImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;

public class ShapeVCImpl
extends SwingVCImpl
implements AspectConstants,
MouseListener,
MouseMotionListener {
    private static Stroke stroke;
    private static Font font;
    private static int lineWidth;
    private static int lineHeight;
    protected MoverImpl mover = new SimpleMoverImpl();
    protected static final int minWidth = 3;
    protected static final int minHeight = 3;
    protected boolean forDrag;
    protected int mousePressedX;
    protected int mousePressedY;
    public static double NOT_CROSSED;
    protected static final double CROSSPOINTCHECK_EPS = 1.0E-10;

    static {
        font = new Font("Default", 0, 10);
        stroke = new BasicStroke(0.5f);
        lineWidth = ShapeVCImpl.updateLineWidth();
        lineHeight = ShapeVCImpl.updateLineHeight();
        NOT_CROSSED = 10.0;
    }

    protected static final Font getDefaultFont() {
        return font;
    }

    protected boolean needToFill() {
        return false;
    }

    protected Font getFont() {
        return font;
    }

    public void setMover(MoverImpl mover) {
        this.mover = mover;
    }

    protected static int updateLineWidth() {
        return (int)Math.ceil((double)((BasicStroke)stroke).getLineWidth() * 0.5);
    }

    protected static int updateLineHeight() {
        return ShapeVCImpl.updateLineWidth();
    }

    protected int getLineWidth() {
        return lineWidth;
    }

    protected int getLineHeight() {
        return lineHeight;
    }

    protected boolean contains(int x, int y) {
        if (this.component.contains(x, y)) {
            return this.containsCompletely(x, y);
        }
        return false;
    }

    protected boolean containsCompletely(int x, int y) {
        return true;
    }

    protected int getMinWidth() {
        return 3;
    }

    protected int getMinHeight() {
        return 3;
    }

    @Override
    public void initializevc(ModelImpl model) {
        super.initializevc(model);
        Class expectedClass = this.getExpectedModelClass();
        if (!expectedClass.isInstance(model)) {
            throw new IllegalArgumentException(String.valueOf(expectedClass.getName()) + " is expected: but " + model.getClass().getName());
        }
        if (!(model instanceof ShapeModelImpl)) {
            throw new IllegalArgumentException("ShapeModelImpl is expected");
        }
        this.forDrag = ((ShapeModelImpl)model).isForDrag();
        if (!this.forDrag && this.component != null) {
            this.component.addMouseListener(this);
            this.component.addMouseMotionListener(this);
        }
        this.mousePressedX = 0;
        this.mousePressedY = 0;
        if (this.component != null) {
            this.component.setFont(this.getFont());
        }
    }

    protected Class getExpectedModelClass() {
        return ShapeModelImpl.class;
    }

    @Override
    protected JComponent createComponent() {
        MyJPanel p = new MyJPanel(this);
        p.setOpaque(false);
        p.setBounds(this.getGUIComponentBounds());
        return p;
    }

    protected Rectangle getGUIOrigin() {
        int x = ((ShapeModelImpl)this.model).getX();
        int y = ((ShapeModelImpl)this.model).getY();
        int w = ((ShapeModelImpl)this.model).getWidth();
        int h = ((ShapeModelImpl)this.model).getHeight();
        Rectangle r = new Rectangle();
        r.x = x;
        r.y = y;
        r.width = w;
        r.height = h;
        return r;
    }

    protected Rectangle getGUIComponentBounds() {
        Rectangle r = this.getGUIBounds();
        r.x -= this.getLineWidth();
        r.width += this.getLineWidth() * 2;
        r.y -= this.getLineHeight();
        r.height += this.getLineHeight() * 2;
        return r;
    }

    protected Rectangle getGUIBounds() {
        int x = ((ShapeModelImpl)this.model).getX();
        int y = ((ShapeModelImpl)this.model).getY();
        int w = ((ShapeModelImpl)this.model).getWidth();
        int h = ((ShapeModelImpl)this.model).getHeight();
        if (w <= 0) {
            x += w;
            w = -w;
        }
        if (h <= 0) {
            y += h;
            h = -h;
        }
        Rectangle r = new Rectangle();
        r.x = x;
        r.y = y;
        r.width = w;
        r.height = h;
        return r;
    }

    @Override
    public void update(Observable model, Object aspect) {
        switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
            case 2: 
            case 31: 
            case 42: {
                if (this.component == null) break;
                Rectangle r = this.getGUIComponentBounds();
                this.component.setBounds(r);
                break;
            }
            case 11: {
                if (this.component == null) break;
                this.component.setVisible(((ShapeModelImpl)this.model).getVisible());
                break;
            }
            case 3: {
                this.remove();
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.visualUpdate();
            }
        }
    }

    protected void visualUpdate() {
        if (this.component != null) {
            this.component.setVisible(false);
            this.component.setVisible(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public boolean isUnderComposite() {
        return this.superVC instanceof CompositeShapeVCImpl;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.canvasVC.needMouseEnteredEventOfSubVCs()) {
            int canvasx = this.getCanvasX(e.getX());
            int canvasy = this.getCanvasY(e.getY());
            this.canvasVC.mouseEntered(e, canvasx, canvasy);
        } else {
            this.mouseEnteredForShape(e);
            if (this.canvasVC.needMouseEnteredEventAfterSubVCs()) {
                int canvasx = this.getCanvasX(e.getX());
                int canvasy = this.getCanvasY(e.getY());
                this.canvasVC.mouseEntered(e, canvasx, canvasy);
            }
        }
    }

    protected void mouseEnteredForShape(MouseEvent e) {
        if (this.isUnderComposite()) {
            ((ShapeVCImpl)this.superVC).mouseEnteredForShape(e);
        } else {
            this.mouseEnteredSelf(e);
        }
    }

    protected void mouseEnteredSelf(MouseEvent e) {
        int selectState = ((ShapeModelImpl)this.model).getSelectState();
        if (selectState == 6) {
            ((ShapeModelImpl)this.model).setSelectState(7);
        } else if (selectState == 10) {
            ((ShapeModelImpl)this.getModel()).setSelectState(9);
        } else if (selectState != 7) {
            ((ShapeModelImpl)this.model).setSelectState(4);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.canvasVC.needMouseExitedEventOfSubVCs()) {
            int canvasx = this.getCanvasX(e.getX());
            int canvasy = this.getCanvasY(e.getY());
            this.canvasVC.mouseExited(e, canvasx, canvasy);
        } else {
            this.mouseExitedForShape(e);
        }
    }

    protected void mouseExitedForShape(MouseEvent e) {
        if (this.isUnderComposite()) {
            ((ShapeVCImpl)this.superVC).mouseExitedForShape(e);
        } else {
            this.mouseExitedSelf(e);
        }
    }

    protected void mouseExitedSelf(MouseEvent e) {
        int selectState = ((ShapeModelImpl)this.model).getSelectState();
        if (selectState == 7) {
            ((ShapeModelImpl)this.model).setSelectState(6);
        } else if (selectState == 9) {
            ((ShapeModelImpl)this.model).setSelectState(10);
        } else if (selectState != 6) {
            ((ShapeModelImpl)this.model).setSelectState(3);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int canvasx = this.getCanvasX(e.getX());
        int canvasy = this.getCanvasY(e.getY());
        if (this.canvasVC.needMousePressedEventOfSubVCs()) {
            this.canvasVC.mousePressed(e, this, canvasx, canvasy);
        } else {
            this.mousePressedForShape(e, this, canvasx, canvasy);
            if (this.canvasVC.isNeedSetMousePressedAfterSubVCs()) {
                this.canvasVC.setMousePressed(e, canvasx, canvasy);
            }
        }
    }

    protected void mousePressedForShape(MouseEvent e, ShapeVCImpl sourcevc, int canvasx, int canvasy) {
        if (this.isUnderComposite()) {
            ((ShapeVCImpl)this.superVC).mousePressedForShape(e, sourcevc, canvasx, canvasy);
        } else {
            this.mousePressedSelf(e, sourcevc, canvasx, canvasy);
        }
    }

    protected void mousePressedSelf(MouseEvent e, ShapeVCImpl sourcevc, int canvasx, int canvasy) {
        int nextState = 5;
        int selectState = ((ShapeModelImpl)this.model).getSelectState();
        if (((ShapeModelImpl)this.model).isSelectable()) {
            if (e.isControlDown()) {
                if (selectState == 6 || selectState == 7) {
                    nextState = 8;
                    ((CanvasModelImpl)this.getCanvasVC().getModel()).resetHandledShape();
                }
            } else if (!(selectState == 7 || this instanceof CompositeShapeVCImpl && selectState == 6)) {
                ((CanvasModelImpl)this.getCanvasVC().getModel()).removeFromSelectedAll();
            }
        }
        sourcevc.setMousePressedPoint(canvasx, canvasy);
        if (nextState != selectState) {
            ((ShapeModelImpl)this.model).setSelectState(nextState);
        }
    }

    protected void setMousePressedPoint(int canvasx, int canvasy) {
        this.mousePressedX = this.getThisX(canvasx);
        this.mousePressedY = this.getThisY(canvasy);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.canvasVC.needMouseReleasedEventOfSubVCs()) {
            int canvasx = this.getCanvasX(e.getX());
            int canvasy = this.getCanvasY(e.getY());
            this.canvasVC.mouseReleased(e, this, canvasx, canvasy);
        } else {
            this.mouseReleasedSelf(e);
        }
    }

    protected void mouseReleasedForShape(MouseEvent e) {
        if (this.isUnderComposite()) {
            ((ShapeVCImpl)this.superVC).mouseReleasedForShape(e);
        } else {
            this.mouseReleasedSelf(e);
        }
    }

    protected void mouseReleasedSelf(MouseEvent e) {
        boolean findThis = false;
        Iterator it = ((CanvasModelImpl)this.getCanvasVC().getModel()).getSelectedListIterator();
        while (it.hasNext()) {
            ShapeModelImpl shapeModel = (ShapeModelImpl)it.next();
            int selectState = shapeModel.getSelectState();
            if (selectState == 8) {
                if (shapeModel == this.model) {
                    findThis = true;
                    shapeModel.setSelectState(4);
                    continue;
                }
                shapeModel.setSelectState(3);
                continue;
            }
            if (shapeModel == this.model) {
                findThis = true;
                shapeModel.setSelectState(7);
                continue;
            }
            shapeModel.setSelectState(6);
        }
        if (!findThis) {
            ((ShapeModelImpl)this.model).setSelectState(4);
        }
        this.getCanvasVC().setMouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int canvasx = this.getCanvasX(e.getX());
        int canvasy = this.getCanvasY(e.getY());
        if (this.canvasVC.needMouseDraggedEventOfSubVCs()) {
            this.canvasVC.mouseDragged(e, canvasx, canvasy);
        } else {
            this.mouseDraggedForShape(e, canvasx, canvasy, this);
        }
    }

    protected void mouseDraggedForShape(MouseEvent e, int canvasx, int canvasy, ShapeVCImpl sourcevc) {
        if (this.isUnderComposite()) {
            ((ShapeVCImpl)this.superVC).mouseDraggedForShape(e, canvasx, canvasy, sourcevc);
        } else {
            this.mouseDraggedSelf(e, canvasx, canvasy, sourcevc);
        }
    }

    protected void restrictDxDyForMoveShapes(DxDy dxDy) {
        this.mover.restrictDxDyForDrag(this, dxDy);
    }

    protected int getThisX(int canvasx) {
        return this.component != null ? canvasx - this.component.getX() : canvasx;
    }

    protected int getThisY(int canvasy) {
        return this.component != null ? canvasy - this.component.getY() : canvasy;
    }

    protected int getCanvasX(int x) {
        return this.component != null ? x + this.component.getX() : x;
    }

    protected int getCanvasY(int y) {
        return this.component != null ? y + this.component.getY() : y;
    }

    protected void mouseDraggedSelf(MouseEvent e, int canvasx, int canvasy, ShapeVCImpl sourcevc) {
        int selectState = ((ShapeModelImpl)this.model).getSelectState();
        if (selectState == 5) {
            int newMouseX = sourcevc.getThisX(canvasx);
            int newMouseY = sourcevc.getThisY(canvasy);
            int dx = newMouseX - sourcevc.mousePressedX;
            int dy = newMouseY - sourcevc.mousePressedY;
            DxDy dxDy = new DxDy(dx, dy);
            Iterator it = ((CanvasModelImpl)this.getCanvasVC().getModel()).getSelectedListIterator();
            while (it.hasNext()) {
                ShapeModelImpl shapem = (ShapeModelImpl)it.next();
                shapem = shapem.getTargetOfMove();
                ShapeVCImpl vc = (ShapeVCImpl)this.getCanvasVC().shapeVCsByModel.get(shapem);
                vc.restrictDxDyForMoveShapes(dxDy);
            }
            dx = dxDy.dx;
            dy = dxDy.dy;
            TreeSet<ShapeModelImpl> shapeSet = new TreeSet<ShapeModelImpl>();
            Iterator it2 = ((CanvasModelImpl)this.getCanvasVC().getModel()).getSelectedListIterator();
            while (it2.hasNext()) {
                ShapeModelImpl shapem = (ShapeModelImpl)it2.next();
                if (shapeSet.contains(shapem = shapem.getTargetOfMove())) continue;
                shapeSet.add(shapem);
            }
            this.moveShapes(shapeSet, dx, dy);
        }
    }

    public void moveShapes(Collection shapes, int dx, int dy) {
        AnchorImpl anchor;
        AnchoredShapeModelImpl ashape;
        for (ShapeModelImpl shape : shapes) {
            if (shape instanceof AnchoredShapeModelImpl) {
                ashape = (AnchoredShapeModelImpl)shape;
                for (ShapeModelImpl s1 : ashape.anchorsMap.keySet()) {
                    anchor = (AnchorImpl)ashape.anchorsMap.get(s1);
                    anchor.updateXY();
                }
            }
            shape.setPrimarilyMoved(true);
        }
        for (ShapeModelImpl shapeModel : shapes) {
            shapeModel.move(dx, dy);
        }
        for (ShapeModelImpl shape : shapes) {
            if (shape instanceof AnchoredShapeModelImpl) {
                ashape = (AnchoredShapeModelImpl)shape;
                for (ShapeModelImpl s1 : ashape.anchorsMap.keySet()) {
                    anchor = (AnchorImpl)ashape.anchorsMap.get(s1);
                    anchor.updateOffset(ashape);
                }
            }
            shape.setPrimarilyMoved(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.canvasVC.needMouseMovedEventOfSubVCs()) {
            int canvasx = this.getCanvasX(e.getX());
            int canvasy = this.getCanvasY(e.getY());
            this.canvasVC.mouseMoved(e, canvasx, canvasy);
        }
    }

    protected void paintGUIComponent(Graphics2D g2) {
        Rectangle rc = this.getGUIComponentBounds();
        Rectangle r = this.getGUIBounds();
        ShapeModelImpl m = (ShapeModelImpl)this.getModel();
        int w = r.width;
        int h = r.height;
        int w1 = w - 1;
        int h1 = h - 1;
        Color foreColor = g2.getColor();
        g2.setBackground(Color.white);
        g2.setColor(this.getForeColorBySelectStatus(m.getSelectState()));
        if (this.needToFill()) {
            g2.fillRect(r.x - rc.x, r.y - rc.y, w, h);
        } else {
            g2.clearRect(r.x - rc.x, r.y - rc.y, w1, h1);
            g2.setStroke(this.getStroke());
            g2.drawRect(r.x - rc.x, r.y - rc.y, w1, h1);
        }
        this.drawGUIComponentName(g2);
        g2.setColor(foreColor);
    }

    public Integer getLayerIndex() {
        return JLayeredPane.DEFAULT_LAYER;
    }

    protected Stroke getStroke() {
        return stroke;
    }

    protected void drawGUIComponentName(Graphics2D g2) {
        ShapeModelImpl m = (ShapeModelImpl)this.getModel();
        String name = m.getName();
        this.drawGUIComponentName(g2, name);
    }

    protected int getNameBasePointOffsetY() {
        return 0;
    }

    protected int getNameOffsetX() {
        return 0;
    }

    protected void drawGUIComponentName(Graphics2D g2, String name) {
        Rectangle r = this.getGUIBounds();
        int w = r.width;
        int h = r.height;
        if (name != null && name.length() > 0) {
            FontMetrics fm = this.component.getFontMetrics(this.component.getFont());
            int fw = fm.stringWidth(name);
            int fh = fm.getHeight();
            int fd = fm.getDescent();
            int x = (w - fw) / 2;
            int y = (h + fh) / 2 - fd + 1;
            g2.drawString(name, x + this.getNameOffsetX(), y + this.getNameBasePointOffsetY());
        }
    }

    protected Color getForeColorBySelectStatus(int selectStatus) {
        Color c;
        switch (selectStatus) {
            case 1: {
                c = Color.GRAY;
                break;
            }
            case 2: {
                c = Color.DARK_GRAY;
                break;
            }
            case 4: {
                c = this.getDefaultForeColor();
                break;
            }
            case 5: {
                c = Color.MAGENTA;
                break;
            }
            case 8: {
                c = this.getDefaultForeColor();
                break;
            }
            case 6: {
                c = Color.MAGENTA;
                break;
            }
            case 7: {
                c = Color.MAGENTA;
                break;
            }
            case 9: {
                c = Color.GREEN;
                break;
            }
            case 10: {
                c = Color.BLUE;
                break;
            }
            default: {
                c = this.getDefaultForeColor();
            }
        }
        return c;
    }

    public Color getDefaultForeColor() {
        return Color.BLACK;
    }

    protected boolean isReversible() {
        return false;
    }

    protected final PointOnPolyline getCrossPoint(LinkedList points, boolean reverse) {
        if (!reverse) {
            int i = 0;
            Iterator it = points.iterator();
            Point s = (Point)it.next();
            while (it.hasNext()) {
                Point e = (Point)it.next();
                double t = this.getCrossPoint(s, e);
                if (t <= 1.0) {
                    return new PointOnPolyline(i, t);
                }
                s = e;
                ++i;
            }
            return new PointOnPolyline(points.size() - 2, 1.0);
        }
        int i = points.size();
        ListIterator it = points.listIterator(i);
        Point s = (Point)it.previous();
        i -= 2;
        while (it.hasPrevious()) {
            Point e = (Point)it.previous();
            double t = this.getCrossPoint(s, e);
            if (t <= 1.0) {
                return new PointOnPolyline(i, 1.0 - t);
            }
            s = e;
            --i;
        }
        return new PointOnPolyline(0, 0.0);
    }

    protected double getCrossPoint(Point ps, Point pe) {
        Rectangle r = this.getGUIBounds();
        Point p1 = new Point(r.x, r.y);
        Point p2 = new Point(r.x + r.width - 1, r.y);
        Point p3 = new Point(r.x + r.width - 1, r.y + r.height - 1);
        Point p4 = new Point(r.x, r.y + r.height - 1);
        double t = ShapeVCImpl.getCrossPoint(ps, pe, p1, p2);
        double t1 = ShapeVCImpl.getCrossPoint(ps, pe, p2, p3);
        if (t1 < t) {
            t = t1;
        }
        if ((t1 = ShapeVCImpl.getCrossPoint(ps, pe, p3, p4)) < t) {
            t = t1;
        }
        if ((t1 = ShapeVCImpl.getCrossPoint(ps, pe, p4, p1)) < t) {
            t = t1;
        }
        return t;
    }

    static double getCrossPoint(Point ps, Point pe, Point qs, Point qe) {
        double px = pe.x - ps.x;
        double py = pe.y - ps.y;
        double qx = qe.x - qs.x;
        double qy = qe.y - qs.y;
        if ((px * (ps.y - qs.y) + py * (qs.x - ps.x)) * (px * (ps.y - qe.y) + py * (qe.x - ps.x)) > 0.0) {
            return NOT_CROSSED;
        }
        if ((qx * (qs.y - ps.y) + qy * (ps.x - qs.x)) * (qx * (qs.y - pe.y) + qy * (pe.x - qs.x)) > 0.0) {
            return NOT_CROSSED;
        }
        double div = px * qy - py * qx;
        if (Math.abs(div) < 1.0E-10) {
            double t2;
            double t1;
            if (Math.abs(px) >= 1.0E-10) {
                t1 = (qs.x - ps.x) / px;
                t2 = (qe.x - ps.x) / px;
            } else if (Math.abs(py) >= 1.0E-10) {
                t1 = (qs.y - ps.y) / py;
                t2 = (qe.y - ps.y) / py;
            } else {
                return NOT_CROSSED;
            }
            if (t1 > t2) {
                double tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if (t1 > 1.0) {
                return NOT_CROSSED;
            }
            if (t2 < 0.0) {
                return NOT_CROSSED;
            }
            if (t1 < 0.0) {
                t1 = 0.0;
            }
            return t1;
        }
        double t = (ps.y * qx - ps.x * qy + qs.x * qy - qs.y * qx) / div;
        return t;
    }

    public static void test() {
        Point[] pp = new Point[5];
        Point p1 = new Point(10, 10);
        Point p2 = new Point(20, 10);
        Point p3 = new Point(20, 20);
        Point p4 = new Point(10, 20);
        pp[0] = p1;
        pp[1] = p2;
        pp[2] = p3;
        pp[3] = p4;
        pp[4] = p1;
        int dx = 0;
        int dy = 0;
        Point ps = new Point(10 + dx, 10 + dy);
        Point pe = new Point(20 + dx, 10 + dy);
        int i = 0;
        while (i < 4) {
            double t = ShapeVCImpl.getCrossPoint(ps, pe, pp[i], pp[i + 1]);
            System.out.println("t=" + t);
            ++i;
        }
    }

    public static void main(String[] args) {
        ShapeVCImpl.test();
    }

    class MyJPanel
    extends JPanel {
        protected ShapeVCImpl vc;

        public MyJPanel(ShapeVCImpl vc) {
            this.vc = vc;
        }

        @Override
        public void paintComponent(Graphics g) {
            this.vc.paintGUIComponent((Graphics2D)g);
        }

        @Override
        public boolean contains(int x, int y) {
            boolean ans = super.contains(x, y);
            if (ans) {
                return this.vc.containsCompletely(x, y);
            }
            return ans;
        }
    }
}

