/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.event.MouseEvent;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacer;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;

public abstract class ShapePlacerByClick
extends ShapePlacer {
    public ShapePlacerByClick(CanvasVCImpl canvasvc) {
        super(canvasvc);
        this.needMouseMovedEvent = true;
        this.needMouseDraggedEvent = true;
        this.needMouseEnteredEvent = true;
        this.needMouseEnteredEventAfterSubVCs = false;
        this.needMouseExitedEvent = true;
        this.needMousePressedEvent = true;
        this.needSetMousePressedAfterSubVCs = true;
        this.needMouseReleasedEvent = true;
    }

    @Override
    public void mouseEnteredInCanvas(MouseEvent e, int canvasx, int canvasy) {
        if (this.canvasm.dragShape == null) {
            this.createDragShape(canvasx, canvasy);
        }
        this.setVisibleDragShape(true);
    }

    @Override
    public void mouseExitedFromCanvas() {
        this.setVisibleDragShape(false);
    }

    @Override
    public void mousePressedInCanvas(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        ShapePlacerByClick.mousePressedInCanvasStatic(this.canvasvc, e, sourcevc, canvasx, canvasy);
    }

    public static void mousePressedInCanvasStatic(CanvasVCImpl canvasvc, MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        canvasvc.setMousePressedPoint(canvasx, canvasy);
        ((CanvasModelImpl)canvasvc.getModel()).dragShape.setSelectState(2);
    }

    @Override
    public void mouseReleasedInCanvas(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        if (this.canvasvc.isMouseIn()) {
            if (this.mousePressed && this.isCreateShape(e, sourcevc, canvasx, canvasy)) {
                if (this.isCreateShapeWithAnchoring(e, sourcevc, canvasx, canvasy)) {
                    ShapeModelImpl shape = this.createShape();
                    this.anchorToTheTarget(shape, sourcevc);
                } else {
                    this.createShape();
                }
                this.canvasm.dragShape.setSelectState(1);
                this.handlerAfterCreateShape();
                return;
            }
            this.canvasm.dragShape.setSelectState(1);
        }
    }

    public ShapeModelImpl createShape() {
        return this.canvasm.createShape();
    }

    protected boolean isCreateShape(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        return true;
    }

    protected boolean isCreateShapeWithAnchoring(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        return sourcevc instanceof ShapeVCImpl;
    }

    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, SwingVCImpl sourcevc) {
        ModelImpl targetModel = ((ShapeVCImpl)sourcevc).getModel();
        if (shape instanceof AnchoredShapeModelImpl && targetModel instanceof ShapeModelImpl) {
            int cx = shape.getCenterX();
            int cy = shape.getCenterY();
            int targetCx = ((ShapeModelImpl)targetModel).getCenterX();
            int targetCy = ((ShapeModelImpl)targetModel).getCenterY();
            int dx = cx - targetCx;
            int dy = cy - targetCy;
            SimpleAnchorImpl anchor = new SimpleAnchorImpl(0, 10, dx, dy);
            ((AnchorImpl)anchor).initialize((ShapeModelImpl)targetModel);
            ((AnchoredShapeModelImpl)shape).addLastAnchor(anchor);
            return (ShapeModelImpl)targetModel;
        }
        return null;
    }

    @Override
    public void mouseDraggedInCanvas(MouseEvent e, int canvasx, int canvasy) {
        this.moveDragShape(canvasx, canvasy);
    }

    @Override
    public void mouseMovedInCanvas(MouseEvent e, int canvasx, int canvasy) {
        this.moveDragShape(canvasx, canvasy);
    }

    @Override
    protected void createDragShape(int x, int y) {
        this.canvasm.createDragShape(x, y, true);
    }

    @Override
    protected void moveDragShape(int x, int y) {
        if (this.canvasm.dragShape == null) {
            this.createDragShape(x, y);
        }
        ShapeModelImpl shape = this.canvasm.dragShape;
        shape.moveAt(x -= shape.getCenterOffsetX(), y -= shape.getCenterOffsetY());
    }
}

