/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.event.MouseEvent;
import java.util.Map;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;

public abstract class ShapePlacer {
    protected boolean needMouseMovedEvent;
    protected boolean needMouseDraggedEvent;
    protected boolean needMouseEnteredEvent;
    protected boolean needMouseEnteredEventAfterSubVCs;
    protected boolean needMouseExitedEvent;
    protected boolean needMousePressedEvent;
    protected boolean needSetMousePressedAfterSubVCs;
    protected boolean needMouseReleasedEvent;
    protected boolean mousePressed;
    protected CanvasVCImpl canvasvc;
    protected CanvasModelImpl canvasm;

    public ShapePlacer(CanvasVCImpl canvasvc) {
        this.canvasvc = canvasvc;
        this.canvasm = (CanvasModelImpl)canvasvc.getModel();
    }

    public boolean isNeedMouseDraggedEvent() {
        return this.needMouseDraggedEvent;
    }

    public boolean isNeedMouseEnteredEvent() {
        return this.needMouseEnteredEvent;
    }

    public boolean isNeedMouseEnteredEventAfterSubVCs() {
        return this.needMouseEnteredEventAfterSubVCs;
    }

    public boolean isNeedMouseExitedEvent() {
        return this.needMouseExitedEvent;
    }

    public boolean isNeedMouseMovedEvent() {
        return this.needMouseMovedEvent;
    }

    public boolean isNeedMousePressedEvent() {
        return this.needMousePressedEvent;
    }

    public boolean isNeedSetMousePressedAfterSubVCs() {
        return this.needSetMousePressedAfterSubVCs;
    }

    public boolean isNeedMouseReleasedEvent() {
        return this.needMouseReleasedEvent;
    }

    public void setMousePressed(boolean b) {
        this.mousePressed = b;
    }

    public abstract void mouseEnteredInCanvas(MouseEvent var1, int var2, int var3);

    public abstract void mouseExitedFromCanvas();

    public abstract void mousePressedInCanvas(MouseEvent var1, SwingVCImpl var2, int var3, int var4);

    public abstract void mouseReleasedInCanvas(MouseEvent var1, SwingVCImpl var2, int var3, int var4);

    public abstract void mouseDraggedInCanvas(MouseEvent var1, int var2, int var3);

    public abstract void mouseMovedInCanvas(MouseEvent var1, int var2, int var3);

    protected void setVisibleDragShape(boolean visibleState) {
        ShapeModelImpl shape = this.canvasm.dragShape;
        if (shape != null) {
            shape.setVisible(visibleState);
        }
    }

    protected void createDragShape(int x, int y) {
        this.canvasm.createDragShape(x, y, false);
    }

    protected void moveDragShape(int x, int y) {
        if (this.canvasm.dragShape == null) {
            this.createDragShape(x, y);
        }
        ShapeModelImpl shape = this.canvasm.dragShape;
        shape.moveAt(x, y);
    }

    protected void resizeDragShape(int x, int y) {
        if (this.canvasm.dragShape == null) {
            this.canvasm.createDragShapeByDrag(x, y);
        }
        ShapeModelImpl shape = this.canvasm.dragShape;
        int w = x - this.canvasvc.mousePressedX;
        int h = y - this.canvasvc.mousePressedY;
        ShapeVCImpl vc = this.canvasvc.dragShapeVC;
        int minWidth = vc.getMinWidth();
        int minHeight = vc.getMinHeight();
        if (vc.isReversible()) {
            if (Math.abs(w) >= minWidth && Math.abs(h) >= minHeight) {
                shape.resize(w, h);
            }
        } else {
            if (w < minWidth) {
                w = minWidth;
            }
            if (h < minHeight) {
                h = minHeight;
            }
            shape.resize(w, h);
        }
    }

    protected void resetDragShape(int x, int y) {
        this.removeDragShape();
        this.createDragShape(x, y);
    }

    protected void removeDragShape() {
        ShapeModelImpl shape = this.canvasm.getDragShape();
        if (shape != null) {
            this.canvasm.removeDragShape();
        }
    }

    protected void handlerAfterCreateShape() {
    }

    public abstract String getMainShapeModelClassName();

    public abstract Map getShapeMVCClassNamesMap();
}

