/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AspectConstants;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;

public class ShapeModelImpl
extends ModelImpl
implements AspectConstants {
    public static final int SELECT_STATE_UNDEFINED = 0;
    public static final int SELECT_STATE_NEWLY_MOVING = 1;
    public static final int SELECT_STATE_NEWLY_DRAGGING = 2;
    public static final int SELECT_STATE_NORMAL = 3;
    public static final int SELECT_STATE_POINTER_ON = 4;
    public static final int SELECT_STATE_DRAGGING = 5;
    public static final int SELECT_STATE_SELECTED = 6;
    public static final int SELECT_STATE_SELECTED_POINTER_ON = 7;
    public static final int SELECT_STATE_DRAGGING_TOGGLE = 8;
    public static final int SELECT_STATE_PRESSED = 9;
    public static final int SELECT_STATE_PRESSED_NOT_SELECTED = 10;
    protected boolean primarilyMoved;
    protected String name = null;
    protected int selectState = 0;
    protected int x = 0;
    protected int y = 0;
    protected int width = this.getDefaultWidth();
    protected int height = this.getDefaultHeight();
    protected boolean visibleState = true;
    protected boolean forDrag;
    protected boolean selectable = true;
    protected CanvasModelImpl canvas = null;
    protected ShapeModelImpl delegateOfMove;
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 16;
    protected boolean directRemovable = true;
    protected TreeSet removeShapesSet;

    protected int getDefaultWidth() {
        return ShapeModelImpl.getDefaultWidthStatic();
    }

    protected int getDefaultHeight() {
        return ShapeModelImpl.getDefaultHeightStatic();
    }

    protected static int getDefaultWidthStatic() {
        return 32;
    }

    protected static int getDefaultHeightStatic() {
        return 16;
    }

    protected ShapeModelImpl() {
    }

    public final void initialize(CanvasModelImpl canvas) {
        this.initialize(canvas, 0, 0, this.getDefaultWidth(), this.getDefaultHeight(), false);
    }

    protected final void initialize(CanvasModelImpl canvas, boolean forDrag) {
        this.initialize(canvas, 0, 0, this.getDefaultWidth(), this.getDefaultHeight(), forDrag);
    }

    public final void initialize(CanvasModelImpl canvas, int x, int y, boolean forDrag) {
        this.initialize(canvas, x, y, this.getDefaultWidth(), this.getDefaultHeight(), forDrag);
    }

    public final void initialize(CanvasModelImpl canvas, int x, int y) {
        this.initialize(canvas, x, y, this.getDefaultWidth(), this.getDefaultHeight(), false);
    }

    public final void initialize(CanvasModelImpl canvas, int x, int y, int w, int h) {
        this.initialize(canvas, x, y, w, h, false);
    }

    public void initialize(CanvasModelImpl canvas, int x, int y, int w, int h, boolean forDrag) {
        this.canvas = canvas;
        this.x = x;
        this.y = y;
        this.forDrag = forDrag;
        this.width = w;
        this.height = h;
        this.visibleState = true;
        this.selectState = forDrag ? 1 : 3;
    }

    protected void initialize(ShapeModelImpl old, boolean forDrag) {
        this.initialize(old.canvas, old.x, old.y, old.width, old.height, forDrag);
    }

    protected boolean isSelectable() {
        return this.selectable;
    }

    public void moveCenterOffsetWithoutNotify() {
        this.x -= this.getCenterOffsetX();
        this.y -= this.getCenterOffsetY();
    }

    protected final int getCenterOffsetX() {
        return this.width / 2;
    }

    protected final int getCenterOffsetY() {
        return this.height / 2;
    }

    public final boolean isForDrag() {
        return this.forDrag;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void resize(int width, int height) {
        int lastWidth = this.getWidth();
        int lastHeight = this.getHeight();
        this.width = width;
        this.height = height;
        int currentWidth = this.getWidth();
        int currentHeight = this.getHeight();
        this.setChanged();
        this.notifyObservers(31, lastWidth, lastHeight, currentWidth, currentHeight);
        this.clearChanged();
    }

    protected void removeChildren() {
    }

    protected void removeInParent() {
    }

    protected void removeSelf() {
    }

    protected final void removeInCanvas() {
        this.canvas.removeShape(this);
    }

    public void remove() {
        this.removeChildren();
        this.removeInCanvas();
        this.removeInParent();
        this.removeSelf();
        this.setChanged();
        this.notifyObservers(3);
        this.clearChanged();
        this.deleteObservers();
    }

    public final void moveAt(int x, int y) {
        int dx = x - this.x;
        int dy = y - this.y;
        this.move(dx, dy);
    }

    public void move(int dx, int dy) {
        this.move(dx, dy, 2);
    }

    protected void move(int dx, int dy, int aspect) {
        this.x += dx;
        this.y += dy;
        this.setChanged();
        this.notifyObservers(aspect);
        this.clearChanged();
    }

    public final void setVisible(boolean visibleState) {
        this.visibleState = visibleState;
        this.setChanged();
        this.notifyObservers(11);
        this.clearChanged();
    }

    public final boolean getVisible() {
        return this.visibleState;
    }

    public final int getSelectState() {
        return this.selectState;
    }

    public static boolean isSelected(int selectState) {
        switch (selectState) {
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public final boolean isSelected() {
        return ShapeModelImpl.isSelected(this.selectState);
    }

    protected void updateHandles() {
        this.canvas.resetHandledShape();
    }

    public void setSelectState(int selectState) {
        if (selectState == 5) {
            this.updateHandles();
        }
        if (this.isSelectable()) {
            boolean sel1 = this.isSelected();
            boolean sel2 = ShapeModelImpl.isSelected(selectState);
            if (!sel1 && sel2) {
                this.canvas.addSelectedActually(this);
            } else if (sel1 && !sel2) {
                this.canvas.removeFromSelectedActually(this);
            }
        }
        this.setSelectStatePrimitive(selectState);
    }

    protected void setSelectStatePrimitive(int selectState) {
        this.selectState = selectState;
        this.setChanged();
        this.notifyObservers(12);
        this.clearChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.setChanged();
        this.notifyObservers(13);
        this.clearChanged();
    }

    protected boolean hasName() {
        return true;
    }

    protected boolean needToSetNameInitially() {
        return this.hasName();
    }

    public boolean isPrimarilyMoved() {
        return this.primarilyMoved;
    }

    public void setPrimarilyMoved(boolean b) {
        this.primarilyMoved = b;
    }

    public String getDefaultName() {
        return "";
    }

    public void setDelegateOfMove(ShapeModelImpl m) {
        this.delegateOfMove = m;
    }

    public ShapeModelImpl getTargetOfMove() {
        return this.delegateOfMove == null ? this : this.delegateOfMove;
    }

    public boolean isDirectRemovable() {
        return this.directRemovable;
    }

    public void setDirectRemovable(boolean b) {
        this.directRemovable = b;
    }

    public boolean hasRemoveShapesSet() {
        return this.removeShapesSet != null && !this.removeShapesSet.isEmpty();
    }

    public void addRemoveShape(ShapeModelImpl shape) {
        if (this.removeShapesSet == null) {
            this.removeShapesSet = new TreeSet();
        }
        this.removeShapesSet.add(shape);
    }

    public void removeRemoveShape(ShapeModelImpl shape) {
        if (this.removeShapesSet != null) {
            this.removeShapesSet.remove(shape);
        }
    }

    protected Set getRemoveShapesSetWithoutNesting() {
        if (this.removeShapesSet == null || this.removeShapesSet.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableSet(this.removeShapesSet);
    }

    public Set getRemoveShapesSet() {
        TreeSet<ShapeModelImpl> set = new TreeSet<ShapeModelImpl>();
        set.add(this);
        return ShapeModelImpl.getRemoveShapesSet(set);
    }

    public static Set getRemoveShapesSet(Collection shapes1) {
        TreeSet shapes0 = new TreeSet(shapes1);
        TreeSet<ShapeModelImpl> shapes2 = new TreeSet<ShapeModelImpl>();
        do {
            for (ShapeModelImpl shape : shapes1) {
                if (!shape.hasRemoveShapesSet()) continue;
                Set set = shape.getRemoveShapesSetWithoutNesting();
                for (ShapeModelImpl shape1 : set) {
                    if (shapes0.contains(shape1) || shapes2.contains(shape1)) continue;
                    shapes2.add(shape1);
                }
            }
            shapes0.addAll(shapes2);
            shapes1 = shapes2;
            shapes2 = new TreeSet();
        } while (!shapes1.isEmpty());
        return shapes0;
    }
}

