/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import jp.co.fujiric.star.gui.gef.swing.AvailableQuadrant;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.RoundRectModel;
import jp.co.fujiric.star.gui.gef.swing.RoundedCornered;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeWithHandleVCImpl;

public class RoundRectVC
extends ShapeWithHandleVCImpl {
    @Override
    protected Class getExpectedModelClass() {
        return RoundRectModel.class;
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        RoundRectVC.paintGUIComponentForRoundRect(this, g2);
    }

    static void paintGUIComponentForRoundRect(ShapeVCImpl vc, Graphics2D g2) {
        Rectangle rc = vc.getGUIComponentBounds();
        Rectangle r = vc.getGUIBounds();
        ShapeModelImpl m = (ShapeModelImpl)vc.getModel();
        int aw = ((RoundedCornered)((Object)m)).getArcWidth();
        int ah = ((RoundedCornered)((Object)m)).getArcHeight();
        int w = r.width;
        int h = r.height;
        Color foreColor = g2.getColor();
        g2.setBackground(Color.white);
        g2.setColor(Color.WHITE);
        g2.fillRoundRect(r.x - rc.x, r.y - rc.y, w, h, aw, ah);
        g2.setColor(vc.getForeColorBySelectStatus(m.getSelectState()));
        vc.drawGUIComponentName(g2);
        g2.setStroke(vc.getStroke());
        g2.drawRoundRect(r.x - rc.x, r.y - rc.y, w - 1, h - 1, aw, ah);
        g2.setColor(foreColor);
    }

    @Override
    protected boolean containsCompletely(int x, int y) {
        return RoundRectVC.containsCompletelyForRoundRect(this, x, y);
    }

    static boolean containsCompletelyForRoundRect(ShapeVCImpl vc, int x, int y) {
        Rectangle rc = vc.getGUIComponentBounds();
        Rectangle r = vc.getGUIBounds();
        ShapeModelImpl m = (ShapeModelImpl)vc.getModel();
        int w = r.width;
        int h = r.height;
        int aw = ((RoundedCornered)((Object)m)).getArcWidth();
        int ah = ((RoundedCornered)((Object)m)).getArcHeight();
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(r.x - rc.x, r.y - rc.y, w, h, aw, ah);
        return rr.contains(x, y);
    }

    @Override
    protected double getCrossPoint(Point ps, Point pe) {
        return RoundRectVC.getCrossPointForRoundRect(this, ps, pe);
    }

    static double getCrossPointForRoundRect(ShapeVCImpl vc, Point ps, Point pe) {
        double t1;
        Rectangle r = vc.getGUIBounds();
        double x = r.x;
        double y = r.y;
        double w = r.width;
        double h = r.height;
        ShapeModelImpl m = (ShapeModelImpl)vc.getModel();
        double aw = ((RoundedCornered)((Object)m)).getArcWidth();
        double ah = ((RoundedCornered)((Object)m)).getArcHeight();
        if (aw >= w && ah >= h) {
            return RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, null, x, y, w, h);
        }
        double t = NOT_CROSSED;
        double xw = x + w - 1.0;
        double yh = y + h - 1.0;
        double dw = w - aw;
        double dh = h - ah;
        double x1 = x + 0.5 * (w - dw);
        double x2 = x + 0.5 * (w + dw);
        double y1 = y + 0.5 * (h - dh);
        double y2 = y + 0.5 * (h + dh);
        if (aw >= w) {
            double t12 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, null, x, y + dh, w, ah);
            if (t12 < t) {
                t = t12;
            }
            if ((t12 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, null, x, y, w, ah)) < t) {
                t = t12;
            }
        } else if (ah >= h) {
            double t13 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, null, x, y, aw, h);
            if (t13 < t) {
                t = t13;
            }
            if ((t13 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, null, x + dw, y, aw, h)) < t) {
                t = t13;
            }
        } else {
            AvailableQuadrant aq = new AvailableQuadrant(true, false, false, false);
            double t14 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, aq, x + dw, y + dh, aw, ah);
            if (t14 < t) {
                t = t14;
            }
            if ((t14 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, aq = new AvailableQuadrant(false, true, false, false), x, y + dh, aw, ah)) < t) {
                t = t14;
            }
            if ((t14 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, aq = new AvailableQuadrant(false, false, true, false), x, y, aw, ah)) < t) {
                t = t14;
            }
            if ((t14 = RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, aq = new AvailableQuadrant(false, false, false, true), x + dw, y, aw, ah)) < t) {
                t = t14;
            }
        }
        if (aw < w) {
            Point p1 = new Point(x1, y);
            Point p2 = new Point(x2, y);
            t1 = RoundRectVC.getCrossPoint(ps, pe, p1, p2);
            if (t1 < t) {
                t = t1;
            }
            if ((t1 = RoundRectVC.getCrossPoint(ps, pe, p1 = new Point(x1, yh), p2 = new Point(x2, yh))) < t) {
                t = t1;
            }
        }
        if (ah < h) {
            Point p1 = new Point(x, y1);
            Point p2 = new Point(x, y2);
            t1 = RoundRectVC.getCrossPoint(ps, pe, p1, p2);
            if (t1 < t) {
                t = t1;
            }
            if ((t1 = RoundRectVC.getCrossPoint(ps, pe, p1 = new Point(xw, y1), p2 = new Point(xw, y2))) < t) {
                t = t1;
            }
        }
        return t;
    }

    static double getCrossPointForCircle(ShapeVCImpl vc, Point ps, Point pe) {
        Rectangle r = vc.getGUIBounds();
        double x = r.x;
        double y = r.y;
        double w = r.width;
        double h = r.height;
        return RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, null, x, y, w + 0.5, h + 0.5);
    }

    public static double getCrossPointForQuadrantCircle(Point ps, Point pe, AvailableQuadrant aq, double x, double y, double w, double h) {
        double m00 = w / 2.0;
        double m11 = h / 2.0;
        double m01 = 0.0;
        double m10 = 0.0;
        double m02 = x + m00;
        double m12 = y + m11;
        AffineTransform af = new AffineTransform(m00, m10, m01, m11, m02, m12);
        try {
            Point2D pst = af.inverseTransform(new Point2D.Double(ps.x, ps.y), null);
            Point2D pet = af.inverseTransform(new Point2D.Double(pe.x, pe.y), null);
            double xs = pst.getX();
            double xe = pet.getX();
            double ys = pst.getY();
            double ye = pet.getY();
            double dx = xe - xs;
            double dy = ye - ys;
            double a = dx * dx + dy * dy;
            double b = 2.0 * (dx * xs + dy * ys);
            double c = xs * xs + ys * ys - 1.0;
            double d2 = b * b - 4.0 * a * c;
            if (a == 0.0 || d2 < -1.0E-10) {
                return NOT_CROSSED;
            }
            if (Math.abs(d2) <= 1.0E-10) {
                double t1 = -b / (2.0 * a);
                if (aq != null && !aq.isAvailable(xs + dx * t1, ys + dy * t1)) {
                    t1 = NOT_CROSSED;
                }
                return t1;
            }
            double t = NOT_CROSSED;
            double d = Math.sqrt(d2);
            double t1 = (-b + d) / (2.0 * a);
            t = aq != null && !aq.isAvailable(xs + dx * t1, ys + dy * t1) ? NOT_CROSSED : t1;
            t1 = (-b - d) / (2.0 * a);
            if (aq != null && !aq.isAvailable(xs + dx * t1, ys + dy * t1)) {
                t1 = NOT_CROSSED;
            }
            if (t1 < t) {
                t = t1;
            }
            return t;
        }
        catch (NoninvertibleTransformException e) {
            return NOT_CROSSED;
        }
    }
}

