/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import javax.swing.JLayeredPane;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ArrowWithHandleVCImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkModelImpl;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.PointOnPolyline;
import jp.co.fujiric.star.gui.gef.swing.RoundRectVC;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;

public class LinkVCImpl
extends ArrowWithHandleVCImpl {
    protected PointOnPolyline[] visualAnchorPoints = null;

    protected LinkVCImpl() {
    }

    @Override
    public void initializevc(ModelImpl model) {
        super.initializevc(model);
        int n = ((LinkModelImpl)model).getMaxAnchorNum();
        this.visualAnchorPoints = new PointOnPolyline[n];
    }

    @Override
    protected Class getExpectedModelClass() {
        return LinkModelImpl.class;
    }

    @Override
    public Integer getLayerIndex() {
        return JLayeredPane.POPUP_LAYER;
    }

    @Override
    protected void addLastVC(ShapeVCImpl shapeVC) {
        PointOnPolyline p;
        int index = this.shapeVCs[0] == null ? 0 : 1;
        this.shapeVCs[index] = shapeVC;
        this.visualAnchorPoints[index] = p = shapeVC.getCrossPoint(((LinkModelImpl)this.model).points, index == 0);
    }

    @Override
    protected boolean containsCompletely(int x, int y) {
        if (this.visualAnchorPoints[1] == null) {
            return super.containsCompletely(x, y);
        }
        PointOnPolyline ps = this.visualAnchorPoints[0];
        PointOnPolyline pe = this.visualAnchorPoints[1];
        LinkedList points = this.getPointsForDraw();
        Iterator it = points.iterator();
        Point p1 = (Point)it.next();
        Point p2 = null;
        int i = 0;
        while (it.hasNext()) {
            p2 = (Point)it.next();
            if (i >= ps.i) {
                double y2;
                double x2;
                double y1;
                double x1;
                if (i == ps.i) {
                    x1 = ps.t * (p2.x - p1.x) + p1.x;
                    y1 = ps.t * (p2.y - p1.y) + p1.y;
                } else {
                    x1 = p1.x;
                    y1 = p1.y;
                }
                if (i == pe.i) {
                    x2 = pe.t * (p2.x - p1.x) + p1.x;
                    y2 = pe.t * (p2.y - p1.y) + p1.y;
                } else {
                    x2 = p2.x;
                    y2 = p2.y;
                }
                boolean ans = this.contains(x, y, new Point(x1, y1), new Point(x2, y2));
                if (ans) {
                    return ans;
                }
                if (i == pe.i) break;
            }
            ++i;
            p1 = p2;
        }
        return false;
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        if (this.visualAnchorPoints[1] == null) {
            super.paintGUIComponent(g2);
            return;
        }
        PointOnPolyline ps = this.visualAnchorPoints[0];
        PointOnPolyline pe = this.visualAnchorPoints[1];
        if (ps.i > pe.i || ps.i == pe.i && ps.t >= pe.t) {
            return;
        }
        LinkModelImpl m = (LinkModelImpl)this.getModel();
        LinkedList points = this.getPointsForDraw();
        ShapeVCImpl shape1 = this.shapeVCs[0];
        if (shape1 != null) {
            Rectangle r1 = shape1.getGUIBounds();
            Point p1 = (Point)points.getFirst();
            Point p2 = (Point)points.getLast();
            if (shape1.contains((int)p1.x - r1.x, (int)p1.y - r1.y) && shape1.contains((int)p2.x - r1.x, (int)p2.y - r1.y)) {
                return;
            }
            ShapeVCImpl shape2 = this.shapeVCs[1];
            if (shape2 != null) {
                Rectangle r2 = shape2.getGUIBounds();
                if (shape2.contains((int)p1.x - r2.x, (int)p1.y - r2.y) && shape2.contains((int)p2.x - r2.x, (int)p2.y - r2.y)) {
                    return;
                }
            }
        }
        Rectangle rc = this.getGUIComponentBounds();
        Color foreColor = g2.getColor();
        g2.setStroke(this.getStroke());
        g2.setColor(this.getForeColorBySelectStatus(m.getSelectState()));
        Iterator it = points.iterator();
        Point p1 = (Point)it.next();
        Point p2 = null;
        int i = 0;
        while (it.hasNext()) {
            p2 = (Point)it.next();
            if (i >= ps.i) {
                double y2;
                double x2;
                double y1;
                double x1;
                if (i == ps.i) {
                    x1 = ps.t * (p2.x - p1.x) + p1.x - (double)rc.x;
                    y1 = ps.t * (p2.y - p1.y) + p1.y - (double)rc.y;
                } else {
                    x1 = p1.x - (double)rc.x;
                    y1 = p1.y - (double)rc.y;
                }
                if (i == pe.i) {
                    x2 = pe.t * (p2.x - p1.x) + p1.x - (double)rc.x;
                    y2 = pe.t * (p2.y - p1.y) + p1.y - (double)rc.y;
                } else {
                    x2 = p2.x - (double)rc.x;
                    y2 = p2.y - (double)rc.y;
                }
                g2.draw(new Line2D.Double(x1, y1, x2, y2));
                if (i == pe.i) {
                    if (m.isHeadless()) break;
                    this.drawArrowHead(g2, x1, y1, x2, y2);
                    break;
                }
            }
            ++i;
            p1 = p2;
        }
        this.drawGUIComponentName(g2);
        g2.setColor(foreColor);
    }

    @Override
    public void update(Observable model, Object aspect) {
        super.update(model, aspect);
        switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
            case 2: 
            case 41: {
                this.updateVisualAnchorPoints();
                break;
            }
            case 31: {
                this.updateVisualAnchorPoints();
            }
        }
    }

    protected LinkedList getPointsForDraw() {
        return ((LinkModelImpl)this.model).points;
    }

    protected void updateVisualAnchorPoints() {
        ShapeVCImpl shapeVCs = this.shapeVCs[0];
        ShapeVCImpl shapeVCe = this.shapeVCs[1];
        LinkedList points = this.getPointsForDraw();
        if (this.visualAnchorPoints[0] == null) {
            this.visualAnchorPoints[0] = new PointOnPolyline(0, 0.0);
        }
        if (this.visualAnchorPoints[1] == null) {
            this.visualAnchorPoints[1] = new PointOnPolyline(points.size() - 2, 1.0);
        }
        PointOnPolyline ps = this.visualAnchorPoints[0];
        PointOnPolyline pe = this.visualAnchorPoints[1];
        if (shapeVCs != null) {
            PointOnPolyline newps = shapeVCs.getCrossPoint(points, true);
            ps.i = newps.i;
            ps.t = newps.t;
        }
        if (shapeVCe != null) {
            PointOnPolyline newpe = shapeVCe.getCrossPoint(points, false);
            pe.i = newpe.i;
            pe.t = newpe.t;
        }
        if (shapeVCe == null) {
            return;
        }
        int gap = this.getLinkageGap();
        if (gap > 0) {
            if (ps.i > pe.i || ps.i == pe.i && ps.t >= pe.t) {
                return;
            }
            boolean find = false;
            double x = 0.0;
            double y = 0.0;
            double w = 2 * gap;
            double h = 2 * gap;
            Iterator it = points.iterator();
            Point p1 = (Point)it.next();
            Point p2 = null;
            int i = 0;
            while (it.hasNext()) {
                p2 = (Point)it.next();
                if (i >= pe.i) {
                    x = pe.t * (p2.x - p1.x) + p1.x;
                    y = pe.t * (p2.y - p1.y) + p1.y;
                    x -= (double)gap;
                    y -= (double)gap;
                    find = true;
                }
                ++i;
                p1 = p2;
            }
            if (find) {
                int i2 = 0;
                Iterator it2 = points.iterator();
                Point s = (Point)it2.next();
                while (it2.hasNext()) {
                    Point e = (Point)it2.next();
                    double t = RoundRectVC.getCrossPointForQuadrantCircle(s, e, null, x, y, w, h);
                    if (t <= 1.0) {
                        pe.i = i2;
                        pe.t = t;
                        break;
                    }
                    s = e;
                    ++i2;
                }
            }
        }
    }

    protected int getLinkageGap() {
        return 0;
    }
}

