/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.event.MouseEvent;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkModelImpl;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacer;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;

public abstract class LinkPlacerByClick
extends ShapePlacer {
    protected int nLink;

    public LinkPlacerByClick(CanvasVCImpl canvasvc) {
        super(canvasvc);
        this.needMouseMovedEvent = true;
        this.needMouseDraggedEvent = true;
        this.needMouseEnteredEvent = false;
        this.needMouseEnteredEventAfterSubVCs = true;
        this.needMouseExitedEvent = false;
        this.needMousePressedEvent = true;
        this.needSetMousePressedAfterSubVCs = false;
        this.needMouseReleasedEvent = true;
        this.nLink = 0;
    }

    public int getNLink() {
        return this.nLink;
    }

    public int incrementNLink() {
        return ++this.nLink;
    }

    public void clearNLink() {
        this.nLink = 0;
    }

    @Override
    public void mouseEnteredInCanvas(MouseEvent e, int canvasx, int canvasy) {
        if (this.canvasm.dragShape == null) {
            this.createDragShape(canvasx, canvasy);
        }
        this.setVisibleDragShape(true);
    }

    @Override
    public void mouseExitedFromCanvas() {
        this.setVisibleDragShape(false);
    }

    @Override
    public void mousePressedInCanvas(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        ShapeVCImpl targetvc = this.isCreateLinkWhenPressed(e, sourcevc, canvasx, canvasy);
        if (targetvc != null) {
            int selectStateOfTheTarget = ((ShapeModelImpl)targetvc.getModel()).getSelectState();
            int nextStateOfTheTarget = 9;
            targetvc.setMousePressedPoint(canvasx, canvasy);
            if (nextStateOfTheTarget != selectStateOfTheTarget) {
                ((ShapeModelImpl)targetvc.getModel()).setSelectState(nextStateOfTheTarget);
            }
            if (this.nLink <= 0) {
                this.canvasvc.setMousePressed(e, canvasx, canvasy);
            }
        }
    }

    protected ShapeVCImpl isCreateLinkWhenPressed(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        boolean ans;
        boolean bl = ans = sourcevc instanceof ShapeVCImpl && ((ShapeModelImpl)sourcevc.getModel()).isSelectable();
        if (ans) {
            return (ShapeVCImpl)sourcevc;
        }
        return null;
    }

    protected ShapeVCImpl isCreateLinkWhenReleased(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        int selectStateOfTheTarget;
        if (sourcevc instanceof ShapeVCImpl && (selectStateOfTheTarget = ((ShapeModelImpl)sourcevc.getModel()).getSelectState()) == 9) {
            return (ShapeVCImpl)sourcevc;
        }
        return null;
    }

    @Override
    public void mouseReleasedInCanvas(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        ShapeVCImpl targetvc;
        if (this.canvasvc.isMouseIn() && (targetvc = this.isCreateLinkWhenReleased(e, sourcevc, canvasx, canvasy)) != null) {
            this.createTemporaryLink(e, targetvc, canvasx, canvasy);
            this.canvasm.removeFromSelectedAll();
            this.canvasm.resetHandledShape();
        }
    }

    protected Point getLinkPoint(ShapeVCImpl shapeVC, int canvasx, int canvasy) {
        return this.getLinkPointCenter(shapeVC, canvasx, canvasy);
    }

    protected Point getLinkPointAsIs(ShapeVCImpl shapeVC, int canvasx, int canvasy) {
        ShapeModelImpl shape = (ShapeModelImpl)shapeVC.getModel();
        if (canvasx < shape.x) {
            canvasx = shape.x;
        } else if (canvasx > shape.x + shape.width) {
            canvasx = shape.x + shape.width;
        }
        if (canvasy < shape.y) {
            canvasy = shape.y;
        } else if (canvasy > shape.y + shape.height) {
            canvasy = shape.y + shape.height;
        }
        return new Point(canvasx, canvasy);
    }

    protected Point getLinkPointCenter(ShapeVCImpl shapeVC, int canvasx, int canvasy) {
        ShapeModelImpl shape = (ShapeModelImpl)shapeVC.getModel();
        int cx = shape.getCenterX();
        int cy = shape.getCenterY();
        return new Point(cx, cy);
    }

    protected LinkModelImpl createTemporaryLinkForStart(MouseEvent e, ShapeVCImpl shapeVC, int canvasx, int canvasy) {
        ShapeModelImpl shape = (ShapeModelImpl)shapeVC.getModel();
        int cx = shape.getCenterX();
        int cy = shape.getCenterY();
        Point newp = this.getLinkPoint(shapeVC, canvasx, canvasy);
        int newx = (int)newp.x;
        int newy = (int)newp.y;
        int w = canvasx - newx;
        int h = canvasy - newy;
        int dx = newx - cx;
        int dy = newy - cy;
        boolean forDrag = true;
        ShapeModelImpl shape1 = this.canvasm.createShapeModel(newx, newy, forDrag);
        LinkModelImpl link1 = (LinkModelImpl)shape1;
        SimpleAnchorImpl anchor = new SimpleAnchorImpl(0, 11, dx, dy);
        link1.addLastShape((ShapeModelImpl)shapeVC.getModel(), anchor);
        link1.resize(w, h);
        this.canvasvc.setMousePressedPoint(newx, newy);
        return link1;
    }

    protected LinkModelImpl createTemporaryLinkForEnd(MouseEvent e, ShapeVCImpl shapeVC, int canvasx, int canvasy) {
        ShapeModelImpl shape = (ShapeModelImpl)shapeVC.getModel();
        int cx = shape.getCenterX();
        int cy = shape.getCenterY();
        Point newp = this.getLinkPoint(shapeVC, canvasx, canvasy);
        int newx = (int)newp.x;
        int newy = (int)newp.y;
        int dx = newx - cx;
        int dy = newy - cy;
        LinkModelImpl link1 = (LinkModelImpl)this.canvasm.dragShape;
        SimpleAnchorImpl anchor = new SimpleAnchorImpl(0, 11, dx, dy);
        link1.addLastShape((ShapeModelImpl)shapeVC.getModel(), anchor);
        return link1;
    }

    protected void createTemporaryLink(MouseEvent e, ShapeVCImpl shapeVC, int canvasx, int canvasy) {
        if (this.nLink == 0) {
            this.removeDragShape();
            LinkModelImpl link1 = this.createTemporaryLinkForStart(e, shapeVC, canvasx, canvasy);
            this.canvasm.addDragShape(link1);
            this.incrementNLink();
        } else {
            LinkModelImpl link1 = this.createTemporaryLinkForEnd(e, shapeVC, canvasx, canvasy);
            int maxAnchors = link1.getMaxAnchorNum();
            if (this.incrementNLink() >= maxAnchors) {
                this.createLink(link1);
                this.removeDragShape();
                this.clearNLink();
            }
        }
    }

    protected LinkModelImpl createLink(LinkModelImpl templink) {
        return this.canvasm.createLink(templink);
    }

    @Override
    public void mouseDraggedInCanvas(MouseEvent e, int canvasx, int canvasy) {
        if (this.nLink == 0) {
            this.moveDragShape(canvasx, canvasy);
        } else {
            this.resizeDragShape(canvasx, canvasy);
        }
    }

    @Override
    public void mouseMovedInCanvas(MouseEvent e, int canvasx, int canvasy) {
        if (this.nLink == 0) {
            this.moveDragShape(canvasx, canvasy);
        } else {
            this.resizeDragShape(canvasx, canvasy);
        }
    }
}

