/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.Observable;
import java.util.Observer;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.ArrowWithHandleModelImpl;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;

public class LinkModelImpl
extends ArrowWithHandleModelImpl
implements Observer {
    protected static final int LINK_ANCHOR_NUM = 2;

    @Override
    protected int getMaxAnchorNum() {
        return 2;
    }

    public LinkModelImpl() {
    }

    public LinkModelImpl(int num) {
        super(num);
    }

    @Override
    public void addLastAnchor(AnchorImpl anchor) {
        if (anchor == null) {
            return;
        }
        this.addAnchor1(anchor);
        int index = this.anchorsList.size();
        if (index == 0) {
            int cx = (int)anchor.getX();
            int cy = (int)anchor.getY();
            int dx = cx - this.x;
            int dy = cy - this.y;
            this.x = cx;
            this.y = cy;
            for (Point p : this.points) {
                p.x += (double)dx;
                p.y += (double)dy;
            }
        } else {
            int cx = (int)anchor.getX();
            int cy = (int)anchor.getY();
            int dx = cx - this.x;
            int dy = cy - this.y;
            this.width = dx;
            this.height = dy;
        }
        anchor.addShapeObserver(this);
        this.setChanged();
        this.notifyObservers(63, anchor);
        this.clearChanged();
        if (index != 0) {
            this.resize(this.width, this.height);
            this.setChanged();
            this.notifyObservers(14);
            this.clearChanged();
        }
    }

    @Override
    public void update(Observable model, Object aspect) {
        switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
            case 42: {
                if (this.isPrimarilyMoved()) break;
                this.rotateByShape(model);
                break;
            }
            case 2: {
                if (this.isPrimarilyMoved()) break;
                this.rotateByShape(model);
                break;
            }
            case 31: {
                if (!this.isPrimarilyMoved()) {
                    this.resizeByShape(model, aspect);
                }
            }
            case 41: {
                if (this.isPrimarilyMoved()) break;
                this.rotateByShape(model);
                break;
            }
            case 3: {
                this.remove();
            }
        }
    }

    protected void rotateByShape(Observable model) {
        AnchorImpl anchor = this.getAnchor((ShapeModelImpl)model);
        anchor.updateXY();
        int newx = (int)anchor.getX();
        int newy = (int)anchor.getY();
        if (anchor.equals(this.getAnchorOf(0))) {
            int dx = newx - this.x;
            int dy = newy - this.y;
            this.rotate(0, dx, dy);
        } else {
            int dx = newx - (this.x + this.width);
            int dy = newy - (this.y + this.height);
            int n = this.points.size();
            this.rotate(n - 1, dx, dy);
        }
    }

    @Override
    public void resizeByHandle(int type, int dx, int dy) {
        int n = this.handles.length;
        if (type == 0 || type == n - 1) {
            AnchorImpl anchor = this.getAnchorOf(type == 0 ? 0 : 1);
            anchor.moveOffset(dx, dy);
        }
        super.resizeByHandle(type, dx, dy);
    }

    public ShapeModelImpl getShapeOf(int index) {
        AnchorImpl anchor = (AnchorImpl)this.anchorsList.get(index);
        return (ShapeModelImpl)anchor.getShapes().iterator().next();
    }

    @Override
    protected int getAnchoredPointX(AnchorImpl anchor) {
        if (anchor.equals(this.getAnchorOf(0))) {
            return this.x;
        }
        return this.x + this.width;
    }

    @Override
    protected int getAnchoredPointY(AnchorImpl anchor) {
        if (anchor.equals(this.getAnchorOf(0))) {
            return this.y;
        }
        return this.y + this.height;
    }
}

