/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.Observable;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.LineWithHandleModelImpl;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeWithHandleModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeWithHandleVCImpl;

public class LineWithHandleVCImpl
extends ShapeWithHandleVCImpl {
    protected static int MARGIN_THICK = 4;

    @Override
    protected Class getExpectedModelClass() {
        return LineWithHandleModelImpl.class;
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        LineWithHandleModelImpl m = (LineWithHandleModelImpl)this.getModel();
        Rectangle rc = this.getGUIComponentBounds();
        Color foreColor = g2.getColor();
        g2.setStroke(this.getStroke());
        g2.setColor(this.getForeColorBySelectStatus(m.getSelectState()));
        if (!m.changedByHandle) {
            Iterator it = m.points.iterator();
            Point p = (Point)it.next();
            double x1 = p.x - (double)rc.x;
            double y1 = p.y - (double)rc.y;
            while (it.hasNext()) {
                p = (Point)it.next();
            }
            double x2 = p.x - (double)rc.x;
            double y2 = p.y - (double)rc.y;
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
        } else {
            Iterator it = m.points.iterator();
            Point p = (Point)it.next();
            double x1 = p.x - (double)rc.x;
            double y1 = p.y - (double)rc.y;
            while (it.hasNext()) {
                p = (Point)it.next();
                double x2 = p.x - (double)rc.x;
                double y2 = p.y - (double)rc.y;
                g2.draw(new Line2D.Double(x1, y1, x2, y2));
                x1 = x2;
                y1 = y2;
            }
        }
        this.drawGUIComponentName(g2);
        g2.setColor(foreColor);
    }

    @Override
    protected double getCrossPoint(Point ps, Point pe) {
        return LineWithHandleVCImpl.getCrossPointForLine(this, ps, pe);
    }

    static double getCrossPointForLine(ShapeVCImpl vc, Point ps, Point pe) {
        LineWithHandleModelImpl m = (LineWithHandleModelImpl)vc.getModel();
        Iterator it = m.points.iterator();
        double t = NOT_CROSSED;
        Point p1 = (Point)it.next();
        while (it.hasNext()) {
            Point p2 = (Point)it.next();
            double t1 = LineWithHandleVCImpl.getCrossPoint(ps, pe, p1, p2);
            if (t1 < t) {
                t = t1;
            }
            p1 = p2;
        }
        return t;
    }

    @Override
    protected int getMinWidth() {
        return 0;
    }

    @Override
    protected int getMinHeight() {
        return 0;
    }

    @Override
    protected boolean containsCompletely(int x, int y) {
        LineWithHandleModelImpl m = (LineWithHandleModelImpl)this.model;
        Iterator it = m.points.iterator();
        Point p1 = (Point)it.next();
        Point p2 = null;
        while (it.hasNext()) {
            p2 = (Point)it.next();
            boolean ans = this.contains(x, y, p1, p2);
            if (ans) {
                return ans;
            }
            p1 = p2;
        }
        return false;
    }

    protected boolean contains(int x, int y, Point ps, Point pe) {
        double ny;
        double nx;
        double dx = pe.x - ps.x;
        double dy = pe.y - ps.y;
        double len = dx * dx + dy * dy;
        if (Math.abs(len) < 0.5) {
            return false;
        }
        len = Math.sqrt(len);
        if (Math.abs(dx) > Math.abs(dy)) {
            nx = dy / len;
            ny = -dx / len;
        } else {
            nx = -dy / len;
            ny = dx / len;
        }
        Rectangle r = this.getGUIComponentBounds();
        x += r.x;
        y += r.y;
        Polygon p = new Polygon();
        p.addPoint((int)(ps.x + (nx *= 4.0)), (int)(ps.y + (ny *= 4.0)));
        p.addPoint((int)(pe.x + nx), (int)(pe.y + ny));
        p.addPoint((int)(pe.x - nx), (int)(pe.y - ny));
        p.addPoint((int)(ps.x - nx), (int)(ps.y - ny));
        return p.contains(x, y);
    }

    @Override
    protected Rectangle getGUIComponentBounds() {
        Rectangle r = this.getGUIBounds();
        r.x -= MARGIN_THICK;
        r.width += MARGIN_THICK * 2;
        r.y -= MARGIN_THICK;
        r.height += MARGIN_THICK * 2;
        return r;
    }

    @Override
    protected Rectangle getGUIBounds() {
        LineWithHandleModelImpl m = (LineWithHandleModelImpl)this.model;
        Iterator it = m.points.iterator();
        Point p = (Point)it.next();
        int x0 = (int)p.x;
        int y0 = (int)p.y;
        int x1 = x0;
        int y1 = y0;
        int i = 1;
        while (it.hasNext()) {
            p = (Point)it.next();
            int x = (int)p.x;
            int y = (int)p.y;
            if (x < x0) {
                x0 = x;
            } else if (x > x1) {
                x1 = x;
            }
            if (y < y0) {
                y0 = y;
            } else if (y > y1) {
                y1 = y;
            }
            ++i;
        }
        Rectangle r = new Rectangle();
        r.x = x0;
        r.y = y0;
        r.width = x1 - x0 + this.getLineWidth();
        r.height = y1 - y0 + this.getLineHeight();
        return r;
    }

    @Override
    protected boolean isReversible() {
        return true;
    }

    private int decrementAbsValue(int i) {
        if (i > 0) {
            --i;
        } else if (i < 0) {
            ++i;
        }
        return i;
    }

    @Override
    protected void resizeByHandle(int type, int dx, int dy) {
        ShapeWithHandleModelImpl m = (ShapeWithHandleModelImpl)this.model;
        int n = m.getHandles().length;
        if (type == 0) {
            int w = m.getWidth();
            int h = m.getHeight();
            if (w - dx == 0 && h - dy == 0) {
                dx = this.decrementAbsValue(dx);
                dy = this.decrementAbsValue(dy);
            }
        } else if (type == n - 1) {
            int w = m.getWidth();
            int h = m.getHeight();
            if (w + dx == 0 && h + dy == 0) {
                dx = this.decrementAbsValue(dx);
                dy = this.decrementAbsValue(dy);
            }
        }
        ((ShapeWithHandleModelImpl)this.model).resizeByHandle(type, dx, dy);
    }

    @Override
    public void update(Observable model, Object aspect) {
        super.update(model, aspect);
        switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
            case 41: {
                Rectangle rold = this.component.getBounds();
                Rectangle r = this.getGUIComponentBounds();
                if (r.equals(rold)) {
                    this.visualUpdate();
                    break;
                }
                this.component.setBounds(r);
            }
        }
    }
}

