/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.Iterator;
import java.util.LinkedList;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.ShapeHandleModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeWithHandleModelImpl;

public class LineWithHandleModelImpl
extends ShapeWithHandleModelImpl {
    protected LinkedList points;
    protected boolean changedByHandle = false;
    protected int internalHandleNumber;

    public LineWithHandleModelImpl() {
        this.internalHandleNumber = 0;
    }

    public LineWithHandleModelImpl(int num) {
        if (num < 0) {
            throw new IllegalArgumentException("num must be non zero. but " + num);
        }
        this.internalHandleNumber = num;
    }

    @Override
    public void initialize(CanvasModelImpl canvas, int x, int y, int w, int h, boolean forDrag) {
        super.initialize(canvas, x, y, w, h, forDrag);
        this.createNodes(this.internalHandleNumber + 1);
    }

    protected void createNodes(int divNum) {
        double dd = divNum;
        this.points = new LinkedList();
        this.points.addLast(new Point(this.x, this.y));
        int i = 1;
        while (i < divNum) {
            this.points.addLast(new Point((double)this.x + (double)i * (double)this.width / dd, (double)this.y + (double)i * (double)this.height / dd));
            ++i;
        }
        this.points.addLast(new Point(this.x + this.width, this.y + this.height));
    }

    @Override
    protected void updateHandles() {
        if (this.handles == null) {
            this.handles = new ShapeHandleModelImpl[this.points.size()];
            int i = 0;
            for (Point p : this.points) {
                this.setMyHandle1(i++, (int)p.x, (int)p.y);
            }
            this.setChanged();
            this.notifyObservers(21);
            this.clearChanged();
            this.canvas.setHandledShape(this);
        }
    }

    @Override
    public void resizeByHandle(int type, int dx, int dy) {
        this.handles[type].movePrimitive(dx, dy);
        int lastCx = this.getCenterX();
        int lastCy = this.getCenterY();
        int n = this.handles.length;
        if (type == 0) {
            this.x += dx;
            this.y += dy;
            this.width -= dx;
            this.height -= dy;
        } else if (type == n - 1) {
            this.width += dx;
            this.height += dy;
        }
        Point p = (Point)this.points.get(type);
        p.x += (double)dx;
        p.y += (double)dy;
        this.changedByHandle = true;
        this.moveAnchor(lastCx, lastCy);
        this.setChanged();
        this.notifyObservers(41);
        this.clearChanged();
    }

    @Override
    protected boolean hasName() {
        return false;
    }

    @Override
    public void move(int dx, int dy) {
        this.moveInternal(dx, dy);
        super.move(dx, dy);
    }

    @Override
    public void move(int dx, int dy, int aspect) {
        if (aspect == 42) {
            this.moveInternal(dx, dy);
        }
        super.move(dx, dy, aspect);
    }

    protected void moveInternal(int dx, int dy) {
        for (Point p : this.points) {
            p.x += (double)dx;
            p.y += (double)dy;
        }
    }

    private Point calcDrDt(double x0, double y0, double x1, double y1, int dx, int dy) {
        double x = x1 - x0;
        double y = y1 - y0;
        double xnew = x + (double)dx;
        double ynew = y + (double)dy;
        double r = Math.sqrt((xnew * xnew + ynew * ynew) / (x * x + y * y));
        double theta = Math.atan2(xnew, ynew) - Math.atan2(x, y);
        Point p = new Point(r, theta);
        p.x = r;
        p.y = theta;
        return p;
    }

    protected void rotate(int type, int dx, int dy) {
        if (this.changedByHandle) {
            if (type == 0) {
                int n = this.points.size();
                Iterator it = this.points.iterator();
                Point p = (Point)it.next();
                double x1 = this.x;
                double y1 = this.y;
                p.x = x1 + (double)dx;
                p.y = y1 + (double)dy;
                Point p1 = (Point)this.points.getLast();
                double x0 = p1.x;
                double y0 = p1.y;
                this.x += dx;
                this.y += dy;
                Point dtdr = this.calcDrDt(x0, y0, x1, y1, dx, dy);
                double rsint = dtdr.x * Math.sin(dtdr.y);
                double rcost = dtdr.x * Math.cos(dtdr.y);
                int i = 1;
                while (i < n - 1) {
                    p = (Point)it.next();
                    double x = p.x - x0;
                    double y = p.y - y0;
                    p.x = rcost * x + rsint * y + x0;
                    p.y = -rsint * x + rcost * y + y0;
                    if (this.handles != null) {
                        this.handles[i].moveAtCenterPrimitive((int)(p.x + 0.5), (int)(p.y + 0.5));
                    }
                    ++i;
                }
                super.resize(this.width - dx, this.height - dy);
            } else {
                int n = this.points.size();
                Iterator it = this.points.iterator();
                Point p = (Point)it.next();
                double x0 = this.x;
                double y0 = this.y;
                p.x = x0;
                p.y = y0;
                Point p1 = (Point)this.points.getLast();
                double x1 = p1.x;
                double y1 = p1.y;
                p1.x += (double)dx;
                p1.y += (double)dy;
                Point dtdr = this.calcDrDt(x0, y0, x1, y1, dx, dy);
                double rsint = dtdr.x * Math.sin(dtdr.y);
                double rcost = dtdr.x * Math.cos(dtdr.y);
                int i = 1;
                while (i < n - 1) {
                    p = (Point)it.next();
                    double x = p.x - x0;
                    double y = p.y - y0;
                    p.x = rcost * x + rsint * y + x0;
                    p.y = -rsint * x + rcost * y + y0;
                    if (this.handles != null) {
                        this.handles[i].moveAtCenterPrimitive((int)(p.x + 0.5), (int)(p.y + 0.5));
                    }
                    ++i;
                }
                super.resize(this.width + dx, this.height + dy);
            }
        } else if (type == 0) {
            this.x += dx;
            this.y += dy;
            int width = this.width - dx;
            int height = this.height - dy;
            this.resize(width, height);
        } else {
            int width = this.width + dx;
            int height = this.height + dy;
            this.resize(width, height);
        }
    }

    @Override
    public void resize(int width, int height) {
        int n = this.points.size();
        Iterator it = this.points.iterator();
        Point p = (Point)it.next();
        double x0 = this.x;
        double y0 = this.y;
        p.x = x0;
        p.y = y0;
        int i = 1;
        while (i < n - 1) {
            p = (Point)it.next();
            double ratio = (double)i / (double)(n - 1);
            p.x = x0 + ratio * (double)width;
            p.y = y0 + ratio * (double)height;
            if (this.handles != null) {
                this.handles[i].moveAtCenterPrimitive((int)(p.x + 0.5), (int)(p.y + 0.5));
            }
            ++i;
        }
        p = (Point)it.next();
        p.x = x0 + (double)width;
        p.y = y0 + (double)height;
        super.resize(width, height);
    }

    @Override
    public void moveCenterOffsetWithoutNotify() {
        super.moveCenterOffsetWithoutNotify();
        if (this.points != null) {
            int dx = this.getCenterOffsetX();
            int dy = this.getCenterOffsetY();
            for (Point p : this.points) {
                p.x -= (double)dx;
                p.y -= (double)dy;
            }
        }
    }
}

