/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.CircleModel;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.RoundRectVC;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;

public class CircleVC
extends AnchoredShapeVCImpl {
    private static Color fillColor = Color.WHITE;

    protected Color getFillColor() {
        return fillColor;
    }

    @Override
    protected Class getExpectedModelClass() {
        return CircleModel.class;
    }

    @Override
    protected boolean containsCompletely(int x, int y) {
        return CircleVC.containsCompletelyForCircle(this, x, y);
    }

    static boolean containsCompletelyForCircle(ShapeVCImpl vc, int x, int y) {
        Rectangle rc = vc.getGUIComponentBounds();
        Rectangle r = vc.getGUIBounds();
        int w = r.width;
        int h = r.height;
        Ellipse2D.Double e = new Ellipse2D.Double(r.x - rc.x, r.y - rc.y, w, h);
        return e.contains(x, y);
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        CircleVC.paintGUIComponentForCircle(this, g2);
    }

    static void paintGUIComponentForCircle(CircleVC vc, Graphics2D g2) {
        Rectangle rc = vc.getGUIComponentBounds();
        Rectangle r = vc.getGUIBounds();
        ShapeModelImpl m = (ShapeModelImpl)vc.getModel();
        int w = r.width;
        int h = r.height;
        Color foreColor = g2.getColor();
        Ellipse2D.Float e = new Ellipse2D.Float(r.x - rc.x, r.y - rc.y, w, h);
        g2.setBackground(Color.white);
        g2.setColor(vc.getFillColor());
        if (!vc.needToFill()) {
            g2.fill(e);
        }
        g2.setColor(vc.getForeColorBySelectStatus(m.getSelectState()));
        vc.drawGUIComponentName(g2);
        if (vc.needToFill()) {
            g2.fill(e);
        } else {
            g2.setStroke(vc.getStroke());
            g2.draw(e);
        }
        g2.setColor(foreColor);
    }

    static void paintGUIComponentForCircleOld(CircleVC vc, Graphics2D g2) {
        Rectangle rc = vc.getGUIComponentBounds();
        Rectangle r = vc.getGUIBounds();
        ShapeModelImpl m = (ShapeModelImpl)vc.getModel();
        int w = r.width;
        int h = r.height;
        int w1 = w - 1;
        int h1 = h - 1;
        Color foreColor = g2.getColor();
        g2.setBackground(Color.white);
        g2.setColor(vc.getFillColor());
        if (!vc.needToFill()) {
            g2.fillOval(r.x - rc.x, r.y - rc.y, w1, h1);
        }
        g2.setColor(vc.getForeColorBySelectStatus(m.getSelectState()));
        vc.drawGUIComponentName(g2);
        if (vc.needToFill()) {
            g2.fillOval(r.x - rc.x, r.y - rc.y, w, h);
        } else {
            g2.setStroke(vc.getStroke());
            g2.drawOval(r.x - rc.x, r.y - rc.y, w - 1, h - 1);
        }
        g2.setColor(foreColor);
    }

    @Override
    protected double getCrossPoint(Point ps, Point pe) {
        return RoundRectVC.getCrossPointForCircle(this, ps, pe);
    }
}

