/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.ViewControllerImpl;
import jp.co.fujiric.star.gui.gef.swing.AspectConstants;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkModelImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacer;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacerPointer;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;

public class CanvasVCImpl
extends SwingVCImpl
implements AspectConstants,
MouseListener,
MouseMotionListener,
Printable {
    protected int scrollUnit = 50;
    protected boolean mousePressed = false;
    protected boolean mouseIsIn = false;
    protected ShapeVCImpl dragShapeVC;
    protected HashMap shapeVCsByModel;
    protected ShapePlacer placer;
    protected int mousePressedX;
    protected int mousePressedY;
    protected Map vcMapByModel;

    @Override
    public void initializevc(ModelImpl model) {
        super.initializevc(model);
        this.shapeVCsByModel = new HashMap();
        this.dragShapeVC = null;
        this.getGuiComponent().addMouseListener(this);
        this.getGuiComponent().addMouseMotionListener(this);
        this.placer = new ShapePlacerPointer(this);
    }

    protected Class getExpectedModelClass() {
        return CanvasModelImpl.class;
    }

    public void setPlacer(ShapePlacer placer) {
        this.placer = placer;
        this.placer.removeDragShape();
        ((CanvasModelImpl)this.model).removeFromSelectedAll();
        ((CanvasModelImpl)this.model).resetHandledShape();
        this.setShapeMVCClassNames(placer.getShapeMVCClassNamesMap(), placer.getMainShapeModelClassName());
    }

    @Override
    protected JComponent createComponent() {
        return new MyJLayeredPane();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseEntered(e, e.getX(), e.getY());
    }

    protected void mouseEntered(MouseEvent e, int canvasx, int canvasy) {
        if (!this.mouseIsIn) {
            this.mouseIsIn = true;
            this.placer.mouseEnteredInCanvas(e, canvasx, canvasy);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseExited(e, e.getX(), e.getY());
    }

    protected void mouseExited(MouseEvent e, int x, int y) {
        this.placer.mouseExitedFromCanvas();
        this.mouseIsIn = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed(e, this, e.getX(), e.getY());
    }

    protected void mousePressed(MouseEvent e, SwingVCImpl sourcevc, int x, int y) {
        this.setMousePressed(e, x, y);
        this.placer.mousePressedInCanvas(e, sourcevc, x, y);
    }

    protected void setMousePressed(MouseEvent e, int x, int y) {
        this.mousePressed = true;
        this.placer.setMousePressed(true);
    }

    protected void setMousePressedPoint(int canvasx, int canvasy) {
        this.mousePressedX = canvasx;
        this.mousePressedY = canvasy;
    }

    protected void setMouseReleased(MouseEvent e) {
        this.mousePressed = false;
        this.placer.setMousePressed(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseReleased(e, this, e.getX(), e.getY());
    }

    protected void mouseReleased(MouseEvent e, SwingVCImpl sourcevc, int x, int y) {
        this.placer.mouseReleasedInCanvas(e, sourcevc, x, y);
        this.setMouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragged(e, e.getX(), e.getY());
    }

    protected void mouseDragged(MouseEvent e, int x, int y) {
        this.placer.mouseDraggedInCanvas(e, x, y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseMoved(e, e.getX(), e.getY());
    }

    protected void mouseMoved(MouseEvent e, int x, int y) {
        this.placer.mouseMovedInCanvas(e, x, y);
    }

    protected ShapeVCImpl createShapeVC(ShapeModelImpl model) {
        ShapeVCImpl vc = this.createShapeVCNotInitialized(model);
        if (vc != null) {
            vc.initializevc(model);
        }
        return vc;
    }

    protected ShapeVCImpl createShapeVCNotInitialized(ShapeModelImpl model) {
        try {
            String className = model.getClass().getName();
            Class<?> clazz = Class.forName((String)this.vcMapByModel.get(className));
            ShapeVCImpl vc = (ShapeVCImpl)clazz.newInstance();
            return vc;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        System.out.println("createShapeVCNotInitialized: className=" + model.getClass().getName());
        System.out.println("vcMapByModel:begin");
        for (Object key : this.vcMapByModel.keySet()) {
            System.out.println("  key=" + key);
        }
        System.out.println("vcMapByModel:end");
        return null;
    }

    protected void setShapeName(ShapeModelImpl shape, String name, Rectangle r) {
        MyTextField tf = new MyTextField(this, shape, name, 10);
        tf.setFont(ShapeVCImpl.getDefaultFont());
        this.component.add(tf, JLayeredPane.DRAG_LAYER, 0);
        tf.setHorizontalAlignment(0);
        FontMetrics fm = tf.getFontMetrics(tf.getFont());
        int fh = fm.getHeight();
        int w = r.width - 2;
        int h = r.height;
        int x = r.x + 1;
        int y = r.y + (h - fh) / 2;
        tf.requestFocus();
        tf.setSelectionStart(0);
        tf.setSelectionEnd(tf.getText().length());
        tf.setBounds(x, y, w, fh);
    }

    protected void setDragShapeVC(ShapeVCImpl dragShapeVC) {
        this.dragShapeVC = dragShapeVC;
        this.add(dragShapeVC);
    }

    @Override
    protected void addGuiComponentPrimitive(SwingVCImpl child) {
        if (child instanceof ShapeVCImpl) {
            ShapeModelImpl shapeModel = (ShapeModelImpl)((ShapeVCImpl)child).getModel();
            if (shapeModel.isForDrag()) {
                this.component.add(child.component, JLayeredPane.DRAG_LAYER, 0);
                return;
            }
            if (shapeModel instanceof LinkModelImpl) {
                LinkVCImpl linkvc = (LinkVCImpl)child;
                this.component.add(child.component, linkvc.getLayerIndex(), 0);
                return;
            }
        }
        Integer layer = JLayeredPane.DEFAULT_LAYER;
        if (child instanceof ShapeVCImpl) {
            ShapeVCImpl vc = (ShapeVCImpl)child;
            layer = vc.getLayerIndex();
        }
        this.component.add(child.component, layer, 0);
    }

    @Override
    public void update(Observable obserbable, Object aspect) {
        switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
            case 1: {
                ShapeModelImpl shape = (ShapeModelImpl)((ModelImpl.AspectWithObject)aspect).getAspectObj();
                ShapeVCImpl shapeVC = this.createShapeVC(shape);
                if (shape.isForDrag()) {
                    this.setDragShapeVC(shapeVC);
                    break;
                }
                this.shapeVCsByModel.put(shape, shapeVC);
                this.add(shapeVC);
                if (shape.needToSetNameInitially()) {
                    Rectangle r = shapeVC.getGUIBounds();
                    this.setShapeName(shape, shape.getDefaultName(), r);
                }
                if (!(shape instanceof LinkModelImpl)) break;
                int n = ((LinkModelImpl)shape).getMaxAnchorNum();
                int i = 0;
                while (i < n) {
                    ShapeModelImpl shape1 = ((LinkModelImpl)shape).getShapeOf(i);
                    ShapeVCImpl shapeVC1 = (ShapeVCImpl)this.shapeVCsByModel.get(shape1);
                    ((LinkVCImpl)shapeVC).addLastVC(shapeVC1);
                    ++i;
                }
                ((LinkVCImpl)shapeVC).updateVisualAnchorPoints();
                break;
            }
            case 3: {
                ShapeModelImpl shape = (ShapeModelImpl)((ModelImpl.AspectWithObject)aspect).getAspectObj();
                if (shape.isForDrag()) {
                    this.removeChild(this.dragShapeVC);
                    break;
                }
                ShapeVCImpl shapevc = (ShapeVCImpl)this.shapeVCsByModel.get(shape);
                if (shapevc == null) break;
                this.removeChild(shapevc);
                break;
            }
            case 61: {
                ShapeModelImpl shape = (ShapeModelImpl)((ModelImpl.AspectWithObject)aspect).getAspectObj();
                ShapeVCImpl shapevc = (ShapeVCImpl)this.shapeVCsByModel.get(shape);
                this.removeChild(shapevc, false);
            }
        }
    }

    private void removeShapeVC(ViewControllerImpl subVC, boolean forGUIComp) {
        if (forGUIComp) {
            SwingVCImpl swingvc;
            JComponent c;
            if (subVC instanceof SwingVCImpl && (c = (swingvc = (SwingVCImpl)subVC).getGuiComponent()) != null) {
                c.setVisible(false);
                this.component.remove(c);
            }
            if (subVC instanceof ShapeVCImpl) {
                this.shapeVCsByModel.remove(subVC.getModel());
            }
        }
        if (this.dragShapeVC == subVC) {
            this.dragShapeVC = null;
        }
    }

    protected void removeChild(ViewControllerImpl subVC, boolean forGUIComp) {
        this.removeShapeVC(subVC, forGUIComp);
        super.removeChild(subVC);
    }

    @Override
    public void removeChild(ViewControllerImpl subVC) {
        this.removeChild(subVC, true);
    }

    public ShapeVCImpl getFromShapeVCByModel(ShapeModelImpl shape) {
        return (ShapeVCImpl)this.shapeVCsByModel.get(shape);
    }

    public void putToShapeVCsByModel(ShapeModelImpl shape, ShapeVCImpl vc) {
        this.shapeVCsByModel.put(shape, vc);
    }

    protected boolean needMouseDraggedEventOfSubVCs() {
        return this.placer.isNeedMouseDraggedEvent();
    }

    protected boolean needMouseMovedEventOfSubVCs() {
        return this.placer.isNeedMouseMovedEvent();
    }

    protected boolean needMousePressedEventOfSubVCs() {
        return this.placer.isNeedMousePressedEvent();
    }

    protected boolean needMouseReleasedEventOfSubVCs() {
        return this.placer.isNeedMouseReleasedEvent();
    }

    protected boolean needMouseEnteredEventOfSubVCs() {
        return this.placer.isNeedMouseEnteredEvent();
    }

    protected boolean needMouseEnteredEventAfterSubVCs() {
        return this.placer.isNeedMouseEnteredEventAfterSubVCs();
    }

    protected boolean isNeedSetMousePressedAfterSubVCs() {
        return this.placer.isNeedSetMousePressedAfterSubVCs();
    }

    protected boolean needMouseExitedEventOfSubVCs() {
        return this.placer.isNeedMouseExitedEvent();
    }

    protected void printGUIComponentTree() {
        JComponent c = this.component;
        int level = 0;
        this.printGUIComponentTree(c, level);
    }

    protected void printVCTree() {
        int level = 0;
        this.printVCTree(this, level);
    }

    protected void printVCTree(ViewControllerImpl vc, int level) {
        if (vc != null) {
            int i = 0;
            while (i < level) {
                System.out.print("  ");
                ++i;
            }
            System.out.println("vc:" + vc);
            ++level;
            Iterator it = vc.getSubsIterator();
            while (it.hasNext()) {
                ViewControllerImpl vc1 = (ViewControllerImpl)it.next();
                this.printVCTree(vc1, level);
            }
        }
    }

    protected void printGUIComponentTree(JComponent c, int level) {
        if (c != null) {
            int i = 0;
            while (i < level) {
                System.out.print("  ");
                ++i;
            }
            System.out.println(" c:" + c);
            ++level;
            int n = c.getComponentCount();
            int i2 = 0;
            while (i2 < n) {
                JComponent c1 = (JComponent)c.getComponent(i2);
                this.printGUIComponentTree(c1, level);
                ++i2;
            }
        }
    }

    public void setShapeMVCClassName(String modelClassName, String vcClassName) {
        ((CanvasModelImpl)this.model).setShapeModelClassName(modelClassName);
        this.vcMapByModel = new HashMap();
        this.vcMapByModel.put(modelClassName, vcClassName);
    }

    public void setShapeMVCClassNames(Map map, String modelClassName) {
        this.vcMapByModel = map != null ? new HashMap(map) : null;
        ((CanvasModelImpl)this.model).setShapeModelClassName(modelClassName);
    }

    public Map getShapeMVCMap() {
        if (this.vcMapByModel == null) {
            return null;
        }
        return this.vcMapByModel;
    }

    public void setShapeMVCMap(Map map) {
        this.vcMapByModel = map;
    }

    public int deleteSelectedShapes() {
        if (this.placer instanceof ShapePlacerPointer) {
            return ((CanvasModelImpl)this.model).removeSelectedShapes();
        }
        return 0;
    }

    public void printCanvas(boolean throwException) throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                if (throwException) {
                    throw pe;
                }
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public void debugPrint(String title) {
        System.out.println(title);
        this.debugPrint();
    }

    public void debugPrint() {
        System.out.println("---printVCs---");
        this.printVCTree();
        System.out.println("---printGUIcomps---");
        this.printGUIComponentTree();
        System.out.println("---printSelectedShapes---");
        this.printSelectionInfo();
        System.out.println("---printShapeVCsByModel---");
        this.printShapeVCsByModel();
    }

    public BufferedImage getBufferedImage(int type) {
        int w = this.getGuiComponent().getWidth();
        int h = this.getGuiComponent().getHeight();
        BufferedImage bi = new BufferedImage(w, h, type);
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, w, h);
        CanvasVCImpl.disableDoubleBuffering(this.component);
        this.component.paint(g2);
        CanvasVCImpl.enableDoubleBuffering(this.component);
        return bi;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        CanvasVCImpl.disableDoubleBuffering(this.component);
        this.component.paint(g2d);
        CanvasVCImpl.enableDoubleBuffering(this.component);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public void printSelectionInfo() {
        CanvasModelImpl canvas = (CanvasModelImpl)this.getModel();
        Iterator it = canvas.getSelectedListIterator();
        while (it.hasNext()) {
            ShapeModelImpl shape = (ShapeModelImpl)it.next();
            System.out.println("  shape:" + shape);
        }
    }

    public void printShapeVCsByModel() {
        for (Object key : this.shapeVCsByModel.keySet()) {
            Object value = this.shapeVCsByModel.get(key);
            System.out.println("  key:" + key + ", value=" + value);
            ShapeModelImpl model = (ShapeModelImpl)key;
            System.out.println("  selectState=" + model.getSelectState());
        }
    }

    public void groupSelectedShapes() {
        if (this.placer instanceof ShapePlacerPointer) {
            ((CanvasModelImpl)this.model).groupSelectedShapes();
        }
    }

    public void ungroupSelectedShapes() {
        if (this.placer instanceof ShapePlacerPointer) {
            ((CanvasModelImpl)this.model).ungroupSelectedShapes();
        }
    }

    public void addForDisposeGroup(ViewControllerImpl subVC) {
        super.addProtected(subVC);
    }

    public boolean isMouseIn() {
        return this.mouseIsIn;
    }

    public class MyJLayeredPane
    extends JLayeredPane
    implements Scrollable {
        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(Color.white);
            Rectangle r = this.getBounds();
            g2.clearRect(0, 0, r.width, r.height);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                int inc = visibleRect.height;
                if (inc <= 0) {
                    inc = 1;
                }
                return inc;
            }
            int inc = visibleRect.width;
            if (inc <= 0) {
                inc = 1;
            }
            return inc;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return CanvasVCImpl.this.scrollUnit;
        }
    }

    public class MyTextField
    extends JTextField
    implements ActionListener,
    FocusListener {
        protected CanvasVCImpl canvasVC;
        protected ShapeModelImpl shape;

        public MyTextField(CanvasVCImpl canvasVC, ShapeModelImpl shape, String name, int column) {
            super(name, column);
            this.canvasVC = canvasVC;
            this.shape = shape;
            this.addActionListener(this);
            this.addFocusListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.setVisible(false);
            this.canvasVC.component.remove(this);
            String name = this.getText();
            this.shape.setName(name);
        }
    }
}

