/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AspectConstants;
import jp.co.fujiric.star.gui.gef.swing.CompositeShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeWithHandleModelImpl;

public class CanvasModelImpl
extends ModelImpl
implements AspectConstants {
    protected LinkedList shapes = new LinkedList();
    protected ShapeModelImpl dragShape = null;
    protected LinkedList selectedShapes = new LinkedList();
    protected ShapeWithHandleModelImpl handledShape = null;
    protected String shapeModelClassName;

    public void addLast(ShapeModelImpl shape) {
        this.shapes.addLast(shape);
        this.setChanged();
        this.notifyObservers(1, shape);
        this.clearChanged();
    }

    public ShapeModelImpl getLastShape() {
        return (ShapeModelImpl)this.shapes.getLast();
    }

    public void removeLast() {
        this.shapes.removeLast();
    }

    public void removeShape(ShapeModelImpl shape) {
        this.removeShapePrimitive(shape, false);
    }

    protected void removeShapePrimitive(ShapeModelImpl shape, boolean forGrouping) {
        this.shapes.remove(shape);
        if (!forGrouping) {
            this.selectedShapes.remove(shape);
            if (this.handledShape == shape) {
                this.handledShape = null;
            }
        }
        if (this.dragShape == shape) {
            this.dragShape = null;
        }
        this.setChanged();
        this.notifyObservers(forGrouping ? 61 : 3, shape);
        this.clearChanged();
    }

    public void addDragShape(ShapeModelImpl shape) {
        this.dragShape = shape;
        this.setChanged();
        this.notifyObservers(1, shape);
        this.clearChanged();
    }

    public ShapeModelImpl getDragShape() {
        return this.dragShape;
    }

    public void removeDragShape() {
        ShapeModelImpl dragShape = this.dragShape;
        if (dragShape != null) {
            this.dragShape = null;
            dragShape.remove();
        }
    }

    public void addSelectedActually(ShapeModelImpl model) {
        this.selectedShapes.addLast(model);
    }

    public void removeFromSelectedActually(ShapeModelImpl model) {
        this.selectedShapes.remove(model);
    }

    public void removeFromSelectedAll() {
        LinkedList list = new LinkedList(this.selectedShapes);
        this.selectedShapes = new LinkedList();
        for (ShapeModelImpl shape : list) {
            int selectState = shape.getSelectState();
            int state = selectState == 7 ? 4 : 3;
            shape.setSelectStatePrimitive(state);
        }
    }

    public void unselectAll() {
        this.removeFromSelectedAll();
        this.resetHandledShape();
    }

    public Iterator getSelectedListIterator() {
        return this.selectedShapes.iterator();
    }

    protected void setHandledShape(ShapeWithHandleModelImpl shape) {
        this.resetHandledShape();
        this.handledShape = shape;
    }

    protected void resetHandledShape() {
        if (this.handledShape != null) {
            this.handledShape.removeHandles();
            this.handledShape = null;
        }
    }

    public void setShapeModelClassName(String modelClassName) {
        this.shapeModelClassName = modelClassName;
    }

    protected final ShapeModelImpl createShapeModelByOldModel(ShapeModelImpl old, boolean forDrag) {
        try {
            Class<?> clazz = Class.forName(this.shapeModelClassName);
            ShapeModelImpl model = (ShapeModelImpl)clazz.newInstance();
            model.initialize(old, forDrag);
            return model;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected final ShapeModelImpl createShapeModel(int x, int y, boolean forDrag) {
        try {
            Class<?> clazz = Class.forName(this.shapeModelClassName);
            ShapeModelImpl model = (ShapeModelImpl)clazz.newInstance();
            model.initialize(this, x, y, forDrag);
            return model;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected final ShapeModelImpl createShapeModel(int x, int y, int w, int h, boolean forDrag) {
        try {
            Class<?> clazz = Class.forName(this.shapeModelClassName);
            ShapeModelImpl model = (ShapeModelImpl)clazz.newInstance();
            model.initialize(this, x, y, w, h, forDrag);
            return model;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ShapeModelImpl createShape() {
        ShapeModelImpl m = this.dragShape;
        boolean forDrag = false;
        ShapeModelImpl shape = this.createShapeModelByOldModel(m, forDrag);
        this.addLast(shape);
        return shape;
    }

    protected LinkModelImpl createLink(LinkModelImpl m) {
        boolean forDrag = false;
        LinkModelImpl link = (LinkModelImpl)this.createShapeModelByOldModel(m, forDrag);
        this.addLast(link);
        link.setSelectState(3);
        return link;
    }

    protected void createDragShapeByDrag(int x, int y) {
        boolean forDrag = true;
        ShapeModelImpl shape = this.createShapeModel(x, y, 1, 1, forDrag);
        this.addDragShape(shape);
    }

    protected void createDragShape(int x, int y, boolean atCenter) {
        boolean forDrag = true;
        ShapeModelImpl shape = this.createShapeModel(x, y, forDrag);
        if (atCenter) {
            shape.moveCenterOffsetWithoutNotify();
        }
        this.addDragShape(shape);
    }

    protected int removeSelectedShapes() {
        TreeSet<ShapeModelImpl> shapes1 = new TreeSet<ShapeModelImpl>();
        TreeSet<ShapeModelImpl> notRemovedSelectedShapes = new TreeSet<ShapeModelImpl>();
        for (ShapeModelImpl shape : this.selectedShapes) {
            if (shape.isDirectRemovable()) {
                shapes1.add(shape);
                continue;
            }
            notRemovedSelectedShapes.add(shape);
        }
        Set shapes0 = ShapeModelImpl.getRemoveShapesSet(shapes1);
        this.removeShapes(shapes0);
        this.selectedShapes = new LinkedList();
        for (ShapeModelImpl shape : notRemovedSelectedShapes) {
            if (shapes0.contains(shape)) continue;
            this.selectedShapes.add(shape);
        }
        return notRemovedSelectedShapes.size();
    }

    protected void removeShapes(Collection shapes0) {
        LinkedList<ShapeModelImpl> shapes = new LinkedList<ShapeModelImpl>();
        for (ShapeModelImpl shape : shapes0) {
            if (!(shape instanceof LinkModelImpl)) continue;
            shapes.addLast(shape);
        }
        for (ShapeModelImpl shape : shapes0) {
            if (shape instanceof LinkModelImpl) continue;
            shapes.addLast(shape);
        }
        for (ShapeModelImpl shape : shapes) {
            shape.remove();
        }
    }

    protected void groupSelectedShapes() {
        boolean forDrag = false;
        CompositeShapeModelImpl compoShape = (CompositeShapeModelImpl)this.createShapeModel(0, 0, forDrag);
        LinkedList shapes = new LinkedList(this.selectedShapes);
        compoShape.add(shapes);
        compoShape.setSelectState(6);
    }

    protected void ungroupSelectedShapes() {
        LinkedList list = new LinkedList(this.selectedShapes);
        for (ShapeModelImpl shape : list) {
            if (!(shape instanceof CompositeShapeModelImpl)) continue;
            CompositeShapeModelImpl compo = (CompositeShapeModelImpl)shape;
            Iterator it1 = compo.getShapesIterator();
            while (it1.hasNext()) {
                ShapeModelImpl shape1 = (ShapeModelImpl)it1.next();
                this.shapes.addLast(shape1);
            }
            compo.dispose();
            compo.remove();
        }
    }
}

