/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import jp.co.fujiric.star.gui.gef.swing.ArrowWithHandleModelImpl;
import jp.co.fujiric.star.gui.gef.swing.LineWithHandleVCImpl;
import jp.co.fujiric.star.gui.gef.swing.Point;

public class ArrowWithHandleVCImpl
extends LineWithHandleVCImpl {
    protected static int HEAD_THICK = MARGIN_THICK - 1;
    protected static final double PI2 = 1.5707963267948966;
    protected static final double PI = Math.PI;
    private static final double HEADANGLE = 0.4;
    private static final double HEADSIZE = 8.0;

    @Override
    protected Class getExpectedModelClass() {
        return ArrowWithHandleModelImpl.class;
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        super.paintGUIComponent(g2);
        ArrowWithHandleModelImpl m = (ArrowWithHandleModelImpl)this.getModel();
        Color foreColor = g2.getColor();
        g2.setColor(this.getForeColorBySelectStatus(m.getSelectState()));
        g2.setStroke(this.getStroke());
        Rectangle r = this.getGUIComponentBounds();
        int x0 = r.x;
        int y0 = r.y;
        int n = m.points.size();
        Point p1 = (Point)m.points.get(n - 2);
        Point p2 = (Point)m.points.getLast();
        if (!m.isHeadless()) {
            this.drawArrowHead(g2, p1.x - (double)x0, p1.y - (double)y0, p2.x - (double)x0, p2.y - (double)y0);
        }
        this.drawGUIComponentName(g2);
        g2.setColor(foreColor);
    }

    protected void drawArrowHead(Graphics2D g2, double x0, double y0, double x1, double y1) {
        Shape s = ArrowWithHandleVCImpl.getArrowHeadShape(x0, y0, x1, y1);
        if (s != null) {
            g2.fill(s);
        }
    }

    public static Shape getArrowHeadShape(double x0, double y0, double x1, double y1) {
        double[] xy = ArrowWithHandleVCImpl.getArrowHeadShapeCoords(x0, y0, x1, y1);
        if (xy == null) {
            return null;
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)x1, (float)y1);
        gp.lineTo((float)(x1 + xy[0]), (float)(y1 + xy[1]));
        gp.lineTo((float)(x1 + xy[2]), (float)(y1 + xy[3]));
        gp.lineTo((float)x1, (float)y1);
        return gp;
    }

    public static boolean isDegenerateArrowVector(double dx, double dy) {
        double eps = 1.0E-6;
        return Math.abs(dx) < 1.0E-6 && Math.abs(dy) < 1.0E-6;
    }

    public static double[] getArrowHeadShapeCoords(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (ArrowWithHandleVCImpl.isDegenerateArrowVector(dx, dy)) {
            return null;
        }
        double angle = -Math.atan2(dx, dy);
        double angle2 = angle - 1.5707963267948966 - 0.4;
        double angle3 = angle - 1.5707963267948966 + 0.4;
        double[] xy = new double[]{Math.cos(angle2) * 8.0, Math.sin(angle2) * 8.0, Math.cos(angle3) * 8.0, Math.sin(angle3) * 8.0};
        return xy;
    }
}

