/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef.swing;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;

public class AnchoredShapeModelImpl
extends ShapeModelImpl
implements Observer {
    protected static final int SHAPE_ANCHOR_NUM = 1;
    protected Map anchorsMap = new TreeMap();
    protected List anchorsList = new LinkedList();

    protected int getMaxAnchorNum() {
        return 1;
    }

    @Override
    protected void initialize(ShapeModelImpl old, boolean forDrag) {
        super.initialize(old, forDrag);
        if (!(old instanceof AnchoredShapeModelImpl)) {
            throw new IllegalArgumentException("AnchoredShapeModelImpl expected:");
        }
        for (AnchorImpl anchor : ((AnchoredShapeModelImpl)old).anchorsList) {
            this.addLastAnchor(anchor);
        }
    }

    protected Set getAnchorShapes() {
        TreeSet s = new TreeSet();
        for (AnchorImpl anchor : this.anchorsList) {
            s.addAll(anchor.getShapes());
        }
        return s;
    }

    protected AnchorImpl getAnchor(ShapeModelImpl shape) {
        return (AnchorImpl)this.anchorsMap.get(shape);
    }

    public AnchorImpl getAnchorOf(int index) {
        return (AnchorImpl)this.anchorsList.get(index);
    }

    public void addLastAnchor(AnchorImpl anchor) {
        if (anchor == null) {
            return;
        }
        this.addAnchor1(anchor);
        int cx = (int)anchor.getX();
        int cy = (int)anchor.getY();
        int dx = cx - this.getCenterX();
        int dy = cy - this.getCenterY();
        this.x += dx;
        this.y += dy;
        anchor.addShapeObserver(this);
        this.setChanged();
        this.notifyObservers(63, anchor);
        this.clearChanged();
    }

    protected int getAnchoredPointX(AnchorImpl anchor) {
        return this.getCenterX();
    }

    protected int getAnchoredPointY(AnchorImpl anchor) {
        return this.getCenterY();
    }

    protected void addAnchor1(AnchorImpl anchor) {
        if (anchor == null) {
            return;
        }
        for (ShapeModelImpl shape : anchor.getShapes()) {
            this.anchorsMap.put(shape, anchor);
        }
        this.anchorsList.add(anchor);
    }

    public void addLastShape(ShapeModelImpl shape, AnchorImpl anchor) {
        anchor.initialize(shape);
        this.addLastAnchor(anchor);
    }

    @Override
    public void update(Observable model, Object aspect) {
        int aspectKind = ((ModelImpl.AspectWrapper)aspect).getAspectInt();
        switch (aspectKind) {
            case 2: 
            case 42: {
                if (this.isPrimarilyMoved()) break;
                this.setLocationByShape(model);
                break;
            }
            case 31: {
                if (!this.isPrimarilyMoved()) {
                    this.resizeByShape(model, aspect);
                }
            }
            case 41: {
                if (this.isPrimarilyMoved()) break;
                this.setLocationByShape(model);
                break;
            }
            case 3: {
                this.remove();
            }
        }
    }

    protected void resizeByShape(Observable model, Object aspect) {
        if (aspect instanceof ModelImpl.AspectWithInt4) {
            AnchorImpl anchor = (AnchorImpl)this.anchorsMap.get(model);
            int w1 = ((ModelImpl.AspectWithInt4)aspect).getI1();
            int h1 = ((ModelImpl.AspectWithInt4)aspect).getI2();
            int w2 = ((ModelImpl.AspectWithInt4)aspect).getI3();
            int h2 = ((ModelImpl.AspectWithInt4)aspect).getI4();
            anchor.moveOffsetByResize((ShapeModelImpl)model, w1, h1, w2, h2);
        }
    }

    public void setLocationByShape(Observable model) {
        AnchorImpl anchor = (AnchorImpl)this.anchorsMap.get(model);
        anchor.updateXY();
        int cx = (int)anchor.getX();
        int cy = (int)anchor.getY();
        int dx = cx - this.getCenterX();
        int dy = cy - this.getCenterY();
        this.moveByHandle(dx, dy);
    }

    public void moveByHandle(int dx, int dy) {
        this.move(dx, dy, 42);
    }

    protected void moveAnchor(int lastCx, int lastCy) {
        for (ShapeModelImpl shape : this.anchorsMap.keySet()) {
            AnchorImpl anchor = (AnchorImpl)this.anchorsMap.get(shape);
            int currentCx = this.getCenterX();
            int currentCy = this.getCenterY();
            int dcx = currentCx - lastCx;
            int dcy = currentCy - lastCy;
            anchor.moveOffsetByOwnerResize(dcx, dcy);
        }
    }

    public void removeAnchors() {
        for (AnchorImpl anchor : this.anchorsList) {
            anchor.deleteShapeObserver(this);
        }
        this.setChanged();
        this.notifyObservers(62);
        this.clearChanged();
    }

    @Override
    protected void removeChildren() {
        this.removeAnchors();
        super.removeChildren();
    }

    @Override
    public void move(int dx, int dy) {
        for (ShapeModelImpl shape : this.anchorsMap.keySet()) {
            AnchorImpl anchor = (AnchorImpl)this.anchorsMap.get(shape);
            if (shape.isPrimarilyMoved()) continue;
            anchor.moveOffset(dx, dy);
        }
        super.move(dx, dy);
    }

    @Override
    public void resize(int width, int height) {
        int lastCx = this.getCenterX();
        int lastCy = this.getCenterY();
        super.resize(width, height);
        this.moveAnchor(lastCx, lastCy);
    }
}

