/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujiric.star.gui.gef;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observer;
import jp.co.fujiric.star.gui.gef.ModelImpl;

public abstract class ViewControllerImpl
implements Observer {
    protected ModelImpl model;
    protected ViewControllerImpl superVC;
    protected LinkedList subVCs;

    public void initializevc(ModelImpl model) {
        this.model = model;
        this.superVC = null;
        this.subVCs = new LinkedList();
        this.model.addObserver(this);
    }

    public final ModelImpl getModel() {
        return this.model;
    }

    public void add(ViewControllerImpl subVC) {
        this.addProtected(subVC);
    }

    protected final void addProtected(ViewControllerImpl subVC) {
        this.subVCs.addLast(subVC);
        subVC.setSuper(this);
    }

    public void removeChild(ViewControllerImpl subVC) {
        this.subVCs.remove(subVC);
    }

    protected void removeChildren() {
        LinkedList list = new LinkedList(this.subVCs);
        for (ViewControllerImpl sub : list) {
            sub.remove();
        }
    }

    protected void removeSelf() {
        this.superVC = null;
    }

    protected void removeInCanvas() {
    }

    protected final void removeInParent() {
        if (this.superVC != null) {
            this.superVC.removeChild(this);
        }
    }

    public final void remove() {
        this.removeChildren();
        this.removeInCanvas();
        this.removeInParent();
        this.removeSelf();
    }

    protected final void setSuper(ViewControllerImpl superVC) {
        this.superVC = superVC;
    }

    public final ViewControllerImpl getSuper() {
        return this.superVC;
    }

    public final Iterator getSubsIterator() {
        return this.subVCs.iterator();
    }
}

