/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import java.awt.Point;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

class GIFImage
extends SimpleRenderedImage {
    private static final int[] INTERLACE_INCREMENT = new int[]{8, 8, 4, 2, -1};
    private static final int[] INTERLACE_OFFSET = new int[]{0, 4, 2, 1, -1};
    private SeekableStream input;
    private boolean interlaceFlag;
    private byte[] block;
    private int blockLength;
    private int bitPos;
    private int nextByte;
    private int initCodeSize;
    private int clearCode;
    private int eofCode;
    private int bitsLeft;
    private int next32Bits;
    private boolean lastBlockFound;
    private int interlacePass;
    private WritableRaster theTile;

    private void skipBlocks() throws IOException {
        int n;
        while ((n = this.input.readUnsignedByte()) != 0) {
            this.input.skipBytes(n);
        }
    }

    GIFImage(SeekableStream seekableStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        boolean bl;
        byte[] byArray2;
        block12: {
            this.interlaceFlag = false;
            this.block = new byte[255];
            this.blockLength = 0;
            this.bitPos = 0;
            this.nextByte = 0;
            this.next32Bits = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.theTile = null;
            this.input = seekableStream;
            byArray2 = null;
            bl = false;
            n3 = 0;
            try {
                long l = seekableStream.getFilePointer();
                while (true) {
                    int n4;
                    if ((n2 = seekableStream.readUnsignedByte()) == 44) {
                        seekableStream.skipBytes(4);
                        this.width = seekableStream.readUnsignedShortLE();
                        this.height = seekableStream.readUnsignedShortLE();
                        n = seekableStream.readUnsignedByte();
                        n4 = (n & 0x80) != 0 ? 1 : 0;
                        this.interlaceFlag = (n & 0x40) != 0;
                        int n5 = 1 << (n & 7) + 1;
                        if (n4 != 0) {
                            byArray2 = new byte[3 * n5];
                            seekableStream.readFully(byArray2);
                        } else {
                            byArray2 = null;
                        }
                        break block12;
                    }
                    if (n2 != 33) break;
                    n = seekableStream.readUnsignedByte();
                    if (n == 249) {
                        seekableStream.read();
                        n4 = seekableStream.readUnsignedByte();
                        bl = (n4 & 1) != 0;
                        seekableStream.skipBytes(2);
                        n3 = seekableStream.readUnsignedByte();
                        seekableStream.read();
                        continue;
                    }
                    if (n == 1) {
                        seekableStream.skipBytes(13);
                        this.skipBlocks();
                        continue;
                    }
                    if (n == 254) {
                        this.skipBlocks();
                        continue;
                    }
                    if (n == 255) {
                        seekableStream.skipBytes(12);
                        this.skipBlocks();
                        continue;
                    }
                    n4 = 0;
                    do {
                        n4 = seekableStream.readUnsignedByte();
                        seekableStream.skipBytes(n4);
                    } while (n4 > 0);
                }
                throw new IOException(JaiI18N.getString("GIFImage0") + " " + n2 + "!");
            }
            catch (IOException iOException) {
                throw new IOException(JaiI18N.getString("GIFImage1"));
            }
        }
        this.tileGridYOffset = 0;
        this.tileGridXOffset = 0;
        this.minY = 0;
        this.minX = 0;
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        byte[] byArray3 = byArray2 != null ? byArray2 : byArray;
        int n6 = byArray3.length / 3;
        n2 = n6 == 2 ? 1 : (n6 == 4 ? 2 : (n6 == 8 || n6 == 16 ? 4 : 8));
        n = 1 << n2;
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n6) {
            byArray4[n8] = byArray3[n7++];
            byArray5[n8] = byArray3[n7++];
            byArray6[n8] = byArray3[n7++];
            ++n8;
        }
        int[] nArray = new int[]{n2};
        this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
        this.colorModel = !bl ? (ImageCodec.isIndicesForGrayscale(byArray4, byArray5, byArray6) ? ImageCodec.createComponentColorModel(this.sampleModel) : new IndexColorModel(n2, byArray4.length, byArray4, byArray5, byArray6)) : new IndexColorModel(n2, byArray4.length, byArray4, byArray5, byArray6, n3);
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int n, int n2) throws IOException {
        if (this.bitsLeft <= 0) {
            return this.eofCode;
        }
        int n3 = this.next32Bits >> this.bitPos & n2;
        this.bitPos += n;
        this.bitsLeft -= n;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                this.blockLength = this.input.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    if (this.bitsLeft < 0) {
                        return this.eofCode;
                    }
                    return n3;
                }
                int n4 = this.blockLength;
                int n5 = 0;
                while (n4 > 0) {
                    int n6 = this.input.read(this.block, n5, n4);
                    n5 += n6;
                    n4 -= n6;
                }
                this.bitsLeft += this.blockLength << 3;
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n3;
    }

    private void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n = 1 << this.initCodeSize;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = -1;
            byArray[n2] = (byte)n2;
            byArray2[n2] = (byte)n2;
            nArray2[n2] = 1;
            ++n2;
        }
        int n3 = n;
        while (n3 < 4096) {
            nArray[n3] = -1;
            nArray2[n3] = 1;
            ++n3;
        }
    }

    private Point outputPixels(byte[] byArray, int n, Point point, byte[] byArray2) {
        if (this.interlacePass < 0 || this.interlacePass > 3) {
            return point;
        }
        int n2 = 0;
        while (n2 < n) {
            if (point.x >= this.minX) {
                byArray2[point.x - this.minX] = byArray[n2];
            }
            ++point.x;
            if (point.x == this.width) {
                this.theTile.setDataElements(this.minX, point.y, this.width, 1, byArray2);
                point.x = 0;
                if (this.interlaceFlag) {
                    point.y += INTERLACE_INCREMENT[this.interlacePass];
                    if (point.y >= this.height) {
                        ++this.interlacePass;
                        if (this.interlacePass > 3) {
                            return point;
                        }
                        point.y = INTERLACE_OFFSET[this.interlacePass];
                    }
                } else {
                    ++point.y;
                }
            }
            ++n2;
        }
        return point;
    }

    public synchronized Raster getTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("GIFImage2"));
        }
        if (this.theTile != null) {
            return this.theTile;
        }
        this.theTile = Raster.createWritableRaster(this.sampleModel, this.sampleModel.createDataBuffer(), null);
        Point point = new Point(0, 0);
        byte[] byArray = new byte[this.width];
        try {
            int n3;
            this.initCodeSize = this.input.readUnsignedByte();
            int n4 = this.blockLength = this.input.readUnsignedByte();
            int n5 = 0;
            while (n4 > 0) {
                n3 = this.input.read(this.block, n5, n4);
                n4 -= n3;
                n5 += n3;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.bitsLeft = this.blockLength << 3;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            int n6 = 0;
            int[] nArray = new int[4096];
            byte[] byArray2 = new byte[4096];
            byte[] byArray3 = new byte[4096];
            int[] nArray2 = new int[4096];
            byte[] byArray4 = new byte[4096];
            this.initializeStringTable(nArray, byArray2, byArray3, nArray2);
            int n7 = (1 << this.initCodeSize) + 2;
            int n8 = this.initCodeSize + 1;
            int n9 = (1 << n8) - 1;
            while (true) {
                int n10;
                int n11;
                int n12;
                if ((n3 = this.getCode(n8, n9)) == this.clearCode) {
                    this.initializeStringTable(nArray, byArray2, byArray3, nArray2);
                    n7 = (1 << this.initCodeSize) + 2;
                    n8 = this.initCodeSize + 1;
                    n9 = (1 << n8) - 1;
                    n3 = this.getCode(n8, n9);
                    if (n3 == this.eofCode) {
                        return this.theTile;
                    }
                } else {
                    if (n3 == this.eofCode) {
                        return this.theTile;
                    }
                    n12 = n3 < n7 ? n3 : n6;
                    n11 = n7++;
                    nArray[n11] = n10 = n6;
                    byArray2[n11] = byArray3[n12];
                    byArray3[n11] = byArray3[n10];
                    nArray2[n11] = nArray2[n10] + 1;
                    if (n7 == 1 << n8 && n7 < 4096) {
                        n9 = (1 << ++n8) - 1;
                    }
                }
                n12 = n3;
                n11 = nArray2[n12];
                n10 = n11 - 1;
                while (n10 >= 0) {
                    byArray4[n10] = byArray2[n12];
                    n12 = nArray[n12];
                    --n10;
                }
                this.outputPixels(byArray4, n11, point, byArray);
                n6 = n3;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("GIFImage3"));
        }
    }
}

