/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.util;

import java.util.Enumeration;
import java.util.Vector;
import jp.fric.graphics.draw.GContainer;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.sbml.Notes;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String MSG_SPECIESID_ALIAS_NOT_FOUND = " Species Alias id not found ";
    public static final String DELIM_SPECIES_ALIAS_ID = "_";

    public static SpeciesAlias getSpeciesAlias(SBModel sbModel, ListOfSpecies listOfSpecies, String speciesIdAliasName) {
        long size = listOfSpecies.size();
        int i = 0;
        while ((long)i < size) {
            Species species = listOfSpecies.get((long)i);
            String specId = species.getId();
            if (speciesIdAliasName.startsWith(specId)) {
                SpeciesAnnotation sa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBModel)sbModel, (SBase)species, null);
                Vector aliases = sa.getReferingAliases();
                for (int j = 0; j < aliases.size(); ++j) {
                    SpeciesAlias alias = (SpeciesAlias)aliases.get(j);
                    if (!speciesIdAliasName.equals(Utils.getSpeciesIdAliasName(alias))) continue;
                    return alias;
                }
            }
            ++i;
        }
        System.out.println(speciesIdAliasName + MSG_SPECIESID_ALIAS_NOT_FOUND);
        return null;
    }

    public static CompartmentAlias getCompartmentAlias(SBModel sbModel, ListOfCompartments listOfCompartments, String compartmentIdAliasName) {
        long size = listOfCompartments.size();
        int i = 0;
        while ((long)i < size) {
            Compartment compartment = listOfCompartments.get((long)i);
            String compId = compartment.getId();
            if (compartmentIdAliasName.startsWith(compId)) {
                CompartmentAnnotation sa = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBModel)sbModel, (SBase)compartment, null);
                Vector aliases = sa.getReferingAliases();
                for (int j = 0; j < aliases.size(); ++j) {
                    CompartmentAlias alias = (CompartmentAlias)aliases.get(j);
                    if (!compartmentIdAliasName.equals(compId + alias.getCompartmentName())) continue;
                    return alias;
                }
            }
            ++i;
        }
        System.out.println(compartmentIdAliasName + MSG_SPECIESID_ALIAS_NOT_FOUND);
        return null;
    }

    public static String getSpeciesIdAliasName(SpeciesAlias sAlias) {
        Species species = sAlias.getOriginalSpecies();
        return species.getId() + DELIM_SPECIES_ALIAS_ID + sAlias.getName();
    }

    public static String getSpeciesId(String speciesIdAliasName) {
        if (null == speciesIdAliasName) {
            return null;
        }
        int index = speciesIdAliasName.indexOf(DELIM_SPECIES_ALIAS_ID);
        if (index <= 0) {
            return null;
        }
        return speciesIdAliasName.substring(0, index);
    }

    public static CompartmentAlias getContainer(SpeciesAlias speciesAlias) {
        GContainer container = speciesAlias.getContainer();
        if (container instanceof ClosedCompartmentAlias || container instanceof OpenedCompartmentAlias) {
            return (CompartmentAlias)container;
        }
        return null;
    }

    public static boolean allMonoSpeciesSameType(SBModel sbModel, ListOfSpecies listOfSpecies, Vector<String> speciesAliasList, String type) {
        Enumeration<String> spEnum = speciesAliasList.elements();
        while (spEnum.hasMoreElements()) {
            String spIdAliasName = spEnum.nextElement();
            SpeciesAlias sa = Utils.getSpeciesAlias(sbModel, listOfSpecies, spIdAliasName);
            if (null == sa) {
                return false;
            }
            if (sa instanceof ComplexSpeciesAlias) {
                return false;
            }
            if (!(sa instanceof ElementSpeciesAlias)) {
                return false;
            }
            ElementSpeciesAlias esa = (ElementSpeciesAlias)sa;
            MonoSpeciesProperty msp = (MonoSpeciesProperty)Utils.getSpeciesProperty((SpeciesAlias)esa);
            if (msp.getType().equals(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareString(String comp1, String comp2) {
        if (null == comp1 && null == comp2) {
            return true;
        }
        if (null == comp1 && null != comp2 || null != comp1 && null == comp2) {
            return false;
        }
        return comp1.equals(comp2);
    }

    public static boolean compareModificationLists(Vector list1, Vector list2) {
        int size2;
        if (null == list1 && null == list2) {
            return true;
        }
        if (null == list1 && null != list2 || null != list1 && null == list2) {
            return false;
        }
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return false;
        }
        Vector copy1 = (Vector)list1.clone();
        Vector copy2 = (Vector)list2.clone();
        for (int i = 0; i < copy1.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < copy2.size(); ++j) {
                if (!((Modification)copy1.get(i)).equals((Modification)copy2.get(j))) continue;
                found = true;
                copy1.remove(i);
                copy2.remove(j);
                --i;
                --j;
            }
            if (found) continue;
            return false;
        }
        return 0 == copy1.size() || 0 == copy2.size();
    }

    public static boolean compareStructuralStateLists(Vector list1, Vector list2) {
        int size2;
        if (null == list1 && null == list2) {
            return true;
        }
        if (null == list1 && null != list2 || null != list1 && null == list2) {
            return false;
        }
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return false;
        }
        Vector copy1 = (Vector)list1.clone();
        Vector copy2 = (Vector)list2.clone();
        for (int i = 0; i < copy1.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < copy2.size(); ++j) {
                if (!((StructuralState)copy1.get(i)).equals((StructuralState)copy2.get(j))) continue;
                found = true;
                copy1.remove(i);
                copy2.remove(j);
                --i;
                --j;
            }
            if (found) continue;
            return false;
        }
        return 0 == copy1.size() || 0 == copy2.size();
    }

    public static boolean compareComplexSpeciesAlias(SBModel sbModel, ComplexSpeciesAlias csa1, ComplexSpeciesAlias csa2) {
        Species sp1 = csa1.getOriginalSpecies();
        Species sp2 = csa2.getOriginalSpecies();
        if (!Utils.compareString(sp1.getName(), sp2.getName())) {
            return false;
        }
        if (csa1.isActive() != csa2.isActive()) {
            return false;
        }
        if (!Utils.compareString(sp1.getCompartment(), sp2.getCompartment())) {
            return false;
        }
        GContainer container1 = csa1.getContainer();
        GContainer container2 = csa2.getContainer();
        if (container1 == null && container2 != null || container1 != null && container2 == null) {
            return false;
        }
        if (null != container1 && null != container2) {
            if (!container1.getClass().getName().equals(container2.getClass().getName())) {
                return false;
            }
            if (container1 instanceof SpeciesAlias && !Utils.compareAlias(sbModel, container1, container2, false)) {
                return false;
            }
        }
        Vector elements1 = (Vector)csa1.getTargets().clone();
        Vector elements2 = (Vector)csa2.getTargets().clone();
        int size = elements1.size();
        if (size != elements2.size()) {
            return false;
        }
        block0: for (int i = 0; i < elements1.size(); ++i) {
            Object o1 = elements1.elementAt(i);
            for (int j = 0; j < elements2.size(); ++j) {
                Object o2 = elements2.elementAt(j);
                if (!Utils.compareAlias(sbModel, o1, o2, false)) continue;
                elements1.remove(i);
                elements2.remove(j);
                --i;
                --j;
                continue block0;
            }
        }
        return 0 == elements1.size() || 0 == elements2.size();
    }

    public static boolean compareAlias(SBModel sbModel, Object o1, Object o2, boolean compareContainer) {
        if (o1 instanceof ElementSpeciesAlias && o2 instanceof ElementSpeciesAlias) {
            return Utils.compareMonoSpeciesAlias(sbModel, (ElementSpeciesAlias)o1, (ElementSpeciesAlias)o2, compareContainer);
        }
        if (o1 instanceof ComplexSpeciesAlias && o2 instanceof ComplexSpeciesAlias) {
            return Utils.compareComplexSpeciesAlias(sbModel, (ComplexSpeciesAlias)o1, (ComplexSpeciesAlias)o2);
        }
        return false;
    }

    public static boolean compareMonoSpeciesAlias(SBModel sbModel, ElementSpeciesAlias esa1, ElementSpeciesAlias esa2, boolean compareContainer) {
        Species species1 = esa1.getOriginalSpecies();
        Species species2 = esa2.getOriginalSpecies();
        if (!Utils.compareString(species1.getCompartment(), species2.getCompartment())) {
            return false;
        }
        GContainer container1 = esa1.getContainer();
        GContainer container2 = esa2.getContainer();
        if (container1 == null && container2 != null || container1 != null && container2 == null) {
            return false;
        }
        if (null != container1 && null != container2) {
            if (!container1.getClass().getName().equals(container2.getClass().getName())) {
                return false;
            }
            if (compareContainer && container1 instanceof SpeciesAlias && !Utils.compareAlias(sbModel, container1, container2, compareContainer)) {
                return false;
            }
        }
        if (!Utils.compareString(species1.getName(), species2.getName())) {
            return false;
        }
        if (esa1.isActive() != esa2.isActive()) {
            return false;
        }
        return Utils.compareMonoSpeciesProperty((MonoSpeciesProperty)Utils.getSpeciesProperty((SpeciesAlias)esa1), (MonoSpeciesProperty)Utils.getSpeciesProperty((SpeciesAlias)esa2));
    }

    public static SpeciesProperty getSpeciesProperty(SpeciesAlias speciesAlias) {
        SpeciesShape shape = (SpeciesShape)speciesAlias.getGFramedShape();
        return shape.getProperty();
    }

    public static SpeciesShape getSpeciesShape(SpeciesAlias speciesAlias) {
        return (SpeciesShape)speciesAlias.getGFramedShape();
    }

    private static boolean compareMonoSpeciesProperty(MonoSpeciesProperty sp1, MonoSpeciesProperty sp2) {
        if (!sp1.getType().equals(sp2.getType())) {
            return false;
        }
        if (!sp1.getName().equals(sp2.getName())) {
            return false;
        }
        if (sp1.getHomodimer() != sp2.getHomodimer()) {
            return false;
        }
        if (sp1.getHypothetical() != sp2.getHypothetical()) {
            return false;
        }
        Protein protein1 = sp1.getProtein();
        Protein protein2 = sp2.getProtein();
        Gene gene1 = sp1.getGene();
        Gene gene2 = sp2.getGene();
        RNA rna1 = sp1.getRNA();
        RNA rna2 = sp2.getRNA();
        AntiSenseRNA antisenseRNA1 = sp1.getAntiSenseRNA();
        AntiSenseRNA antisenseRNA2 = sp2.getAntiSenseRNA();
        if (protein1 == null && protein2 != null) {
            return false;
        }
        if (protein1 != null && protein2 == null) {
            return false;
        }
        if (gene1 == null && gene2 != null) {
            return false;
        }
        if (gene1 != null && gene2 == null) {
            return false;
        }
        if (rna1 == null && rna2 != null) {
            return false;
        }
        if (rna1 != null && rna2 == null) {
            return false;
        }
        if (antisenseRNA1 == null && antisenseRNA2 != null) {
            return false;
        }
        if (antisenseRNA1 != null && antisenseRNA2 == null) {
            return false;
        }
        if (protein1 != null && protein2 != null && !protein1.getName().equals(protein2.getName())) {
            return false;
        }
        if (gene1 != null && gene2 != null && !gene1.getName().equals(gene2.getName())) {
            return false;
        }
        if (rna1 != null && rna2 != null && !rna1.getName().equals(rna2.getName())) {
            return false;
        }
        if (antisenseRNA1 != null && antisenseRNA2 != null && !antisenseRNA1.getName().equals(antisenseRNA2.getName())) {
            return false;
        }
        if (!Utils.compareModificationLists(sp1.getModifications(), sp2.getModifications())) {
            return false;
        }
        return false != Utils.compareStructuralStateLists(sp1.getStructuralStates(), sp2.getStructuralStates());
    }

    public static String getNotes(Species s) {
        Notes n = (Notes)LibSBMLUtil.getNotes((SBase)s, null);
        if (null == n) {
            return null;
        }
        return n.getText();
    }

    public static Vector<ElementSpeciesAlias> getMonoSpeciesListInComplex(ComplexSpeciesAlias csa) {
        Vector<ElementSpeciesAlias> v = new Vector<ElementSpeciesAlias>();
        Utils.getMonoSpeciesListInComplex(csa, v);
        return v;
    }

    protected static void getMonoSpeciesListInComplex(ComplexSpeciesAlias csa, Vector<ElementSpeciesAlias> monoSPeciesList) {
        Vector components = csa.getTargets();
        for (int i = 0; i < components.size(); ++i) {
            SpeciesAlias alias = (SpeciesAlias)components.get(i);
            if (alias instanceof ElementSpeciesAlias) {
                monoSPeciesList.add((ElementSpeciesAlias)alias);
                continue;
            }
            Utils.getMonoSpeciesListInComplex((ComplexSpeciesAlias)alias, monoSPeciesList);
        }
    }

    public static void main(String[] args) {
    }
}

