/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SNameTranslator {
    protected static Hashtable sNameLookup;
    protected static Hashtable specialSubstitionsLookup;
    protected static Vector sortedList;
    protected static Hashtable nameToTransName;
    public static final int INDEX_TRANSLATE_NAME = 0;
    public static final int INDEX_ERROR_INFO = 1;
    public static final String MSG_ERROR = "String to be translated is null";
    public static final String MSG_ERROR_BUFFER1 = "contains";
    public static final String MSG_ERROR_BUFFER2 = " from character position ";
    public static final String MSG_ERROR_BUFFER3 = " to ";
    public static final String MSG_ERROR_BUFFER4 = " which overlaps another key.  |";
    public static final String MSG_ERROR_BUFFER5 = " ends with incomplete token ";
    public static final String MSG_ERROR_BUFFER6 = ".  |";
    public static final String MSG_ERROR_BUFFER7 = " ends with non word character.  |";

    protected static boolean init() {
        specialSubstitionsLookup = new Hashtable();
        specialSubstitionsLookup.put("_minus__br_", "-");
        specialSubstitionsLookup.put("-_br_", "-");
        sNameLookup = new Hashtable();
        sNameLookup.put("_plus_", "+");
        sNameLookup.put("_minus_", "-");
        sNameLookup.put("_slash_", "/");
        sNameLookup.put("_underscore_", "_");
        sNameLookup.put("_space_", " ");
        sNameLookup.put("_br_", " ");
        sNameLookup.put("_super_", "");
        sNameLookup.put("_endsuper_", "");
        sNameLookup.put("_sub_", "");
        sNameLookup.put("_endsub_", "");
        sNameLookup.put("_Alpha_", "Alpha");
        sNameLookup.put("_Beta_", "Beta");
        sNameLookup.put("_Gamma_", "Gamma");
        sNameLookup.put("_Delta_", "Delta");
        sNameLookup.put("_Epsilon_", "Epsilon");
        sNameLookup.put("_Zeta_", "Zeta");
        sNameLookup.put("_Eta_", "Eta");
        sNameLookup.put("_Theta_", "Theta");
        sNameLookup.put("_Iota_", "Iota");
        sNameLookup.put("_Kappa_", "Kappa");
        sNameLookup.put("_Lambda_", "Lambda");
        sNameLookup.put("_Mu_", "Mu");
        sNameLookup.put("_Nu_", "Nu");
        sNameLookup.put("_Xi_", "Xi");
        sNameLookup.put("_Omicron_", "Omicron");
        sNameLookup.put("_Pi_", "Pi");
        sNameLookup.put("_Rho_", "Rho");
        sNameLookup.put("_Sigma_", "Sigma");
        sNameLookup.put("_Tau_", "Tau");
        sNameLookup.put("_Upsilon_", "Upsilon");
        sNameLookup.put("_Phi_", "Phi");
        sNameLookup.put("_Chi_", "Chi");
        sNameLookup.put("_Psi_", "Psi");
        sNameLookup.put("_Omega_", "Omega");
        sNameLookup.put("_alpha_", "alpha");
        sNameLookup.put("_beta_", "beta");
        sNameLookup.put("_gamma_", "gamma");
        sNameLookup.put("_delta_", "delta");
        sNameLookup.put("_epsilon_", "epsilon");
        sNameLookup.put("_zeta_", "zeta");
        sNameLookup.put("_eta_", "eta");
        sNameLookup.put("_theta_", "theta");
        sNameLookup.put("_iota_", "iota");
        sNameLookup.put("_kappa_", "kappa");
        sNameLookup.put("_lambda_", "lambda");
        sNameLookup.put("_mu_", "mu");
        sNameLookup.put("_nu_", "nu");
        sNameLookup.put("_xi_", "xi");
        sNameLookup.put("_omicron_", "omicron");
        sNameLookup.put("_pi_", "pi");
        sNameLookup.put("_rho_", "rho");
        sNameLookup.put("_sigma_", "sigma");
        sNameLookup.put("_tau_", "tau");
        sNameLookup.put("_upsilon_", "upsilon");
        sNameLookup.put("_phi_", "phi");
        sNameLookup.put("_chi_", "chi");
        sNameLookup.put("_psi_", "psi");
        sNameLookup.put("_omega_", "omega");
        SNameTranslator.createSortedList();
        return true;
    }

    protected static void createSortedList() {
        sortedList = new Vector(sNameLookup.size());
        Enumeration e = sNameLookup.keys();
        while (e.hasMoreElements()) {
            SNameTranslator.insertIntoList((String)e.nextElement());
        }
    }

    public static void insertIntoList(String key) {
        for (int i = 0; i < sortedList.size(); ++i) {
            if (key.length() >= ((String)sortedList.elementAt(i)).length()) continue;
            sortedList.insertElementAt(key, i);
            return;
        }
        sortedList.add(key);
    }

    public static String translateSName(String sName) {
        String value = (String)nameToTransName.get(sName);
        if (null == value) {
            String endKey;
            String key;
            Enumeration e = specialSubstitionsLookup.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                sName = SNameTranslator.replaceRecursively(sName, key, (String)specialSubstitionsLookup.get(key));
            }
            value = SNameTranslator.translateSNameRecursively(sName);
            e = specialSubstitionsLookup.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                endKey = key.substring(0, key.length() - 1);
                if (!value.endsWith(endKey)) continue;
                value = value.substring(0, value.lastIndexOf(endKey)) + sNameLookup.get(key);
            }
            e = sNameLookup.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                endKey = key.substring(0, key.length() - 1);
                if (!value.endsWith(endKey)) continue;
                value = value.substring(0, value.lastIndexOf(endKey)) + sNameLookup.get(key);
            }
            nameToTransName.put(sName, value);
        }
        return value;
    }

    protected static String translateSNameRecursively(String sName) {
        for (int i = sortedList.size() - 1; i >= 0; --i) {
            String key = (String)sortedList.elementAt(i);
            int index = sName.indexOf(key);
            if (-1 == index) continue;
            sName = SNameTranslator.replaceRecursively(sName, key, (String)sNameLookup.get(key));
        }
        return sName;
    }

    public static String replaceRecursively(String orig, String token, String replace) {
        if (null == orig || null == token || null == replace) {
            return orig;
        }
        int index = orig.indexOf(token);
        if (-1 == index) {
            return orig;
        }
        return SNameTranslator.replaceRecursively(orig.substring(0, index), token, replace) + replace + SNameTranslator.replaceRecursively(orig.substring(index + token.length(), orig.length()), token, replace);
    }

    public static Vector getSNameTranslatorInfo(String s) {
        int j;
        int index;
        Vector<String> returnInfo = new Vector<String>(2);
        returnInfo.setSize(2);
        String translated = SNameTranslator.translateSName(s);
        if (null == translated) {
            returnInfo.setElementAt(MSG_ERROR, 1);
            return returnInfo;
        }
        StringBuffer errorStrBuffer = new StringBuffer();
        String tmpStr = s;
        boolean[] checkedIndices = new boolean[s.length()];
        for (int i = 0; i < checkedIndices.length; ++i) {
            checkedIndices[i] = true;
        }
        Enumeration e = specialSubstitionsLookup.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            index = tmpStr.indexOf(key);
            if (-1 == index) continue;
            while (-1 != index) {
                for (j = index; j < index + key.length(); ++j) {
                    if (!checkedIndices[j]) {
                        errorStrBuffer.append(tmpStr + MSG_ERROR_BUFFER1 + key + MSG_ERROR_BUFFER2 + (index + 1) + MSG_ERROR_BUFFER3 + (index + 1 + key.length()) + MSG_ERROR_BUFFER4);
                        break;
                    }
                    checkedIndices[j] = false;
                }
                index = tmpStr.indexOf(key, index + key.length());
            }
        }
        for (int i = 0; i < checkedIndices.length; ++i) {
            checkedIndices[i] = true;
        }
        e = sNameLookup.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            index = tmpStr.indexOf(key);
            if (-1 == index) continue;
            while (-1 != index) {
                for (j = index; j < index + key.length(); ++j) {
                    if (!checkedIndices[j]) {
                        errorStrBuffer.append(tmpStr + MSG_ERROR_BUFFER1 + key + MSG_ERROR_BUFFER2 + (index + 1) + MSG_ERROR_BUFFER3 + (index + 1 + key.length()) + MSG_ERROR_BUFFER4);
                        break;
                    }
                    checkedIndices[j] = false;
                }
                index = tmpStr.indexOf(key, index + key.length());
            }
        }
        e = specialSubstitionsLookup.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String endKey = key.substring(0, key.length() - 1);
            if (!tmpStr.endsWith(endKey)) continue;
            errorStrBuffer.append(tmpStr + MSG_ERROR_BUFFER5 + key + MSG_ERROR_BUFFER6);
        }
        e = sNameLookup.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String endKey = key.substring(0, key.length() - 1);
            if (!tmpStr.endsWith(endKey)) continue;
            errorStrBuffer.append(tmpStr + MSG_ERROR_BUFFER5 + key + MSG_ERROR_BUFFER6);
        }
        Pattern nonWordCharPattern = Pattern.compile("\\W");
        Matcher matcher = nonWordCharPattern.matcher(translated);
        if (matcher.find(translated.length() - 1)) {
            errorStrBuffer.append(translated + MSG_ERROR_BUFFER7);
        }
        returnInfo.setElementAt(translated, 0);
        if (0 != errorStrBuffer.length()) {
            returnInfo.setElementAt(errorStrBuffer.toString(), 1);
        }
        return returnInfo;
    }

    public static Hashtable getTransNames() {
        return nameToTransName;
    }

    public static void main(String[] args) {
        String trans;
        String orig = "3_beta__minus_hydroxy_minus__Delta__super_5_endsuper__minus__br_steroid_space_dehydrogenase";
        System.out.println(orig);
        String s = SNameTranslator.translateSName(orig);
        System.out.println(s);
        orig = " + O_sub_2_endsub_ _super_-._endsuper";
        System.out.println(orig);
        s = SNameTranslator.translateSName(orig);
        System.out.println(s);
        orig = "3_beta__minus_hydroxy_minus__Delta__super_5_endsuper_minus__br_steroid_space_dehydrogenase_br";
        System.out.println(orig);
        Vector v = SNameTranslator.getSNameTranslatorInfo(orig);
        String error = (String)v.elementAt(1);
        if (null != error) {
            System.out.println(error);
        } else {
            trans = (String)v.elementAt(0);
            System.out.println(trans);
        }
        orig = "3_beta__minus_hydroxy_minus__Delta__super_5_endsuper__minus__br_steroid_space_dehydrogenase/";
        System.out.println(orig);
        v = SNameTranslator.getSNameTranslatorInfo(orig);
        error = (String)v.elementAt(1);
        if (null != error) {
            System.out.println(error);
        } else {
            trans = (String)v.elementAt(0);
            System.out.println(trans);
        }
    }

    static {
        nameToTransName = new Hashtable();
        SNameTranslator.init();
    }
}

