/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.util;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.PhysicalEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioPax3Util {
    public static Set<Complex> getOutermostComplex(PhysicalEntity pe) {
        Set containers = pe.isComponentOf();
        if (null == containers) {
            return null;
        }
        HashSet<Complex> outerComplex = new HashSet<Complex>();
        BioPax3Util.addDistinctOutermostComplex(pe.getCellularLocation(), containers, outerComplex);
        return outerComplex;
    }

    private static void addDistinctOutermostComplex(CellularLocationVocabulary clv, Set<Complex> containers, Set<Complex> complexList) {
        for (Complex c : containers) {
            Set parentContainer = c.isComponentOf();
            if (null == parentContainer || 0 == parentContainer.size()) {
                if (clv != c.getCellularLocation()) continue;
                complexList.add(c);
                continue;
            }
            BioPax3Util.addDistinctOutermostComplex(clv, parentContainer, complexList);
        }
    }

    public static Set<CellularLocationVocabulary> getDistinctCellularLocation(Set<PhysicalEntity> entitySet) {
        if (null == entitySet) {
            return null;
        }
        HashSet<CellularLocationVocabulary> locations = new HashSet<CellularLocationVocabulary>();
        for (PhysicalEntity pe : entitySet) {
            CellularLocationVocabulary clv = pe.getCellularLocation();
            if (null == clv) continue;
            locations.add(clv);
        }
        return locations;
    }
}

