/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.plugin;

import java.util.Vector;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;

public class Utils {
    public static final String DELIM_SPECIES_ALIAS = "_";

    public static String constructSpeciesIdAliasName(String speciesId, String aliasName) {
        return speciesId + DELIM_SPECIES_ALIAS + aliasName;
    }

    public static PluginSpeciesAlias getPluginSpeciesAlias(PluginModel pModel, String pluginSpeciesIdAliasName) {
        if (null == pluginSpeciesIdAliasName) {
            return null;
        }
        int index = pluginSpeciesIdAliasName.indexOf(DELIM_SPECIES_ALIAS);
        if (index < 0) {
            return null;
        }
        String pluginSpeciesId = pluginSpeciesIdAliasName.substring(0, index);
        String pluginAliasName = pluginSpeciesIdAliasName.substring(index + 1);
        PluginSpecies ps = pModel.getSpecies(pluginSpeciesId);
        return ps.getSpeciesAlias(pluginAliasName);
    }

    public static boolean comparePluginAlias(PluginSpeciesAlias alias1, PluginSpeciesAlias alias2, boolean compareContainer) {
        String type2;
        String type1 = alias1.getType();
        if (!type1.equals(type2 = alias2.getType())) {
            return false;
        }
        if (type1.equals("COMPLEX")) {
            return Utils.comparePluginComplexSpeciesAlias(alias1, alias2);
        }
        return Utils.comparePluginMonoSpeciesAlias(alias1, alias2, compareContainer);
    }

    public static boolean comparePluginMonoSpeciesAlias(PluginSpeciesAlias psa1, PluginSpeciesAlias psa2, boolean compareContainer) {
        PluginSpecies species1 = psa1.getSpecies();
        PluginSpecies species2 = psa2.getSpecies();
        if (!Utils.compareString(species1.getCompartment(), species2.getCompartment())) {
            return false;
        }
        if (!Utils.compareString(species1.getName(), species2.getName())) {
            return false;
        }
        if (psa1.isActive() != psa2.isActive()) {
            return false;
        }
        return false;
    }

    public static boolean compareMonoSpeciesProperty(PluginSpeciesAlias psa1, PluginSpeciesAlias psa2) {
        if (psa1.getHomodimer() != psa2.getHomodimer()) {
            return false;
        }
        if (psa1.getHypothetical() != psa2.getHypothetical()) {
            return false;
        }
        PluginProtein protein1 = psa1.getProtein();
        PluginProtein protein2 = psa2.getProtein();
        PluginGene gene1 = psa1.getGene();
        PluginGene gene2 = psa2.getGene();
        PluginRNA rna1 = psa1.getRNA();
        PluginRNA rna2 = psa2.getRNA();
        PluginAntiSenseRNA antisenseRNA1 = psa1.getAntiSenseRNA();
        PluginAntiSenseRNA antisenseRNA2 = psa2.getAntiSenseRNA();
        if (protein1 == null && protein2 != null) {
            return false;
        }
        if (protein1 != null && protein2 == null) {
            return false;
        }
        if (gene1 == null && gene2 != null) {
            return false;
        }
        if (gene1 != null && gene2 == null) {
            return false;
        }
        if (rna1 == null && rna2 != null) {
            return false;
        }
        if (rna1 != null && rna2 == null) {
            return false;
        }
        if (antisenseRNA1 == null && antisenseRNA2 != null) {
            return false;
        }
        if (antisenseRNA1 != null && antisenseRNA2 == null) {
            return false;
        }
        if (protein1 != null && protein2 != null && !protein1.getName().equals(protein2.getName())) {
            return false;
        }
        if (gene1 != null && gene2 != null && !gene1.getName().equals(gene2.getName())) {
            return false;
        }
        if (rna1 != null && rna2 != null && !rna1.getName().equals(rna2.getName())) {
            return false;
        }
        if (antisenseRNA1 != null && antisenseRNA2 != null && !antisenseRNA1.getName().equals(antisenseRNA2.getName())) {
            return false;
        }
        if (!Utils.comparePluginModifications(psa1.getModifications(), psa2.getModifications())) {
            return false;
        }
        return false != Utils.comparePluginStructuralStates(psa1.getPluginListOfStructuralStates(), psa2.getPluginListOfStructuralStates());
    }

    public static boolean comparePluginModifications(PluginListOf list1, PluginListOf list2) {
        return false;
    }

    public static boolean comparePluginStructuralStates(PluginListOf list1, PluginListOf list2) {
        return false;
    }

    public static boolean comparePluginComplexSpeciesAlias(PluginSpeciesAlias psa1, PluginSpeciesAlias psa2) {
        return false;
    }

    public static boolean compareString(String comp1, String comp2) {
        if (null == comp1 && null == comp2) {
            return true;
        }
        if (null == comp1 && null != comp2 || null != comp1 && null == comp2) {
            return false;
        }
        return comp1.equals(comp2);
    }

    public static boolean compareLists(Vector list1, Vector list2) {
        int size2;
        if (null == list1 && null == list2) {
            return true;
        }
        if (null == list1 && null != list2 || null != list1 && null == list2) {
            return false;
        }
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return false;
        }
        Vector copy1 = (Vector)list1.clone();
        Vector copy2 = (Vector)list2.clone();
        for (int i = 0; i < copy1.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < copy2.size(); ++j) {
                if (!copy1.get(i).equals(copy2.get(j))) continue;
                found = true;
                copy1.remove(i);
                copy2.remove(j);
                --i;
                --j;
            }
            if (found) continue;
            return false;
        }
        return 0 == copy1.size() || 0 == copy2.size();
    }
}

