/*
 * Decompiled with CFR 0.152.
 */
package com.sri.panther.pathway.plugin;

import com.sri.panther.pathway.plugin.Utils;
import java.util.Hashtable;
import java.util.Vector;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;

public class CDPluginInfo {
    PluginModel pModel;
    protected String currentModelName;
    protected String currentModelNotes;
    protected PluginListOf currentListOfSpecies;
    protected PluginListOf currentListOfCompartments;
    protected PluginListOf currentListOfReactions;
    protected Hashtable<String, Vector<Vector<String>>> monoSpecUniqueStructTbl = new Hashtable();
    protected Hashtable<String, Vector<Vector<String>>> complexSpecUniqueStructTbl = new Hashtable();
    protected Hashtable<String, PluginSpeciesAlias> speciesIdAliasTbl;
    protected Hashtable<String, Vector<PluginSpecies>> monoSpeciesTbl = new Hashtable();
    protected Hashtable<String, String> compartmentTbl;

    public CDPluginInfo(PluginModel pModel) {
        this.pModel = pModel;
        this.generateInfo();
    }

    protected void generateInfo() {
        this.currentListOfSpecies = this.pModel.getListOfSpecies();
        this.currentListOfCompartments = this.pModel.getListOfCompartments();
        this.currentListOfReactions = this.pModel.getListOfReactions();
        this.initModelInfo();
        this.initCompartmentInfo();
        this.initSpeciesInfo();
        this.initReactionsInfo();
    }

    protected void initModelInfo() {
        this.currentModelName = this.pModel.getName();
        this.currentModelNotes = this.pModel.getNotesString();
    }

    protected void initCompartmentInfo() {
        int numCompartments = this.currentListOfCompartments.size();
        this.compartmentTbl = new Hashtable(numCompartments);
        for (int i = 0; i < numCompartments; ++i) {
            PluginCompartment pCompartment = (PluginCompartment)this.currentListOfCompartments.get(i);
            String id = pCompartment.getId();
            this.compartmentTbl.put(id, pCompartment.getName());
        }
    }

    protected void initSpeciesInfo() {
        this.speciesIdAliasTbl = new Hashtable();
        int numSpecies = this.currentListOfSpecies.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numSpecies; ++i) {
            sb.setLength(0);
            PluginSpecies pSpecies = (PluginSpecies)this.currentListOfSpecies.get(i);
            this.updateSpeciesStructureTable(pSpecies);
        }
    }

    protected void initReactionsInfo() {
    }

    protected void updateSpeciesStructureTable(PluginSpecies pSpecies) {
        Hashtable<String, Vector<Vector<String>>> uniqueStructTbl;
        String name = pSpecies.getName();
        String spId = pSpecies.getId();
        PluginListOf pluginList = pSpecies.getListOfSpeciesAlias();
        PluginSpeciesAlias alias = (PluginSpeciesAlias)pluginList.get(0);
        String type = alias.getType();
        String key = type + name;
        if ("COMPLEX".equals(type)) {
            uniqueStructTbl = this.monoSpecUniqueStructTbl;
        } else {
            uniqueStructTbl = this.complexSpecUniqueStructTbl;
            Vector<Object> speciesList = this.monoSpeciesTbl.get(key);
            if (null == speciesList) {
                speciesList = new Vector(1);
                this.monoSpeciesTbl.put(key, speciesList);
            }
            speciesList.add(pSpecies);
        }
        Vector<Vector<String>> groupedSpecies = uniqueStructTbl.get(key);
        if (null == groupedSpecies) {
            groupedSpecies = new Vector();
            uniqueStructTbl.put(key, groupedSpecies);
        }
        for (int i = 0; i < pluginList.size(); ++i) {
            PluginSpeciesAlias currentPluginSpeciesAlias = (PluginSpeciesAlias)pluginList.get(i);
            String pluginAliasId = currentPluginSpeciesAlias.getAliasID();
            String currentPluginSpeciesIdAliasName = Utils.constructSpeciesIdAliasName(spId, pluginAliasId);
            boolean matchingAliasFound = false;
            for (int j = 0; j < groupedSpecies.size(); ++j) {
                Vector<String> relatedSpeciesList = groupedSpecies.get(j);
                String pluginSpeciesIdAliasName = relatedSpeciesList.elementAt(0);
                PluginSpeciesAlias pluginSpeciesAlias = Utils.getPluginSpeciesAlias(this.pModel, pluginSpeciesIdAliasName);
                if (!Utils.comparePluginAlias(currentPluginSpeciesAlias, pluginSpeciesAlias, true)) continue;
                relatedSpeciesList.add(currentPluginSpeciesIdAliasName);
                matchingAliasFound = true;
                break;
            }
            if (matchingAliasFound) continue;
            Vector<String> v1 = new Vector<String>(1);
            v1.add(currentPluginSpeciesIdAliasName);
            groupedSpecies.add(v1);
        }
    }
}

